/*
 * Decompiled with CFR 0.152.
 */
package javax.wvcm;

import java.util.HashMap;
import javax.wvcm.Resource;

public class WvcmException
extends Exception {
    private Resource _resource;
    private ReasonCode _reasonCode;
    private Throwable[] _nestedExceptions = null;
    private static final long serialVersionUID = -663023054869664237L;

    public WvcmException(String message, ReasonCode reasonCode) {
        super(message);
        this._resource = null;
        this._reasonCode = reasonCode;
    }

    public WvcmException(String message, ReasonCode reasonCode, Throwable cause) {
        super(message, cause);
        this._reasonCode = reasonCode;
    }

    public WvcmException(String message, Resource resource, ReasonCode reasonCode) {
        super(message);
        this._resource = resource;
        this._reasonCode = reasonCode;
    }

    public WvcmException(String message, Resource resource, ReasonCode reasonCode, Throwable cause) {
        super(message, cause);
        this._resource = resource;
        this._reasonCode = reasonCode;
    }

    public WvcmException(String message, Resource resource, ReasonCode reasonCode, Throwable[] nestedExceptions) {
        super(message);
        this._resource = resource;
        this._reasonCode = reasonCode;
        this._nestedExceptions = nestedExceptions;
    }

    public WvcmException(String message, Resource resource, ReasonCode reasonCode, Throwable cause, Throwable[] nestedExceptions) {
        super(message, cause);
        this._resource = resource;
        this._reasonCode = reasonCode;
        this._nestedExceptions = nestedExceptions;
    }

    public Resource getResource() {
        return this._resource;
    }

    public ReasonCode getReasonCode() {
        return this._reasonCode;
    }

    public Throwable[] getNestedExceptions() {
        return this._nestedExceptions;
    }

    public static enum ReasonCode {
        READ_FAILED("read-failed"),
        WRITE_FAILED("write-failed"),
        PROPERTY_NOT_SUPPORTED_BY_SERVER("property-not-supported-by-server"),
        PROPERTY_NOT_REQUESTED("property-not-requested"),
        PROPERTY_NOT_DEFINED_FOR_RESOURCE("property-not-defined-for-resource"),
        PROPERTY_OVERWRITE_FORBIDDEN("property-overwrite-forbidden"),
        UNAUTHORIZED("unauthorized"),
        FORBIDDEN("forbidden"),
        NOT_FOUND("not-found"),
        CONFLICT("conflict"),
        BAD_ARGUMENT_TYPE("bad-argument-type"),
        CONTROLLED_CONFIGURATION_ALREADY_EXISTS("controlled-configuration-already-exists"),
        CANNOT_HAVE_MULTIPLE_BASELINE_CONTROLLED_FOLDERS("cannot-have-multiple-baseline-controlled-folders"),
        CANNOT_CREATE_AT_THIS_LOCATION("cannot-create-at-this-location"),
        CANNOT_MERGE_CHECKOUT_NOT_ALLOWED("checkout-not-allowed"),
        CANNOT_CHECKOUT_MULTI_CHECKOUT_IS_DISCOURAGED("checkout-of-checked-out-version-is-discouraged"),
        PROPERTY_NOT_CURRENTLY_AVAILABLE("property-not-currently-available"),
        CANNOT_CHECKOUT_MULTI_CHECKOUT_IS_FORBIDDEN("cannot-checkout-multi-checkout-is-forbidden"),
        CANNOT_REMOVE_LABEL_DOES_NOT_EXIST("cannot-remove-label-does-not-exist"),
        CANNOT_CHECKIN_FORK_DISCOURAGED("checkin-fork-discouraged"),
        CANNOT_FORK("checkin-fork-forbidden"),
        CANNOT_MODIFY_VERSION("cannot-modify-version"),
        MULTI_STATUS("multi-status"),
        RESOURCE_ALREADY_EXISTS_AT_LOCATION("resource-already-exists-at-location"),
        CANNOT_CHECKOUT_FORKING_IS_DISCOURAGED("checkout-of-version-with-descendant-is-discouraged"),
        CANNOT_CHECKOUT_FORKING_IS_FORBIDDEN("cannot-checkout-forking-is-forbidden"),
        VERSION_HISTORY_MUST_BE_A_TREE("version-history-must-be-a-tree"),
        CANNOT_HAVE_CONTROLLED_MEMBERS("cannot-have-controlled-members"),
        ONE_CONTROLLED_RESOURCE_PER_HISTORY_PER_WORKSPACE("one-controlled-resource-per-history-per-workspace"),
        ONE_CHECKOUT_PER_ACTIVITY_PER_HISTORY("one-checkout-per-activity-per-history"),
        CANNOT_CHECKIN_TO_RESERVED_ACTIVITY("cannot-checkin-to-reserved-activity"),
        MUST_BE_CHECKED_IN("must-be-checked-in"),
        MUST_BE_CHECKED_OUT("must-be-checked-out"),
        CANNOT_CREATE_BRANCH_IN_ACTIVITY("linear-activity"),
        CANNOT_CREATE_BRANCH_IN_STREAM("linear-stream"),
        ADD_MUST_BE_NEW_LABEL("add-must-be-new-label"),
        NO_CHECKED_OUT_BASELINE_CONTROLLED_FOLDER_MEMBERS("no-checked-out-baseline-controlled-folder-members"),
        CANNOT_MODIFY_PROTECTED_PROPERTY("cannot-modify-protected-property"),
        METHOD_NOT_SUPPORTED("method-not-supported"),
        ILLEGAL_LOCATION_SYNTAX("illegal-location-syntax"),
        NO_CROSS_SERVER_BINDING("no-cross-server-binding"),
        CANNOT_OVERWRITE("cannot-overwrite"),
        CYCLE_NOT_ALLOWED("cycle-not-allowed"),
        ABORTED("aborted");

        private static final HashMap<String, ReasonCode> _rfc3253ToWvcmMap;
        private final String _codeImage;

        static {
            _rfc3253ToWvcmMap = new HashMap();
            _rfc3253ToWvcmMap.put("put-under-version-control", FORBIDDEN);
            _rfc3253ToWvcmMap.put("must-not-change-existing-checked-in-out", FORBIDDEN);
            _rfc3253ToWvcmMap.put("supported-report", METHOD_NOT_SUPPORTED);
            _rfc3253ToWvcmMap.put("acceptable-depth", FORBIDDEN);
            _rfc3253ToWvcmMap.put("no-modification", FORBIDDEN);
            _rfc3253ToWvcmMap.put("cannot-modify-version-controlled-content", FORBIDDEN);
            _rfc3253ToWvcmMap.put("cannot-modify-version", CANNOT_MODIFY_VERSION);
            _rfc3253ToWvcmMap.put("auto-checkout", FORBIDDEN);
            _rfc3253ToWvcmMap.put("auto-checkout-checkin", FORBIDDEN);
            _rfc3253ToWvcmMap.put("supported-live-property", PROPERTY_NOT_CURRENTLY_AVAILABLE);
            _rfc3253ToWvcmMap.put("cannot-modify-version-controlled-property", FORBIDDEN);
            _rfc3253ToWvcmMap.put("cannot-modify-version", CANNOT_MODIFY_VERSION);
            _rfc3253ToWvcmMap.put("cannot-modify-protected-property", CANNOT_MODIFY_PROTECTED_PROPERTY);
            _rfc3253ToWvcmMap.put("supported-live-property", PROPERTY_NOT_CURRENTLY_AVAILABLE);
            _rfc3253ToWvcmMap.put("auto-checkout", FORBIDDEN);
            _rfc3253ToWvcmMap.put("auto-checkout-checkin", FORBIDDEN);
            _rfc3253ToWvcmMap.put("no-version-delete", METHOD_NOT_SUPPORTED);
            _rfc3253ToWvcmMap.put("update-predecessor-set", FORBIDDEN);
            _rfc3253ToWvcmMap.put("must-not-copy-versioning-property", FORBIDDEN);
            _rfc3253ToWvcmMap.put("auto-checkout", FORBIDDEN);
            _rfc3253ToWvcmMap.put("auto-checkout-checkin", FORBIDDEN);
            _rfc3253ToWvcmMap.put("copy-creates-new-resource", FORBIDDEN);
            _rfc3253ToWvcmMap.put("cannot-rename-version", METHOD_NOT_SUPPORTED);
            _rfc3253ToWvcmMap.put("preserve-versioning-properties", FORBIDDEN);
            _rfc3253ToWvcmMap.put("version-history-is-tree", VERSION_HISTORY_MUST_BE_A_TREE);
            _rfc3253ToWvcmMap.put("auto-checkin", FORBIDDEN);
            _rfc3253ToWvcmMap.put("must-be-checked-in", MUST_BE_CHECKED_IN);
            _rfc3253ToWvcmMap.put("checkout-of-version-with-descendant-is-forbidden", CANNOT_CHECKOUT_FORKING_IS_FORBIDDEN);
            _rfc3253ToWvcmMap.put("checkout-of-version-with-descendant-is-discouraged", CANNOT_CHECKOUT_FORKING_IS_DISCOURAGED);
            _rfc3253ToWvcmMap.put("checkout-of-checked-out-version-is-forbidden", CANNOT_CHECKOUT_MULTI_CHECKOUT_IS_FORBIDDEN);
            _rfc3253ToWvcmMap.put("checkout-of-checked-out-version-is-discouraged", CANNOT_CHECKOUT_MULTI_CHECKOUT_IS_DISCOURAGED);
            _rfc3253ToWvcmMap.put("is-checked-out", FORBIDDEN);
            _rfc3253ToWvcmMap.put("initialize-predecessor-set", FORBIDDEN);
            _rfc3253ToWvcmMap.put("must-be-checked-out", MUST_BE_CHECKED_OUT);
            _rfc3253ToWvcmMap.put("version-history-is-tree", VERSION_HISTORY_MUST_BE_A_TREE);
            _rfc3253ToWvcmMap.put("checkin-fork-forbidden", CANNOT_FORK);
            _rfc3253ToWvcmMap.put("checkin-fork-discouraged", CANNOT_CHECKIN_FORK_DISCOURAGED);
            _rfc3253ToWvcmMap.put("create-version", FORBIDDEN);
            _rfc3253ToWvcmMap.put("initialize-version-content-and-properties", FORBIDDEN);
            _rfc3253ToWvcmMap.put("checked-in", FORBIDDEN);
            _rfc3253ToWvcmMap.put("keep-checked-out", FORBIDDEN);
            _rfc3253ToWvcmMap.put("must-be-checked-out-version-controlled-resource", MUST_BE_CHECKED_OUT);
            _rfc3253ToWvcmMap.put("cancel-checked-out", FORBIDDEN);
            _rfc3253ToWvcmMap.put("restore-content-and-dead-properties", FORBIDDEN);
            _rfc3253ToWvcmMap.put("must-be-version-history", BAD_ARGUMENT_TYPE);
            _rfc3253ToWvcmMap.put("delete-version-set", FORBIDDEN);
            _rfc3253ToWvcmMap.put("version-history-has-root", FORBIDDEN);
            _rfc3253ToWvcmMap.put("cannot-copy-history", METHOD_NOT_SUPPORTED);
            _rfc3253ToWvcmMap.put("cannot-rename-history", METHOD_NOT_SUPPORTED);
            _rfc3253ToWvcmMap.put("new-version-history", FORBIDDEN);
            _rfc3253ToWvcmMap.put("add-to-history", FORBIDDEN);
            _rfc3253ToWvcmMap.put("resource-must-be-null", RESOURCE_ALREADY_EXISTS_AT_LOCATION);
            _rfc3253ToWvcmMap.put("workspace-location-ok", CANNOT_CREATE_AT_THIS_LOCATION);
            _rfc3253ToWvcmMap.put("initialize-workspace", FORBIDDEN);
            _rfc3253ToWvcmMap.put("delete-workspace-members", FORBIDDEN);
            _rfc3253ToWvcmMap.put("workspace-member-moved", FORBIDDEN);
            _rfc3253ToWvcmMap.put("workspace-moved", FORBIDDEN);
            _rfc3253ToWvcmMap.put("cannot-add-to-existing-history", RESOURCE_ALREADY_EXISTS_AT_LOCATION);
            _rfc3253ToWvcmMap.put("must-be-version", FORBIDDEN);
            _rfc3253ToWvcmMap.put("one-version-controlled-resource-per-history-per-workspace", ONE_CONTROLLED_RESOURCE_PER_HISTORY_PER_WORKSPACE);
            _rfc3253ToWvcmMap.put("new-version-controlled-resource", FORBIDDEN);
            _rfc3253ToWvcmMap.put("update-content-and-properties", FORBIDDEN);
            _rfc3253ToWvcmMap.put("report-properties", FORBIDDEN);
            _rfc3253ToWvcmMap.put("must-be-checked-in", MUST_BE_CHECKED_IN);
            _rfc3253ToWvcmMap.put("add-must-be-new-label", ADD_MUST_BE_NEW_LABEL);
            _rfc3253ToWvcmMap.put("label-must-exist", CANNOT_REMOVE_LABEL_DOES_NOT_EXIST);
            _rfc3253ToWvcmMap.put("add-or-set-label", FORBIDDEN);
            _rfc3253ToWvcmMap.put("remove-label", FORBIDDEN);
            _rfc3253ToWvcmMap.put("apply-request-to-labeled-version", FORBIDDEN);
            _rfc3253ToWvcmMap.put("must-select-version-in-history", FORBIDDEN);
            _rfc3253ToWvcmMap.put("apply-request-to-labeled-version", FORBIDDEN);
            _rfc3253ToWvcmMap.put("apply-request-to-labeled-version", FORBIDDEN);
            _rfc3253ToWvcmMap.put("must-not-have-label-and-apply-to-version", FORBIDDEN);
            _rfc3253ToWvcmMap.put("apply-request-to-labeled-version", FORBIDDEN);
            _rfc3253ToWvcmMap.put("depth-update", FORBIDDEN);
            _rfc3253ToWvcmMap.put("apply-request-to-labeled-version", FORBIDDEN);
            _rfc3253ToWvcmMap.put("checkout-of-version-with-descendant-is-discouraged", CANNOT_CHECKOUT_FORKING_IS_DISCOURAGED);
            _rfc3253ToWvcmMap.put("checkout-of-checked-out-version-is-forbidden", CANNOT_CHECKOUT_MULTI_CHECKOUT_IS_FORBIDDEN);
            _rfc3253ToWvcmMap.put("checkout-of-checked-out-version-is-discouraged", CANNOT_CHECKOUT_MULTI_CHECKOUT_IS_DISCOURAGED);
            _rfc3253ToWvcmMap.put("create-working-resource", FORBIDDEN);
            _rfc3253ToWvcmMap.put("create-working-resource-from-checked-in-version", FORBIDDEN);
            _rfc3253ToWvcmMap.put("must-be-checked-in", MUST_BE_CHECKED_IN);
            _rfc3253ToWvcmMap.put("version-history-is-tree", VERSION_HISTORY_MUST_BE_A_TREE);
            _rfc3253ToWvcmMap.put("checkin-fork-forbidden", CANNOT_FORK);
            _rfc3253ToWvcmMap.put("checkin-fork-discouraged", CANNOT_CHECKIN_FORK_DISCOURAGED);
            _rfc3253ToWvcmMap.put("no-overwrite-by-auto-update", FORBIDDEN);
            _rfc3253ToWvcmMap.put("create-version", FORBIDDEN);
            _rfc3253ToWvcmMap.put("initialize-version-content-and-properties", FORBIDDEN);
            _rfc3253ToWvcmMap.put("auto-update", FORBIDDEN);
            _rfc3253ToWvcmMap.put("delete-working-resource", FORBIDDEN);
            _rfc3253ToWvcmMap.put("copy-creates-new-resource", FORBIDDEN);
            _rfc3253ToWvcmMap.put("cannot-rename-working-resource", FORBIDDEN);
            _rfc3253ToWvcmMap.put("update-auto-update", FORBIDDEN);
            _rfc3253ToWvcmMap.put("cannot-merge-checked-out-resource", FORBIDDEN);
            _rfc3253ToWvcmMap.put("checkout-not-allowed", CANNOT_MERGE_CHECKOUT_NOT_ALLOWED);
            _rfc3253ToWvcmMap.put("ancestor-version", FORBIDDEN);
            _rfc3253ToWvcmMap.put("decendent-version", FORBIDDEN);
            _rfc3253ToWvcmMap.put("checked-out-for-merge", FORBIDDEN);
            _rfc3253ToWvcmMap.put("update-merge-set", FORBIDDEN);
            _rfc3253ToWvcmMap.put("report-properties", FORBIDDEN);
            _rfc3253ToWvcmMap.put("delete-version-reference", FORBIDDEN);
            _rfc3253ToWvcmMap.put("merge-must-be-complete", FORBIDDEN);
            _rfc3253ToWvcmMap.put("configuration-must-not-exist", FORBIDDEN);
            _rfc3253ToWvcmMap.put("must-be-baseline", BAD_ARGUMENT_TYPE);
            _rfc3253ToWvcmMap.put("must-have-no-version-controlled-members", CANNOT_HAVE_CONTROLLED_MEMBERS);
            _rfc3253ToWvcmMap.put("one-baseline-controlled-collection-per-history-per-workspace", CANNOT_HAVE_MULTIPLE_BASELINE_CONTROLLED_FOLDERS);
            _rfc3253ToWvcmMap.put("create-configuration", FORBIDDEN);
            _rfc3253ToWvcmMap.put("reference-configuration", FORBIDDEN);
            _rfc3253ToWvcmMap.put("select-existing-baseline", FORBIDDEN);
            _rfc3253ToWvcmMap.put("create-new-baseline", FORBIDDEN);
            _rfc3253ToWvcmMap.put("must-be-baseline", BAD_ARGUMENT_TYPE);
            _rfc3253ToWvcmMap.put("baselines-from-same-history", FORBIDDEN);
            _rfc3253ToWvcmMap.put("must-not-update-baseline-collection", FORBIDDEN);
            _rfc3253ToWvcmMap.put("no-checked-out-baseline-controlled-collection-members", NO_CHECKED_OUT_BASELINE_CONTROLLED_FOLDER_MEMBERS);
            _rfc3253ToWvcmMap.put("one-version-per-history-per-baseline", FORBIDDEN);
            _rfc3253ToWvcmMap.put("cannot-modify-configuration", FORBIDDEN);
            _rfc3253ToWvcmMap.put("create-baseline-collection", FORBIDDEN);
            _rfc3253ToWvcmMap.put("modify-configuration", FORBIDDEN);
            _rfc3253ToWvcmMap.put("baseline-controlled-members-must-be-checked-in", NO_CHECKED_OUT_BASELINE_CONTROLLED_FOLDER_MEMBERS);
            _rfc3253ToWvcmMap.put("must-not-update-baseline-collection", FORBIDDEN);
            _rfc3253ToWvcmMap.put("cannot-modify-version-controlled-configuration", FORBIDDEN);
            _rfc3253ToWvcmMap.put("set-baseline-controlled-collection-members", FORBIDDEN);
            _rfc3253ToWvcmMap.put("modify-configuration", FORBIDDEN);
            _rfc3253ToWvcmMap.put("must-not-update-baseline-collection", FORBIDDEN);
            _rfc3253ToWvcmMap.put("cannot-modify-configuration", FORBIDDEN);
            _rfc3253ToWvcmMap.put("merge-baseline", FORBIDDEN);
            _rfc3253ToWvcmMap.put("set-baseline-controlled-collection-members", FORBIDDEN);
            _rfc3253ToWvcmMap.put("modify-configuration", FORBIDDEN);
            _rfc3253ToWvcmMap.put("resource-must-be-null", RESOURCE_ALREADY_EXISTS_AT_LOCATION);
            _rfc3253ToWvcmMap.put("activity-location-ok", CANNOT_CREATE_AT_THIS_LOCATION);
            _rfc3253ToWvcmMap.put("initialize-activity", FORBIDDEN);
            _rfc3253ToWvcmMap.put("must-be-activity", BAD_ARGUMENT_TYPE);
            _rfc3253ToWvcmMap.put("delete-activity-reference", FORBIDDEN);
            _rfc3253ToWvcmMap.put("update-checked-out-reference", FORBIDDEN);
            _rfc3253ToWvcmMap.put("update-activity-reference", FORBIDDEN);
            _rfc3253ToWvcmMap.put("update-workspace-reference", FORBIDDEN);
            _rfc3253ToWvcmMap.put("one-checkout-per-activity-per-history", ONE_CHECKOUT_PER_ACTIVITY_PER_HISTORY);
            _rfc3253ToWvcmMap.put("linear-activity", CANNOT_CREATE_BRANCH_IN_ACTIVITY);
            _rfc3253ToWvcmMap.put("initialize-activity-set", FORBIDDEN);
            _rfc3253ToWvcmMap.put("initialize-reserved", FORBIDDEN);
            _rfc3253ToWvcmMap.put("linear-activity", CANNOT_CREATE_BRANCH_IN_ACTIVITY);
            _rfc3253ToWvcmMap.put("atomic-activity-checkin", MULTI_STATUS);
            _rfc3253ToWvcmMap.put("initialize-activity-set", FORBIDDEN);
            _rfc3253ToWvcmMap.put("activity-checkin", FORBIDDEN);
            _rfc3253ToWvcmMap.put("checkin-activity", FORBIDDEN);
            _rfc3253ToWvcmMap.put("cannot-modify-checked-in-parent", FORBIDDEN);
            _rfc3253ToWvcmMap.put("delete-working-collection-binding", FORBIDDEN);
            _rfc3253ToWvcmMap.put("cannot-copy-collection-version", METHOD_NOT_SUPPORTED);
            _rfc3253ToWvcmMap.put("cannot-modify-checked-in-parent", FORBIDDEN);
            _rfc3253ToWvcmMap.put("cannot-modify-destination-checked-in-parent", FORBIDDEN);
            _rfc3253ToWvcmMap.put("cannot-modify-checked-in-parent", FORBIDDEN);
            _rfc3253ToWvcmMap.put("new-version-controlled-collection", FORBIDDEN);
            _rfc3253ToWvcmMap.put("initialize-version-history-bindings", FORBIDDEN);
            _rfc3253ToWvcmMap.put("initialize-version-controlled-bindings", FORBIDDEN);
            _rfc3253ToWvcmMap.put("version-control-working-collection-members", FORBIDDEN);
            _rfc3253ToWvcmMap.put("update-version-controlled-collection-members", FORBIDDEN);
            _rfc3253ToWvcmMap.put("bind-source-exists", NOT_FOUND);
            _rfc3253ToWvcmMap.put("name-allowed", CANNOT_CREATE_AT_THIS_LOCATION);
            _rfc3253ToWvcmMap.put("binding-allowed", METHOD_NOT_SUPPORTED);
            _rfc3253ToWvcmMap.put("cross-server-binding", NO_CROSS_SERVER_BINDING);
            _rfc3253ToWvcmMap.put("can-overwrite", CANNOT_OVERWRITE);
            _rfc3253ToWvcmMap.put("cycle-allowed", CYCLE_NOT_ALLOWED);
            _rfc3253ToWvcmMap.put("new-binding", FORBIDDEN);
            _rfc3253ToWvcmMap.put("unbind-source-exists", NOT_FOUND);
            _rfc3253ToWvcmMap.put("rebind-source-exists", NOT_FOUND);
        }

        private ReasonCode(String codeImage) {
            this._codeImage = codeImage;
        }

        public static ReasonCode getReasonCodeForRFC3253Condition(String condition) {
            return _rfc3253ToWvcmMap.get(condition);
        }

        public String toString() {
            return this._codeImage;
        }
    }
}

