/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common.internal.preview;

import com.ibm.team.calm.foundation.common.Property;
import com.ibm.team.calm.foundation.common.internal.preview.CompactRenderingDocument;
import com.ibm.team.calm.foundation.common.oslc.DublinCoreIdentifiers;
import com.ibm.team.calm.foundation.common.oslc.JazzIdentifiers;
import com.ibm.team.calm.foundation.common.oslc.RDFIdentifiers;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class JazzCompactRenderingDocument
extends CompactRenderingDocument {
    public JazzCompactRenderingDocument(String uri, InputStream inputStream) {
        super(uri, inputStream);
    }

    @Override
    protected void readDocument() throws TeamRepositoryException {
        try {
            Element largePreview;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document doc = documentBuilder.parse(this.fInputStream);
            Element root = doc.getDocumentElement();
            Attr about = this.getAttribute(root, RDFIdentifiers.ABOUT);
            this.fAbout = about.getNodeValue();
            this.fTitle = this.getStringValue(root, DublinCoreIdentifiers.TITLE);
            this.fAbbreviation = this.getStringValue(root, JazzIdentifiers.PROPERTY_CR_ABBREVIATION);
            this.fIconURI = this.getResourceUri(root, JazzIdentifiers.PROPERTY_CR_ICON);
            Element smallPreview = this.getElement(root, JazzIdentifiers.PROPERTY_CR_SMALL_PREVIEW);
            if (smallPreview != null) {
                this.fSmallPreview = this.getResourceUri(smallPreview);
                if (this.fSmallPreview != null) {
                    this.fSmallPreviewWidth = this.getPixelsValueFromAttribute(smallPreview, JazzIdentifiers.PROPERTY_CR_PREFERRED_WIDTH);
                    this.fSmallPreviewHeight = this.getPixelsValueFromAttribute(smallPreview, JazzIdentifiers.PROPERTY_CR_PREFERRED_HEIGHT);
                }
            }
            if ((largePreview = this.getElement(root, JazzIdentifiers.PROPERTY_CR_LARGE_PREVIEW)) != null) {
                this.fLargePreview = this.getResourceUri(largePreview);
                if (this.fLargePreview != null) {
                    this.fLargePreviewWidth = this.getPixelsValueFromAttribute(largePreview, JazzIdentifiers.PROPERTY_CR_PREFERRED_WIDTH);
                    this.fLargePreviewHeight = this.getPixelsValueFromAttribute(largePreview, JazzIdentifiers.PROPERTY_CR_PREFERRED_HEIGHT);
                }
            }
        }
        catch (ParserConfigurationException e) {
            throw new TeamRepositoryException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            throw new TeamRepositoryException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new TeamRepositoryException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private Attr getAttribute(Element element, Property property) {
        return element.getAttributeNodeNS(property.getNamespaceURI(), property.getName());
    }

    private String getStringValue(Element parent, Property property) {
        String stringValue = null;
        NodeList nodeList = parent.getElementsByTagNameNS(property.getNamespaceURI(), property.getName());
        if (nodeList != null && nodeList.getLength() == 1 && (stringValue = nodeList.item(0).getTextContent()) != null) {
            stringValue = XMLString.createFromPlainText((String)stringValue).getXMLText();
        }
        return stringValue;
    }

    private String getResourceUri(Element parent, Property property) {
        String uri = null;
        Element resource = this.getElement(parent, property);
        if (resource != null) {
            uri = this.getResourceUri(resource);
        }
        return uri;
    }

    private Element getElement(Element parent, Property property) {
        Node propertyNode;
        NodeList nodeList = parent.getElementsByTagNameNS(property.getNamespaceURI(), property.getName());
        if (nodeList != null && nodeList.getLength() == 1 && (propertyNode = nodeList.item(0)).getNodeType() == 1) {
            return (Element)propertyNode;
        }
        return null;
    }

    private String getResourceUri(Element resource) {
        String uri = null;
        Attr resourceAttr = this.getAttribute(resource, RDFIdentifiers.RESOURCE);
        if (resourceAttr != null) {
            uri = resourceAttr.getNodeValue();
        }
        return uri;
    }

    private Long getPixelsValueFromAttribute(Element element, Property attribute) {
        Long pixels = null;
        Attr attributeNode = this.getAttribute(element, attribute);
        if (attributeNode != null) {
            pixels = this.convertToPixels(attributeNode.getNodeValue());
        }
        return pixels;
    }
}

