/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ct;

import com.ibm.rational.wvcm.ct.CCaseElemInfo;
import com.ibm.rational.wvcm.ct.CCaseLib;
import com.ibm.rational.wvcm.ct.CCaseObjInfo;
import com.ibm.rational.wvcm.ct.CCaseVerInfo;
import com.ibm.rational.wvcm.ct.CTActivity;
import com.ibm.rational.wvcm.ct.CTComponent;
import com.ibm.rational.wvcm.ct.CTElement;
import com.ibm.rational.wvcm.ct.CTLocation;
import com.ibm.rational.wvcm.ct.CTProvider;
import com.ibm.rational.wvcm.ct.CTResource;
import com.ibm.rational.wvcm.ct.CTStream;
import com.ibm.rational.wvcm.ct.CTUcmView;
import com.ibm.rational.wvcm.ct.CTVersion;
import com.ibm.rational.wvcm.ct.CTWvcmConfiguration;
import com.ibm.rational.wvcm.ct.DiffBLInfo;
import com.ibm.rational.wvcm.ct.ObjSelUtils;
import com.ibm.rational.wvcm.ri.impl.BaselineImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.wvcm.Baseline;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.Version;
import javax.wvcm.VersionSet;
import javax.wvcm.WvcmException;

public class CTBaseline
extends CTVersion {
    private static final String SPACES = " +";
    private static final String TWO_LEFT_ARROWS = "<<";
    private static final String TWO_RIGHT_ARROWS = ">>";
    private static final String LEFT_ARROW = "<-";
    private static final String RIGHT_ARROW = "->";
    private final CCaseLib cc;
    private List<CTBaseline> _subBaselineList;

    CTBaseline(Location location, CTProvider provider) {
        super(location, provider);
        this.cc = provider.getCCaseLib();
    }

    @Override
    public Class<?> get_proxyClass() {
        return BaselineImpl.class;
    }

    @Override
    public Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Resource.PATHNAME_LOCATION)) {
            return this.location();
        }
        if (propertyName.equals((Object)Version.VERSION_HISTORY)) {
            return this.getComponent(feedback);
        }
        if (propertyName.equals((Object)Version.VERSION_NAME)) {
            return this.getPathname(feedback);
        }
        if (propertyName.equals((Object)Version.PREDECESSOR_LIST)) {
            return Collections.singletonList(this.getPredecessorBaseline(feedback));
        }
        if ("com.ibm.team.importer".equals(propertyName.getNamespace())) {
            return this.getBaselineAttribute(propertyName.getName(), feedback);
        }
        if (propertyName.equals((Object)Resource.DISPLAY_NAME)) {
            return this.getDisplayName(feedback);
        }
        if (propertyName.equals((Object)Baseline.SUB_BASELINE_LIST)) {
            return this.getSubBaselineList(feedback);
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    private List<CTBaseline> getSubBaselineList(SrvcFeedback feedback) throws WvcmException {
        if (this._subBaselineList == null) {
            CTProvider p = this.provider();
            CCaseLib cc = p.getCCaseLib();
            List<String> subBaselineSels = cc.getMemberBaselines(Collections.singletonList(this.location().getDisplayName()), feedback);
            ArrayList<CTBaseline> results = new ArrayList<CTBaseline>(subBaselineSels.size());
            for (String sel : subBaselineSels) {
                results.add(CTBaseline.valueOf(p, sel, feedback));
            }
            this._subBaselineList = results;
        }
        return this._subBaselineList;
    }

    public CTComponent getComponent(SrvcFeedback feedback) throws WvcmException {
        CTProvider p = this.provider();
        return (CTComponent)p.get(this.getComponentLocation(feedback), feedback);
    }

    private Location getComponentLocation(SrvcFeedback feedback) throws WvcmException {
        CTProvider p = this.provider();
        CCaseObjInfo compObjInfo = CCaseObjInfo.getObjInfo(this.cc, this.getComponentSelector(false, feedback), feedback);
        String compUsel = compObjInfo.getUniversalSelector();
        CTLocation compLoc = CTLocation.valueOf(CTLocation.Kind.COMPONENT, compUsel);
        p.createAndCacheCTResource(compLoc, compObjInfo, feedback);
        return compLoc;
    }

    protected SrvcResource.SrvcCompareReport computeBlReport(DiffBLInfo diffBLInfo) throws WvcmException {
        CTVersion vOld = diffBLInfo.getOldBaselineVersion();
        CTVersion vNew = diffBLInfo.getNewBaselineVersion();
        if (vOld == null && vNew == null) {
            throw new IllegalArgumentException("Old and new versions are both null");
        }
        if (vOld == null) {
            return new SrvcResource.SrvcAddedVersion((SrvcResource)vNew);
        }
        if (vNew == null) {
            return new SrvcResource.SrvcDeletedVersion((SrvcResource)vOld);
        }
        return new SrvcResource.SrvcChangedVersion((SrvcResource)vOld, (SrvcResource)vNew);
    }

    private SrvcResource.SrvcCompareReport computeBlReport(String actLine, SrvcFeedback feedback) throws WvcmException {
        String[] items = actLine.split(SPACES, 3);
        CTLocation activityLoc = CTLocation.valueOf(CTLocation.Kind.ACTIVITY, ObjSelUtils.formatSelector("activity", items[1].trim()));
        String prefix = items[0];
        CTActivity ctAct = (CTActivity)this.provider().get((Location)activityLoc, feedback);
        if (prefix.equals(TWO_RIGHT_ARROWS)) {
            return new SrvcResource.SrvcAddedActivity((SrvcResource)ctAct);
        }
        if (prefix.equals(TWO_LEFT_ARROWS)) {
            return new SrvcResource.SrvcDeletedActivity((SrvcResource)ctAct);
        }
        if (prefix.equals(RIGHT_ARROW)) {
            return new SrvcResource.SrvcPartiallyAddedActivity((SrvcResource)ctAct);
        }
        if (prefix.equals(LEFT_ARROW)) {
            return new SrvcResource.SrvcPartiallyDeletedActivity((SrvcResource)ctAct);
        }
        throw new IllegalArgumentException("Activity line has unrecognized prefix: " + actLine);
    }

    public List<SrvcResource.SrvcCompareReport> doCompareReport(SrvcResource resource, VersionSet.CompareFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        boolean getActs = false;
        boolean newOnly = false;
        VersionSet.CompareFlag[] compareFlagArray = flags;
        int n = flags.length;
        int n2 = 0;
        while (n2 < n) {
            VersionSet.CompareFlag flag = compareFlagArray[n2];
            if (flag.equals(VersionSet.CompareFlag.ACTIVITIES)) {
                getActs = true;
            } else if (flag.equals(VersionSet.CompareFlag.NEW_ONLY)) {
                newOnly = true;
            }
            ++n2;
        }
        if (resource instanceof CTBaseline || resource instanceof CTStream) {
            if (!newOnly) {
                throw new WvcmException("implementation limitation: newOnly must be true", WvcmException.ReasonCode.FORBIDDEN);
            }
            if (!getActs) {
                throw new WvcmException("implementation limitation: getActs must be true", WvcmException.ReasonCode.FORBIDDEN);
            }
            return this.doCompare(((CTResource)resource).getUniversalSelector(feedback), feedback);
        }
        if (!(resource instanceof CTUcmView)) {
            throw new IllegalArgumentException("Compare report should be for UCM view, not: " + resource.getClass().getName());
        }
        CTUcmView view = (CTUcmView)resource;
        CTComponent comp = this.getComponent(feedback);
        CTWvcmConfiguration config = CTWvcmConfiguration.valueOf(view, comp, feedback);
        CTBaseline newBaseline = config.getLatestBaseline(feedback);
        if (newBaseline.equals((Object)this)) {
            return new ArrayList<SrvcResource.SrvcCompareReport>();
        }
        String baselineSelectorNew = newBaseline.getUniversalSelector(feedback);
        List<SrvcResource.SrvcCompareReport> results = this.doCompareBaselineWithView(baselineSelectorNew, view, newOnly, feedback);
        if (getActs) {
            List<SrvcResource.SrvcCompareReport> activitiesReport = this.doActivitiesReport(newBaseline, view, feedback);
            results.addAll(activitiesReport);
        }
        return results;
    }

    private List<SrvcResource.SrvcCompareReport> doCompare(String versionSetSelectorNew, SrvcFeedback feedback) throws WvcmException {
        CTUcmView view = (CTUcmView)this.getDefaultUcmView(feedback);
        String viewTag = view.getViewTag();
        String baselineSelectorOld = this.getUniversalSelector(feedback);
        List<String> lines = this.cc.diffBl(true, false, true, versionSetSelectorNew, baselineSelectorOld, viewTag, feedback);
        LinkedHashMap<String, List<String>> activityNamesAndTheirVerPnames = CTBaseline.parseDiffBlOutput(lines);
        Map<String, String> activityName2ActivityUSel = this.getActivityUSels(activityNamesAndTheirVerPnames.keySet(), feedback);
        int roughCount = lines.size();
        ArrayList<String> verPnames = new ArrayList<String>(roughCount);
        for (List<String> somePnames : activityNamesAndTheirVerPnames.values()) {
            verPnames.addAll(somePnames);
        }
        ArrayList<SrvcResource.SrvcCompareReport> results = new ArrayList<SrvcResource.SrvcCompareReport>(verPnames.size());
        Map<String, CCaseVerInfo> verInfos = CCaseVerInfo.getVerInfos(this.cc, verPnames, feedback);
        CTProvider p = this.provider();
        for (Map.Entry<String, List<String>> entry : activityNamesAndTheirVerPnames.entrySet()) {
            String activityName = entry.getKey();
            String activitySelector = activityName2ActivityUSel.get(activityName);
            CTLocation activityLoc = CTLocation.valueOf(CTLocation.Kind.ACTIVITY, activitySelector);
            CTActivity activity = (CTActivity)p.lookup((Location)activityLoc, feedback);
            List<String> somePnames = entry.getValue();
            int count = somePnames.size();
            ArrayList<CTVersion> activityVersionList = new ArrayList<CTVersion>(count);
            for (String verPname : somePnames) {
                CCaseVerInfo verInfo = verInfos.get(verPname);
                CTVersion ver = CTVersion.valueOf(p, verInfo, view, verPname, feedback);
                activityVersionList.add(ver);
            }
            activity.setVersionList(activityVersionList);
            results.add((SrvcResource.SrvcCompareReport)new SrvcResource.SrvcPartiallyAddedActivity((SrvcResource)activity));
        }
        return results;
    }

    private Map<String, String> getActivityUSels(Collection<String> activityNames, SrvcFeedback feedback) throws WvcmException {
        if (activityNames.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<String, String> results = this.cc.getActivitiesUniversalSelectors(activityNames, feedback);
        return results;
    }

    public static LinkedHashMap<String, List<String>> parseDiffBlOutput(List<String> lines) {
        String line;
        int count = lines.size();
        LinkedHashMap<String, List<String>> results = new LinkedHashMap<String, List<String>>(count);
        int i = 0;
        while (i < count) {
            line = lines.get(i);
            if (line.startsWith(TWO_LEFT_ARROWS) || line.startsWith(LEFT_ARROW)) break;
            ++i;
        }
        while (i < count) {
            line = lines.get(i);
            String[] items = line.split(SPACES, 3);
            String activitySelector = items[1];
            ArrayList<String> verPnames = new ArrayList<String>();
            ++i;
            while (i < count) {
                line = lines.get(i);
                if (line.startsWith(TWO_LEFT_ARROWS) || line.startsWith(LEFT_ARROW)) break;
                String verPname = line.trim();
                verPnames.add(verPname);
                ++i;
            }
            results.put(activitySelector, verPnames);
        }
        return results;
    }

    public List<SrvcResource.SrvcCompareReport> doActivitiesReport(CTBaseline newBaseline, CTUcmView view, SrvcFeedback feedback) throws WvcmException {
        String baselineSelectorNew = newBaseline.getUniversalSelector(feedback);
        String baselineSelectorOld = this.getUniversalSelector(feedback);
        List<String> actLines = this.cc.diffBl(true, false, false, baselineSelectorOld, baselineSelectorNew, view.getViewTag(), feedback);
        ArrayList<SrvcResource.SrvcCompareReport> activitiesReport = new ArrayList<SrvcResource.SrvcCompareReport>();
        for (String actLine : actLines) {
            activitiesReport.add(this.computeBlReport(actLine, feedback));
        }
        return activitiesReport;
    }

    private List<SrvcResource.SrvcCompareReport> doCompareBaselineWithView(String baselineSelectorNew, CTUcmView view, boolean newOnly, SrvcFeedback feedback) throws WvcmException {
        if (!newOnly) {
            throw new IllegalArgumentException("must request newOnly when comparing a baseline with a view");
        }
        ArrayList<SrvcResource.SrvcCompareReport> results = new ArrayList<SrvcResource.SrvcCompareReport>();
        String baselineSelectorOld = this.getUniversalSelector(feedback);
        List<String> elemLines = this.cc.diffBl(false, true, false, baselineSelectorOld, baselineSelectorNew, view.getViewTag(), feedback);
        int roughCount = elemLines.size();
        ArrayList<String> elemPnames = new ArrayList<String>(roughCount);
        ArrayList<String> verPnames = new ArrayList<String>(roughCount);
        for (String line : elemLines) {
            String[] items = line.split(SPACES, 2);
            if (!items[0].equals(TWO_RIGHT_ARROWS)) continue;
            String pathname = items[1].trim();
            int length = pathname.length();
            int expectedIndex = length - "@@".length();
            int index = pathname.lastIndexOf("@@");
            if (index != expectedIndex) continue;
            elemPnames.add(pathname);
            String verPname = pathname.substring(0, index);
            verPnames.add(verPname);
        }
        int count = elemPnames.size();
        Map<String, CCaseElemInfo> elemInfos = CCaseElemInfo.getElemInfos(this.cc, elemPnames, feedback);
        Map<String, CCaseVerInfo> verInfos = CCaseVerInfo.getVerInfos(this.cc, verPnames, feedback);
        CTProvider p = this.provider();
        int i = 0;
        while (i < count) {
            String elemPname = (String)elemPnames.get(i);
            CCaseElemInfo elemInfo = elemInfos.get(elemPname);
            CTElement elem = CTElement.valueOf(p, elemInfo, view, elemPname, feedback);
            String verPname = (String)verPnames.get(i);
            CCaseVerInfo verInfo = verInfos.get(verPname);
            CTVersion ver = CTVersion.valueOf(p, verInfo, view, verPname, feedback);
            ver.setElemUSel(elem.getUniversalSelector(feedback));
            results.add((SrvcResource.SrvcCompareReport)new SrvcResource.SrvcAddedVersion((SrvcResource)ver));
            ++i;
        }
        return results;
    }

    public static CTBaseline valueOf(CTProvider p, String baselineSelector, SrvcFeedback feedback) throws WvcmException {
        CTLocation myLoc = CTLocation.valueOf(CTLocation.Kind.BASELINE, baselineSelector);
        return (CTBaseline)p.get((Location)myLoc, feedback);
    }

    private String getComponentSelector(boolean objSelector, SrvcFeedback feedback) throws WvcmException {
        String componentSelector = this.cc.getComponent(this.location().getDisplayName(), objSelector, feedback);
        return componentSelector;
    }

    private CTBaseline getPredecessorBaseline(SrvcFeedback feedback) throws WvcmException {
        CTProvider p = this.provider();
        String predBl = this.cc.getPredecessorBaseline(this.location().getDisplayName(), feedback);
        CTLocation predLocation = CTLocation.valueOf(predBl);
        CTBaseline predBaseline = new CTBaseline((Location)predLocation, p);
        return predBaseline;
    }

    private String getBaselineAttribute(String attribute, SrvcFeedback feedback) throws WvcmException {
        return this.cc.getAttribute(this.location().getDisplayName(), attribute, feedback);
    }

    protected String getDisplayName(SrvcFeedback feedback) throws WvcmException {
        return this.getObjInfo(feedback).getPathName();
    }

    public void setSubBaselineUniversalSelectors(List<String> subUSels, SrvcFeedback feedback) throws WvcmException {
        this._subBaselineList = new ArrayList<CTBaseline>(subUSels.size());
        CTProvider p = this.provider();
        for (String uSel : subUSels) {
            CTBaseline sub = CTBaseline.valueOf(p, uSel, feedback);
            this._subBaselineList.add(sub);
        }
    }
}

