/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ct;

import com.ibm.rational.wvcm.ct.CCaseLib;
import com.ibm.rational.wvcm.ct.CommandProvider;
import com.ibm.rational.wvcm.ct.CommonUtils;
import com.ibm.rational.wvcm.ct.Messages;
import java.io.File;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.wvcm.WvcmException;
import org.eclipse.osgi.util.NLS;

public class ObjSelUtils {
    public static final String ACTIVITY = "activity";
    public static final String ANY_ACTIVITY = "anyactivity";
    public static final String ATTYPE = "attype";
    public static final String BASELINE = "baseline";
    public static final String COMPONENT = "component";
    public static final String ELTYPE = "eltype";
    public static final String PROJECT = "project";
    public static final String STREAM = "stream";
    public static final String FOLDER = "folder";
    public static final String VOB = "vob";
    public static final String OID = "oid";
    public static final String DBID = "dbid";
    public static final String VOBUUID = "vobuuid";
    public static final String BRTYPE = "brtype";
    public static final String LBTYPE = "lbtype";
    public static final String HLTYPE = "hltype";
    public static final String TRTYPE = "trtype";
    public static final String WKO = "wko";
    public static final String DIRECTORY_VERSION = "directory version";
    public static final String DIRECTORY_ELEMENT = "directory element";
    public static final String FILE_ELEMENT = "file element";
    public static final String SYMBOLIC_LINK = "symbolic link";
    public static final String NULL_MTYPE = "**null meta type**";
    public static final String VERSION = "version";
    public static final String DO_VERSION = "derived object version";
    public static final String ELEMENT = "element";
    public static final String VERSIONED_OBJECT_BASE = "versioned object base";
    public static final String VIEW_PVT_OBJECT = "view private object";
    public static final String DERIVED_OBJECT = "derived object";
    public static final String READ_ONLY = "_READ_ONLY";
    public static final String UNDERSCORE = String.valueOf('_');
    public static final String SIMPLE_PROJECT = "SIMPLE";
    public static final String DEFAULT_PROJECT = "DEFAULT";
    public static final String WKO_MAIN = "3";
    public static final String NO_COMMENT = "";
    public static final String QUOTED_CONTENT_REGEX = "\"(.*?)\"";
    private static final Pattern JUST_QUOTED_CONTENT_PATTERN = Pattern.compile(".*\"(.*?)\".*");
    private static final Pattern VOB_UUID_PATTERN = Pattern.compile("vobuuid:([0-9a-f.:]+)");
    private static final Pattern VOB_UUID_SELECTOR_PATTERN = Pattern.compile(".*?@(" + VOB_UUID_PATTERN + ").*");
    private static final Pattern OBJECT_SELECTOR_PATTERN = Pattern.compile("([a-z]+):(.+?)@(.+)");
    private static final Pattern SHORT_OBJECT_SELECTOR_PATTERN = Pattern.compile("([a-z]+):(.+?)");
    public static final String EXTENDED_NAMING_SYMBOL = "@@";
    private static final Pattern VIEWTAG_IN_SELECTOR_PATTERN_WIN = Pattern.compile("^(.:)?[/\\\\](.+?)[/\\\\].*");
    private static final Pattern VIEWTAG_IN_SELECTOR_PATTERN_UX = Pattern.compile("^(/view/)(.+?)[/].*");
    public static SimpleDateFormat DATE_TIME_FORMAT = new SimpleDateFormat("yy.MM.FF_HH.mm.ss");

    public static final String vobOidSubstring(String src) {
        Matcher vobuuidMatcher = VOB_UUID_PATTERN.matcher(src);
        if (!vobuuidMatcher.find()) {
            throw new IllegalArgumentException("vobUuidOnlySubstring could not find vobuuid in " + src);
        }
        return vobuuidMatcher.group(1);
    }

    public static final String vobUuidSelectorSubstring(String src) {
        Matcher vobuuidMatcher = VOB_UUID_SELECTOR_PATTERN.matcher(src);
        if (!vobuuidMatcher.find()) {
            throw new IllegalArgumentException("getVobuuid could not find vobuuid in " + src);
        }
        return vobuuidMatcher.replaceFirst("$1");
    }

    public static String createActivitySelectorFromStdOut(String vobUUIDString, String info) {
        String[] infoLines = info.split("\n");
        Matcher m = JUST_QUOTED_CONTENT_PATTERN.matcher(infoLines[0]);
        if (!m.find()) {
            throw new IllegalArgumentException("Could not find activity name (quoted content) in: " + info);
        }
        String actName = m.replaceFirst("$1");
        return ObjSelUtils.formatSelector(ACTIVITY, actName, vobUUIDString);
    }

    public static String formatSelector(String objselKind, String objName, String vobSelector) {
        return String.format("%s:%s@%s", objselKind, objName, vobSelector);
    }

    public static String formatSelector(String objSelKind, String objName) {
        return String.format("%s:%s", objSelKind, objName);
    }

    public static String formatSelectorNoKind(String objName, String vobSelector) {
        return String.format("%s@%s", objName, vobSelector);
    }

    public static String formatSelectorNoKind(String selector) {
        String objectName = ObjSelUtils.getObjSelName(selector);
        String vob = ObjSelUtils.getObjSelVobSel(selector);
        return ObjSelUtils.formatSelectorNoKind(objectName, vob);
    }

    public static String initialBaselineName(String compName) {
        return String.valueOf(compName) + "_INITIAL";
    }

    public static String initialBaselineSelector(String compName, String vobSelector) {
        return ObjSelUtils.formatSelector(BASELINE, ObjSelUtils.initialBaselineName(compName), vobSelector);
    }

    public static String initialBaselineSelector(String componentSelector) {
        return ObjSelUtils.initialBaselineSelector(ObjSelUtils.getObjSelName(componentSelector), ObjSelUtils.getObjSelVobSel(componentSelector));
    }

    public static String makeUsel(String vobuuid, String oid) {
        return ObjSelUtils.formatSelector(OID, oid, vobuuid);
    }

    public static String makeVobUsel(String voboid) {
        return String.format("oid:%s@vobuuid:%s", voboid, voboid);
    }

    public static String stripObjSelKind(String pvobSelector) {
        Matcher vobuuidMatcher = VOB_UUID_PATTERN.matcher(pvobSelector);
        if (!vobuuidMatcher.find()) {
            throw new IllegalArgumentException("getVobuuid could not find vobuuid in " + pvobSelector);
        }
        return vobuuidMatcher.replaceFirst("$1");
    }

    private static String[] burstSelector(String selector) {
        Matcher m = OBJECT_SELECTOR_PATTERN.matcher(selector);
        String[] result = new String[3];
        if (m.find()) {
            result[0] = m.replaceAll("$1");
            result[1] = m.replaceAll("$2");
            result[2] = m.replaceAll("$3");
            return result;
        }
        m = SHORT_OBJECT_SELECTOR_PATTERN.matcher(selector);
        if (m.find()) {
            result[0] = m.replaceAll("$1");
            result[1] = m.replaceAll("$2");
            result[2] = null;
            return result;
        }
        return null;
    }

    public static String getObjSelKind(String selector) {
        return ObjSelUtils.getObjSelPart(selector, 0);
    }

    public static String getObjSelName(String selector) {
        return ObjSelUtils.getObjSelPart(selector, 1);
    }

    public static String getObjSelVobSel(String selector) {
        return ObjSelUtils.getObjSelPart(selector, 2);
    }

    private static String getObjSelPart(String selector, int index) {
        String[] parts = ObjSelUtils.burstSelector(selector);
        if (parts == null || parts[index] == null) {
            return new String();
        }
        return parts[index];
    }

    public static boolean isUniversalSelector(String string) {
        return string.matches("oid:.+@vobuuid:.+");
    }

    public static boolean isOidSelector(String string) {
        return string.matches("oid:.+@(..)?/.+");
    }

    public static boolean isFullyQualifiedSelector(String string) {
        return string.matches("^.+?:.+?@.+?");
    }

    private static final Pattern getViewTagInPathnamePattern(String mvfsRoot) {
        return Pattern.compile(String.valueOf('^') + mvfsRoot + "[/\\\\](.+?)([/\\\\].*|$)");
    }

    public static final String getViewTag(String mvfsRoot, String locString) {
        String result = null;
        Matcher viewtagMatcher = null;
        viewtagMatcher = locString.startsWith("/view/") ? VIEWTAG_IN_SELECTOR_PATTERN_UX.matcher(locString) : VIEWTAG_IN_SELECTOR_PATTERN_WIN.matcher(locString);
        if (viewtagMatcher.find()) {
            result = viewtagMatcher.replaceFirst("$2");
        } else {
            viewtagMatcher = ObjSelUtils.getViewTagInPathnamePattern(mvfsRoot).matcher(locString);
            if (viewtagMatcher.find()) {
                result = viewtagMatcher.replaceFirst("$1");
            }
        }
        return result;
    }

    public static final String composePathname(String viewTag, String compPathname, String myRelativePath) throws WvcmException {
        String viewPrefix = CCaseLib.getPathIntoView(viewTag);
        String result = String.valueOf(viewPrefix) + compPathname;
        if (myRelativePath != null) {
            result = String.valueOf(result) + '/' + myRelativePath;
        }
        return CommonUtils.canonicalizePathname(result);
    }

    public static String computeStgPath(boolean isView, String tag, String stgDir) {
        String pathname;
        File path;
        String storageDir = CommonUtils.canonicalizePathname(stgDir);
        if (!storageDir.endsWith(CommonUtils.FWDSLASH)) {
            storageDir = String.valueOf(storageDir) + CommonUtils.FWDSLASH;
        }
        if ((path = new File(pathname = String.valueOf(storageDir) + tag + (isView ? ".vws" : ".vbs"))).exists()) {
            pathname = String.valueOf(pathname) + UNDERSCORE + DATE_TIME_FORMAT.format(new Date());
        }
        return pathname;
    }

    public static String stripTrailingElementSuffix(String gpath) {
        return gpath.replaceAll("@@$", new String());
    }

    public static final void validateViewStgPath(String viewStgPath) throws WvcmException {
        if (viewStgPath == null) {
            throw new IllegalArgumentException("view storage path must not be null");
        }
        if (CommandProvider.IS_WINDOWS && !CommonUtils.canonicalizePathname(viewStgPath).startsWith(CommonUtils.FWDSLASH)) {
            throw new WvcmException(NLS.bind((String)Messages.ObjSelUtils_STORAGE_PATH_MUST_BE_UNC, (Object)viewStgPath), WvcmException.ReasonCode.FORBIDDEN);
        }
        File viewStg = new File(viewStgPath);
        if (!viewStg.exists()) {
            throw new WvcmException(NLS.bind((String)Messages.ObjSelUtils_COULD_NOT_FIND_STORAGE_ERROR, (Object)viewStgPath), WvcmException.ReasonCode.FORBIDDEN);
        }
        if (!viewStg.isDirectory()) {
            throw new WvcmException(NLS.bind((String)Messages.ObjSelUtils_STORAGE_PATH_MUST_BE_DIR, (Object)viewStgPath), WvcmException.ReasonCode.FORBIDDEN);
        }
        if (!viewStg.canWrite()) {
            throw new WvcmException(NLS.bind((String)Messages.ObjSelUtils_STORAGE_PATH_IS_NOT_WRITEABLE, (Object)viewStgPath), WvcmException.ReasonCode.FORBIDDEN);
        }
    }

    public static String extendedElemPathName(String elemPathName) {
        if (elemPathName.contains(EXTENDED_NAMING_SYMBOL)) {
            return elemPathName;
        }
        return String.valueOf(elemPathName) + EXTENDED_NAMING_SYMBOL;
    }

    public static String uuidToOid(String uuid) {
        return MessageFormat.format("{0}.{1}.{2}.{3}:{4}:{5}:{6}:{7}:{8}", uuid.substring(0, 8), uuid.substring(8, 16), uuid.substring(16, 20), uuid.substring(20, 22), uuid.substring(22, 24), uuid.substring(24, 26), uuid.substring(26, 28), uuid.substring(28, 30), uuid.substring(30, 32));
    }
}

