/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.daemon;

import com.ibm.team.filesystem.client.daemon.JSONHandlerEvent;
import com.ibm.team.filesystem.client.internal.http.HttpRequest;
import com.ibm.team.filesystem.client.internal.http.HttpResponse;
import com.ibm.team.repository.common.json.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;

public class JSONHandlerResponseEvent
extends JSONHandlerEvent {
    private final Charset payloadCharset;
    private final byte[] payload;
    private final int payloadSize;
    private final int payloadOffset;

    public JSONHandlerResponseEvent(HttpRequest req, HttpResponse resp, Charset payloadCharset, byte[] payload) {
        super(req, resp);
        this.payloadCharset = payloadCharset;
        this.payload = payload;
        this.payloadSize = payload != null ? payload.length : -1;
        this.payloadOffset = payload != null ? 0 : -1;
    }

    public JSONHandlerResponseEvent(HttpRequest req, HttpResponse resp, Charset payloadCharset, byte[] payload, int payloadOffset, int payloadSize) {
        super(req, resp);
        this.payloadCharset = payloadCharset;
        this.payload = payload;
        this.payloadSize = payloadSize;
        this.payloadOffset = payloadOffset;
    }

    public String getFormattedPayload() {
        Object parsed;
        if (this.payload == null || this.payloadSize < 1) {
            return "(null)";
        }
        try {
            parsed = JSONObject.parseAny((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(this.payload, this.payloadOffset, this.payloadSize), this.payloadCharset));
        }
        catch (IOException e) {
            StringBuffer buf = new StringBuffer("Exception decoding: " + e.getMessage() + "\nFull text: ");
            buf.append(new String(this.payload));
            return buf.toString();
        }
        if (parsed == null) {
            return "(null)";
        }
        return parsed.toString();
    }
}

