/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.common.internal.setup.builders;

import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.common.internal.setup.builders.BuildContext;
import com.ibm.team.rtc.common.internal.setup.builders.IArtifactBuilder;
import com.ibm.team.rtc.common.internal.setup.builders.IArtifactBuilderContext;
import com.ibm.team.rtc.common.internal.setup.builders.IPostSaveHook;
import com.ibm.team.rtc.common.internal.setup.builders.IPreSaveHook;
import com.ibm.team.rtc.common.internal.setup.builders.ValueKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class AbstractArtifactBuilder<T>
implements IArtifactBuilder<T> {
    private final IArtifactBuilderContext fBuildContext;
    private final Map<String, Object> fBuilderValues = new HashMap<String, Object>();
    private final List<IArtifactBuilder<?>> fChildBuilders = new LinkedList();
    private List<IPostSaveHook<T>> fPostSaveHooks = new LinkedList<IPostSaveHook<T>>();
    private List<IPreSaveHook<T>> fPreSaveHooks = new LinkedList<IPreSaveHook<T>>();
    private T fExistingArtifact;

    public AbstractArtifactBuilder(IArtifactBuilderContext buildContext) {
        this.fBuildContext = buildContext;
    }

    public AbstractArtifactBuilder<T> addPostSaveHook(IPostSaveHook<T> postSaveHook) {
        this.fPostSaveHooks.add(postSaveHook);
        return this;
    }

    public AbstractArtifactBuilder<T> addPreSaveHook(IPreSaveHook<T> preSaveHook) {
        this.fPreSaveHooks.add(preSaveHook);
        return this;
    }

    protected void use(T existingArtifact) {
        this.fExistingArtifact = existingArtifact;
    }

    protected T getExistingArtifact() {
        return this.fExistingArtifact;
    }

    protected boolean artifactExists() {
        return this.fExistingArtifact != null;
    }

    protected T artifact(IItemType itemType) {
        Object item;
        if (this.artifactExists()) {
            item = this.getExistingArtifact();
            if (item instanceof IItem && ((IItem)item).getWorkingCopy() != null) {
                item = ((IItem)item).getWorkingCopy();
            }
        } else {
            item = itemType.createItem();
        }
        return item;
    }

    public T save() throws TeamRepositoryException {
        return this.save(new BuildContext());
    }

    @Override
    public T save(BuildContext saveContext) throws TeamRepositoryException {
        if (this.getContext() == null) {
            throw new UnsupportedOperationException("Cannot call save() while running unit tests.");
        }
        T artifact = this.doSave(saveContext);
        artifact = this.postSave(artifact, saveContext);
        this.fireSaveEvent(artifact);
        return artifact;
    }

    protected T postSave(T artifact, BuildContext saveContext) throws TeamRepositoryException {
        return artifact;
    }

    public T build() {
        return this.build(new BuildContext());
    }

    @Override
    public T build(BuildContext buildContext) {
        T artifact = this.doBuild(buildContext);
        this.adapt(artifact);
        this.fireSaveEvent(artifact);
        return artifact;
    }

    public void updateItem(T storeItem) {
        this.fireSaveEvent(new ArtifactSavedEvent<T>(storeItem, ArtifactSavedEvent.SaveEventType.UPDATE));
    }

    protected IArtifactBuilderContext getContext() {
        return this.fBuildContext;
    }

    protected <K> void setBuilderValue(ValueKey<K> key, K value) {
        this.fBuilderValues.put(key.fKey, value);
    }

    protected <K> K getBuilderValue(ValueKey<K> key) {
        return this.getBuilderValue(key, null);
    }

    protected <K> boolean isBuilderValueSet(ValueKey<K> key) {
        return this.fBuilderValues.containsKey(key.fKey);
    }

    protected <K> K getBuilderValue(ValueKey<K> key, K defaultValue) {
        return (K)(this.fBuilderValues.containsKey(key.fKey) ? this.fBuilderValues.get(key.fKey) : defaultValue);
    }

    protected void addChildBuilder(IArtifactBuilder<?> ... builder) {
        this.fChildBuilders.addAll(Arrays.asList(builder));
    }

    protected List<IArtifactBuilder<?>> getChildBuilders() {
        return Collections.unmodifiableList(this.fChildBuilders);
    }

    protected abstract T doSave(BuildContext var1) throws TeamRepositoryException;

    protected abstract T doBuild(BuildContext var1);

    protected void adapt(T artifact) {
        for (IPreSaveHook<T> preSaveHook : this.fPreSaveHooks) {
            preSaveHook.adapt(new ArtifactSavedEvent<T>(artifact, ArtifactSavedEvent.SaveEventType.SAVE));
        }
    }

    protected void adapt(ArtifactSavedEvent<T> artifactSavedEvent) {
        for (IPreSaveHook<T> preSaveHook : this.fPreSaveHooks) {
            preSaveHook.adapt(artifactSavedEvent);
        }
    }

    protected void fireSaveEvent(T artifact) {
        for (IPostSaveHook<T> postSaveHook : this.fPostSaveHooks) {
            postSaveHook.itemSaved(new ArtifactSavedEvent<T>(artifact, ArtifactSavedEvent.SaveEventType.SAVE));
        }
    }

    protected void fireSaveEvent(ArtifactSavedEvent<T> artifactSavedEvent) {
        for (IPostSaveHook<T> postSaveHook : this.fPostSaveHooks) {
            postSaveHook.itemSaved(artifactSavedEvent);
        }
    }

    protected <K> K chooseValue(ValueKey<K> valuekey, K itemValue) {
        return this.chooseValue(valuekey, itemValue, itemValue);
    }

    protected <K> K chooseValue(ValueKey<K> valuekey, K itemValue, K defaultValue) {
        return this.chooseValue(null, valuekey, null, itemValue, defaultValue);
    }

    protected <K> K chooseValue(BuildContext context, ValueKey<K> valuekey, ValueKey<K> contextKey, K itemValue) {
        return this.chooseValue(context, valuekey, contextKey, itemValue, itemValue);
    }

    protected <K> K chooseValue(BuildContext context, ValueKey<K> valuekey, ValueKey<K> contextKey, K itemValue, K defaultValue) {
        if (this.isBuilderValueSet(valuekey)) {
            return this.getBuilderValue(valuekey);
        }
        if (context != null && context.isPropertySet(contextKey)) {
            return context.getProperty(contextKey);
        }
        return this.artifactExists() ? itemValue : defaultValue;
    }

    public static class ArtifactSavedEvent<T> {
        public T fArtifact;
        public SaveEventType fEventType;

        public ArtifactSavedEvent(T artifact, SaveEventType eventType) {
            this.fArtifact = artifact;
            this.fEventType = eventType;
        }

        public static enum SaveEventType {
            SAVE,
            UPDATE;

        }
    }
}

