/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.client;

import com.ibm.rational.wvcm.interop.InteropUtilities;
import com.ibm.rational.wvcm.ri.impl.VersionImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import com.ibm.team.connector.scm.client.JzProvider;
import com.ibm.team.connector.scm.client.JzRepoVersion;
import com.ibm.team.connector.scm.client.Messages;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IFileContentManager;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.VersionedContentDeleted;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.WvcmException;
import org.eclipse.core.runtime.IProgressMonitor;

public class JzRepoFileItem
extends JzRepoVersion {
    private static final String IO_ERROR_WHILE_DOWNLOADING_WITH_NAME = Messages.JzRepoFileItem_ERROR_WHILE_DOWNLOADING_WITH_NAME;
    static final List<PropertyNameList.PropertyName<?>> CONTENT_PROPERTIES = new ArrayList<PropertyNameList.PropertyName>(Arrays.asList(Resource.CONTENT_CHARACTER_SET, Resource.CONTENT_LENGTH, InteropUtilities.PN_LINE_SEPARATOR));
    static final Map<FileLineDelimiter, InteropUtilities.LineSeparator> delimsToSeps = new HashMap<FileLineDelimiter, InteropUtilities.LineSeparator>();

    static {
        delimsToSeps.put(FileLineDelimiter.LINE_DELIMITER_CR, InteropUtilities.LineSeparator.CR);
        delimsToSeps.put(FileLineDelimiter.LINE_DELIMITER_CRLF, InteropUtilities.LineSeparator.CRLF);
        delimsToSeps.put(FileLineDelimiter.LINE_DELIMITER_LF, InteropUtilities.LineSeparator.LF);
        delimsToSeps.put(FileLineDelimiter.LINE_DELIMITER_PLATFORM, InteropUtilities.LineSeparator.PLATFORM);
    }

    @Override
    public Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (CONTENT_PROPERTIES.contains(propertyName)) {
            IFileContent content = this.getContent(feedback);
            if (propertyName.equals((Object)Resource.CONTENT_CHARACTER_SET)) {
                return content.getCharacterEncoding();
            }
            if (propertyName.equals((Object)InteropUtilities.PN_LINE_SEPARATOR)) {
                FileLineDelimiter ld = content.getLineDelimiter();
                if (delimsToSeps.containsKey(ld)) {
                    return delimsToSeps.get(ld).name();
                }
                return InteropUtilities.LineSeparator.UNSPECIFIED.name();
            }
            if (propertyName.equals((Object)Resource.CONTENT_LENGTH)) {
                return content.getRawLength();
            }
        } else {
            if (propertyName.equals((Object)Resource.CONTENT_TYPE)) {
                return ((IFileItem)this.fetchCompleteState(feedback)).getContentType();
            }
            if (propertyName.equals((Object)Resource.IS_EXECUTABLE)) {
                return new Boolean(((IFileItem)this.fetchCompleteState(feedback)).isExecutable());
            }
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    private static IFileItem getFileItem(JzProvider p, IVersionableHandle handle, SrvcFeedback feedback) throws WvcmException {
        p.applyDeferredContentCommits(feedback);
        return (IFileItem)JzRepoFileItem.fetchCompleteState(p, handle, feedback);
    }

    private IFileContent getContent(SrvcFeedback feedback) throws WvcmException {
        return JzRepoFileItem.getFileItem(this.provider(), (IVersionableHandle)this.getItemHandle(feedback), feedback).getContent();
    }

    public JzRepoFileItem(JzProvider provider, Location loc) {
        super(provider, loc);
    }

    @Override
    public Class<?> get_proxyClass() {
        return VersionImpl.class;
    }

    public void doReadContent(OutputStream result, Resource accept, SrvcFeedback feedback) throws WvcmException {
        JzRepoFileItem.doReadContent(result, this.provider(), (IVersionableHandle)this.getItemHandle(feedback), accept, feedback);
    }

    protected static void doReadContent(OutputStream result, JzProvider provider, IVersionableHandle versionableHandle, Resource accept, SrvcFeedback feedback) throws WvcmException {
        try {
            FileLineDelimiter lineDelimiter;
            IFileItem file = JzRepoFileItem.getFileItem(provider, versionableHandle, feedback.nest(40));
            InteropUtilities.LineSeparator lineSeparator = JzProvider.lookupLineSeparator(accept);
            FileLineDelimiter fileLineDelimiter = lineDelimiter = lineSeparator == null ? FileLineDelimiter.LINE_DELIMITER_NONE : JzProvider.getLineDelimiter(lineSeparator);
            if (file != null) {
                JzRepoFileItem.readContent(FileSystemCore.getContentManager((ITeamRepository)provider.getRepo()), (IFileItemHandle)file, file.getContent(), lineDelimiter, accept != null ? accept.location() : null, result, JzProvider.getMonitor(feedback, 100), provider);
            }
        }
        catch (VersionedContentDeleted e) {
            throw new WvcmException("version's content has been deleted", WvcmException.ReasonCode.CONFLICT, (Throwable)e);
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }

    protected boolean hasSameContent(SrvcResource otherVersion, SrvcFeedback feedback) throws WvcmException {
        JzRepoFileItem otherFileItem = (JzRepoFileItem)otherVersion;
        IFileContent myContent = this.getContent(feedback);
        IFileContent otherContent = ((IFileItem)otherFileItem.fetchCompleteState(feedback)).getContent();
        return myContent.sameContent(otherContent);
    }

    static void readContent(IFileContentManager contentManager, IFileItemHandle state, IFileContent storedContent, FileLineDelimiter requestedDelimiter, Location acceptLocation, OutputStream output, IProgressMonitor monitor, JzProvider p) throws TeamRepositoryException, WvcmException {
        OutputStream outputLoc;
        FileLineDelimiter storedDelimiter;
        if (requestedDelimiter.equals((Object)FileLineDelimiter.LINE_DELIMITER_PLATFORM)) {
            requestedDelimiter = FileLineDelimiter.getPlatformDelimiter();
        }
        if ((storedDelimiter = storedContent.getLineDelimiter()).equals((Object)FileLineDelimiter.LINE_DELIMITER_PLATFORM)) {
            storedDelimiter = FileLineDelimiter.getPlatformDelimiter();
        }
        boolean useStoredDelimiter = storedDelimiter.equals((Object)requestedDelimiter) || FileLineDelimiter.LINE_DELIMITER_NONE.equals((Object)storedDelimiter);
        boolean convertVS = ((String)p.initArgs().get("com.ibm.team.connector.scm.PROCESS_VISUAL_STUDIO_FILES")).equals("true");
        OutputStream outputStream = outputLoc = convertVS && JzProvider.isVSFile(acceptLocation) ? new ByteArrayOutputStream() : output;
        if (useStoredDelimiter) {
            contentManager.retrieveContent(state, storedContent, outputLoc, monitor);
        } else {
            try {
                InputStream input = contentManager.retrieveContentStream(state, storedContent, storedContent.getCharacterEncoding(), requestedDelimiter, monitor);
                try {
                    byte[] buf = new byte[8192];
                    int read = input.read(buf);
                    while (read != -1) {
                        outputLoc.write(buf, 0, read);
                        read = input.read(buf);
                    }
                }
                finally {
                    input.close();
                }
            }
            catch (IOException e) {
                throw new TeamRepositoryException(NLS.bind((String)IO_ERROR_WHILE_DOWNLOADING_WITH_NAME, (Object)storedContent, (Object[])new Object[0]), (Throwable)e);
            }
        }
        if (convertVS && JzProvider.isVSFile(acceptLocation)) {
            JzProvider.convertSCPInVsFileFromJazz(acceptLocation, (ByteArrayOutputStream)outputLoc, output, storedContent.getCharacterEncoding(), useStoredDelimiter ? storedDelimiter : requestedDelimiter);
        }
    }

    public void deleteContentForTest(SrvcFeedback f) throws WvcmException {
        JzProvider provider = this.provider();
        IFileContent content = this.getContent(f);
        ContentHash hash = content.getHash();
        try {
            IFileContentManager contentManager = FileSystemCore.getContentManager((ITeamRepository)provider.getRepo());
            contentManager.deleteContent(hash, false, JzProvider.getMonitor(f, 100));
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException((Exception)((Object)e));
        }
    }
}

