/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.wvcm.WvcmException;

public class TreeNode<T> {
    final T item;
    String label;
    List<TreeNode<T>> predecessors = new ArrayList<TreeNode<T>>();
    private final List<TreeNode<T>> successors = new ArrayList<TreeNode<T>>();

    TreeNode(T item) {
        this(item, item instanceof String ? (String)item : null);
    }

    TreeNode(T item, String label) {
        this.item = item;
        this.label = label == null && item instanceof String ? (String)item : label;
    }

    void addParent(TreeNode<T> parent, boolean isMergeParent) {
        if (isMergeParent || this.predecessors.isEmpty()) {
            this.predecessors.add(parent);
        } else {
            this.predecessors.add(0, parent);
        }
    }

    void addChild(TreeNode<T> child) {
        this.successors.add(child);
    }

    boolean parentAndChildLinkagesAreValid() {
        boolean isThisChildOfParent = false;
        boolean isThisChildOfAllParents = true;
        for (TreeNode<T> predecessor : this.predecessors) {
            if (predecessor.successors().contains(this)) {
                isThisChildOfParent = true;
            }
            if (isThisChildOfParent) {
                isThisChildOfParent = false;
                continue;
            }
            isThisChildOfAllParents = false;
            break;
        }
        if (!isThisChildOfAllParents) {
            return false;
        }
        boolean isThisParentOfChildren = true;
        boolean isThisParentOfChild = false;
        for (TreeNode<T> child : this.successors()) {
            for (TreeNode<T> parent : child.predecessors()) {
                if (!this.equals(parent)) continue;
                isThisParentOfChild = true;
                break;
            }
            if (isThisParentOfChild) {
                isThisParentOfChild = false;
                continue;
            }
            isThisParentOfChildren = false;
            break;
        }
        return isThisParentOfChildren;
    }

    void traverse(ITreeNodeVisitor<T> visitor, int depth) throws WvcmException {
        visitor.visit(this, depth);
        for (TreeNode<T> child : this.successors()) {
            child.traverse(visitor, 1 + depth);
        }
    }

    public List<TreeNode<T>> predecessors() {
        return Collections.unmodifiableList(this.predecessors);
    }

    public List<TreeNode<T>> successors() {
        return Collections.unmodifiableList(this.successors);
    }

    public static interface ITreeNodeVisitor<T> {
        public void visit(TreeNode<T> var1, int var2) throws WvcmException;
    }
}

