/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.attributeValueProviders;

import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProcessConfigurationData;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IAuditableCommonProcess;
import com.ibm.team.workitem.common.internal.attributeValueProviders.CachableConfiguration;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IConfiguration;
import com.ibm.team.workitem.common.internal.attributeValueProviders.ProviderType;
import com.ibm.team.workitem.common.internal.util.CacheHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public class ProviderConfigurationManager
extends CacheHelper {
    public static final String PROVIDERS_CONFIGURATION_DATA_POINT = "com.ibm.team.workitem.configuration.providers";
    public static final String VALUE_SET_PROVIDERS = "valueSetProviders";
    public static final String VALUE_PROVIDERS = "valueProviders";
    public static final String DEFAULT_VALUE_PROVIDERS = "defaultValueProviders";
    public static final String CONDITIONS = "conditions";
    public static final String VALIDATORS = "validators";
    public static final String PROVIDER_ID = "providerId";
    private final Map<UUID, ProviderDefinitions> fDefinitions = new HashMap<UUID, ProviderDefinitions>();

    public ProviderConfigurationManager(IAuditableCommon auditableCommon) {
        super(auditableCommon);
    }

    public IConfiguration getProviderConfiguration(IProjectAreaHandle projectArea, ProviderType providerType, String providerId, IProgressMonitor monitor) throws TeamRepositoryException {
        this.checkCache(projectArea, monitor);
        ProviderDefinitions definitions = this.fDefinitions.get(projectArea.getItemId());
        return definitions.getConfiguration(providerType, providerId);
    }

    public ProviderDefinitions getProviderDefinitions(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        this.checkCache(projectArea, monitor);
        return this.fDefinitions.get(projectArea.getItemId());
    }

    @Override
    protected void updateCache(IProjectAreaHandle projectArea, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        ProviderDefinitions definitions = this.computeProviderDefinitions(projectArea, monitor);
        this.fDefinitions.put(projectArea.getItemId(), definitions);
    }

    private ProviderDefinitions computeProviderDefinitions(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        IAuditableCommonProcess process = this.getAuditableCommon().getProcess((IProcessAreaHandle)projectArea, monitor);
        IProcessConfigurationData processConfiguration = process.findProcessConfiguration(PROVIDERS_CONFIGURATION_DATA_POINT, null);
        return ProviderConfigurationManager.computeProviderDefinitions(processConfiguration);
    }

    public static ProviderDefinitions computeProviderDefinitions(IProcessConfigurationData processConfiguration) {
        ProviderDefinitions definitions = new ProviderDefinitions();
        if (processConfiguration != null) {
            IProcessConfigurationElement[] iProcessConfigurationElementArray = processConfiguration.getElements();
            int n = iProcessConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProcessConfigurationElement element = iProcessConfigurationElementArray[n2];
                IProcessConfigurationElement[] iProcessConfigurationElementArray2 = element.getChildren();
                int n3 = iProcessConfigurationElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IProcessConfigurationElement providerElement = iProcessConfigurationElementArray2[n4];
                    ProviderType providerType = ProviderType.fromId(providerElement.getName());
                    if (providerType != null) {
                        definitions.add(providerElement);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return definitions;
    }

    public static class ProviderDefinitions {
        private final Map<String, Map<String, IConfiguration>> fDefinitionMap = new HashMap<String, Map<String, IConfiguration>>();

        private ProviderDefinitions() {
        }

        public IConfiguration getConfiguration(ProviderType providerType, String providerId) {
            Map<String, IConfiguration> providerMap = this.fDefinitionMap.get(providerType.getId());
            return providerMap != null ? providerMap.get(providerId) : null;
        }

        public Set<String> getProviderIds(ProviderType providerType) {
            Map<String, IConfiguration> providerMap = this.fDefinitionMap.get(providerType.getId());
            if (providerMap == null) {
                return Collections.emptySet();
            }
            return providerMap.keySet();
        }

        private void add(IProcessConfigurationElement providerElement) {
            String providerId;
            CachableConfiguration configuration = new CachableConfiguration(providerElement);
            Map<String, IConfiguration> providerMap = this.fDefinitionMap.get(providerElement.getName());
            if (providerMap == null) {
                providerMap = new HashMap<String, IConfiguration>();
                this.fDefinitionMap.put(providerElement.getName(), providerMap);
            }
            if ((providerId = providerElement.getAttribute("id")) != null) {
                providerMap.put(providerId, configuration);
            }
        }
    }
}

