/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.emailtemplates;

import com.ibm.team.workitem.common.internal.emailtemplates.TemplatePart;

public class EmailTemplate {
    private final String fID;
    private String fName;
    private String fDescription;
    private String fSubject;
    private String fHTMLBody;
    private String fPlainTextBody;
    private TemplatePart fSubjectPart;
    private TemplatePart fHTMLBodyPart;
    private TemplatePart fPlainTextBodyPart;

    public EmailTemplate(String ID) {
        this.fID = ID;
    }

    public String getID() {
        return this.fID;
    }

    public String getName() {
        return this.fName;
    }

    public String getSubject() {
        return this.fSubject == null ? "" : EmailTemplate.eliminateNewLineCharacters(this.fSubject);
    }

    public String getHTMLBody() {
        return this.fHTMLBody == null ? "" : EmailTemplate.normalizeNewLineCharacter(this.fHTMLBody);
    }

    public String getPlainTextBody() {
        return this.fPlainTextBody == null ? "" : EmailTemplate.normalizeNewLineCharacter(this.fPlainTextBody);
    }

    public String getfDescription() {
        return this.fDescription;
    }

    public void setName(String Name) {
        this.fName = Name;
    }

    public void setSubject(String Subject) {
        this.fSubject = Subject;
        this.fSubjectPart = null;
    }

    public void setHTMLBody(String HTMLBody) {
        this.fHTMLBody = HTMLBody;
        this.fHTMLBodyPart = null;
    }

    public void setPlainTextBody(String PlainTextBody) {
        this.fPlainTextBody = PlainTextBody;
        this.fPlainTextBodyPart = null;
    }

    public void setDescription(String Description) {
        this.fDescription = Description;
    }

    public TemplatePart getSubjectPart() {
        if (this.fSubjectPart == null) {
            this.fSubjectPart = new TemplatePart(this.fSubject);
        }
        return this.fSubjectPart;
    }

    public TemplatePart getHTMLBodyPart() {
        if (this.fHTMLBodyPart == null) {
            this.fHTMLBodyPart = new TemplatePart(this.fHTMLBody);
        }
        return this.fHTMLBodyPart;
    }

    public TemplatePart getPlainTextBodyPart() {
        if (this.fPlainTextBodyPart == null) {
            this.fPlainTextBodyPart = new TemplatePart(this.fPlainTextBody);
        }
        return this.fPlainTextBodyPart;
    }

    public static String normalizeNewLineCharacter(String input) {
        String output = input.replaceAll("\r\n", "\n");
        return output.replaceAll("\r", "\n");
    }

    public static String eliminateNewLineCharacters(String input) {
        String output = input.replaceAll("\n", "");
        output = output.replaceAll("\r", "");
        return output;
    }
}

