/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.oslc.mappings;

import com.ibm.team.calm.foundation.common.CustomNamespaceContext;
import com.ibm.team.calm.foundation.common.Namespaces;
import com.ibm.team.calm.foundation.common.oslc.OSLCCoreIdentifiers;
import com.ibm.team.calm.foundation.common.oslc.Version;
import com.ibm.team.foundation.common.util.FoundationLog;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.links.common.registry.ILinkTypeRegistry;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.transport.AbstractElementDescriptor;
import com.ibm.team.repository.common.transport.TeamServiceRegistryException;
import com.ibm.team.repository.common.util.ExtensionRegistryReader;
import com.ibm.team.workitem.common.internal.oslc.mappings.AbstractVersionedDescriptor;
import com.ibm.team.workitem.common.internal.oslc.mappings.AttributeRegistry;
import com.ibm.team.workitem.common.internal.oslc.mappings.AttributeTypeDescriptor;
import com.ibm.team.workitem.common.internal.oslc.mappings.EMFAttributeDescriptor;
import com.ibm.team.workitem.common.internal.oslc.mappings.IAttributeDescriptor;
import com.ibm.team.workitem.common.internal.oslc.mappings.IAttributeTypeDescriptor;
import com.ibm.team.workitem.common.internal.oslc.mappings.LinkAttributeDescriptor;
import com.ibm.team.workitem.common.internal.oslc.mappings.Messages;
import com.ibm.team.workitem.common.model.WorkItemLinkTypes;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;

public class OSLCAttributeDefinitionDescriptor
extends AbstractElementDescriptor {
    private static final FoundationLog LOGGER = FoundationLog.getLog(ExtensionRegistryReader.class);
    private static final String ELEMENT = "oslcAttributeDefinition";
    private static final String VERSION = "version";
    private static final String NS_ELEMENT = "ns";
    private static final String TYPE_ELEMENT = "type";
    private static final String ATTRIBUTE_ELEMENT = "attribute";
    private static final String LINK_ELEMENT = "link";
    private static final String ATTR_ID = "id";
    private static final String ATTR_URI = "uri";
    private static final String ATTR_INTERNAL_ID = "id";
    private static final String ATTR_OSLC_ID = "publicId";
    private static final String ATTR_ITEM_TYPE_ID = "itemTypeId";
    private static final String ATTR_NS = "ns";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_TITLE = "title";
    private static final String ATTR_DESCRIPTION = "description";
    private static final String ATTR_MIN_OCCURS = "min-occurs";
    private static final String ATTR_IS_COLLECTION = "isCollection";
    private static final String ATTR_IS_SINGLE_VALUED = "isSingleValued";
    private static final String ATTR_IS_READ_ONLY = "isReadOnly";
    private static final String ATTR_IS_MEMBER_PROPERTY = "isMemberProperty";
    private static final String ATTR_COMPLETE_LINKS = "completeLinks";
    private static final String ATTR_LINKS_NS = "linksNs";
    private static final String ATTR_EMF_PATH = "emfPath";
    private static final String ATTR_HIDDEN = "hidden";
    private static final String ATTR_REPRESENTATION = "representation";
    private static final String ATTR_IS_LITERAL_TYPE = "isLiteralType";
    private CustomNamespaceContext fNamespaces;
    private List<String> fAddedTypes;
    private Version fVersion;

    protected OSLCAttributeDefinitionDescriptor(IConfigurationElement element) {
        super(element, ELEMENT);
    }

    void remove() throws TeamServiceRegistryException {
        AttributeRegistry instance = AttributeRegistry.getInstance();
        for (String typeName : this.fAddedTypes) {
            instance.removeTypeDescriptor(typeName);
        }
    }

    private Version getVersion() {
        if (this.fVersion == null) {
            String version = this.getElement().getAttribute(VERSION);
            this.fVersion = version == null ? OSLCCoreIdentifiers.VERSION_DEFAULT : new Version(version);
        }
        return this.fVersion;
    }

    protected void processChild(IConfigurationElement child) {
        String elementName = child.getName();
        if (elementName.equals("ns")) {
            String id = child.getAttribute("id");
            String uri = child.getAttribute(ATTR_URI);
            if (this.fNamespaces == null) {
                this.fNamespaces = Namespaces.createDefaultContext();
            }
            this.fNamespaces.setPrefixSuggestion(uri, id);
        } else if (elementName.equals("type")) {
            IConfigurationElement[] attrOslcId;
            IConfigurationElement[] children;
            String typeId = child.getAttribute("id");
            String oslcId = child.getAttribute(ATTR_OSLC_ID);
            String ns = child.getAttribute("ns");
            String itemTypeId = child.getAttribute(ATTR_ITEM_TYPE_ID);
            AttributeRegistry registry = AttributeRegistry.getInstance();
            AttributeTypeDescriptor typeDescriptor = (AttributeTypeDescriptor)registry.getTypeDescriptor(typeId);
            if (typeDescriptor == null) {
                typeDescriptor = new AttributeTypeDescriptor(typeId, itemTypeId);
                registry.addTypeDescriptor(typeDescriptor);
            }
            typeDescriptor.addPublicIdentifier(this.getVersion(), oslcId, this.getNamespaceURI(ns));
            typeDescriptor.setNamespaceContext(this.getVersion(), this.fNamespaces);
            typeDescriptor.setLiteralType(Boolean.parseBoolean(child.getAttribute(ATTR_IS_LITERAL_TYPE)));
            boolean completeLinks = Boolean.parseBoolean(child.getAttribute(ATTR_COMPLETE_LINKS));
            IConfigurationElement[] iConfigurationElementArray = children = child.getChildren(ATTRIBUTE_ELEMENT);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                EMFAttributeDescriptor attrDescriptor;
                IConfigurationElement attr = iConfigurationElementArray[n2];
                String attrInternalId = attr.getAttribute("id");
                attrOslcId = attr.getAttribute(ATTR_OSLC_ID);
                String attrNs = attr.getAttribute("ns");
                String type = attr.getAttribute("type");
                String displayName = attr.getAttribute(ATTR_TITLE);
                String description = attr.getAttribute(ATTR_DESCRIPTION);
                String emfPath = attr.getAttribute(ATTR_EMF_PATH);
                String representation = attr.getAttribute(ATTR_REPRESENTATION);
                boolean isCollection = Boolean.parseBoolean(attr.getAttribute(ATTR_IS_COLLECTION));
                boolean isReadOnly = Boolean.parseBoolean(attr.getAttribute(ATTR_IS_READ_ONLY));
                boolean inline = "inline".equals(representation);
                String minOccursValue = attr.getAttribute(ATTR_MIN_OCCURS);
                int minOccurs = minOccursValue != null && minOccursValue.length() > 0 ? Integer.parseInt(minOccursValue) : 0;
                Boolean isMemberProperty = null;
                String memberPropertyValue = attr.getAttribute(ATTR_IS_MEMBER_PROPERTY);
                if (memberPropertyValue != null && memberPropertyValue.length() > 0) {
                    isMemberProperty = Boolean.parseBoolean(memberPropertyValue);
                }
                if ((attrDescriptor = (EMFAttributeDescriptor)typeDescriptor.getAttributeDescriptor(attrInternalId)) == null) {
                    attrDescriptor = new EMFAttributeDescriptor(attrInternalId, typeDescriptor.getAttributeTypeIdentifier(), type, displayName, description, emfPath, isReadOnly, isCollection, inline, representation, minOccurs, isMemberProperty);
                    typeDescriptor.addAttributeDescriptor(attrDescriptor);
                }
                attrDescriptor.addPublicIdentifier(this.getVersion(), (String)attrOslcId, this.getNamespaceURI(attrNs));
                ++n2;
            }
            IConfigurationElement[] links = child.getChildren(LINK_ELEMENT);
            if (completeLinks || links.length > 0) {
                Map<String, IEndPointDescriptor> linkEndPoints = this.getLinkEndPoints(typeDescriptor);
                attrOslcId = links;
                int n3 = links.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement attr = attrOslcId[n4];
                    String description = attr.getAttribute(ATTR_DESCRIPTION);
                    String attrInternalId = attr.getAttribute("id");
                    String attrOslcId2 = attr.getAttribute(ATTR_OSLC_ID);
                    String attrNs = attr.getAttribute("ns");
                    String representation = attr.getAttribute(ATTR_REPRESENTATION);
                    boolean hidden = Boolean.parseBoolean(attr.getAttribute(ATTR_HIDDEN));
                    boolean isSingleValued = Boolean.parseBoolean(attr.getAttribute(ATTR_IS_SINGLE_VALUED));
                    boolean inline = "inline".equals(representation);
                    IEndPointDescriptor endPointDescriptor = linkEndPoints.remove(attrInternalId);
                    if (endPointDescriptor != null) {
                        if (!hidden) {
                            LinkAttributeDescriptor attrDescriptor = (LinkAttributeDescriptor)typeDescriptor.getAttributeDescriptor(attrInternalId);
                            if (attrDescriptor == null) {
                                attrDescriptor = new LinkAttributeDescriptor(typeDescriptor.getAttributeTypeIdentifier(), attrInternalId, endPointDescriptor, inline, isSingleValued, description);
                                typeDescriptor.addAttributeDescriptor(attrDescriptor);
                            }
                            attrDescriptor.addPublicIdentifier(this.getVersion(), attrOslcId2, this.getNamespaceURI(attrNs));
                        }
                    } else {
                        LOGGER.error(MessageFormat.format(Messages.getString("OSLCAttributeDefinitionDescriptor_UNKNOWN_LINK"), attrInternalId, typeDescriptor.getAttributeTypeIdentifier()), null);
                    }
                    ++n4;
                }
                if (completeLinks) {
                    String linkNamespace = child.getAttribute(ATTR_LINKS_NS);
                    if (linkNamespace == null) {
                        linkNamespace = ns;
                    }
                    for (Map.Entry<String, IEndPointDescriptor> entry : linkEndPoints.entrySet()) {
                        LinkAttributeDescriptor attrDescriptor = (LinkAttributeDescriptor)typeDescriptor.getAttributeDescriptor(entry.getKey());
                        if (attrDescriptor == null) {
                            attrDescriptor = new LinkAttributeDescriptor(typeDescriptor.getAttributeTypeIdentifier(), entry.getKey(), entry.getValue(), false, entry.getValue().isSingleValued(), null);
                            typeDescriptor.addAttributeDescriptor(attrDescriptor);
                        }
                        attrDescriptor.addPublicIdentifier(this.getVersion(), entry.getKey(), this.getNamespaceURI(linkNamespace));
                    }
                }
            }
            if (this.fAddedTypes == null) {
                this.fAddedTypes = new ArrayList<String>();
            }
            this.fAddedTypes.add(typeDescriptor.getAttributeTypeIdentifier());
        } else {
            super.processChild(child);
        }
    }

    private String getNamespaceURI(String id) {
        String nsURI;
        if (this.fNamespaces != null && (nsURI = this.fNamespaces.getNamespaceURI(id)) != null) {
            return nsURI;
        }
        return id;
    }

    private Map<String, IEndPointDescriptor> getLinkEndPoints(AttributeTypeDescriptor typeDescriptor) {
        HashMap<String, IEndPointDescriptor> result = new HashMap<String, IEndPointDescriptor>();
        Collection links = ILinkTypeRegistry.INSTANCE.allEntries();
        for (ILinkType linkType : links) {
            IEndPointDescriptor source = linkType.getSourceEndPointDescriptor();
            IEndPointDescriptor target = linkType.getTargetEndPointDescriptor();
            if (this.isSupported(source, typeDescriptor)) {
                result.put(OSLCAttributeDefinitionDescriptor.getIdentifier(target), target);
            }
            if (WorkItemLinkTypes.isSymmetric(source) || !this.isSupported(target, typeDescriptor)) continue;
            result.put(OSLCAttributeDefinitionDescriptor.getIdentifier(source), source);
        }
        return result;
    }

    private boolean isSupported(IEndPointDescriptor target, AttributeTypeDescriptor parentType) {
        IItemType itemType = target.getReferencedItemType();
        String itemTypeId = parentType.getItemTypeId();
        return itemType != null && itemTypeId != null && itemTypeId.equals(String.valueOf(itemType.getNamespaceURI()) + '.' + itemType.getName());
    }

    private static String getIdentifier(IEndPointDescriptor endPoint) {
        String endPointId = endPoint.getId();
        if (endPointId == null) {
            endPointId = endPoint.isSource() ? "s" : "t";
        }
        return String.format("%s.%s", endPoint.getLinkType().getLinkTypeId(), endPointId);
    }

    public String getExtensionPointPrintout(AttributeRegistry registry, Version version) {
        StringBuilder buf = new StringBuilder();
        for (IAttributeTypeDescriptor typeDesc : registry.getTypeDescriptors(version)) {
            String ns = this.fNamespaces.getPrefix(typeDesc.getNamespace());
            buf.append("<type id=\"").append(typeDesc.getAttributeTypeIdentifier()).append("\" publicId=\"").append(typeDesc.getPublicIdentifier()).append("\" ns=\"").append(ns);
            if (typeDesc.getItemTypeId() != null) {
                buf.append("\" itemTypeId=\"").append(typeDesc.getItemTypeId());
            }
            buf.append("\">").append('\n');
            for (IAttributeDescriptor desc : typeDesc.getAttributeDescriptors()) {
                String dns;
                AbstractVersionedDescriptor d;
                if (desc instanceof EMFAttributeDescriptor) {
                    d = (EMFAttributeDescriptor)desc;
                    dns = this.fNamespaces.getPrefix(d.getNamespace());
                    buf.append("\t").append("<attribute id=\"").append(((EMFAttributeDescriptor)d).getInternalIdentifier()).append("\" publicId=\"").append(d.getPublicIdentifier());
                    buf.append("\" ns=\"").append(dns).append("\" type=\"").append(((EMFAttributeDescriptor)d).getAttributeType()).append("\" title=\"").append(((EMFAttributeDescriptor)d).getDisplayName()).append("\"");
                    if (((EMFAttributeDescriptor)d).getEMFPath() != null && !((EMFAttributeDescriptor)d).getEMFPath().equals(((EMFAttributeDescriptor)d).getInternalIdentifier())) {
                        buf.append(" emfPath=\"").append(((EMFAttributeDescriptor)d).getEMFPath()).append("\"");
                    }
                    if (((EMFAttributeDescriptor)d).isReadOnly()) {
                        buf.append(" isReadOnly=\"true\"");
                    }
                    if (((EMFAttributeDescriptor)d).isCollection()) {
                        buf.append(" isCollection=\"true\"");
                    }
                    buf.append("/>").append('\n');
                    continue;
                }
                if (!(desc instanceof LinkAttributeDescriptor)) continue;
                d = (LinkAttributeDescriptor)desc;
                dns = this.fNamespaces.getPrefix(d.getNamespace());
                buf.append("\t").append("<link id=\"").append(OSLCAttributeDefinitionDescriptor.getIdentifier(((LinkAttributeDescriptor)d).getEndPointDescriptor())).append("\" publicId=\"").append(d.getPublicIdentifier());
                buf.append("\" ns=\"").append(dns).append("\"/>").append('\n');
            }
            buf.append("</type>").append('\n');
        }
        return buf.toString();
    }
}

