/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.ITeamAreaHierarchy;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.AuditableCommon;
import com.ibm.team.workitem.common.internal.WorkItemCommon;
import com.ibm.team.workitem.common.internal.util.CategoriesHelper;
import com.ibm.team.workitem.common.internal.util.CategoryTreeNode;
import com.ibm.team.workitem.common.internal.util.WorkItemQueries;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

public class CategoriesManager {
    private static final String HIERARCHICAL_NAME_DELIMITER = "/";
    private IAuditableCommon fAuditableCommon;
    private IProjectAreaHandle fProjectAreaHandle;
    private IProjectArea fProjectArea;
    private CategoryTreeNode fRoot;
    private boolean fWritable = false;
    private Map<UUID, ITeamArea> fTeamAreas;
    private Map<UUID, IDevelopmentLine> fDevelopmentLines;
    private Map<UUID, UUID> fTeamAreaToDevelopmentLineMap;
    private Map<UUID, String> fTeamAreaPaths = new HashMap<UUID, String>();

    public static CategoriesManager createInstance(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        return CategoriesManager.createInstance(auditableCommon, true, projectArea, monitor);
    }

    public static CategoriesManager createInstance(IAuditableCommon auditableCommon, boolean writable, IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        CategoriesManager manager = new CategoriesManager(auditableCommon, projectArea);
        manager.initialize(writable, monitor);
        return manager;
    }

    public CategoriesManager(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea) {
        this.fAuditableCommon = auditableCommon;
        this.fProjectAreaHandle = projectArea;
    }

    public IProjectArea getProjectArea() {
        return this.fProjectArea;
    }

    public CategoryTreeNode getRoot() {
        return this.fRoot;
    }

    public ITeamArea getTeamArea(ITeamAreaHandle handle) {
        return this.fTeamAreas.get(handle.getItemId());
    }

    public IDevelopmentLine getDevelopmentLine(ITeamAreaHandle teamArea) {
        UUID line = this.fTeamAreaToDevelopmentLineMap.get(teamArea.getItemId());
        return line != null ? this.fDevelopmentLines.get(line) : null;
    }

    public Collection<IDevelopmentLine> getDevelopmentLines() {
        return this.fDevelopmentLines.values();
    }

    public String getTeamAreaPath(ITeamAreaHandle teamArea) {
        String path = this.fTeamAreaPaths.get(teamArea.getItemId());
        if (path != null) {
            return path;
        }
        StringBuilder builder = new StringBuilder();
        ITeamAreaHierarchy hierarchy = this.getProjectArea().getTeamAreaHierarchy();
        ITeamArea current = this.getTeamArea(teamArea);
        while (current != null) {
            builder.insert(0, current.getName());
            builder.insert(0, HIERARCHICAL_NAME_DELIMITER);
            ITeamArea iTeamArea = current = hierarchy.getParent((ITeamAreaHandle)current) != null ? this.getTeamArea(hierarchy.getParent((ITeamAreaHandle)current)) : null;
        }
        return builder.length() > 0 ? builder.substring(1) : "";
    }

    public void removeNewArchived() {
        this.removeNewArchived(this.fRoot);
    }

    private void removeNewArchived(CategoryTreeNode node) {
        if (node.isArchived() && node.getItem().isNewItem() && node.getParent() != null) {
            node.getParent().removeChild(node);
            return;
        }
        for (CategoryTreeNode child : new ArrayList<CategoryTreeNode>(node.getChildren())) {
            this.removeNewArchived(child);
        }
    }

    public CategoryTreeNode findNode(ICategoryHandle category) {
        return this.findNode(this.getRoot(), category);
    }

    private CategoryTreeNode findNode(CategoryTreeNode node, ICategoryHandle category) {
        if (node.getCategory().sameItemId((IItemHandle)category)) {
            return node;
        }
        for (CategoryTreeNode child : node.getChildren()) {
            CategoryTreeNode found = this.findNode(child, category);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public void save(IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isTrue((boolean)this.fWritable);
        if (this.fRoot == null) {
            return;
        }
        ArrayList<ICategory> categories = new ArrayList<ICategory>();
        this.collectDirtyCategories(this.fRoot, categories);
        if (categories.isEmpty()) {
            return;
        }
        WorkItemCommon workItemCommon = (WorkItemCommon)this.fAuditableCommon.getPeer(IWorkItemCommon.class);
        List<ICategory> savedItems = workItemCommon.saveCategories(categories, monitor);
        HashMap<UUID, ICategory> map = new HashMap<UUID, ICategory>();
        for (ICategory category : savedItems) {
            map.put(category.getItemId(), category);
        }
        this.updateNodes(this.fRoot, map);
    }

    private void collectDirtyCategories(CategoryTreeNode parent, List<ICategory> categories) {
        if (parent.isDirty()) {
            categories.add(parent.getItem());
        }
        for (CategoryTreeNode child : parent.getChildren()) {
            this.collectDirtyCategories(child, categories);
        }
    }

    private void updateNodes(CategoryTreeNode parent, Map<UUID, ICategory> categories) {
        ICategory category = categories.get(parent.getCategory().getItemId());
        if (category != null) {
            parent.setItem(category);
        }
        for (CategoryTreeNode child : parent.getChildren()) {
            this.updateNodes(child, categories);
        }
    }

    public void updateTeamAreas(IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectArea projectArea = (IProjectArea)this.fAuditableCommon.resolveAuditable((IAuditableHandle)this.fProjectAreaHandle, ItemProfile.createFullProfile(IProjectArea.ITEM_TYPE), monitor);
        HashMap<UUID, ITeamArea> teamAreas = new HashMap<UUID, ITeamArea>();
        List teamAreaList = this.fAuditableCommon.resolveAuditablesPermissionAware(projectArea.getTeamAreas(), ItemProfile.createFullProfile(ITeamArea.ITEM_TYPE), monitor);
        for (ITeamArea teamArea : teamAreaList) {
            teamAreas.put(teamArea.getItemId(), teamArea);
        }
        HashMap<UUID, IDevelopmentLine> developmentLines = new HashMap<UUID, IDevelopmentLine>();
        List developmentLineList = this.fAuditableCommon.resolveAuditablesPermissionAware(Arrays.asList(projectArea.getDevelopmentLines()), ItemProfile.createFullProfile(IDevelopmentLine.ITEM_TYPE), monitor);
        for (IDevelopmentLine developmentLine : developmentLineList) {
            developmentLines.put(developmentLine.getItemId(), developmentLine);
        }
        HashMap<UUID, UUID> map = new HashMap<UUID, UUID>();
        for (ITeamArea teamArea : teamAreaList) {
            IDevelopmentLineHandle line = projectArea.getTeamAreaHierarchy().getDevelopmentLine((ITeamAreaHandle)teamArea);
            map.put(teamArea.getItemId(), line != null ? line.getItemId() : null);
        }
        this.fProjectArea = projectArea;
        this.fTeamAreas = teamAreas;
        this.fDevelopmentLines = developmentLines;
        this.fTeamAreaToDevelopmentLineMap = map;
        this.fTeamAreaPaths.clear();
    }

    private void initialize(boolean writable, IProgressMonitor monitor) throws TeamRepositoryException {
        this.updateTeamAreas(monitor);
        this.fRoot = this.resolveTree(writable, monitor);
    }

    /*
     * Unable to fully structure code
     */
    private CategoryTreeNode resolveTree(boolean writable, IProgressMonitor monitor) throws TeamRepositoryException {
        this.fWritable = writable;
        if (writable) {
            handles = WorkItemQueries.categoryByProjectArea(this.fAuditableCommon, (IProjectAreaHandle)this.getProjectArea()).toList(monitor);
            categories = this.fAuditableCommon.resolveAuditablesPermissionAware(handles, ICategory.FULL_PROFILE, monitor);
            i = 0;
            while (i < handles.size()) {
                handle = handles.get(i);
                category = categories.get(i);
                if (handle.getStateId() != null && !category.sameStateId((IItemHandle)handle)) {
                    categories.set(i, ((AuditableCommon)this.fAuditableCommon).fetchCurrentAuditable(handle, ICategory.FULL_PROFILE, monitor));
                }
                ++i;
            }
        } else {
            workItemCommon = this.fAuditableCommon.getPeer(IWorkItemCommon.class);
            categories = ((WorkItemCommon)workItemCommon).findAllCategories((IProjectAreaHandle)this.getProjectArea(), ICategory.FULL_PROFILE, monitor);
        }
        categories = new ArrayList<ICategory>(categories);
        Collections.sort(categories, new Comparator<ICategory>(){

            @Override
            public int compare(ICategory o1, ICategory o2) {
                return o1.getCategoryId().compareTo(o2.getCategoryId());
            }
        });
        if (categories.isEmpty()) {
            return null;
        }
        rootCategory = categories.remove(0);
        parent = root = CategoryTreeNode.createRoot(this, rootCategory);
        parentId = rootCategory.getCategoryId().getInternalRepresentation();
        for (ICategory category : categories) {
            categoryId = category.getCategoryId();
            if (!categoryId.getInternalRepresentation().equals(parentId)) ** GOTO lbl34
            continue;
lbl-1000:
            // 1 sources

            {
                parent = parent.getParent();
                Assert.isNotNull((Object)parent);
                index = parentId.lastIndexOf("/", parentId.length() - 2);
                Assert.isTrue((boolean)(index != -1));
                parentId = parentId.substring(0, index + 1);
lbl34:
                // 2 sources

                ** while (!categoryId.getInternalRepresentation().startsWith((String)parentId))
            }
lbl35:
            // 1 sources

            missing = new ArrayList<String>();
            expected = category.getParentId2();
            while (expected != null && !expected.getInternalRepresentation().equals(parentId)) {
                namePath = CategoriesHelper.getNamePath(expected);
                missing.add(namePath[namePath.length - 1]);
                expected = CategoriesHelper.getParentId(expected);
            }
            Collections.reverse(missing);
            for (String name : missing) {
                parent = parent.createChild(name);
                parent.setArchived(category.isArchived());
                parentId = String.valueOf(parentId) + name + "/";
            }
            parent = parent.createChildFromExisting(category);
            parentId = categoryId.getInternalRepresentation();
        }
        return root;
    }

    public IAuditableCommon getAuditableCommon() {
        return this.fAuditableCommon;
    }
}

