/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.client;

import com.ibm.team.process.client.IAdvisorProblemResolution;
import com.ibm.team.process.common.advice.IAdvisorInfo;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.common.advice.IParticipantReport;
import com.ibm.team.process.common.advice.IProcessReport;
import com.ibm.team.process.internal.client.AdvisorProblemResolution;
import com.ibm.team.repository.common.util.ExtensionRegistryReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;

public class AdvisorProblemResolutionManager {
    private static AdvisorProblemResolutionManager fgManager;
    private ProblemResolutionRegistry fResolutionRegistry = new ProblemResolutionRegistry();

    public static AdvisorProblemResolutionManager getDefault() {
        if (fgManager == null) {
            fgManager = new AdvisorProblemResolutionManager();
        }
        return fgManager;
    }

    private AdvisorProblemResolutionManager() {
    }

    public IAdvisorProblemResolution[] getResolutions(IAdvisorInfo problem) {
        List problemResolutions;
        IProcessReport parentReport = problem.getProcessReport();
        IOperationReport operationReport = parentReport instanceof IParticipantReport ? ((IParticipantReport)parentReport).getOperationReport() : (IOperationReport)parentReport;
        ArrayList<IAdvisorProblemResolution> resolutions = new ArrayList<IAdvisorProblemResolution>();
        int severity = problem.getSeverity();
        if (!(operationReport.wasRun() || severity != 4 && severity != 2 || (problemResolutions = this.fResolutionRegistry.getProblemResolution(problem.getIdentifier())) == null)) {
            ListIterator iter = problemResolutions.listIterator();
            while (iter.hasNext()) {
                IAdvisorProblemResolution resolution = (IAdvisorProblemResolution)iter.next();
                if (!resolution.mayBeApplicable(problem)) continue;
                resolutions.add(resolution);
            }
        }
        return resolutions.toArray(new IAdvisorProblemResolution[resolutions.size()]);
    }

    private static class ProblemResolutionRegistry
    extends ExtensionRegistryReader<Object> {
        private static final String ATTR_PROBLEM_TYPE = "problemType";
        private Map<String, List> fContributedResolutions;

        public ProblemResolutionRegistry() {
            super("com.ibm.team.process.client", "advisorProblemResolutions");
        }

        protected void initialize() {
            this.fContributedResolutions = new HashMap<String, List>();
            super.initialize();
        }

        protected synchronized Object handleExtensionAdded(IConfigurationElement element) {
            String problemType = element.getAttribute(ATTR_PROBLEM_TYPE);
            if (problemType != null) {
                ArrayList<AdvisorProblemResolution> list = this.fContributedResolutions.get(problemType);
                if (list == null) {
                    list = new ArrayList<AdvisorProblemResolution>();
                    this.fContributedResolutions.put(problemType, list);
                }
                AdvisorProblemResolution resolution = new AdvisorProblemResolution(element);
                list.add(resolution);
            }
            return null;
        }

        protected synchronized void handleExtensionRemoved(IConfigurationElement element, Object descriptor) throws Exception {
            List list;
            String problemType = element.getAttribute(ATTR_PROBLEM_TYPE);
            if (problemType != null && (list = this.fContributedResolutions.get(problemType)) != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    AdvisorProblemResolution resolution = (AdvisorProblemResolution)iterator.next();
                    if (!resolution.getConfigurationElement().equals((Object)element)) continue;
                    iterator.remove();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List getProblemResolution(String problemType) {
            this.start();
            ProblemResolutionRegistry problemResolutionRegistry = this;
            synchronized (problemResolutionRegistry) {
                return this.fContributedResolutions.get(problemType);
            }
        }
    }
}

