/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.client.workingcopies;

import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.client.workingcopies.IProcessAreaWorkingCopy;
import com.ibm.team.process.client.workingcopies.IProcessAttachmentsWorkingCopy;
import com.ibm.team.process.client.workingcopies.IUpdateContext;
import com.ibm.team.process.client.workingcopies.IWorkingCopy;
import com.ibm.team.process.client.workingcopies.IWorkingCopyListener;
import com.ibm.team.process.client.workingcopies.WorkingCopyChangeEvent;
import com.ibm.team.process.common.IProcessAttachment;
import com.ibm.team.process.common.IProcessAttachmentHandle;
import com.ibm.team.process.common.IProcessContainer;
import com.ibm.team.process.common.IProcessContainerHandle;
import com.ibm.team.process.common.IProcessItemHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.internal.client.workingcopies.ExecUtil;
import com.ibm.team.process.internal.client.workingcopies.Messages;
import com.ibm.team.process.internal.client.workingcopies.ProjectAreaWorkingCopy;
import com.ibm.team.process.internal.client.workingcopies.PropertyWorkingCopy;
import com.ibm.team.process.internal.client.workingcopies.ServerRequest;
import com.ibm.team.process.internal.client.workingcopies.UpdateRequest;
import com.ibm.team.process.internal.common.InvalidAccessException;
import com.ibm.team.process.internal.common.ItemHandleAwareHashMap;
import com.ibm.team.process.internal.common.ItemHandleAwareHashSet;
import com.ibm.team.process.internal.common.ProjectArea;
import com.ibm.team.repository.client.IContentManager;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.LineDelimiter;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class ProcessAttachmentsWorkingCopy
extends PropertyWorkingCopy
implements IProcessAttachmentsWorkingCopy {
    private ITeamRepository fCachedTeamRepository;
    private IProcessContainerHandle fProcessContainerHandle;
    private LocalWorkingCopyManager fWorkingCopyManager = new LocalWorkingCopyManager();
    private ItemHandleAwareHashSet fVisibleProviderAttachments = new ItemHandleAwareHashSet();
    private ItemHandleAwareHashSet fHiddenProviderAttachments = new ItemHandleAwareHashSet();
    private IWorkingCopy fProcessSharingWorkingCopy = null;
    private ProviderListener fProcessSharingListener = null;

    public ProcessAttachmentsWorkingCopy(ITeamRepository teamRepository) {
        this.fCachedTeamRepository = teamRepository;
    }

    public ProcessAttachmentsWorkingCopy(ITeamRepository teamRepository, IProcessAreaWorkingCopy processArea) {
        this.fCachedTeamRepository = teamRepository;
        if (processArea instanceof ProjectAreaWorkingCopy) {
            this.fProcessSharingListener = new ProviderListener();
            this.fProcessSharingWorkingCopy = ((ProjectAreaWorkingCopy)processArea).getProcessProvider();
            this.fProcessSharingWorkingCopy.addWorkingCopyListener(this.fProcessSharingListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        ProcessAttachmentsWorkingCopy processAttachmentsWorkingCopy = this;
        synchronized (processAttachmentsWorkingCopy) {
            this.fCachedTeamRepository = null;
            this.fProcessContainerHandle = null;
            if (this.fWorkingCopyManager != null) {
                this.fWorkingCopyManager.clear();
                this.fWorkingCopyManager = null;
            }
            this.fVisibleProviderAttachments = null;
            this.fHiddenProviderAttachments = null;
            if (this.fProcessSharingWorkingCopy != null && this.fProcessSharingListener != null) {
                this.fProcessSharingWorkingCopy.removeWorkingCopyListener(this.fProcessSharingListener);
                this.fProcessSharingWorkingCopy = null;
                this.fProcessSharingListener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDisposed() {
        ProcessAttachmentsWorkingCopy processAttachmentsWorkingCopy = this;
        synchronized (processAttachmentsWorkingCopy) {
            return this.fCachedTeamRepository == null;
        }
    }

    public void asyncUpdate(final IProcessContainer processContainer, final int flags, IUpdateContext context, IProgressMonitor monitor) {
        if (this.isDisposed()) {
            return;
        }
        UpdateRequest request = new UpdateRequest(Messages.getString("ProcessAttachmentsWorkingCopy.0")){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IStatus execute(IUpdateContext context, IProgressMonitor monitor) {
                if (ProcessAttachmentsWorkingCopy.this.isDisposed()) {
                    return Status.OK_STATUS;
                }
                monitor.beginTask(this.getName(), 1000);
                try {
                    List<IProcessAttachmentHandle> attachmentHandles = Arrays.asList(processContainer.getAttachments());
                    ArrayList<IProcessAttachmentHandle> deletedAttachments = new ArrayList<IProcessAttachmentHandle>();
                    List resolvedAttachments = ProcessAttachmentsWorkingCopy.this.fCachedTeamRepository.itemManager().fetchCompleteItems(attachmentHandles, flags, (IProgressMonitor)new SubProgressMonitor(monitor, 600));
                    Object e1 = attachmentHandles.iterator();
                    Iterator e2 = resolvedAttachments.iterator();
                    while (e2.hasNext()) {
                        IProcessAttachmentHandle handle = e1.next();
                        IProcessAttachment attachment = (IProcessAttachment)e2.next();
                        if (attachment != null) continue;
                        deletedAttachments.add(handle);
                        e2.remove();
                    }
                    e1 = ProcessAttachmentsWorkingCopy.this;
                    synchronized (e1) {
                        ProcessAttachmentsWorkingCopy.this.fVisibleProviderAttachments = new ItemHandleAwareHashSet();
                        ProcessAttachmentsWorkingCopy.this.fHiddenProviderAttachments = new ItemHandleAwareHashSet();
                    }
                    if (processContainer instanceof ProjectArea) {
                        ProjectArea projectArea = (ProjectArea)processContainer;
                        IProjectAreaHandle providerHandle = projectArea.getProcessProvider();
                        if (providerHandle == null) {
                            providerHandle = projectArea.getRemoteProcessProvider();
                        }
                        if (providerHandle != null) {
                            IProcessContainer provider = (IProcessContainer)ProcessAttachmentsWorkingCopy.this.fCachedTeamRepository.itemManager().fetchCompleteItem((IItemHandle)providerHandle, flags, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                            HashSet<String> localPaths = new HashSet<String>();
                            for (Object localAttachment : resolvedAttachments) {
                                localPaths.add(((IProcessAttachment)localAttachment).getPath());
                            }
                            ProcessAttachmentsWorkingCopy.this.mergeProviderAttachments(provider, localPaths, (IProgressMonitor)new SubProgressMonitor(monitor, 350));
                        }
                    } else {
                        monitor.worked(400);
                    }
                    if (ProcessAttachmentsWorkingCopy.this.isDisposed()) {
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    final LocalWorkingCopyManager workingCopyManager = new LocalWorkingCopyManager(resolvedAttachments, deletedAttachments);
                    final boolean markInitiallyDirty = !deletedAttachments.isEmpty();
                    Runnable runnable = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            boolean isDisposed;
                            ProcessAttachmentsWorkingCopy processAttachmentsWorkingCopy = ProcessAttachmentsWorkingCopy.this;
                            synchronized (processAttachmentsWorkingCopy) {
                                isDisposed = ProcessAttachmentsWorkingCopy.this.isDisposed();
                                if (!isDisposed) {
                                    ProcessAttachmentsWorkingCopy.this.fProcessContainerHandle = (IProcessContainerHandle)processContainer;
                                    ProcessAttachmentsWorkingCopy.this.fWorkingCopyManager = workingCopyManager;
                                    ProcessAttachmentsWorkingCopy.this.setDirty(markInitiallyDirty, true);
                                }
                            }
                            if (!isDisposed) {
                                ProcessAttachmentsWorkingCopy.this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(ProcessAttachmentsWorkingCopy.this, "processAttachments.change", null, null));
                            }
                        }
                    };
                    if (context != null) {
                        context.execute(runnable);
                    } else {
                        runnable.run();
                    }
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (TeamRepositoryException x) {
                    if (ProcessAttachmentsWorkingCopy.this.isDisposed()) {
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    Status status = new Status(4, "com.ibm.team.process.client", 0, this.getName(), (Throwable)x);
                    return status;
                }
                finally {
                    monitor.done();
                }
            }
        };
        ExecUtil.asyncExec(request, context, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IProcessAttachmentHandle[] getAttachments() {
        ProcessAttachmentsWorkingCopy processAttachmentsWorkingCopy = this;
        synchronized (processAttachmentsWorkingCopy) {
            Collection attachments = this.fWorkingCopyManager.getManagedItems();
            attachments.addAll(this.fVisibleProviderAttachments);
            return attachments.toArray(new IProcessAttachmentHandle[attachments.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IProcessAttachmentHandle[] getLocalAttachments() {
        ProcessAttachmentsWorkingCopy processAttachmentsWorkingCopy = this;
        synchronized (processAttachmentsWorkingCopy) {
            Collection attachments = this.fWorkingCopyManager.getManagedItems();
            return attachments.toArray(new IProcessAttachmentHandle[attachments.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isModifiable(IProcessAttachmentHandle attachmentHandle) {
        ProcessAttachmentsWorkingCopy processAttachmentsWorkingCopy = this;
        synchronized (processAttachmentsWorkingCopy) {
            return this.fWorkingCopyManager.manages((IItemHandle)attachmentHandle);
        }
    }

    @Override
    public String getPath(IProcessAttachmentHandle attachmentHandle) {
        ProcessAttachmentWorkingCopy workingCopy = this.getAttachmentWorkingCopy(attachmentHandle, false);
        if (workingCopy != null) {
            return workingCopy.getProcessAttachment().getPath();
        }
        IProcessAttachment attachment = (IProcessAttachment)this.fCachedTeamRepository.itemManager().getSharedItemIfKnown((IItemHandle)attachmentHandle);
        Assert.isNotNull((Object)attachment);
        return attachment.getPath();
    }

    @Override
    public long getSize(IProcessAttachmentHandle attachmentHandle) {
        ProcessAttachmentWorkingCopy workingCopy = this.getAttachmentWorkingCopy(attachmentHandle, false);
        if (workingCopy != null) {
            return workingCopy.getSize();
        }
        IProcessAttachment attachment = (IProcessAttachment)this.fCachedTeamRepository.itemManager().getSharedItemIfKnown((IItemHandle)attachmentHandle);
        Assert.isNotNull((Object)attachment);
        return attachment.getContent().getRawLength();
    }

    @Override
    public IContent getContent(IProcessAttachmentHandle attachmentHandle) {
        ProcessAttachmentWorkingCopy workingCopy = this.getAttachmentWorkingCopy(attachmentHandle, false);
        if (workingCopy != null) {
            return workingCopy.getProcessAttachment().getContent();
        }
        IProcessAttachment attachment = (IProcessAttachment)this.fCachedTeamRepository.itemManager().getSharedItemIfKnown((IItemHandle)attachmentHandle);
        Assert.isNotNull((Object)attachment);
        return attachment.getContent();
    }

    @Override
    public File getLocalFile(IProcessAttachmentHandle attachmentHandle) {
        ProcessAttachmentWorkingCopy workingCopy = this.getAttachmentWorkingCopy(attachmentHandle, false);
        if (workingCopy != null) {
            return workingCopy.getFile();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createAttachment(String path, File content) {
        ProcessAttachmentWorkingCopy workingCopy = new ProcessAttachmentWorkingCopy(path, content, null, null);
        ProcessAttachmentsWorkingCopy processAttachmentsWorkingCopy = this;
        synchronized (processAttachmentsWorkingCopy) {
            this.fWorkingCopyManager.add((IItemHandle)workingCopy.getProcessAttachment(), workingCopy);
            this.localAttachmentCreated(path);
        }
        this.commitChanges("processAttachments.add", null, new IProcessItemHandle[]{workingCopy.getProcessAttachment()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createAttachment(String path, File content, String contentType, String characterEncoding) {
        ProcessAttachmentWorkingCopy workingCopy = new ProcessAttachmentWorkingCopy(path, content, contentType, characterEncoding);
        ProcessAttachmentsWorkingCopy processAttachmentsWorkingCopy = this;
        synchronized (processAttachmentsWorkingCopy) {
            this.fWorkingCopyManager.add((IItemHandle)workingCopy.getProcessAttachment(), workingCopy);
            this.localAttachmentCreated(path);
        }
        this.commitChanges("processAttachments.add", null, new IProcessItemHandle[]{workingCopy.getProcessAttachment()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAttachmentProperties(IProcessAttachmentHandle attachmentHandle, String path, File content) {
        ProcessAttachmentsWorkingCopy processAttachmentsWorkingCopy = this;
        synchronized (processAttachmentsWorkingCopy) {
            if (this.fWorkingCopyManager.manages((IItemHandle)attachmentHandle)) {
                ProcessAttachmentWorkingCopy workingCopy = this.getAttachmentWorkingCopy(attachmentHandle, true);
                String existingPath = workingCopy.getProcessAttachment().getPath();
                workingCopy.getProcessAttachment().setPath(path);
                workingCopy.setFile(content);
                IProcessItemHandle[] updated = new IProcessItemHandle[]{workingCopy.getProcessAttachment()};
                this.commitChanges("processAttachments.update", updated, updated);
                if (!path.equals(existingPath)) {
                    this.localAttachmentDeleted(existingPath);
                    this.localAttachmentCreated(path);
                }
            } else if (this.fVisibleProviderAttachments.contains((Object)attachmentHandle)) {
                this.createAttachment(path, content);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAttachment(IProcessAttachmentHandle attachmentHandle) {
        ProcessAttachmentsWorkingCopy processAttachmentsWorkingCopy = this;
        synchronized (processAttachmentsWorkingCopy) {
            if (!this.fWorkingCopyManager.manages((IItemHandle)attachmentHandle)) {
                if (this.fVisibleProviderAttachments.contains((Object)attachmentHandle)) {
                    return;
                }
                throw new IllegalArgumentException();
            }
            this.localAttachmentDeleted(this.getPath(attachmentHandle));
            this.fWorkingCopyManager.remove((IItemHandle)attachmentHandle);
            this.commitChanges("processAttachments.delete", new IProcessItemHandle[]{attachmentHandle}, null);
        }
    }

    private void commitChanges(String eventProperty, IProcessItemHandle[] oldValue, IProcessItemHandle[] newValue) {
        this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(this, eventProperty, oldValue, newValue));
        this.setDirty(true, true);
    }

    private ProcessAttachmentWorkingCopy getAttachmentWorkingCopy(IProcessAttachmentHandle processAttachmentHandle, boolean create) {
        ProcessAttachmentsWorkingCopy processAttachmentsWorkingCopy = this;
        synchronized (processAttachmentsWorkingCopy) {
            block6: {
                if (this.isDisposed()) {
                    throw new InvalidAccessException();
                }
                if (this.fWorkingCopyManager.manages((IItemHandle)processAttachmentHandle)) {
                    return (ProcessAttachmentWorkingCopy)this.fWorkingCopyManager.getWorkingCopy((IItemHandle)processAttachmentHandle, create);
                }
                if (create || !this.fVisibleProviderAttachments.contains((Object)processAttachmentHandle)) break block6;
                return null;
            }
            throw new IllegalArgumentException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean syncSave(IProcessContainer mutableProcessContainer, List processItemsToSaveCollector, IProgressMonitor monitor) throws TeamRepositoryException {
        boolean saveProcessContainer = false;
        ProcessAttachmentsWorkingCopy processAttachmentsWorkingCopy = this;
        synchronized (processAttachmentsWorkingCopy) {
            List workingCopies = this.fWorkingCopyManager.getWorkingCopies();
            if (!workingCopies.isEmpty()) {
                monitor.beginTask(Messages.getString("ProcessAttachmentsWorkingCopy.1"), workingCopies.size() * 100);
                try {
                    for (ProcessAttachmentWorkingCopy attachment : workingCopies) {
                        File file = attachment.getFile();
                        if (file != null) {
                            String contentType = attachment.getContentType();
                            if (contentType == null || contentType.trim().length() == 0) {
                                contentType = "application/unknown";
                            }
                            IContent content = this.uploadContent(file, contentType, attachment.getCharacterEncoding(), attachment.getProcessAttachment().getContent(), (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                            attachment.getProcessAttachment().setContent(content);
                        } else {
                            monitor.worked(100);
                        }
                        processItemsToSaveCollector.add(attachment.getProcessAttachment());
                    }
                }
                finally {
                    monitor.done();
                }
            }
            Collection attachments = this.fWorkingCopyManager.getAddedItems();
            Iterator e = attachments.iterator();
            while (e.hasNext()) {
                mutableProcessContainer.addAttachment((IProcessAttachmentHandle)e.next());
                saveProcessContainer = true;
            }
            attachments = this.fWorkingCopyManager.getRemovedItems();
            e = attachments.iterator();
            while (e.hasNext()) {
                mutableProcessContainer.removeAttachment((IProcessAttachmentHandle)e.next());
                saveProcessContainer = true;
            }
        }
        return saveProcessContainer;
    }

    private IContent uploadContent(final File file, final String contentType, final String characterEncoding, final IContent predecessorContent, IProgressMonitor monitor) throws TeamRepositoryException {
        final IContent[] content = new IContent[1];
        ServerRequest saveRequest = new ServerRequest(Messages.getString("ProcessAttachmentsWorkingCopy.2")){

            @Override
            public void execute(IProgressMonitor monitor) throws TeamRepositoryException {
                IContentManager manager = ProcessAttachmentsWorkingCopy.this.fCachedTeamRepository.contentManager();
                try {
                    FileInputStream stream = new FileInputStream(file);
                    UUID predecessorId = predecessorContent != null ? predecessorContent.getContentId() : null;
                    content[0] = manager.storeContent(contentType, characterEncoding, LineDelimiter.LINE_DELIMITER_NONE, (InputStream)stream, predecessorId, monitor);
                }
                catch (FileNotFoundException x) {
                    throw new TeamRepositoryException((Throwable)x);
                }
            }
        };
        ExecUtil.syncExec(saveRequest, monitor);
        return content[0];
    }

    private void localAttachmentCreated(String path) {
        Iterator i = this.fVisibleProviderAttachments.iterator();
        while (i.hasNext()) {
            IProcessAttachmentHandle handle = (IProcessAttachmentHandle)i.next();
            String providerPath = ((IProcessAttachment)this.fCachedTeamRepository.itemManager().getSharedItemIfKnown((IItemHandle)handle)).getPath();
            if (!path.equals(providerPath)) continue;
            i.remove();
            this.fHiddenProviderAttachments.add((Object)handle);
        }
    }

    private void localAttachmentDeleted(String path) {
        Iterator i = this.fHiddenProviderAttachments.iterator();
        while (i.hasNext()) {
            IProcessAttachmentHandle handle = (IProcessAttachmentHandle)i.next();
            String providerPath = ((IProcessAttachment)this.fCachedTeamRepository.itemManager().getSharedItemIfKnown((IItemHandle)handle)).getPath();
            if (!path.equals(providerPath)) continue;
            i.remove();
            this.fVisibleProviderAttachments.add((Object)handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeProviderAttachments(IProcessContainer provider, Set<String> localPaths, IProgressMonitor monitor) throws TeamRepositoryException {
        List<IProcessAttachmentHandle> providerAttachmentHandles = Arrays.asList(provider.getAttachments());
        List providerAttachments = this.fCachedTeamRepository.itemManager().fetchCompleteItems(providerAttachmentHandles, 1, (IProgressMonitor)new SubProgressMonitor(monitor, 350));
        ProcessAttachmentsWorkingCopy processAttachmentsWorkingCopy = this;
        synchronized (processAttachmentsWorkingCopy) {
            for (Object providerAttachment : providerAttachments) {
                if (localPaths.contains(((IProcessAttachment)providerAttachment).getPath())) {
                    this.fHiddenProviderAttachments.add(providerAttachment);
                    continue;
                }
                this.fVisibleProviderAttachments.add(providerAttachment);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateUnderlyingPropertyState() {
        ProcessAttachmentsWorkingCopy processAttachmentsWorkingCopy = this;
        synchronized (processAttachmentsWorkingCopy) {
            this.fWorkingCopyManager.abandonWorkingCopies();
        }
    }

    private class LocalWorkingCopyManager {
        private ItemHandleAwareHashMap fWorkingCopies = new ItemHandleAwareHashMap();
        private ItemHandleAwareHashSet fAddedItems = new ItemHandleAwareHashSet();
        private ItemHandleAwareHashSet fRemovedItems = new ItemHandleAwareHashSet();

        public LocalWorkingCopyManager() {
        }

        public LocalWorkingCopyManager(List originals, List deleted) {
            Iterator e = originals.iterator();
            while (e.hasNext()) {
                this.fWorkingCopies.put(e.next(), null);
            }
            e = deleted.iterator();
            while (e.hasNext()) {
                this.fRemovedItems.add(e.next());
            }
        }

        public boolean manages(IItemHandle itemHandle) {
            return this.fWorkingCopies.containsKey((Object)itemHandle);
        }

        public Collection getManagedItems() {
            return this.fWorkingCopies.keySet();
        }

        public Object add(IItemHandle itemHandle, Object workingCopy) {
            if (this.manages(itemHandle)) {
                throw new IllegalArgumentException();
            }
            this.fWorkingCopies.put((Object)itemHandle, workingCopy);
            this.fAddedItems.add((Object)itemHandle);
            return workingCopy;
        }

        public Collection getAddedItems() {
            return this.fAddedItems;
        }

        public void remove(IItemHandle itemHandle) {
            if (!this.manages(itemHandle)) {
                throw new IllegalArgumentException();
            }
            this.fWorkingCopies.remove((Object)itemHandle);
            if (!this.fAddedItems.remove((Object)itemHandle)) {
                this.fRemovedItems.add((Object)itemHandle);
            }
        }

        public Collection getRemovedItems() {
            return this.fRemovedItems;
        }

        public Object getWorkingCopy(IItemHandle itemHandle, boolean create) {
            if (!this.manages(itemHandle)) {
                throw new IllegalArgumentException();
            }
            Object workingCopy = this.fWorkingCopies.get((Object)itemHandle);
            if (workingCopy == null && create) {
                IItem item = ProcessAttachmentsWorkingCopy.this.fCachedTeamRepository.itemManager().getSharedItemIfKnown(itemHandle);
                Assert.isNotNull((Object)item);
                workingCopy = this.createWorkingCopy(item.getWorkingCopy());
                this.fWorkingCopies.put((Object)itemHandle, workingCopy);
            }
            return workingCopy;
        }

        public List getWorkingCopies() {
            ArrayList workingCopies = new ArrayList();
            for (Object workingCopy : this.fWorkingCopies.values()) {
                if (workingCopy == null) continue;
                workingCopies.add(workingCopy);
            }
            return workingCopies;
        }

        public void abandonWorkingCopies() {
            IItemManager itemManager = ProcessAttachmentsWorkingCopy.this.fCachedTeamRepository.itemManager();
            ItemHandleAwareHashMap workingCopies = new ItemHandleAwareHashMap();
            for (IItem item : this.fWorkingCopies.keySet()) {
                if (this.fAddedItems.contains((Object)item)) {
                    IItem sharedItem = itemManager.getSharedItemIfKnown((IItemHandle)item);
                    if (sharedItem == null) continue;
                    workingCopies.put((Object)sharedItem, null);
                    continue;
                }
                workingCopies.put((Object)item, null);
            }
            this.fAddedItems.clear();
            this.fWorkingCopies = workingCopies;
        }

        public void clear() {
            this.fWorkingCopies.clear();
            this.fAddedItems.clear();
            this.fRemovedItems.clear();
        }

        public Object createWorkingCopy(IItem itemWorkingCopy) {
            return new ProcessAttachmentWorkingCopy((IProcessAttachment)itemWorkingCopy);
        }
    }

    private class ProcessAttachmentWorkingCopy {
        private IProcessAttachment fProcessAttachment;
        private File fFile;
        private String fContentType;
        private String fCharacterEncoding;

        public ProcessAttachmentWorkingCopy(String path, File file, String contentType, String characterEncoding) {
            IProcessItemService service = (IProcessItemService)ProcessAttachmentsWorkingCopy.this.fCachedTeamRepository.getClientLibrary(IProcessItemService.class);
            this.fProcessAttachment = service.createProcessAttachment();
            this.fProcessAttachment.setProcessContainer(ProcessAttachmentsWorkingCopy.this.fProcessContainerHandle);
            this.fProcessAttachment.setPath(path);
            this.fFile = file;
            this.fContentType = contentType;
            this.fCharacterEncoding = characterEncoding;
        }

        public ProcessAttachmentWorkingCopy(IProcessAttachment processAttachment) {
            this.fProcessAttachment = processAttachment;
        }

        public IProcessAttachment getProcessAttachment() {
            return this.fProcessAttachment;
        }

        public long getSize() {
            if (this.fFile != null) {
                return this.fFile.length();
            }
            IContent content = this.fProcessAttachment.getContent();
            if (content != null) {
                return content.getRawLength();
            }
            return 0L;
        }

        public void setFile(File file) {
            this.fFile = file;
        }

        public File getFile() {
            return this.fFile;
        }

        public String getContentType() {
            return this.fContentType;
        }

        public String getCharacterEncoding() {
            return this.fCharacterEncoding;
        }
    }

    private class ProviderListener
    implements IWorkingCopyListener {
        private ProviderListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void workingCopyChanged(WorkingCopyChangeEvent event) {
            if (event.getProperty().equals("ProcessProviderProjectAreaChange")) {
                ProcessAttachmentsWorkingCopy processAttachmentsWorkingCopy = ProcessAttachmentsWorkingCopy.this;
                synchronized (processAttachmentsWorkingCopy) {
                    ProcessAttachmentsWorkingCopy.this.fVisibleProviderAttachments.clear();
                    ProcessAttachmentsWorkingCopy.this.fHiddenProviderAttachments.clear();
                }
                final IProcessContainer newProvider = (IProcessContainer)event.getNewValue();
                if (newProvider != null) {
                    UpdateRequest request = new UpdateRequest(Messages.getString("ProcessAttachmentsWorkingCopy.0")){

                        @Override
                        public IStatus execute(IUpdateContext context, IProgressMonitor monitor) {
                            if (ProcessAttachmentsWorkingCopy.this.isDisposed()) {
                                return Status.OK_STATUS;
                            }
                            monitor.beginTask(this.getName(), 1000);
                            try {
                                HashSet<String> localPaths = new HashSet<String>();
                                IProcessAttachmentHandle[] iProcessAttachmentHandleArray = ProcessAttachmentsWorkingCopy.this.getLocalAttachments();
                                int n = iProcessAttachmentHandleArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IProcessAttachmentHandle handle = iProcessAttachmentHandleArray[n2];
                                    localPaths.add(ProcessAttachmentsWorkingCopy.this.getPath(handle));
                                    ++n2;
                                }
                                ProcessAttachmentsWorkingCopy.this.mergeProviderAttachments(newProvider, localPaths, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                                Runnable runnable = new Runnable(){

                                    @Override
                                    public void run() {
                                        ProcessAttachmentsWorkingCopy.this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(ProcessAttachmentsWorkingCopy.this, "processAttachments.change", null, null));
                                    }
                                };
                                if (context != null) {
                                    context.execute(runnable);
                                } else {
                                    runnable.run();
                                }
                                IStatus iStatus = Status.OK_STATUS;
                                return iStatus;
                            }
                            catch (TeamRepositoryException x) {
                                if (ProcessAttachmentsWorkingCopy.this.isDisposed()) {
                                    IStatus iStatus = Status.OK_STATUS;
                                    return iStatus;
                                }
                                Status status = new Status(4, "com.ibm.team.process.client", 0, this.getName(), (Throwable)x);
                                return status;
                            }
                            finally {
                                monitor.done();
                            }
                        }
                    };
                    IUpdateContext context = ((IProcessItemService)ProcessAttachmentsWorkingCopy.this.fCachedTeamRepository.getClientLibrary(IProcessItemService.class)).getWorkingCopyManager().getUpdateContext();
                    ExecUtil.asyncExec(request, context, null);
                } else {
                    ProcessAttachmentsWorkingCopy.this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(ProcessAttachmentsWorkingCopy.this, "processAttachments.change", null, null));
                }
            } else if (event.getProperty().equals("ProcessProviderUsesChange") && !((Boolean)event.getNewValue()).booleanValue()) {
                ProcessAttachmentsWorkingCopy processAttachmentsWorkingCopy = ProcessAttachmentsWorkingCopy.this;
                synchronized (processAttachmentsWorkingCopy) {
                    ProcessAttachmentsWorkingCopy.this.fVisibleProviderAttachments.clear();
                    ProcessAttachmentsWorkingCopy.this.fHiddenProviderAttachments.clear();
                }
                ProcessAttachmentsWorkingCopy.this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(ProcessAttachmentsWorkingCopy.this, "processAttachments.change", null, null));
            }
        }
    }
}

