/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.transport.client;

import com.ibm.team.repository.transport.internal.nls.Messages;
import java.io.FilterInputStream;
import java.io.IOException;
import org.apache.commons.httpclient.HttpMethod;

public class ReleasingAndAbortingInputStream
extends FilterInputStream {
    private HttpMethod method;
    private boolean eofReached;

    public ReleasingAndAbortingInputStream(HttpMethod method) throws IOException {
        super(method.getResponseBodyAsStream());
        this.method = method;
    }

    @Override
    public int read() throws IOException {
        this.assertUnderlyingInputStreamIsNotNull();
        try {
            int bytesRead = super.read();
            this.eofReached = bytesRead == -1;
            return bytesRead;
        }
        catch (IOException e) {
            this.eofReached = true;
            throw e;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.assertUnderlyingInputStreamIsNotNull();
        try {
            int bytesRead = super.read(b, off, len);
            this.eofReached = bytesRead == -1;
            return bytesRead;
        }
        catch (IOException e) {
            this.eofReached = true;
            throw e;
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.assertUnderlyingInputStreamIsNotNull();
        try {
            int bytesRead = super.read(b);
            this.eofReached = bytesRead == -1;
            return bytesRead;
        }
        catch (IOException e) {
            this.eofReached = true;
            throw e;
        }
    }

    @Override
    public long skip(long n) throws IOException {
        this.assertUnderlyingInputStreamIsNotNull();
        return super.skip(n);
    }

    @Override
    public int available() throws IOException {
        this.assertUnderlyingInputStreamIsNotNull();
        return super.available();
    }

    @Override
    public synchronized void mark(int readlimit) {
        if (this.in != null) {
            super.mark(readlimit);
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        this.assertUnderlyingInputStreamIsNotNull();
        super.reset();
    }

    @Override
    public boolean markSupported() {
        if (this.in != null) {
            return super.markSupported();
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.in == null) {
                return;
            }
            if (!this.eofReached) {
                this.method.abort();
            } else {
                super.close();
            }
        }
        finally {
            this.method.releaseConnection();
        }
    }

    private void assertUnderlyingInputStreamIsNotNull() throws IOException {
        if (this.in == null) {
            throw new IOException(Messages.getClientString("ReleasingAndAbortingInputStream.NoResponseBody"));
        }
    }
}

