/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.serialize.internal;

import com.ibm.team.repository.common.serialize.IDeserializer;
import com.ibm.team.repository.common.serialize.ISerializer;
import com.ibm.team.repository.common.serialize.ISerializerFactory;
import com.ibm.team.repository.common.serialize.internal.json.JSONDeserializer;
import com.ibm.team.repository.common.serialize.internal.json.JSONSerializer_03;
import com.ibm.team.repository.common.serialize.internal.xml.XMLDeserializer;
import com.ibm.team.repository.common.serialize.internal.xml.XMLSerializer_03;
import com.ibm.team.repository.common.serialize.internal.xml.XMLSerializer_04;

public class SerializerFactory
implements ISerializerFactory {
    public static final String AttributeSerializeVersion = "serializeVersion";

    @Override
    public IDeserializer getDeserializer(String serializedFormat) {
        if (serializedFormat == null) {
            throw new IllegalArgumentException("serializedFormat must not be null");
        }
        if ("xml".equals(serializedFormat)) {
            return new XMLDeserializer();
        }
        if ("json".equals(serializedFormat)) {
            return new JSONDeserializer();
        }
        return null;
    }

    @Override
    public ISerializer getSerializer(String serializedFormat, String serializedVersion) {
        if (serializedFormat == null) {
            throw new IllegalArgumentException("serializedFormat must not be null");
        }
        if ("xml".equals(serializedFormat)) {
            if (serializedVersion == null) {
                serializedVersion = "0.4";
            }
            if ("0.3".equals(serializedVersion)) {
                return new XMLSerializer_03();
            }
            if ("0.4".equals(serializedVersion)) {
                return new XMLSerializer_04();
            }
        } else if ("json".equals(serializedFormat)) {
            if (serializedVersion == null) {
                serializedVersion = "0.3";
            }
            if ("0.3".equals(serializedVersion)) {
                return new JSONSerializer_03();
            }
        }
        return null;
    }

    @Override
    public ISerializer getSerializer(String serializedFormat) {
        return this.getSerializer(serializedFormat, null);
    }
}

