/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.serialize.internal.xml;

import com.ibm.team.repository.common.serialize.IPrimitiveHandler;
import com.ibm.team.repository.common.serialize.IPrimitiveRegistry;
import com.ibm.team.repository.common.serialize.SerializeException;
import com.ibm.team.repository.common.serialize.internal.nls.Messages;
import com.ibm.team.repository.common.util.NLS;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLDeserializer_03 {
    private static final IPrimitiveRegistry PrimitiveReg = IPrimitiveRegistry.INSTANCE;
    public static final String STRING_SER_URI = "http://www.ibm.com/team/1.0.0/Serializer/0.3";
    public static final String STRING_LIST_TAG = "list";
    public static final String STRING_ITEM_TAG = "item";
    public static final String STRING_NULL_TAG = "null";

    public EObject deserializeEObject(Node node) throws SerializeException {
        while (node != null && node.getNodeType() != 1) {
            node = node.getNextSibling();
        }
        if (node == null) {
            throw new SerializeException(Messages.getServerString("XMLDeserializer_03.ErrorMissingElement"));
        }
        Element element = (Element)node;
        String nsURI = element.getNamespaceURI();
        String name = element.getLocalName();
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(nsURI);
        if (ePackage == null) {
            throw new SerializeException(NLS.bind((String)Messages.getServerString("XMLDeserializer_03.ErrorMissingPackage"), (Object)nsURI, (Object[])new Object[0]));
        }
        EClassifier eClassifier = ePackage.getEClassifier(name);
        if (eClassifier == null) {
            throw new SerializeException(NLS.bind((String)Messages.getServerString("XMLDeserializer_03.ErrorMissingClass"), (Object)name, (Object[])new Object[0]));
        }
        if (!(eClassifier instanceof EClass)) {
            throw new SerializeException(NLS.bind((String)Messages.getServerString("XMLDeserializer_03.ErrorWrongClass"), (Object)name, (Object[])new Object[0]));
        }
        EClass eClass = (EClass)eClassifier;
        EObject result = ePackage.getEFactoryInstance().create(eClass);
        node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() != 1) {
                node = node.getNextSibling();
                continue;
            }
            element = (Element)node;
            name = element.getLocalName();
            EStructuralFeature sf = eClass.getEStructuralFeature(name);
            if (sf == null || sf.isTransient()) {
                node = node.getNextSibling();
                continue;
            }
            EClassifier valueClassifier = sf.getEType();
            Object value = this.deserializeFeatureValue(element, valueClassifier);
            if (!sf.isMany()) {
                result.eSet(sf, value);
            } else {
                if (!(value instanceof List)) {
                    String valueClass = value == null ? String.valueOf(null) : value.getClass().getName();
                    throw new SerializeException(NLS.bind((String)Messages.getServerString("XMLDeserializer_03.ErrorMissingList"), (Object)valueClass, (Object[])new Object[0]));
                }
                ((List)result.eGet(sf)).addAll((List)value);
            }
            node = node.getNextSibling();
        }
        return result;
    }

    private Object deserializeFeatureValue(Element parent, EClassifier eClassifier) throws SerializeException {
        StringBuffer sb = new StringBuffer();
        Node child = parent.getFirstChild();
        while (child != null) {
            switch (child.getNodeType()) {
                case 8: {
                    break;
                }
                case 3: 
                case 4: {
                    sb.append(child.getNodeValue());
                    break;
                }
                case 1: {
                    Element element = (Element)child;
                    return this.deserializeFeatureValueFromElement(element, eClassifier);
                }
                default: {
                    throw new SerializeException(NLS.bind((String)Messages.getServerString("XMLDeserializer_03.ErrorUnexpectedElementNode"), (Object)child.getNodeType(), (Object[])new Object[]{child.getNodeValue()}));
                }
            }
            child = child.getNextSibling();
        }
        String string = sb.toString();
        if (eClassifier instanceof EEnum) {
            EEnum eEnum = (EEnum)eClassifier;
            return eEnum.getEEnumLiteral(string).getInstance();
        }
        IPrimitiveHandler primHandler = PrimitiveReg.getHandler(eClassifier.getInstanceClass());
        if (primHandler == null) {
            throw new SerializeException(NLS.bind((String)Messages.getServerString("XMLDeserializer_03.ErrorMissingHandler"), (Object)eClassifier.getInstanceClass().getName(), (Object[])new Object[0]));
        }
        return primHandler.stringToObject(string);
    }

    private Object deserializeFeatureValueFromElement(Element element, EClassifier eClassifier) throws SerializeException {
        if (STRING_SER_URI.equals(element.getNamespaceURI())) {
            if (STRING_NULL_TAG.equals(element.getLocalName())) {
                return null;
            }
            if (STRING_LIST_TAG.equals(element.getLocalName())) {
                return this.deserializeList(element, eClassifier);
            }
        }
        return this.deserializeEObject(element);
    }

    private List deserializeList(Element element, EClassifier eClassifier) throws SerializeException {
        ArrayList<Object> result = new ArrayList<Object>();
        Node child = element.getFirstChild();
        while (child != null) {
            if (1 == child.getNodeType()) {
                element = (Element)child;
                String nsURI = element.getNamespaceURI();
                String name = element.getLocalName();
                if (!STRING_SER_URI.equals(nsURI) || !STRING_ITEM_TAG.equals(name)) {
                    throw new SerializeException(NLS.bind((String)Messages.getServerString("XMLDeserializer_03.ErrorUnexpectedElementURI"), (Object)nsURI, (Object[])new Object[]{name}));
                }
                Object value = this.deserializeFeatureValue(element, eClassifier);
                result.add(value);
            }
            child = child.getNextSibling();
        }
        return result;
    }
}

