/**
 * <copyright>
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2006-2007. All Rights Reserved. 
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 * </copyright>
 *
 * $Id$
 */
package com.ibm.team.foundation.rcp.core.internal.favorites;

import java.util.List;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Folder</b></em>'.
 *
 * @since 0.5
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesFolder#getChildren <em>Children</em>}</li>
 * </ul>
 * </p>
 *
 * @see com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesPackage#getFavoritesFolder()
 * @model annotation="teamClass dbPersistable='false'"
 * @generated
 */
public interface FavoritesFolder extends FavoritesNode {
	/**
	 * Returns the value of the '<em><b>Children</b></em>' containment reference list.
	 * The list contents are of type {@link com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesNode}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Children</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Children</em>' containment reference list.
	 * @see #isSetChildren()
	 * @see #unsetChildren()
	 * @see com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesPackage#getFavoritesFolder_Children()
	 * @model type="com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesNode" containment="true" unsettable="true"
	 * @generated
	 */
	List getChildren();

	/**
	 * Unsets the value of the '{@link com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesFolder#getChildren <em>Children</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSetChildren()
	 * @see #getChildren()
	 * @generated
	 */
	void unsetChildren();

	/**
	 * Returns whether the value of the '{@link com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesFolder#getChildren <em>Children</em>}' containment reference list is set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return whether the value of the '<em>Children</em>' containment reference list is set.
	 * @see #unsetChildren()
	 * @see #getChildren()
	 * @generated
	 */
	boolean isSetChildren();

} // FavoritesFolder