/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.internal;

import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.advice.IObjectsResponse;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.ContextLock;
import com.ibm.team.scm.client.DeliveryRequiresHistoryReorderingException;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IWorkspaceConfiguration;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.Visibility;
import com.ibm.team.scm.client.VisibilityEnum;
import com.ibm.team.scm.client.internal.ChangeHistoryEvent;
import com.ibm.team.scm.client.internal.ChangeSetClientCache;
import com.ibm.team.scm.client.internal.ClientCurrentComponentInfo;
import com.ibm.team.scm.client.internal.CommitEvent;
import com.ibm.team.scm.client.internal.Connection;
import com.ibm.team.scm.client.internal.CurrentChangeSetEvent;
import com.ibm.team.scm.client.internal.FlowNodeConnection;
import com.ibm.team.scm.client.internal.FlowTable;
import com.ibm.team.scm.client.internal.ImportChangeSetResult;
import com.ibm.team.scm.client.internal.ItemPermissionChangeEvent;
import com.ibm.team.scm.client.internal.LineDelimiterHandlingCache;
import com.ibm.team.scm.client.internal.Messages;
import com.ibm.team.scm.client.internal.RemoteRepoDescriptorUtils;
import com.ibm.team.scm.client.internal.SCMClientUtil;
import com.ibm.team.scm.client.internal.VersionableManager;
import com.ibm.team.scm.client.internal.WorkspaceManager;
import com.ibm.team.scm.client.internal.isv.IWorkspaceDeliverRunnable;
import com.ibm.team.scm.client.internal.isv.IWorkspaceOperationRunner;
import com.ibm.team.scm.client.internal.process.ClientAdvisableOperation;
import com.ibm.team.scm.client.internal.process.ProcessUtils;
import com.ibm.team.scm.client.interop.IImportChangeSetResult;
import com.ibm.team.scm.client.interop.IWorkspaceConnectionInteropAdapter;
import com.ibm.team.scm.common.AcceptFlags;
import com.ibm.team.scm.common.ChangeSetsNotOutgoingException;
import com.ibm.team.scm.common.CompletedChangeSetException;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.DeliveryIntroducesConflictsException;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IChangeDetail;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IChangeSetSourcesPage;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.ICurrentComponentInfo;
import com.ibm.team.scm.common.ICurrentPatch;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IItemInfoException;
import com.ibm.team.scm.common.IPageDescriptor;
import com.ibm.team.scm.common.IRepositoryProgressMonitor;
import com.ibm.team.scm.common.IRepositoryProgressMonitorHandle;
import com.ibm.team.scm.common.IScmService;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableChange;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.InvalidAuthenticationTokenException;
import com.ibm.team.scm.common.InvalidStreamOperationException;
import com.ibm.team.scm.common.LineDelimiterHandlingEnum;
import com.ibm.team.scm.common.NWayConflictUnsupportedException;
import com.ibm.team.scm.common.SyncReportInappropriateException;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.dto.IComponentLockReport;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import com.ibm.team.scm.common.dto.IComponentizedAncestorList;
import com.ibm.team.scm.common.dto.ICurrentPatchOperationDescriptor;
import com.ibm.team.scm.common.dto.IItemUpdateReport;
import com.ibm.team.scm.common.dto.ILockSearchCriteria;
import com.ibm.team.scm.common.dto.ILockSearchResult;
import com.ibm.team.scm.common.dto.IPermissionContextProvider;
import com.ibm.team.scm.common.dto.IReadScope;
import com.ibm.team.scm.common.dto.ISynchronizationInfo;
import com.ibm.team.scm.common.dto.IUpdateReport;
import com.ibm.team.scm.common.internal.BaselineHandle;
import com.ibm.team.scm.common.internal.ChangeSetHandle;
import com.ibm.team.scm.common.internal.ComponentFlow;
import com.ibm.team.scm.common.internal.ComponentHandle;
import com.ibm.team.scm.common.internal.ConfigUtil;
import com.ibm.team.scm.common.internal.CurrentFlows;
import com.ibm.team.scm.common.internal.FlowEntry;
import com.ibm.team.scm.common.internal.IScmImportService;
import com.ibm.team.scm.common.internal.VersionedContent;
import com.ibm.team.scm.common.internal.Workspace;
import com.ibm.team.scm.common.internal.WorkspaceHandle;
import com.ibm.team.scm.common.internal.dto.BasisMapping;
import com.ibm.team.scm.common.internal.dto.ChangeHistorySyncReport;
import com.ibm.team.scm.common.internal.dto.CommitParameter;
import com.ibm.team.scm.common.internal.dto.ComponentBaselineEntry;
import com.ibm.team.scm.common.internal.dto.ComponentChangeSetEntry;
import com.ibm.team.scm.common.internal.dto.ComponentInfo;
import com.ibm.team.scm.common.internal.dto.ComponentLocks;
import com.ibm.team.scm.common.internal.dto.ComponentStateSummary;
import com.ibm.team.scm.common.internal.dto.ComponentizedFetchParameter;
import com.ibm.team.scm.common.internal.dto.ComponentizedFetchResult;
import com.ibm.team.scm.common.internal.dto.ComponentizedFolderEntryReport;
import com.ibm.team.scm.common.internal.dto.ICommitParameter;
import com.ibm.team.scm.common.internal.dto.ItemConflictReport;
import com.ibm.team.scm.common.internal.dto.PredecessorInfo;
import com.ibm.team.scm.common.internal.dto.RemoteRepoDescriptor;
import com.ibm.team.scm.common.internal.dto.ScmDtoFactory;
import com.ibm.team.scm.common.internal.dto.ServiceConfigurationProvider;
import com.ibm.team.scm.common.internal.dto.SyncTime;
import com.ibm.team.scm.common.internal.dto.UpdateReport;
import com.ibm.team.scm.common.internal.dto.WorkspaceDeliveryResult;
import com.ibm.team.scm.common.internal.dto.WorkspaceImportResult;
import com.ibm.team.scm.common.internal.dto.WorkspaceItemListResult;
import com.ibm.team.scm.common.internal.dto.WorkspaceItemResult;
import com.ibm.team.scm.common.internal.dto.WorkspaceOperationResult;
import com.ibm.team.scm.common.internal.dto.WorkspaceRefreshParameter;
import com.ibm.team.scm.common.internal.dto.WorkspaceRefreshResult;
import com.ibm.team.scm.common.internal.dto.WorkspaceUpdateReportResult;
import com.ibm.team.scm.common.internal.dto.impl.ComponentReport;
import com.ibm.team.scm.common.internal.dto2.LineDelimiterHandling;
import com.ibm.team.scm.common.process.DeliverOperationData;
import com.ibm.team.scm.common.process.ProcessProxy;
import com.ibm.team.scm.common.process.RepositoryRunnable;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class WorkspaceConnection
extends FlowNodeConnection
implements IWorkspaceConnection,
IWorkspaceOperationRunner {
    private LineDelimiterHandlingCache lineDelimiterCache = new LineDelimiterHandlingCache();
    private static final ILockSearchResult NO_LOCKS = ScmDtoFactory.eINSTANCE.createLockSearchResult();
    private final IWorkspaceConnection.IConfigurationOpFactory configurationOpFactory = new ConfigurationOpFactory();
    private final ChangeSetClientCache changeSetCache = new ChangeSetClientCache();
    private final IWorkspaceConfiguration workspaceConfiguration;
    private final ILockSearchCriteria criteria;
    protected Map<UUID, ICurrentPatch> currentPorts = Collections.EMPTY_MAP;
    private final CurrentPortOpFactory currentPortOpFactory = new CurrentPortOpFactory();

    WorkspaceConnection(WorkspaceManager workspaceManager, WorkspaceRefreshResult refreshResult, IProgressMonitor progress) throws TeamRepositoryException {
        super(workspaceManager, refreshResult);
        this.refresh(refreshResult, null, false, progress);
        this.workspaceConfiguration = new WorkspaceConfigurationProxy();
        if (this.getResolvedWorkspace().isStream()) {
            this.criteria = ILockSearchCriteria.FACTORY.newInstance();
            this.criteria.getStreams().add((IWorkspaceHandle)this.getResolvedWorkspace().getItemHandle());
        } else {
            this.criteria = null;
        }
    }

    @Override
    public IUpdateReport conflictReport(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.conflictReport(null, monitor);
    }

    IUpdateReport conflictReport(ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            monitor.worked(10);
            IUpdateReport result = service.conflictReport(this.getWorkspaceHandle(), WorkspaceConnection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor(monitor));
            monitor.worked(80);
            SCMClientUtil.checkMonitor(monitor);
            IUpdateReport iUpdateReport = result;
            return iUpdateReport;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IChangeSetHandle createChangeSet(IComponentHandle component, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.createChangeSet(component, "", false, null, monitor);
    }

    IChangeSetHandle createChangeSet(IComponentHandle component, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.createChangeSet(component, "", false, syncInfo, monitor);
    }

    @Override
    public IChangeSetHandle createChangeSet(IComponentHandle component, String comment, boolean setCurrent, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.createChangeSet(component, comment, setCurrent, null, monitor);
    }

    IChangeSetHandle createChangeSet(IComponentHandle component, String comment, boolean setCurrent, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (!(component instanceof ComponentHandle)) {
            throw new IllegalArgumentException();
        }
        if (comment == null) {
            throw new IllegalArgumentException();
        }
        if (this.getResolvedWorkspace().isStream()) {
            throw new InvalidStreamOperationException(Messages.WorkspaceConnection_0);
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ContextLock lock = new ContextLock();
        lock.addExclusive((IContextHandle)this.getWorkspaceHandle(), component);
        lock.acquire((IProgressMonitor)progress.newChild(1));
        WorkspaceConnection.log("Workspace " + this.workspace.getItemId().getUuidValue() + " createChangeSet() begins");
        try {
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            WorkspaceRefreshParameter delta = this.getDeltaParameter();
            WorkspaceItemResult serviceResult = service.createChangeSet(this.getWorkspaceHandle(), component, comment, setCurrent, delta, WorkspaceConnection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor((IProgressMonitor)progress));
            progress.worked(90);
            IChangeSet changeSet = (IChangeSet)serviceResult.getItem();
            serviceResult.unsetItem();
            this.acquire();
            try {
                this.refresh(serviceResult.getRefreshResult(), delta, false, (IProgressMonitor)progress.newChild(5));
            }
            finally {
                this.release();
            }
            WorkspaceConnection.log("Workspace " + this.workspace.getItemId().getUuidValue() + " createChangeSet() ends");
            IChangeSet iChangeSet = changeSet;
            return iChangeSet;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails(e);
        }
        finally {
            lock.release();
            progress.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List activeChangeSets() {
        Object object = this.lock;
        synchronized (object) {
            return this.changeSetCache.getActiveChangeSets();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long activeState() {
        Object object = this.lock;
        synchronized (object) {
            return this.changeSetCache.getActiveState();
        }
    }

    @Override
    public List<IChangeSetHandle> suspendedChangeSets() {
        return this.workspaceManager().suspendedChangeSets();
    }

    @Override
    public List<IChangeSetHandle> suspendedChangeSets(IComponentHandle component) {
        if (component == null) {
            throw new IllegalArgumentException();
        }
        return this.workspaceManager().suspendedChangeSets(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List activeChangeSets(IComponentHandle component) {
        if (component == null) {
            throw new IllegalArgumentException();
        }
        Object object = this.lock;
        synchronized (object) {
            return this.changeSetCache.getActiveChangeSetsByComponent(component);
        }
    }

    @Override
    public IUpdateReport moveFoldersBetweenComponents(IComponentHandle sourceComponent, IComponentHandle targetComponent, IFolderHandle[] folderHandles, IFolderHandle[] parentsToMoveInto, String sourceComment, String targetComment, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.moveFoldersBetweenComponents(sourceComponent, targetComponent, folderHandles, parentsToMoveInto, sourceComment, targetComment, null, monitor);
    }

    IUpdateReport moveFoldersBetweenComponents(IComponentHandle sourceComponent, IComponentHandle targetComponent, IFolderHandle[] folderHandles, IFolderHandle[] parentsToMoveInto, String sourceComment, String targetComment, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (sourceComponent == null) {
            throw new TeamRepositoryException((Throwable)new IllegalArgumentException());
        }
        if (targetComponent == null) {
            throw new TeamRepositoryException((Throwable)new IllegalArgumentException());
        }
        if (folderHandles == null || folderHandles.length == 0) {
            throw new TeamRepositoryException((Throwable)new IllegalArgumentException());
        }
        if (parentsToMoveInto == null || parentsToMoveInto.length != folderHandles.length) {
            throw new TeamRepositoryException((Throwable)new IllegalArgumentException());
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ContextLock lock = new ContextLock();
        lock.addExclusive((IContextHandle)this.getWorkspaceHandle(), sourceComponent);
        lock.addExclusive((IContextHandle)this.getWorkspaceHandle(), targetComponent);
        lock.acquire((IProgressMonitor)progress.newChild(1));
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " moveFolders() begins");
        try {
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            WorkspaceRefreshParameter deltaParameter = this.getDeltaParameter();
            WorkspaceUpdateReportResult result = service.moveFoldersWithHistory(this.getWorkspaceHandle(), sourceComponent, targetComponent, folderHandles, parentsToMoveInto, sourceComment, targetComment, deltaParameter, WorkspaceConnection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor((IProgressMonitor)progress));
            progress.worked(90);
            this.acquire();
            try {
                this.refresh(result.getRefreshResult(), deltaParameter, false, (IProgressMonitor)progress.newChild(5));
                this.sendEvent(result.getReport());
            }
            finally {
                this.release();
            }
            WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " moveFolders() ends");
            IUpdateReport iUpdateReport = result.getReport();
            return iUpdateReport;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails(e);
        }
        finally {
            lock.release();
            progress.done();
        }
    }

    @Override
    public void closeChangeSets(Collection changeSets, IProgressMonitor monitor) throws TeamRepositoryException {
        this.closeChangeSets(changeSets, true, null, monitor);
    }

    void closeChangeSets(Collection changeSets, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        this.closeChangeSets(changeSets, true, syncInfo, monitor);
    }

    @Override
    public void ensureClosed(Collection changeSets, IProgressMonitor monitor) throws TeamRepositoryException {
        this.closeChangeSets(changeSets, false, null, monitor);
    }

    void ensureClosed(Collection changeSets, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        this.closeChangeSets(changeSets, false, syncInfo, monitor);
    }

    private static void addBaselineEntries(List<ComponentBaselineEntry> cbe, Map<UUID, IComponentHandle> componentMap) {
        for (ComponentBaselineEntry be : cbe) {
            IComponentHandle c = be.getComponent();
            for (IBaselineHandle bh : be.getBaselines()) {
                componentMap.put(bh.getItemId(), c);
            }
        }
    }

    private static void addChangeSetEntries(List<ComponentChangeSetEntry> cce, Map<UUID, IComponentHandle> componentMap) {
        for (ComponentChangeSetEntry ce : cce) {
            IComponentHandle c = ce.getComponent();
            for (IChangeSetHandle ch : ce.getChangeSets()) {
                componentMap.put(ch.getItemId(), c);
            }
        }
    }

    private static void addBasisMappings(List<BasisMapping> bm, Map<UUID, IComponentHandle> componentMap) {
        for (BasisMapping b : bm) {
            componentMap.put(b.getBaseline().getItemId(), b.getComponent());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToLock(ContextLock lock, ChangeHistorySyncReport report, Collection<IBaselineHandle> baselines, Collection<IChangeSetHandle> changeSets, boolean lockRemote, IProgressMonitor monitor) throws TeamRepositoryException {
        IComponentHandle cmp;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        HashMap<UUID, IComponentHandle> componentMap = new HashMap<UUID, IComponentHandle>();
        WorkspaceConnection.addBaselineEntries(report.getIncomingComponentBaselineEntries(), componentMap);
        WorkspaceConnection.addBaselineEntries(report.getOutgoingComponentBaselineEntries(), componentMap);
        WorkspaceConnection.addChangeSetEntries(report.getIncomingComponentChangeSetEntries(), componentMap);
        WorkspaceConnection.addChangeSetEntries(report.getIncomingComponentChangeSetEntriesAfterBasis(), componentMap);
        WorkspaceConnection.addChangeSetEntries(report.getOutgoingComponentChangeSetEntries(), componentMap);
        WorkspaceConnection.addChangeSetEntries(report.getOutgoingComponentChangeSetEntriesAfterBasis(), componentMap);
        WorkspaceConnection.addBasisMappings(report.getCommonComponentBaselines(), componentMap);
        WorkspaceConnection.addBasisMappings(report.getLocalBases(), componentMap);
        WorkspaceConnection.addBasisMappings(report.getRemoteBases(), componentMap);
        IWorkspaceHandle remoteWorkspace = report.getRemote();
        WorkspaceConnection other = this.workspaceManager.getConnectionIfKnown(report.getRemote());
        ArrayList<IChangeSetHandle> toFetch = null;
        for (IBaselineHandle h : baselines) {
            cmp = (IComponentHandle)componentMap.get(h.getItemId());
            if (cmp == null && (cmp = this.getComponent(h)) == null && (cmp = this.getComponentFromBasis(h)) == null) {
                if (other != null) {
                    cmp = other.getComponentFromBasis(h);
                }
                if (cmp == null) {
                    if (toFetch == null) {
                        toFetch = new ArrayList<IChangeSetHandle>();
                    }
                    toFetch.add((IChangeSetHandle)h);
                    continue;
                }
            }
            lock.addExclusive((IContextHandle)this.getWorkspaceHandle(), cmp);
            if (!lockRemote) continue;
            lock.addExclusive((IContextHandle)remoteWorkspace, cmp);
        }
        for (IChangeSetHandle cs : changeSets) {
            cmp = (IComponentHandle)componentMap.get(cs.getItemId());
            if (cmp == null && (cmp = this.getComponent(cs)) == null) {
                Object object = this.lock;
                synchronized (object) {
                    cmp = this.changeSetCache.getComponent(cs);
                }
                if (cmp == null) {
                    if (other != null) {
                        object = other.lock;
                        synchronized (object) {
                            cmp = other.changeSetCache.getComponent(cs);
                        }
                    }
                    if (cmp == null) {
                        if (toFetch == null) {
                            toFetch = new ArrayList();
                        }
                        toFetch.add(cs);
                        continue;
                    }
                }
            }
            lock.addExclusive((IContextHandle)this.getWorkspaceHandle(), cmp);
            if (!lockRemote) continue;
            lock.addExclusive((IContextHandle)remoteWorkspace, cmp);
        }
        if (toFetch != null) {
            List fetched = this.teamRepository().itemManager().fetchCompleteItems(toFetch, 0, (IProgressMonitor)progress.newChild(100));
            int idx = 0;
            for (IItem i : fetched) {
                IComponentHandle cmp2;
                if (i == null) {
                    throw new ItemNotFoundException((IItemHandle)toFetch.get(idx));
                }
                if (i instanceof IBaseline) {
                    cmp2 = ((IBaseline)i).getComponent();
                } else if (i instanceof IChangeSet) {
                    cmp2 = ((IChangeSet)i).getComponent();
                } else {
                    throw new IllegalStateException();
                }
                lock.addExclusive((IContextHandle)this.getWorkspaceHandle(), cmp2);
                if (lockRemote) {
                    lock.addExclusive((IContextHandle)remoteWorkspace, cmp2);
                }
                ++idx;
            }
        }
        progress.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IComponentHandle getComponentFromBasis(IBaselineHandle h) {
        Object object = this.lock;
        synchronized (object) {
            for (ClientCurrentComponentInfo info : this.cachedComponents.values()) {
                if (!h.sameItemId((IItemHandle)info.basis())) continue;
                return info.getComponent();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToLock(ContextLock lock, List<? extends IChangeSetHandle> list1, List<? extends IChangeSetHandle> list2, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ArrayList<IChangeSetHandle> toFetch = null;
        Iterator<? extends IChangeSetHandle> i2 = list2.iterator();
        for (IChangeSetHandle iChangeSetHandle : list1) {
            IComponentHandle cmp = this.getComponent(iChangeSetHandle);
            if (cmp == null) {
                Object object = this.lock;
                synchronized (object) {
                    cmp = this.changeSetCache.getComponent(iChangeSetHandle);
                }
                if (cmp == null) {
                    IChangeSetHandle iChangeSetHandle2 = i2.next();
                    cmp = this.getComponent(iChangeSetHandle2);
                    if (cmp == null) {
                        object = this.lock;
                        synchronized (object) {
                            cmp = this.changeSetCache.getComponent(iChangeSetHandle2);
                        }
                        if (cmp == null) {
                            if (toFetch == null) {
                                toFetch = new ArrayList<IChangeSetHandle>();
                            }
                            toFetch.add(iChangeSetHandle2);
                            continue;
                        }
                    }
                } else {
                    i2.next();
                }
            } else {
                i2.next();
            }
            lock.addExclusive((IContextHandle)this.getWorkspaceHandle(), cmp);
        }
        i2 = null;
        if (toFetch != null) {
            List list = this.teamRepository().itemManager().fetchCompleteItems(toFetch, 0, (IProgressMonitor)progress.newChild(100));
            int idx = 0;
            for (IItem i : list) {
                if (i == null) {
                    throw new ItemNotFoundException((IItemHandle)toFetch.get(idx));
                }
                lock.addExclusive((IContextHandle)this.getWorkspaceHandle(), ((IChangeSet)i).getComponent());
                ++idx;
            }
        }
        progress.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToLock(ContextLock lock, Collection<IChangeSetHandle> changeSets, ITeamRepository originRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ArrayList<IChangeSetHandle> toFetch = null;
        for (IChangeSetHandle cs : changeSets) {
            IComponentHandle cmp = this.getComponent(cs);
            if (cmp == null) {
                Iterator iterator = this.lock;
                synchronized (iterator) {
                    cmp = this.changeSetCache.getComponent(cs);
                }
                if (cmp == null) {
                    if (toFetch == null) {
                        toFetch = new ArrayList<IChangeSetHandle>();
                    }
                    toFetch.add(cs);
                    continue;
                }
            }
            lock.addExclusive((IContextHandle)this.getWorkspaceHandle(), cmp);
        }
        if (toFetch != null) {
            List fetched = originRepository.itemManager().fetchCompleteItems(toFetch, 0, (IProgressMonitor)progress.newChild(100));
            int idx = 0;
            for (IItem i : fetched) {
                if (i == null) {
                    throw new ItemNotFoundException((IItemHandle)toFetch.get(idx));
                }
                lock.addExclusive((IContextHandle)this.getWorkspaceHandle(), ((IChangeSet)i).getComponent());
                ++idx;
            }
        }
        progress.done();
    }

    private IComponentHandle getComponent(IChangeSetHandle csh) {
        IChangeSet cs;
        if (csh instanceof IChangeSet && (cs = (IChangeSet)csh).getComponent() != null) {
            return cs.getComponent();
        }
        cs = (IChangeSet)this.teamRepository().itemManager().getSharedItemIfKnown((IItemHandle)csh);
        if (cs != null && cs.getComponent() != null) {
            return cs.getComponent();
        }
        return null;
    }

    private IComponentHandle getComponent(IBaselineHandle bh) {
        IBaseline b;
        if (bh instanceof IBaseline && (b = (IBaseline)bh).getComponent() != null) {
            return b.getComponent();
        }
        b = (IBaseline)this.teamRepository().itemManager().getSharedItemIfKnown((IItemHandle)bh);
        if (b != null && b.getComponent() != null) {
            return b.getComponent();
        }
        return null;
    }

    private void closeChangeSets(Collection changeSets, boolean checkActive, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (changeSets == null) {
            throw new IllegalArgumentException();
        }
        WorkspaceConnection.checkForDuplicates(changeSets);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ContextLock lock = new ContextLock();
        this.addToLock(lock, changeSets, this.teamRepository(), (IProgressMonitor)progress.newChild(5));
        lock.acquire((IProgressMonitor)progress.newChild(1));
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " closeChangeSets() begins");
        try {
            try {
                this.validate();
                IScmService service = this.workspaceManager.getServerConfigurationService();
                WorkspaceRefreshParameter deltaParameter = this.getDeltaParameter();
                WorkspaceItemListResult result = service.closeChangeSets(this.getWorkspaceHandle(), (IChangeSetHandle[])changeSets.toArray(new ChangeSetHandle[changeSets.size()]), checkActive, deltaParameter, WorkspaceConnection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor((IProgressMonitor)progress));
                progress.worked(85);
                this.acquire();
                try {
                    this.sendEvent("com.ibm.team.scm.ChangeHistoryEvent.CloseChangeSets", new ArrayList(changeSets));
                    WorkspaceRefreshResult refreshResult = result.getRefreshResult();
                    this.refresh(refreshResult, deltaParameter, false, (IProgressMonitor)progress.newChild(5));
                    this.teamRepository().itemManager().applyItemUpdates(result.getItems());
                    result.unsetItems();
                    WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " closeChangeSets() ends");
                }
                finally {
                    this.release();
                }
            }
            catch (ItemNotFoundException e) {
                throw this.expandItemNotFoundDetails(e);
            }
        }
        finally {
            lock.release();
            progress.done();
        }
    }

    @Override
    public IUpdateReport discardChangeSets(boolean preflight, Collection changeSets, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.discardChangeSets(preflight, changeSets, null, monitor);
    }

    public List getMostRecentBaselinesAffecting(IComponentHandle component, List folderHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            for (Object element : folderHandles) {
                if (element == null) {
                    throw new IllegalArgumentException();
                }
                if (element instanceof IVersionableHandle) continue;
                throw new IllegalArgumentException();
            }
            SCMClientUtil.checkMonitor(monitor);
            this.validate();
            IScmService service = this.workspaceManager().getServerConfigurationService();
            IBaseline[] baselines = service.getMostRecentBaselinesAffecting((IWorkspaceHandle)this.getResolvedWorkspace(), component, folderHandles.toArray(new IFolderHandle[folderHandles.size()]), (IRepositoryProgressMonitorHandle)this.monitorFor(monitor));
            SCMClientUtil.checkMonitor(monitor);
            monitor.worked(50);
            List<IBaseline> list = Arrays.asList(baselines);
            return list;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails(e);
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void initializeMostRecentBaselinesAffecting(IComponentHandle component, List<? extends IBaselineHandle> baselines, List<? extends IFolderHandle> folderHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (baselines.size() != folderHandles.size()) {
                throw new IllegalArgumentException();
            }
            for (IFolderHandle iFolderHandle : folderHandles) {
                if (iFolderHandle == null) {
                    throw new IllegalArgumentException();
                }
                if (iFolderHandle instanceof IVersionableHandle) continue;
                throw new IllegalArgumentException();
            }
            for (IFolderHandle iFolderHandle : baselines) {
                if (iFolderHandle != null) continue;
                throw new IllegalArgumentException();
            }
            SCMClientUtil.checkMonitor(monitor);
            this.validate();
            IScmService service = this.workspaceManager().getServerConfigurationService();
            service.initializeMostRecentBaselinesAffecting((IWorkspaceHandle)this.getResolvedWorkspace(), component, baselines.toArray(new IBaselineHandle[baselines.size()]), folderHandles.toArray(new IFolderHandle[folderHandles.size()]), (IRepositoryProgressMonitorHandle)this.monitorFor(monitor));
            SCMClientUtil.checkMonitor(monitor);
            monitor.worked(50);
        }
        finally {
            monitor.done();
        }
    }

    IUpdateReport discardChangeSets(boolean preflight, Collection changeSets, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        ContextLock lock;
        if (changeSets == null) {
            throw new IllegalArgumentException();
        }
        WorkspaceConnection.checkForDuplicates(changeSets);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (!preflight) {
            lock = new ContextLock();
            this.addToLock(lock, changeSets, this.teamRepository(), (IProgressMonitor)progress.newChild(5));
            lock.acquire((IProgressMonitor)progress.newChild(1));
            if (!preflight) {
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " discardChangeSets() begins");
            }
        } else {
            lock = null;
        }
        progress.setWorkRemaining(95);
        try {
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            WorkspaceRefreshParameter deltaParameter = this.getDeltaParameter();
            WorkspaceUpdateReportResult result = service.discardChangeSets(this.getWorkspaceHandle(), preflight, (IChangeSetHandle[])changeSets.toArray(new ChangeSetHandle[changeSets.size()]), deltaParameter, WorkspaceConnection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor((IProgressMonitor)progress));
            IUpdateReport report = result.getReport();
            progress.worked(85);
            if (!preflight) {
                this.acquire();
                try {
                    this.refresh(result.getRefreshResult(), deltaParameter, false, (IProgressMonitor)progress.newChild(5));
                    this.sendEvent("com.ibm.team.scm.ChangeHistoryEvent.DiscardChangeSet", new ArrayList(changeSets));
                    this.sendEvent(report);
                }
                finally {
                    this.release();
                }
            }
            if (!preflight) {
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " discardChangeSets() ends");
            }
            IUpdateReport iUpdateReport = report;
            return iUpdateReport;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails(e);
        }
        finally {
            if (!preflight) {
                lock.release();
            }
            progress.done();
        }
    }

    @Override
    public void refresh(IProgressMonitor monitor) throws TeamRepositoryException {
        this.refresh(false, monitor);
    }

    @Override
    public void refresh(boolean replaceComponent, IProgressMonitor monitor) throws TeamRepositoryException {
        UUID txnId = UUID.generate();
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refresh(bool,monitor) begins - tag " + txnId.getUuidValue());
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            try {
                WorkspaceRefreshParameter parm = this.createRefreshParameter();
                WorkspaceRefreshResult refreshResult = this.refreshInternal((IProgressMonitor)progress.newChild(90), parm, txnId);
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refresh(bool,monitor) acquires lock - tag " + txnId.getUuidValue());
                ContextLock lock = new ContextLock();
                lock.addExclusive((IContextHandle)this.getWorkspaceHandle());
                lock.acquire((IProgressMonitor)progress.newChild(5));
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refresh(bool,monitor) acquires lock - tag " + txnId.getUuidValue());
                try {
                    this.refresh(refreshResult, parm, false, " - tag " + txnId.getUuidValue(), (IProgressMonitor)progress.newChild(5));
                }
                finally {
                    lock.release();
                }
            }
            catch (ItemNotFoundException e) {
                throw this.expandItemNotFoundDetails(e);
            }
        }
        finally {
            progress.done();
        }
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refresh(bool,monitor) ends - tag " + txnId.getUuidValue());
    }

    private WorkspaceRefreshResult refreshInternal(IProgressMonitor monitor, WorkspaceRefreshParameter parm) throws TeamRepositoryException {
        return this.refreshInternal(monitor, parm, null);
    }

    private WorkspaceRefreshResult refreshInternal(IProgressMonitor monitor, WorkspaceRefreshParameter parm, UUID txnId) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            IScmService service = this.workspaceManager.getServerConfigurationService();
            if (txnId != null) {
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refreshParameter created" + txnId.getUuidValue());
            }
            WorkspaceRefreshParameter[] workspaceRefreshParameters = new WorkspaceRefreshParameter[]{parm};
            WorkspaceRefreshResult refreshResult = service.refreshWorkspaces(workspaceRefreshParameters, (IRepositoryProgressMonitorHandle)IRepositoryProgressMonitor.ITEM_FACTORY.createItem(monitor))[0];
            if (txnId != null) {
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refreshResult returned" + txnId.getUuidValue());
            }
            if (refreshResult == null) {
                throw new ItemNotFoundException(this.getResolvedWorkspace().getItemHandle());
            }
            WorkspaceRefreshResult workspaceRefreshResult = refreshResult;
            return workspaceRefreshResult;
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WorkspaceRefreshParameter createRefreshParameter() {
        WorkspaceRefreshParameter parm = ScmDtoFactory.eINSTANCE.createWorkspaceRefreshParameter();
        parm.setContributorState(this.workspaceManager.getRefreshParameter());
        Object object = this.lock;
        synchronized (object) {
            IWorkspace resolvedWorkspace = this.getResolvedWorkspace();
            parm.setWorkspace((IWorkspaceHandle)resolvedWorkspace.getStateHandle());
            parm.setActiveState(this.activeState());
            for (ICurrentComponentInfo iCurrentComponentInfo : this.getComponentsInfo()) {
                ComponentStateSummary state = ScmDtoFactory.eINSTANCE.createComponentStateSummary();
                state.setChangeHistoryState(((SyncTime)iCurrentComponentInfo.changeHistoryTime()).getValue());
                state.setComponent(iCurrentComponentInfo.getComponent());
                state.setConfigurationState(((SyncTime)iCurrentComponentInfo.configurationTime()).getValue());
                state.setLockState(((SyncTime)iCurrentComponentInfo.lockTime()).getValue());
                state.setAcceptQueueState(((SyncTime)iCurrentComponentInfo.pendingPortsTime()).getValue());
                state.setCurrentPatchState(((SyncTime)iCurrentComponentInfo.currentPortTime()).getValue());
                parm.getCurrentComponents().add(state);
            }
        }
        return parm;
    }

    public void refresh(WorkspaceRefreshResult data, WorkspaceRefreshParameter parm, IProgressMonitor progress) throws TeamRepositoryException {
        if (data == null) {
            throw new IllegalArgumentException();
        }
        this.refresh(data, parm, false, progress);
    }

    @Override
    protected void refresh(WorkspaceRefreshResult refreshResult, WorkspaceRefreshParameter parm, boolean replaceComponent, IProgressMonitor monitor) throws TeamRepositoryException {
        this.refresh(refreshResult, parm, replaceComponent, "", monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh(WorkspaceRefreshResult refreshResult, WorkspaceRefreshParameter parm, boolean replaceComponent, String tag, IProgressMonitor monitor) throws TeamRepositoryException {
        if (!refreshResult.getWorkspace().sameItemId((IItemHandle)this.workspaceHandle)) {
            throw new IllegalArgumentException();
        }
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refresh(WRR,bool) begins " + tag);
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.workspaceManager().refresh(refreshResult.getContributorState(), (IProgressMonitor)sm.newChild(50));
        this.acquire();
        try {
            Object object = this.lock;
            synchronized (object) {
                Map afterActive;
                IChangeSetHandle oldCurrent;
                Workspace workspaceFromServer = (Workspace)refreshResult.getWorkspace();
                List componentList = refreshResult.getComponents();
                Map previousBases = this.getBases();
                HashMap<UUID, IComponentHandle> previousComponents = new HashMap<UUID, IComponentHandle>();
                for (ClientCurrentComponentInfo i : this.cachedComponents.values()) {
                    previousComponents.put(i.getComponent().getItemId(), i.getComponent());
                }
                Map beforeActive = ConfigUtil.tableForItems(this.changeSetCache.getActiveChangeSets());
                TreeMap<IComponentHandle, IBaselineHandle> newBases = new TreeMap<IComponentHandle, IBaselineHandle>(ItemUtil.itemIdComparator);
                newBases.putAll(previousBases);
                HashMap<UUID, ClientCurrentComponentInfo> componentMap = new HashMap<UUID, ClientCurrentComponentInfo>(this.cachedComponents);
                HashMap oldcomponentMap = new HashMap(this.cachedComponents);
                HashMap<UUID, IComponentHandle> newInaccessibleComponents = new HashMap<UUID, IComponentHandle>(this.inaccessibleComponents);
                HashMap<UUID, ICurrentPatch> newCurrentPorts = new HashMap<UUID, ICurrentPatch>(this.currentPorts);
                Iterator iter = componentList.iterator();
                HashMap<UUID, IComponentHandle> newComponents = new HashMap<UUID, IComponentHandle>();
                TreeMap<IComponentHandle, IChangeSetHandle> currentChangeSets = new TreeMap<IComponentHandle, IChangeSetHandle>(ItemUtil.itemIdComparator);
                HashSet<UUID> staleComponents = new HashSet<UUID>();
                boolean locksChanged = false;
                HashSet<UUID> componentsWithPendingPortsChanges = new HashSet<UUID>();
                HashSet<UUID> componentsWithCurrentPortChanges = new HashSet<UUID>();
                while (iter.hasNext()) {
                    Map<UUID, ClientCurrentComponentInfo.ConflictInfo> previousConflicts;
                    ComponentInfo entry = (ComponentInfo)iter.next();
                    if (WorkspaceConnection.compareTimes(this.vTime.getValue(), workspaceFromServer.getTime()) > 0) {
                        staleComponents.add(entry.getComponent().getItemId());
                        continue;
                    }
                    ClientCurrentComponentInfo ci = (ClientCurrentComponentInfo)this.cachedComponents.get(entry.getComponent().getItemId());
                    if (ci != null) {
                        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refresh(WRR,bool) - component " + entry.getComponent().getItemId().getUuidValue() + " has local chTime=" + ci.changeHistoryTime().toString() + " and supplied chTime=" + entry.getChangeHistoryState() + tag);
                    } else {
                        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refresh(WRR,bool) - component " + entry.getComponent().getItemId().getUuidValue() + " has supplied chTime=" + entry.getChangeHistoryState() + tag);
                    }
                    if (ci == null) {
                        locksChanged = true;
                        ICurrentPatch port = refreshResult.getCurrentPatch(entry.getComponent());
                        if (port != null) {
                            newCurrentPorts.put(entry.getComponent().getItemId(), port);
                        }
                    } else if (WorkspaceConnection.compareTimes(this.vTime.getValue(), workspaceFromServer.getTime()) < 0) {
                        locksChanged = true;
                    } else {
                        long currentCHTime;
                        long previousLockTime = ((SyncTime)ci.lockTime()).getValue();
                        long currentLockTime = entry.getLockState();
                        long previousCHTime = ((SyncTime)ci.changeHistoryTime()).getValue();
                        if (WorkspaceConnection.compareTimes(previousCHTime, currentCHTime = entry.getChangeHistoryState()) > 0) {
                            boolean stale = true;
                            if (parm != null) {
                                UUID cmpId = entry.getComponent().getItemId();
                                for (ComponentStateSummary summary : parm.getCurrentComponents()) {
                                    UUID componentId = summary.getComponent().getItemId();
                                    if (!componentId.equals((Object)cmpId)) continue;
                                    if (summary.getChangeHistoryState() != previousCHTime) break;
                                    stale = false;
                                    break;
                                }
                            }
                            if (stale) {
                                staleComponents.add(entry.getComponent().getItemId());
                                continue;
                            }
                        }
                        locksChanged |= WorkspaceConnection.compareTimes(previousLockTime, currentLockTime) < 0;
                        if (WorkspaceConnection.compareTimes(((SyncTime)ci.pendingPortsTime()).getValue(), entry.getAcceptQueueState()) < 0) {
                            componentsWithPendingPortsChanges.add(entry.getComponent().getItemId());
                        }
                        if (WorkspaceConnection.compareTimes(((SyncTime)ci.currentPortTime()).getValue(), entry.getCurrentPatchState()) < 0) {
                            componentsWithCurrentPortChanges.add(entry.getComponent().getItemId());
                            ICurrentPatch port = refreshResult.getCurrentPatch(entry.getComponent());
                            if (port != null) {
                                newCurrentPorts.put(entry.getComponent().getItemId(), port);
                            } else {
                                newCurrentPorts.remove(entry.getComponent().getItemId());
                            }
                        }
                    }
                    newInaccessibleComponents.remove(entry.getComponent().getItemId());
                    ClientCurrentComponentInfo newInfo = new ClientCurrentComponentInfo(entry);
                    componentMap.put(entry.getComponent().getItemId(), newInfo);
                    Map<UUID, ClientCurrentComponentInfo.ConflictInfo> currentConflicts = newInfo.getConflicts();
                    Map<UUID, ClientCurrentComponentInfo.ConflictInfo> map = previousConflicts = ci == null ? Collections.EMPTY_MAP : ci.getConflicts();
                    if (!previousConflicts.equals(currentConflicts)) {
                        this.sendEvent("com.ibm.team.scm.ConflictUpdate", Collections.EMPTY_LIST, entry.getComponent());
                    }
                    newComponents.put(entry.getComponent().getItemId(), entry.getComponent());
                    if (entry.getBasis() != null) {
                        newBases.put(entry.getComponent(), entry.getBasis());
                    }
                    IChangeSetHandle current = entry.getCurrentChangeSet();
                    IChangeSetHandle oldCurrent2 = this.changeSetCache.getCurrentChangeSet(entry.getComponent());
                    if (current == null && oldCurrent2 != null || current != null && !current.sameItemId((IItemHandle)oldCurrent2)) {
                        this.sendCurrentChangeSetEvent(current, oldCurrent2, entry.getComponent());
                    }
                    currentChangeSets.put(entry.getComponent(), current == null ? ChangeSetClientCache.CURRENT_UNSET : current);
                }
                if (WorkspaceConnection.compareTimes(this.vTime.getValue(), workspaceFromServer.getTime()) < 0) {
                    for (IComponentHandle deleted : refreshResult.getRemovedComponents()) {
                        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refresh(WRR,bool) - component " + deleted.getItemId().getUuidValue() + " is removed." + tag);
                        UUID componentId = deleted.getItemId();
                        componentMap.remove(componentId);
                        oldCurrent = this.changeSetCache.getCurrentChangeSet(deleted);
                        if (oldCurrent != null) {
                            this.sendCurrentChangeSetEvent(null, oldCurrent, deleted);
                        }
                        currentChangeSets.put(deleted, ChangeSetClientCache.CURRENT_UNSET);
                        newBases.remove(deleted);
                        newInaccessibleComponents.remove(componentId);
                        newCurrentPorts.remove(componentId);
                    }
                    for (IComponentHandle inaccessible : refreshResult.getUnreachableComponentsRemoved()) {
                        newInaccessibleComponents.remove(inaccessible.getItemId());
                    }
                }
                if (WorkspaceConnection.compareTimes(this.vTime.getValue(), workspaceFromServer.getTime()) <= 0) {
                    for (IComponentHandle inaccessible : refreshResult.getNewUnreachableComponents()) {
                        UUID componentId = inaccessible.getItemId();
                        componentMap.remove(componentId);
                        oldCurrent = this.changeSetCache.getCurrentChangeSet(inaccessible);
                        if (oldCurrent != null) {
                            this.sendCurrentChangeSetEvent(null, oldCurrent, inaccessible);
                        }
                        currentChangeSets.put(inaccessible, ChangeSetClientCache.CURRENT_UNSET);
                        newBases.remove(inaccessible);
                        newInaccessibleComponents.put(componentId, inaccessible);
                    }
                }
                Set newBasesIds = ConfigUtil.getItemIds(newBases.values());
                Set prevBasesIds = ConfigUtil.getItemIds(previousBases.values());
                if (replaceComponent || !newBasesIds.equals(prevBasesIds)) {
                    this.sendPropertyChangeEvent("com.ibm.team.repository.PropertySet", "bases", previousBases, newBases);
                }
                if (locksChanged) {
                    this.sendPropertyChangeEvent("com.ibm.team.repository.PropertySet", "stream locks", null, null);
                }
                if (!componentsWithCurrentPortChanges.isEmpty() || !componentsWithPendingPortsChanges.isEmpty()) {
                    this.sendPortingUpdateEvent(componentsWithCurrentPortChanges, componentsWithPendingPortsChanges);
                }
                if (!previousComponents.keySet().equals(componentMap.keySet())) {
                    Collection value;
                    newComponents.keySet().removeAll(previousComponents.keySet());
                    previousComponents.keySet().removeAll(componentMap.keySet());
                    if (!newComponents.isEmpty()) {
                        String eventType = "com.ibm.team.repository.PropertyAddMany";
                        value = newComponents.values();
                        if (newComponents.size() == 1) {
                            eventType = "com.ibm.team.repository.PropertyAdd";
                            value = newComponents.values().iterator().next();
                        }
                        if (eventType == "com.ibm.team.repository.PropertyAdd") {
                            WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refresh(WRR,bool) - newComponent added " + tag);
                        } else {
                            WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refresh(WRR,bool) - newComponents added " + tag);
                        }
                        this.sendPropertyChangeEvent(eventType, "components", null, value);
                    }
                    if (!previousComponents.isEmpty()) {
                        String eventType = "com.ibm.team.repository.PropertyRemoveMany";
                        value = previousComponents.values();
                        if (previousComponents.size() == 1) {
                            eventType = "com.ibm.team.repository.PropertyRemove";
                            value = previousComponents.values().iterator().next();
                        }
                        if (eventType == "com.ibm.team.repository.PropertyRemove") {
                            WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refresh(WRR,bool) - component removed" + tag);
                        } else {
                            WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refresh(WRR,bool) - components removed" + tag);
                        }
                        this.sendPropertyChangeEvent(eventType, "components", value, null);
                    }
                }
                if (parm == null || parm.getCurrentComponents().isEmpty()) {
                    HashSet possibleStales = new HashSet(oldcomponentMap.keySet());
                    for (ComponentInfo info : componentList) {
                        UUID id = info.getComponent().getItemId();
                        if (!possibleStales.contains(id)) continue;
                        ClientCurrentComponentInfo oldInfo = (ClientCurrentComponentInfo)oldcomponentMap.get(id);
                        if (WorkspaceConnection.compareTimes(info.getChangeHistoryState(), ((SyncTime)oldInfo.changeHistoryTime()).getValue()) <= 0) continue;
                        possibleStales.remove(info.getComponent().getItemId());
                    }
                    if (!previousComponents.keySet().equals(componentMap.keySet())) {
                        possibleStales.removeAll(previousComponents.keySet());
                    }
                    staleComponents.addAll(possibleStales);
                } else {
                    for (ComponentStateSummary summary : parm.getCurrentComponents()) {
                        ClientCurrentComponentInfo oldInfo;
                        UUID componentId = summary.getComponent().getItemId();
                        ClientCurrentComponentInfo newInfo = (ClientCurrentComponentInfo)componentMap.get(componentId);
                        if (newInfo != (oldInfo = (ClientCurrentComponentInfo)oldcomponentMap.get(componentId)) || newInfo != null && WorkspaceConnection.compareTimes(summary.getChangeHistoryState(), ((SyncTime)newInfo.changeHistoryTime()).getValue()) >= 0) continue;
                        staleComponents.add(componentId);
                    }
                }
                oldcomponentMap = null;
                this.changeSetCache.updateCaches(refreshResult, parm, currentChangeSets, staleComponents, this.teamRepository().itemManager(), this, (IProgressMonitor)sm.newChild(50));
                this.cachedComponents = Collections.unmodifiableMap(componentMap);
                this.inaccessibleComponents = Collections.unmodifiableMap(newInaccessibleComponents);
                this.currentPorts = Collections.unmodifiableMap(newCurrentPorts);
                if (WorkspaceConnection.compareTimes(this.vTime.getValue(), workspaceFromServer.getTime()) < 0) {
                    List flows = workspaceFromServer.getFlows();
                    CurrentFlows currentFlows = workspaceFromServer.getCurrentFlows();
                    HashMap<UUID, CurrentFlows> currentComponentFlows = new HashMap<UUID, CurrentFlows>();
                    for (ComponentFlow e : workspaceFromServer.getCurrentComponentFlows()) {
                        currentComponentFlows.put(e.getComponent().getItemId(), e.getCurrentFlows());
                    }
                    FlowTable newFlowTable = new FlowTable(flows.toArray(new FlowEntry[flows.size()]), currentFlows, currentComponentFlows);
                    if (!((Object)newFlowTable).equals(this.flowTable)) {
                        this.sendPropertyChangeEvent("com.ibm.team.repository.PropertySet", "flow table", this.flowTable, newFlowTable);
                    }
                    this.flowTable = newFlowTable;
                    this.vTime = new SyncTime(workspaceFromServer.getTime());
                    this.teamRepository().itemManager().applyItemUpdates(Collections.singletonList(workspaceFromServer));
                }
                if (!(afterActive = ConfigUtil.tableForItems(this.changeSetCache.getActiveChangeSets())).keySet().equals(beforeActive.keySet())) {
                    HashMap added = new HashMap(afterActive);
                    added.keySet().removeAll(beforeActive.keySet());
                    if (!added.isEmpty()) {
                        for (IChangeSetHandle cs : added.values()) {
                            this.sendEvent("com.ibm.team.scm.ChangeHistoryEvent.CreateChangeSet", Collections.singletonList(cs), this.changeSetCache.getComponent(cs));
                        }
                    }
                }
                ArrayList<IChangeSet> valid = new ArrayList<IChangeSet>(refreshResult.getActiveChangeSets().size());
                for (IChangeSet cs : refreshResult.getActiveChangeSets()) {
                    if (staleComponents.contains(cs.getComponent().getItemId())) continue;
                    valid.add(cs);
                }
                if (!valid.isEmpty()) {
                    WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refresh(WRR,bool) - refreshing " + valid.size() + " active change sets " + tag);
                    for (IChangeSet cs : valid) {
                        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refresh(WRR,bool) - refreshing change set " + cs.getItemId().getUuidValue() + " to stateId " + cs.getStateId().getUuidValue() + " " + tag);
                    }
                    this.teamRepository().itemManager().applyItemUpdates(valid);
                    WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refresh(WRR,bool) - refreshing " + valid.size() + " active change sets " + tag);
                }
                this.clearRefreshResult(refreshResult);
            }
        }
        finally {
            this.release();
        }
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refresh(WRR,bool) ends " + tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void refreshWorkspace(Workspace w) {
        this.acquire();
        try {
            Object object = this.lock;
            synchronized (object) {
                block10: {
                    if (WorkspaceConnection.compareTimes(this.vTime.getValue(), w.getTime()) < 0) break block10;
                    return;
                }
                List flows = w.getFlows();
                CurrentFlows currentFlows = w.getCurrentFlows();
                HashMap<UUID, CurrentFlows> currentComponentFlows = new HashMap<UUID, CurrentFlows>();
                for (ComponentFlow e : w.getCurrentComponentFlows()) {
                    currentComponentFlows.put(e.getComponent().getItemId(), e.getCurrentFlows());
                }
                this.teamRepository().itemManager().applyItemUpdates(Collections.singletonList(w));
                this.vTime = new SyncTime(w.getTime());
                FlowTable newFlowTable = new FlowTable(flows.toArray(new FlowEntry[flows.size()]), currentFlows, currentComponentFlows);
                if (!newFlowTable.equals(this.flowTable)) {
                    this.sendPropertyChangeEvent("com.ibm.team.repository.PropertySet", "flow table", this.flowTable, newFlowTable);
                }
                this.flowTable = newFlowTable;
            }
        }
        finally {
            this.release();
        }
    }

    protected void clearRefreshResult(WorkspaceRefreshResult refreshResult) {
        refreshResult.unsetActiveChangeSets();
        refreshResult.unsetContributorState();
        refreshResult.unsetActiveRemoved();
        refreshResult.unsetWorkspaceItemId();
        refreshResult.unsetWorkspace();
        refreshResult.unsetComponents();
    }

    @Override
    public IUpdateReport accept(int flags, IWorkspaceConnection acceptSource, IChangeHistorySyncReport syncReport, List baselines, List incomingChangeSets, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.accept(flags, acceptSource, syncReport, baselines, incomingChangeSets, null, monitor);
    }

    IUpdateReport accept(int flags, IWorkspaceConnection acceptSource, IChangeHistorySyncReport syncReport, List baselines, List incomingChangeSets, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        ContextLock lock;
        boolean preflight;
        boolean bl = preflight = (flags & 1) != 0;
        if (syncReport == null) {
            throw new IllegalArgumentException();
        }
        if (baselines == null) {
            throw new IllegalArgumentException();
        }
        if (incomingChangeSets == null) {
            throw new IllegalArgumentException();
        }
        for (Object o : baselines) {
            if (o != null && o instanceof BaselineHandle) continue;
            throw new IllegalArgumentException();
        }
        for (Object o : incomingChangeSets) {
            if (o != null && o instanceof ChangeSetHandle) continue;
            throw new IllegalArgumentException();
        }
        IWorkspaceHandle remoteWorkspaceHandle = this.checkedGetRemote(syncReport, acceptSource);
        IWorkspaceHandle handle = this.getWorkspaceHandle();
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.checkLocal(syncReport, handle, (IProgressMonitor)sm.newChild(5));
        List<IChangeSetHandle> sortedIncomingCsHandleList = WorkspaceConnection.checkAgainstReport((IChangeHistorySyncReport)((ChangeHistorySyncReport)syncReport), true, incomingChangeSets, this.teamRepository());
        if (!AcceptFlags.isValid((int)flags)) {
            throw new IllegalArgumentException();
        }
        if (!preflight) {
            lock = new ContextLock();
            this.addToLock(lock, (ChangeHistorySyncReport)syncReport, baselines, sortedIncomingCsHandleList, false, (IProgressMonitor)sm.newChild(4));
            lock.acquire((IProgressMonitor)sm.newChild(1));
            if (!preflight) {
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " acceptCombined() begins");
            }
        } else {
            sm.setWorkRemaining(90);
            lock = null;
        }
        try {
            WorkspaceUpdateReportResult result;
            this.validate();
            ChangeSetHandle[] sortedIncomingCsHandles = sortedIncomingCsHandleList.toArray(new ChangeSetHandle[sortedIncomingCsHandleList.size()]);
            IScmService service = this.workspaceManager.getServerConfigurationService();
            WorkspaceRefreshParameter deltaParameter = this.getDeltaParameter();
            RemoteRepoDescriptor remoteDescriptor = null;
            InvalidAuthenticationTokenException authEx = null;
            while (true) {
                RemoteRepoDescriptor newDescriptor = this.extractRemoteDescriptor(acceptSource, sm.newChild(5));
                if (remoteDescriptor != null && newDescriptor.getAuthToken().getTruth().equals(remoteDescriptor.getAuthToken().getTruth())) {
                    throw authEx;
                }
                remoteDescriptor = newDescriptor;
                try {
                    result = service.acceptCombined(handle, flags, remoteWorkspaceHandle, remoteDescriptor, (IBaselineHandle[])baselines.toArray(new BaselineHandle[baselines.size()]), (IChangeSetHandle[])sortedIncomingCsHandles, deltaParameter, WorkspaceConnection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor((IProgressMonitor)sm));
                }
                catch (InvalidAuthenticationTokenException e) {
                    if (remoteDescriptor == null) {
                        throw e;
                    }
                    this.resetRemoteDescriptor(acceptSource);
                    authEx = e;
                    sm.setWorkRemaining(90);
                    continue;
                }
                break;
            }
            IUpdateReport updateReport = result.getReport();
            sm.worked(75);
            if (!preflight) {
                this.acquire();
                try {
                    this.refresh(result.getRefreshResult(), deltaParameter, false, (IProgressMonitor)sm.newChild(5));
                    this.sendEvent(updateReport);
                    this.sendEvent("com.ibm.team.scm.ChangeHistoryEvent.AcceptCombined", new ArrayList(baselines), new ArrayList(incomingChangeSets));
                }
                finally {
                    this.release();
                }
            }
            if (!preflight) {
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " acceptCombined() ends");
            }
            IUpdateReport iUpdateReport = updateReport;
            return iUpdateReport;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails(e);
        }
        finally {
            if (!preflight) {
                lock.release();
            }
            sm.done();
        }
    }

    @Override
    public IUpdateReport accept(int flags, List incoming, ITeamRepository optionalTeamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.accept(flags, incoming, optionalTeamRepository, null, monitor);
    }

    IUpdateReport accept(int flags, List incoming, ITeamRepository optionalTeamRepository, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        ContextLock lock;
        boolean preflight;
        boolean bl = preflight = (flags & 1) != 0;
        if (incoming == null) {
            throw new IllegalArgumentException();
        }
        if (!AcceptFlags.isValid((int)flags)) {
            throw new IllegalArgumentException();
        }
        WorkspaceConnection.checkForDuplicates(incoming);
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (!preflight) {
            lock = new ContextLock();
            this.addToLock(lock, incoming, optionalTeamRepository == null ? this.teamRepository() : optionalTeamRepository, (IProgressMonitor)sm.newChild(9));
            lock.acquire((IProgressMonitor)sm.newChild(1));
            if (!preflight) {
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " accept() begins");
            }
        } else {
            lock = null;
            sm.setWorkRemaining(90);
        }
        try {
            WorkspaceUpdateReportResult result;
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            WorkspaceRefreshParameter deltaParameter = this.getDeltaParameter();
            RemoteRepoDescriptor remoteDescriptor = null;
            InvalidAuthenticationTokenException authEx = null;
            while (true) {
                if (optionalTeamRepository != null && !optionalTeamRepository.getId().equals((Object)this.teamRepository().getId())) {
                    RemoteRepoDescriptor newDescriptor = RemoteRepoDescriptorUtils.getRemoteDescriptor(optionalTeamRepository, (IProgressMonitor)sm.newChild(5));
                    if (remoteDescriptor != null && newDescriptor.getAuthToken().getTruth().equals(remoteDescriptor.getAuthToken().getTruth())) {
                        throw authEx;
                    }
                    remoteDescriptor = newDescriptor;
                }
                try {
                    result = service.accept(this.getWorkspaceHandle(), flags, (IChangeSetHandle[])incoming.toArray(new ChangeSetHandle[incoming.size()]), remoteDescriptor, deltaParameter, WorkspaceConnection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor((IProgressMonitor)sm));
                }
                catch (InvalidAuthenticationTokenException e) {
                    if (remoteDescriptor == null) {
                        throw e;
                    }
                    RemoteRepoDescriptorUtils.resetRemoteDescriptor(optionalTeamRepository);
                    authEx = e;
                    sm.setWorkRemaining(90);
                    continue;
                }
                break;
            }
            IUpdateReport report = result.getReport();
            sm.worked(75);
            if (!preflight) {
                this.acquire();
                try {
                    this.refresh(result.getRefreshResult(), deltaParameter, false, (IProgressMonitor)sm.newChild(5));
                    this.sendEvent(report);
                    this.sendEvent("com.ibm.team.scm.ChangeHistoryEvent.AcceptChangeSets", new ArrayList(incoming));
                }
                finally {
                    this.release();
                }
            }
            if (!preflight) {
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " accept() ends");
            }
            sm.done();
            IUpdateReport iUpdateReport = report;
            return iUpdateReport;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails(e);
        }
        finally {
            if (!preflight) {
                lock.release();
            }
        }
    }

    @Override
    public IUpdateReport resume(int flags, List<IChangeSetHandle> incoming, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.resume(flags, incoming, null, monitor);
    }

    IUpdateReport resume(int flags, List<IChangeSetHandle> incoming, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        ContextLock lock;
        boolean preflight;
        boolean bl = preflight = (flags & 1) != 0;
        if (incoming == null) {
            throw new IllegalArgumentException();
        }
        if (!AcceptFlags.isValid((int)flags)) {
            throw new IllegalArgumentException();
        }
        WorkspaceConnection.checkForDuplicates(incoming);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (!preflight) {
            lock = new ContextLock();
            this.addToLock(lock, incoming, this.teamRepository(), (IProgressMonitor)progress.newChild(5));
            lock.acquire((IProgressMonitor)progress.newChild(1));
            if (!preflight) {
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " resume() begins");
            }
        } else {
            lock = null;
        }
        progress.setWorkRemaining(95);
        try {
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            WorkspaceRefreshParameter deltaParameter = this.getDeltaParameter();
            WorkspaceUpdateReportResult result = service.resume(this.getWorkspaceHandle(), flags, (IChangeSetHandle[])incoming.toArray(new ChangeSetHandle[incoming.size()]), deltaParameter, WorkspaceConnection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor((IProgressMonitor)progress));
            IUpdateReport report = result.getReport();
            progress.worked(85);
            if (!preflight) {
                this.acquire();
                try {
                    this.refresh(result.getRefreshResult(), deltaParameter, false, (IProgressMonitor)progress.newChild(5));
                    this.sendEvent(report);
                    this.sendEvent("com.ibm.team.scm.ChangeHistoryEvent.AcceptChangeSets", new ArrayList<IChangeSetHandle>(incoming));
                }
                finally {
                    this.release();
                }
            }
            if (!preflight) {
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " resume() ends");
            }
            IUpdateReport iUpdateReport = report;
            return iUpdateReport;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails(e);
        }
        finally {
            if (!preflight) {
                lock.release();
            }
            progress.done();
        }
    }

    @Override
    public List<IComponentLockReport> deliver(IWorkspaceConnection remoteConnection, IChangeHistorySyncReport syncReport, List baselines, List outgoingChangeSets, IProgressMonitor m) throws TeamRepositoryException {
        return this.deliver(remoteConnection, syncReport, baselines, outgoingChangeSets, null, null, m);
    }

    List<IComponentLockReport> deliver(IWorkspaceConnection remoteWorkspaceConnection, final IChangeHistorySyncReport syncReport, final List baselines, final List outgoingChangeSets, final ISynchronizationInfo syncInfo, final IWorkspaceOperationRunner.IWorkspaceOperationRunnable preConditionRunnable, IProgressMonitor m) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)m, (int)100);
        if (syncReport == null) {
            throw new IllegalArgumentException();
        }
        if (baselines == null) {
            throw new IllegalArgumentException();
        }
        if (outgoingChangeSets == null) {
            throw new IllegalArgumentException();
        }
        this.checkLocal(syncReport, this.getWorkspaceHandle(), (IProgressMonitor)progress.newChild(1));
        this.checkedGetRemote(syncReport, remoteWorkspaceConnection);
        final WorkspaceConnection remoteConnection = (WorkspaceConnection)remoteWorkspaceConnection;
        final IScmService service = remoteConnection.workspaceManager.getServerConfigurationService();
        DeliverOperationData deliverData = new DeliverOperationData((ProcessProxy)new ProcessUtils.ClientProcessProxy(this.teamRepository()), this.getResolvedWorkspace(), remoteConnection.getResolvedWorkspace(), baselines, outgoingChangeSets);
        final ClientAdvisableOperation operation = new ClientAdvisableOperation(remoteConnection.teamRepository(), "com.ibm.team.scm.client.deliver", deliverData, (IItem)remoteConnection.getResolvedWorkspace(), (IProgressMonitor)progress.newChild(4));
        operation.setIgnoredExceptions(false);
        final ArrayList<IComponentLockReport> result = new ArrayList<IComponentLockReport>();
        operation.setBlock(new RepositoryRunnable(){

            public Object run(IProgressMonitor topMonitor) throws TeamRepositoryException {
                return WorkspaceConnection.this.runDeliver(new IWorkspaceDeliverRunnable(){

                    @Override
                    public IObjectsResponse deliver(IWorkspaceConnection workspace, IWorkspaceConnection targetWorkspace, IBaselineHandle[] baselines, IChangeSetHandle[] outgoingChangeSets, IProgressMonitor monitor) throws TeamRepositoryException {
                        boolean distributed;
                        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                        if (preConditionRunnable != null && operation.isBeingRerun()) {
                            preConditionRunnable.run((IProgressMonitor)sm.newChild(5));
                        }
                        boolean bl = distributed = !targetWorkspace.sameRepository(workspace);
                        if (distributed && outgoingChangeSets.length > 0) {
                            List fullChangesets = workspace.teamRepository().itemManager().fetchCompleteItems(Arrays.asList(outgoingChangeSets), 2, (IProgressMonitor)sm.newChild(5));
                            ArrayList<IChangeSetHandle> toClose = new ArrayList<IChangeSetHandle>();
                            for (IChangeSet cs : fullChangesets) {
                                if (!cs.isActive()) continue;
                                toClose.add((IChangeSetHandle)cs.getItemHandle());
                            }
                            if (!toClose.isEmpty()) {
                                workspace.closeChangeSets(toClose, (IProgressMonitor)sm.newChild(5));
                            }
                        }
                        RemoteRepoDescriptor sourceRepoDescriptor = null;
                        InvalidAuthenticationTokenException authEx = null;
                        while (true) {
                            sm.setWorkRemaining(85);
                            if (!remoteConnection.sameRepository(WorkspaceConnection.this)) {
                                RemoteRepoDescriptor newDesc = RemoteRepoDescriptorUtils.getRemoteDescriptor(WorkspaceConnection.this.teamRepository(), (IProgressMonitor)sm.newChild(5));
                                if (sourceRepoDescriptor != null && newDesc.getAuthToken().getTruth().equals(sourceRepoDescriptor.getAuthToken().getTruth())) {
                                    throw authEx;
                                }
                                sourceRepoDescriptor = newDesc;
                            }
                            try {
                                WorkspaceRefreshParameter deltaParameter1 = WorkspaceConnection.this.getDeltaParameter();
                                deltaParameter1.setOpConfigInfo(operation.getOperationConfigurationInfo());
                                WorkspaceRefreshParameter deltaParameter2 = ((WorkspaceConnection)targetWorkspace).getDeltaParameter();
                                IObjectsResponse resp = service.deliverCombined((IWorkspaceHandle)workspace.getResolvedWorkspace().getItemHandle(), sourceRepoDescriptor, (IWorkspaceHandle)targetWorkspace.getResolvedWorkspace().getItemHandle(), baselines, outgoingChangeSets, deltaParameter1, deltaParameter2, WorkspaceConnection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)WorkspaceConnection.this.monitorFor((IProgressMonitor)sm));
                                sm.done();
                                return resp;
                            }
                            catch (InvalidAuthenticationTokenException e) {
                                if (sourceRepoDescriptor == null) {
                                    throw e;
                                }
                                RemoteRepoDescriptorUtils.resetRemoteDescriptor(WorkspaceConnection.this.teamRepository());
                                authEx = e;
                                continue;
                            }
                            catch (DeliveryIntroducesConflictsException e) {
                                this.checkForHistoryReordering(workspace, targetWorkspace, baselines, outgoingChangeSets, sm, (IItemInfoException)e);
                                throw e;
                            }
                            catch (NWayConflictUnsupportedException e) {
                                this.checkForHistoryReordering(workspace, targetWorkspace, baselines, outgoingChangeSets, sm, (IItemInfoException)e);
                                throw e;
                            }
                            break;
                        }
                    }

                    private void checkForHistoryReordering(IWorkspaceConnection workspace, IWorkspaceConnection targetWorkspace, IBaselineHandle[] baselines, IChangeSetHandle[] outgoingChangeSets, SubMonitor sm, IItemInfoException cause) throws TeamRepositoryException, DeliveryRequiresHistoryReorderingException {
                        IComponentHandle comp = cause.getInfo().getComponent();
                        IChangeHistorySyncReport sr = workspace.compareTo(targetWorkspace, 0, Collections.EMPTY_LIST, (IProgressMonitor)sm.newChild(5));
                        boolean hasIncoming = this.hasIncoming(sr, comp);
                        boolean deliveringAllOutgoing = this.deliveringAllOutgoing(comp, sr, baselines, outgoingChangeSets, sm.newChild(20));
                        if (!hasIncoming && deliveringAllOutgoing) {
                            IComponent component = (IComponent)WorkspaceConnection.this.teamRepository().itemManager().fetchCompleteItem((IItemHandle)comp, 0, (IProgressMonitor)sm.newChild(4));
                            String componentName = component.getName();
                            DeliveryRequiresHistoryReorderingException drhre = new DeliveryRequiresHistoryReorderingException(NLS.bind((String)Messages.WorkspaceConnection_Requires_Reordering, (Object)componentName, (Object[])new Object[0]));
                            drhre.setData(comp);
                            throw drhre;
                        }
                        if (!hasIncoming && !deliveringAllOutgoing) {
                            IComponent component = (IComponent)WorkspaceConnection.this.teamRepository().itemManager().fetchCompleteItem((IItemHandle)comp, 0, (IProgressMonitor)sm.newChild(4));
                            String componentName = component.getName();
                            throw new DeliveryIntroducesConflictsException(NLS.bind((String)Messages.WorkspaceConnection_TRY_DELIVER_ALL_OUTGOING, (Object)componentName, (Object[])new Object[0]), (Throwable)((TeamRepositoryException)cause));
                        }
                    }

                    private boolean hasIncoming(IChangeHistorySyncReport sr, IComponentHandle comp) {
                        return !sr.incomingChangeSets(comp).isEmpty();
                    }

                    private boolean deliveringAllOutgoing(IComponentHandle component, IChangeHistorySyncReport sr, IBaselineHandle[] baselines, IChangeSetHandle[] outgoingChangeSets, SubMonitor monitor) throws TeamRepositoryException {
                        List outgoingBaselines = sr.outgoingBaselines(component);
                        if (outgoingBaselines.isEmpty()) {
                            return this.checkChangesOnly(component, sr, outgoingChangeSets);
                        }
                        Set outgoingBaselineIds = ConfigUtil.getItemIds((Collection)sr.outgoingBaselines(component));
                        Set specifiedBaselineIds = ConfigUtil.getItemIds(Arrays.asList(baselines));
                        specifiedBaselineIds.retainAll(outgoingBaselineIds);
                        if (specifiedBaselineIds.isEmpty()) {
                            return this.checkChangesOnly(component, sr, outgoingChangeSets);
                        }
                        IBaselineHandle outgoingBaseline = (IBaselineHandle)IBaseline.ITEM_TYPE.createItemHandle((UUID)specifiedBaselineIds.iterator().next(), null);
                        if (outgoingBaselines.size() <= 1) {
                            return this.checkChangesOnly(component, sr, outgoingChangeSets);
                        }
                        IBaselineHandle latest = (IBaselineHandle)outgoingBaselines.get(0);
                        if (latest.sameItemId((IItemHandle)outgoingBaseline)) {
                            return this.checkChangesOnly(component, sr, outgoingChangeSets);
                        }
                        IBaselineConnection current = (this).WorkspaceConnection.this.workspaceManager.getBaselineConnection(outgoingBaseline, (IProgressMonitor)monitor.newChild(5));
                        IChangeHistorySyncReport compareBaselines = current.compareTo(latest, (IProgressMonitor)monitor.newChild(5));
                        if (compareBaselines.incomingChangeSets().isEmpty()) {
                            return this.checkChangesOnly(component, sr, outgoingChangeSets);
                        }
                        return false;
                    }

                    private boolean checkChangesOnly(IComponentHandle component, IChangeHistorySyncReport sr, IChangeSetHandle[] outgoingChangeSets) {
                        Set delivering = ConfigUtil.getItemIds(Arrays.asList(outgoingChangeSets));
                        Set outgoingCs = ConfigUtil.getItemIds((Collection)sr.outgoingChangeSets(component));
                        return delivering.containsAll(outgoingCs);
                    }
                }, remoteConnection, syncReport, baselines, outgoingChangeSets, result, topMonitor);
            }
        });
        operation.processExec((IProgressMonitor)progress.newChild(95));
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " deliver() ends");
        return result;
    }

    @Override
    public IOperationReport runDeliver(IWorkspaceDeliverRunnable runnable, IWorkspaceConnection remoteConnection, IChangeHistorySyncReport syncReport, List<IBaselineHandle> baselineHandles, List<IChangeSetHandle> outgoingChangeSets, List<IComponentLockReport> result2, IProgressMonitor monitor) throws TeamRepositoryException {
        List<IChangeSetHandle> sortedChangeSetHandles = WorkspaceConnection.checkAgainstReport((IChangeHistorySyncReport)((ChangeHistorySyncReport)syncReport), false, outgoingChangeSets, this.teamRepository());
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ContextLock lock = new ContextLock();
        this.addToLock(lock, (ChangeHistorySyncReport)syncReport, baselineHandles, sortedChangeSetHandles, true, (IProgressMonitor)sm.newChild(9));
        lock.acquire((IProgressMonitor)sm.newChild(1));
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " deliver() begins");
        try {
            ((WorkspaceConnection)remoteConnection).validate();
            this.validate();
            WorkspaceHandle remoteWorkspaceHandle = (WorkspaceHandle)remoteConnection.getResolvedWorkspace();
            IObjectsResponse response = runnable.deliver(this, remoteConnection, (IBaselineHandle[])baselineHandles.toArray(new BaselineHandle[baselineHandles.size()]), (IChangeSetHandle[])sortedChangeSetHandles.toArray(new ChangeSetHandle[sortedChangeSetHandles.size()]), (IProgressMonitor)sm.newChild(75));
            WorkspaceDeliveryResult result = (WorkspaceDeliveryResult)response.getClientObjects()[0];
            if (result.getOpConfigInfo() != null) {
                remoteConnection.teamRepository().itemManager().applyItemUpdates(Collections.singletonList(result.getOpConfigInfo()));
            }
            remoteConnection.teamRepository().itemManager().applyItemUpdates(result.getItems());
            result.unsetItems();
            this.acquire();
            WorkspaceRefreshParameter deltaParameter = this.getDeltaParameter();
            try {
                if (this.sameRepository(remoteConnection)) {
                    this.refresh(result.getRefreshResult(), deltaParameter, (IProgressMonitor)sm.newChild(3));
                }
                this.sendDeliverEvent("com.ibm.team.scm.ChangeHistoryEvent.Deliver", new ArrayList<IBaselineHandle>(baselineHandles), sortedChangeSetHandles, (IFlowNodeHandle)remoteWorkspaceHandle);
            }
            finally {
                this.release();
            }
            ((WorkspaceConnection)remoteConnection).refresh(result.getTargetRefreshResult(), deltaParameter, (IProgressMonitor)sm.newChild(2));
            if (result.getLocksToRelease() != null) {
                for (ComponentLocks cl : result.getLocksToRelease().getComponentLocks()) {
                    result2.add((IComponentLockReport)new ComponentReport(cl));
                }
            }
            IOperationReport iOperationReport = response.getOperationReport();
            return iOperationReport;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails(e);
        }
        finally {
            lock.release();
            sm.done();
        }
    }

    private static Set<UUID> checkForDuplicates(Collection<IChangeSetHandle> changeSets) {
        HashSet<UUID> result = new HashSet<UUID>();
        for (IChangeSetHandle element : changeSets) {
            if (element == null || !(element instanceof IChangeSetHandle)) {
                throw new IllegalArgumentException();
            }
            if (result.add(element.getItemId())) continue;
            throw new IllegalArgumentException();
        }
        return result;
    }

    public static List<IChangeSetHandle> checkAgainstReport(IChangeHistorySyncReport report, boolean incoming, List<IChangeSetHandle> changeSets, ITeamRepository teamRepository) throws TeamRepositoryException {
        Set<UUID> uniqueCsIds = WorkspaceConnection.checkForDuplicates(changeSets);
        HashSet<UUID> reportCsIds = new HashSet<UUID>();
        ArrayList<IChangeSetHandle> sortedCsHandles = new ArrayList<IChangeSetHandle>(changeSets.size());
        List reportList = incoming ? report.incomingChangeSets() : report.outgoingChangeSets();
        for (IChangeSetHandle csh : reportList) {
            reportCsIds.add(csh.getItemId());
            if (!uniqueCsIds.contains(csh.getItemId())) continue;
            sortedCsHandles.add(csh);
        }
        if (!reportCsIds.containsAll(uniqueCsIds)) {
            HashSet<UUID> notContainedIds = new HashSet<UUID>(uniqueCsIds);
            notContainedIds.removeAll(reportCsIds);
            String msg = incoming ? Messages.WorkspaceConnection_1 : Messages.WorkspaceConnection_2;
            if (!incoming) {
                throw new ChangeSetsNotOutgoingException((Object)teamRepository, msg);
            }
            throw new TeamRepositoryException((Object)teamRepository, msg);
        }
        return sortedCsHandles;
    }

    private void checkLocal(IChangeHistorySyncReport syncReport, IWorkspaceHandle localHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask("", 100);
        IWorkspaceHandle reportLocalHandle = ((ChangeHistorySyncReport)syncReport).getLocal();
        if (reportLocalHandle == null) {
            throw new SyncReportInappropriateException((Object)this.teamRepository(), Messages.WorkspaceConnection_3);
        }
        if (!reportLocalHandle.sameItemId((IItemHandle)localHandle)) {
            IWorkspace reportWorkspace = (IWorkspace)this.teamRepository().itemManager().fetchCompleteItem((IItemHandle)reportLocalHandle, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            IWorkspace workspace = (IWorkspace)this.teamRepository().itemManager().fetchCompleteItem((IItemHandle)localHandle, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            String message = NLS.bind((String)Messages.WorkspaceConnection_4, (Object[])new Object[]{reportWorkspace.getName(), workspace.getName()}, (Object[])new Object[0]);
            throw new SyncReportInappropriateException((Object)this.teamRepository(), message);
        }
        monitor.done();
    }

    private IWorkspaceHandle checkedGetRemote(IChangeHistorySyncReport syncReport, IWorkspaceConnection connection) throws TeamRepositoryException {
        IWorkspaceHandle remote = ((ChangeHistorySyncReport)syncReport).getRemote();
        if (remote == null) {
            throw new SyncReportInappropriateException((Object)this.teamRepository(), Messages.WorkspaceConnection_5);
        }
        if (!remote.sameItemId((IItemHandle)connection.getResolvedWorkspace())) {
            throw new SyncReportInappropriateException((Object)this.teamRepository(), Messages.WorkspaceConnection_5);
        }
        return remote;
    }

    @Override
    public IWorkspaceConnection.IConfigurationOpFactory configurationOpFactory() {
        return this.configurationOpFactory;
    }

    @Override
    public IUpdateReport commit(IChangeSetHandle activeChangeSet, Collection configOps, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.commit(activeChangeSet, configOps, null, monitor);
    }

    IUpdateReport commit(IChangeSetHandle activeChangeSet, Collection configOps, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (activeChangeSet == null) {
            throw new IllegalArgumentException();
        }
        if (configOps == null) {
            throw new IllegalArgumentException();
        }
        if (this.getResolvedWorkspace().isStream()) {
            throw new InvalidStreamOperationException(Messages.WorkspaceConnection_6);
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ContextLock lock = new ContextLock();
        this.addToLock(lock, Collections.singletonList(activeChangeSet), this.teamRepository(), (IProgressMonitor)progress.newChild(5));
        lock.acquire((IProgressMonitor)progress.newChild(1));
        WorkspaceConnection.log("Workspace " + this.workspace.getItemId().getUuidValue() + " commit() begins");
        try {
            this.validate();
            HashSet<UUID> itemIds = new HashSet<UUID>();
            ICommitParameter instruction = ICommitParameter.FACTORY.create(activeChangeSet);
            HashMap<UUID, IVersionable> toSaveMap = new HashMap<UUID, IVersionable>();
            for (IWorkspaceConnection.IConfigurationOp element : configOps) {
                this.processConfigOp(element, itemIds, toSaveMap, instruction);
            }
            IScmService service = this.workspaceManager.getServerConfigurationService();
            WorkspaceRefreshParameter deltaParameter = this.getDeltaParameter();
            WorkspaceUpdateReportResult result = service.batchCommit((IWorkspaceHandle)this.getResolvedWorkspace(), new ICommitParameter[]{instruction}, deltaParameter, WorkspaceConnection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)IRepositoryProgressMonitor.ITEM_FACTORY.createItem((IProgressMonitor)progress));
            progress.worked(85);
            IUpdateReport report = result.getReport();
            WorkspaceConnection.applyUpdatesAfterCommit(toSaveMap, report);
            this.acquire();
            try {
                this.sendCommitEvent(activeChangeSet);
                this.sendEvent(report);
                this.refresh(result.getRefreshResult(), deltaParameter, false, (IProgressMonitor)progress.newChild(5));
            }
            finally {
                this.release();
            }
            WorkspaceConnection.log("Workspace " + this.workspace.getItemId().getUuidValue() + " commit() ends");
            IUpdateReport iUpdateReport = report;
            return iUpdateReport;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails(e);
        }
        finally {
            lock.release();
            progress.done();
        }
    }

    private static void applyUpdatesAfterCommit(Map<UUID, IVersionable> toSaveMap, IUpdateReport report) {
        for (IItemUpdateReport r : report.updates()) {
            IVersionable v;
            IVersionableHandle h = r.getNewCurrentState();
            if (h == null || (v = toSaveMap.get(h.getItemId())) == null) continue;
            WorkspaceConnection.adjustAllContentAfterSave((EObject)v, (IVersionableHandle)h.getItemType().createItemHandle(h.getItemId(), h.getStateId()));
        }
    }

    private static void adjustAllContentAfterSave(EObject currentChild, IVersionableHandle h) {
        EList features = currentChild.eClass().getEAllReferences();
        List values = null;
        int i = 0;
        while (i < features.size()) {
            EReference reference = (EReference)features.get(i);
            if (ItemUtil.isPersistent((EClass)currentChild.eClass(), (EStructuralFeature)reference) && reference.isContainment() && currentChild.eIsSet((EStructuralFeature)reference)) {
                Object value = currentChild.eGet((EStructuralFeature)reference);
                if (reference.isMany()) {
                    values = (List)value;
                    int j = 0;
                    while (j < values.size()) {
                        Object child = values.get(j);
                        if (child != null) {
                            if (child instanceof VersionedContent) {
                                WorkspaceConnection.adjustContentAfterSave((VersionedContent)child, h);
                            } else {
                                WorkspaceConnection.adjustAllContentAfterSave((EObject)child, h);
                            }
                        }
                        ++j;
                    }
                } else if (value instanceof VersionedContent) {
                    WorkspaceConnection.adjustContentAfterSave((VersionedContent)value, h);
                } else {
                    WorkspaceConnection.adjustAllContentAfterSave((EObject)value, h);
                }
            }
            ++i;
        }
    }

    private static void adjustContentAfterSave(VersionedContent vc, IVersionableHandle h) {
        vc.setOriginalContainingState(h);
    }

    @Override
    public IUpdateReport commit(List<IChangeSetHandle> activeChangeSets, List<Collection<? extends IWorkspaceConnection.IConfigurationOp>> configOps, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.commit(activeChangeSets, configOps, null, monitor);
    }

    IUpdateReport commit(List<IChangeSetHandle> activeChangeSets, List<Collection<? extends IWorkspaceConnection.IConfigurationOp>> configOps, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (activeChangeSets == null) {
            throw new IllegalArgumentException();
        }
        if (configOps == null) {
            throw new IllegalArgumentException();
        }
        if (activeChangeSets.size() != configOps.size()) {
            throw new IllegalArgumentException();
        }
        if (activeChangeSets.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (this.getResolvedWorkspace().isStream()) {
            throw new InvalidStreamOperationException(Messages.WorkspaceConnection_9);
        }
        if (ConfigUtil.getItemIds(activeChangeSets).size() != activeChangeSets.size()) {
            throw new IllegalArgumentException();
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ContextLock lock = new ContextLock();
        this.addToLock(lock, activeChangeSets, this.teamRepository(), (IProgressMonitor)progress.newChild(5));
        lock.acquire((IProgressMonitor)progress.newChild(1));
        WorkspaceConnection.log("Workspace " + this.workspace.getItemId().getUuidValue() + " commit() begins");
        try {
            this.validate();
            CommitParameter[] instructions = new CommitParameter[configOps.size()];
            HashMap<UUID, IVersionable> toSaveMap = new HashMap<UUID, IVersionable>();
            int i = 0;
            while (i < instructions.length) {
                HashSet<UUID> itemIds = new HashSet<UUID>();
                ICommitParameter instruction = ICommitParameter.FACTORY.create(activeChangeSets.get(i));
                for (IWorkspaceConnection.IConfigurationOp iConfigurationOp : configOps.get(i)) {
                    this.processConfigOp(iConfigurationOp, itemIds, toSaveMap, instruction);
                }
                instructions[i] = instruction;
                ++i;
            }
            IScmService service = this.workspaceManager.getServerConfigurationService();
            WorkspaceRefreshParameter deltaParameter = this.getDeltaParameter();
            WorkspaceUpdateReportResult result = service.batchCommit((IWorkspaceHandle)this.getResolvedWorkspace(), (ICommitParameter[])instructions, deltaParameter, WorkspaceConnection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)IRepositoryProgressMonitor.ITEM_FACTORY.createItem((IProgressMonitor)progress));
            progress.worked(85);
            IUpdateReport iUpdateReport = result.getReport();
            WorkspaceConnection.applyUpdatesAfterCommit(toSaveMap, iUpdateReport);
            this.acquire();
            try {
                for (IChangeSetHandle ch : activeChangeSets) {
                    this.sendCommitEvent(ch);
                }
                this.sendEvent(iUpdateReport);
                this.refresh(result.getRefreshResult(), deltaParameter, false, (IProgressMonitor)progress.newChild(5));
            }
            finally {
                this.release();
            }
            WorkspaceConnection.log("Workspace " + this.workspace.getItemId().getUuidValue() + " commit() ends");
            IUpdateReport iUpdateReport2 = iUpdateReport;
            return iUpdateReport2;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails(e);
        }
        finally {
            lock.release();
            progress.done();
        }
    }

    private void processConfigOp(IWorkspaceConnection.IConfigurationOp element, Set<UUID> itemIds, Map<UUID, IVersionable> itemsToSave, ICommitParameter instruction) throws TeamRepositoryException {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        if (element instanceof SaveOp) {
            SaveOp op = (SaveOp)element;
            IVersionable item = op.item;
            if (!itemIds.add(item.getItemId())) {
                throw new IllegalArgumentException("Duplicate configuration operation");
            }
            if (!item.isWorkingCopy()) {
                throw new TeamRepositoryException((Throwable)new IllegalArgumentException());
            }
            instruction.addItemToSave(op.item);
            itemsToSave.put(item.getItemId(), item);
            return;
        }
        if (element instanceof RevertOp) {
            RevertOp op = (RevertOp)element;
            if (!itemIds.add(op.itemStateHandle.getItemId())) {
                throw new IllegalArgumentException("Duplicate configuration operation");
            }
            instruction.addItemToRevert(op.itemStateHandle);
            return;
        }
        if (element instanceof DeleteOp) {
            DeleteOp op = (DeleteOp)element;
            if (!itemIds.add(op.itemHandle.getItemId())) {
                throw new IllegalArgumentException("Duplicate configuration operation");
            }
            instruction.addItemToDelete(op.itemHandle);
            return;
        }
        if (element instanceof DeleteSubtreeOp) {
            DeleteSubtreeOp op = (DeleteSubtreeOp)element;
            if (!itemIds.add(op.folderHandle.getItemId())) {
                throw new IllegalArgumentException("Duplicate configuration operation");
            }
            instruction.addFolderToDeleteSubtree(op.folderHandle);
            return;
        }
        if (element instanceof UndoOp) {
            UndoOp op = (UndoOp)element;
            if (!itemIds.add(op.itemHandle.getItemId())) {
                throw new IllegalArgumentException("Duplicate configuration operation");
            }
            instruction.addItemToUndo(op.itemHandle);
            return;
        }
        if (element instanceof MergeOp) {
            MergeOp op = (MergeOp)element;
            IWorkspaceConnection.IMergeResultOp innerOp = op.getInnerOp();
            if (itemIds.contains(innerOp.getItemHandle().getItemId())) {
                throw new IllegalArgumentException("Duplicate configuration operation");
            }
            this.processConfigOp(innerOp, itemIds, itemsToSave, instruction);
            PredecessorInfo info = ScmDtoFactory.eINSTANCE.createPredecessorInfo();
            info.setItemId(innerOp.getItemHandle().getItemId());
            info.setPredecessor(op.getSelectedState());
            info.setMergePredecessor(op.getProposedState());
            instruction.addPredecessorInformation(info);
            return;
        }
        if (element instanceof MarkAsMergedOp) {
            MarkAsMergedOp op = (MarkAsMergedOp)element;
            if (!itemIds.add(op.item.getItemId())) {
                throw new IllegalArgumentException("Duplicate configuration operation");
            }
            PredecessorInfo info = ScmDtoFactory.eINSTANCE.createPredecessorInfo();
            info.setItemId(op.item.getItemId());
            info.setPredecessor(op.getSelectedState());
            info.setMergePredecessor(op.getProposedState());
            if (!info.isValid()) {
                throw new IllegalArgumentException("MarkAsMerge operation malformed.");
            }
            instruction.addPredecessorInformation(info);
            instruction.addItemToMarkAsMerged(op.item);
            return;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public IUpdateReport suspend(Collection changeSets, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.suspend(changeSets, null, monitor);
    }

    IUpdateReport suspend(Collection changeSets, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (changeSets == null) {
            throw new IllegalArgumentException();
        }
        WorkspaceConnection.checkForDuplicates(changeSets);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ContextLock lock = new ContextLock();
        this.addToLock(lock, changeSets, this.teamRepository(), (IProgressMonitor)progress.newChild(5));
        lock.acquire((IProgressMonitor)progress.newChild(1));
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " suspend() begins");
        try {
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            ChangeSetHandle[] array = changeSets.toArray(new ChangeSetHandle[changeSets.size()]);
            WorkspaceRefreshParameter deltaParameter = this.getDeltaParameter();
            WorkspaceUpdateReportResult result = service.suspend(this.getWorkspaceHandle(), (IChangeSetHandle[])array, deltaParameter, WorkspaceConnection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor((IProgressMonitor)progress));
            IUpdateReport report = result.getReport();
            progress.worked(85);
            this.acquire();
            try {
                this.refresh(result.getRefreshResult(), deltaParameter, false, (IProgressMonitor)progress.newChild(5));
                this.sendEvent(report);
                this.sendEvent("com.ibm.team.scm.ChangeHistoryEvent.DiscardChangeSet", new ArrayList(changeSets));
            }
            finally {
                this.release();
            }
            WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " suspend() ends");
            IUpdateReport iUpdateReport = report;
            return iUpdateReport;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails(e);
        }
        finally {
            lock.release();
            progress.done();
        }
    }

    @Override
    public void removeSuspended(Collection changeSets, IProgressMonitor monitor) throws TeamRepositoryException {
        this.removeSuspended(changeSets, null, monitor);
    }

    void removeSuspended(Collection changeSets, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        this.workspaceManager.removeSuspended(changeSets, monitor);
    }

    @Override
    public void setCurrentChangeSet(IChangeSetHandle current, IProgressMonitor monitor) throws TeamRepositoryException {
        this.setCurrentChangeSet(current, null, monitor);
    }

    void setCurrentChangeSet(IChangeSetHandle current, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (current == null) {
            throw new IllegalArgumentException();
        }
        if (this.getResolvedWorkspace().isStream()) {
            throw new InvalidStreamOperationException(Messages.WorkspaceConnection_12);
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ContextLock lock = new ContextLock();
        this.addToLock(lock, Collections.singleton(current), this.teamRepository(), (IProgressMonitor)progress.newChild(5));
        lock.acquire((IProgressMonitor)progress.newChild(1));
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " setCurrentChangeSet() begins");
        try {
            try {
                this.validate();
                if (!this.isActive(current)) {
                    throw new CompletedChangeSetException(Messages.WorkspaceConnection_13);
                }
                IScmService service = this.workspaceManager.getServerConfigurationService();
                WorkspaceRefreshParameter deltaParameter = this.getDeltaParameter();
                WorkspaceRefreshResult result = service.setCurrentChangeSet(this.getWorkspaceHandle(), current, deltaParameter, WorkspaceConnection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor((IProgressMonitor)progress));
                progress.worked(85);
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " setCurrentChangeSet() beforeRefresh");
                this.refresh(result, deltaParameter, false, (IProgressMonitor)progress.newChild(5));
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " setCurrentChangeSet() ends");
            }
            catch (ItemNotFoundException e) {
                throw this.expandItemNotFoundDetails(e);
            }
        }
        finally {
            lock.release();
            progress.done();
        }
    }

    @Override
    public void unsetCurrentChangeSet(IComponentHandle component, IProgressMonitor monitor) throws TeamRepositoryException {
        this.unsetCurrentChangeSet(component, null, monitor);
    }

    void unsetCurrentChangeSet(IComponentHandle component, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (component == null) {
            throw new IllegalArgumentException();
        }
        if (this.getResolvedWorkspace().isStream()) {
            throw new InvalidStreamOperationException(Messages.WorkspaceConnection_14);
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ContextLock lock = new ContextLock();
        lock.addExclusive((IContextHandle)this.getWorkspaceHandle(), component);
        lock.acquire((IProgressMonitor)progress.newChild(1));
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " unsetCurrentChangeSet() begins");
        try {
            try {
                this.validate();
                IScmService service = this.workspaceManager.getServerConfigurationService();
                WorkspaceRefreshParameter deltaParameter = this.getDeltaParameter();
                WorkspaceRefreshResult result = service.unsetCurrentChangeSet(this.getWorkspaceHandle(), component, deltaParameter, WorkspaceConnection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor((IProgressMonitor)progress));
                progress.worked(90);
                this.refresh(result, deltaParameter, false, (IProgressMonitor)progress.newChild(5));
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " unsetCurrentChangeSet() ends");
            }
            catch (ItemNotFoundException e) {
                throw this.expandItemNotFoundDetails(e);
            }
        }
        finally {
            lock.release();
            progress.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isActive(IChangeSetHandle changeSet) {
        Set ids = null;
        Object object = this.lock;
        synchronized (object) {
            ids = ConfigUtil.getItemIds(this.changeSetCache.getActiveChangeSets());
        }
        return ids.contains(changeSet.getItemId());
    }

    private void sendCurrentChangeSetEvent(IChangeSetHandle current, IChangeSetHandle oldCurrent, IComponentHandle component) {
        this.queue(new CurrentChangeSetEvent(this, current, oldCurrent, component));
    }

    private void sendCommitEvent(IChangeSetHandle changeSet) {
        this.queue(new CommitEvent(this, "com.ibm.team.scm.Commit", changeSet));
    }

    private void sendDeliverEvent(String type, List baselineHandles, List changeSetHandles, IFlowNodeHandle deliverTarget) {
        this.queue(new ChangeHistoryEvent(this, type, baselineHandles, changeSetHandles, null, deliverTarget));
    }

    public void committedWork(IChangeSetHandle changeSet, IUpdateReport updateReport, IProgressMonitor monitor) throws TeamRepositoryException {
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " committedWork(cset,ur,monitor) begins");
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            this.acquire();
            try {
                this.sendCommitEvent(changeSet);
                this.sendEvent(updateReport);
            }
            finally {
                this.release();
            }
            ContextLock lock = new ContextLock();
            HashSet<UUID> before = new HashSet<UUID>();
            IWorkspaceHandle ws = this.getWorkspaceHandle();
            for (IComponentStateSummary s : updateReport.getComponentStatesBefore()) {
                before.add(s.getComponent().getItemId());
                lock.addExclusive((IContextHandle)ws, s.getComponent());
            }
            for (IComponentStateSummary s : updateReport.getComponentStatesAfter()) {
                if (before.remove(s.getComponent().getItemId())) continue;
                lock.clear();
                lock.addExclusive((IContextHandle)ws);
                break;
            }
            if (!before.isEmpty()) {
                lock.clear();
                lock.addExclusive((IContextHandle)ws);
            }
            before = null;
            lock.acquire((IProgressMonitor)progress.newChild(1));
            try {
                WorkspaceRefreshParameter parm = this.createRefreshParameter();
                WorkspaceRefreshResult r = this.refreshInternal((IProgressMonitor)progress.newChild(90), parm);
                this.refresh(r, parm, (IProgressMonitor)progress.newChild(5));
            }
            finally {
                lock.release();
            }
            WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " committedWork(cset,ur,monitor) ends");
        }
        finally {
            progress.done();
        }
    }

    public void committedWork(List changeSets, IUpdateReport[] reports, IProgressMonitor monitor) throws TeamRepositoryException {
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " committedWork(cset[],ur[],monitor) begins");
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            ContextLock lock = new ContextLock();
            this.acquire();
            try {
                int i = 0;
                while (i < reports.length) {
                    HashSet<UUID> before = new HashSet<UUID>();
                    IWorkspaceHandle ws = this.getWorkspaceHandle();
                    for (IComponentStateSummary s : reports[i].getComponentStatesBefore()) {
                        before.add(s.getComponent().getItemId());
                        lock.addExclusive((IContextHandle)ws, s.getComponent());
                    }
                    for (IComponentStateSummary s : reports[i].getComponentStatesAfter()) {
                        if (before.remove(s.getComponent().getItemId())) continue;
                        lock.clear();
                        lock.addExclusive((IContextHandle)ws);
                        break;
                    }
                    if (!before.isEmpty()) {
                        lock.clear();
                        lock.addExclusive((IContextHandle)ws);
                    }
                    this.sendEvent(reports[i]);
                    ++i;
                }
                i = 0;
                while (i < changeSets.size()) {
                    this.sendCommitEvent((IChangeSetHandle)changeSets.get(i));
                    ++i;
                }
            }
            finally {
                this.release();
            }
            lock.acquire((IProgressMonitor)progress.newChild(1));
            try {
                WorkspaceRefreshParameter parm = this.createRefreshParameter();
                WorkspaceRefreshResult r = this.refreshInternal((IProgressMonitor)progress.newChild(90), parm);
                this.refresh(r, parm, (IProgressMonitor)progress.newChild(5));
            }
            finally {
                lock.release();
            }
            WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " committedWork(cset[],ur[],monitor) ends");
        }
        finally {
            progress.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IChangeSetHandle getCurrentChangeSet(IComponentHandle componentHandle) {
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " getCurrentChangeSet(Comp) begins");
        if (componentHandle == null) {
            throw new IllegalArgumentException("component cannot be null");
        }
        IChangeSetHandle changeSet = null;
        Object object = this.lock;
        synchronized (object) {
            changeSet = this.changeSetCache.getCurrentChangeSet(componentHandle);
        }
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " getCurrentChangeSet(Comp) ends");
        return changeSet;
    }

    @Override
    public List retrieveComponentStateSummaries(IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            monitor.worked(10);
            IComponentStateSummary[] summaries = service.getWorkspaceComponentStateSummaries(this.getWorkspaceHandle(), (IRepositoryProgressMonitorHandle)this.monitorFor(monitor));
            monitor.worked(80);
            ArrayList<IComponentStateSummary> result = new ArrayList<IComponentStateSummary>(summaries.length);
            int i = 0;
            while (i < summaries.length) {
                IComponentStateSummary summary = summaries[i];
                result.add(summary);
                ++i;
            }
            SCMClientUtil.checkMonitor(monitor);
            ArrayList<IComponentStateSummary> arrayList = result;
            return arrayList;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails(e);
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void relocateChanges(List<? extends IChangeSetHandle> targetChangeSets, List<? extends IVersionableHandle> itemsToMove, List<? extends IChangeSetHandle> sourceChangeSets, IProgressMonitor monitor) throws TeamRepositoryException {
        this.relocateChanges(targetChangeSets, itemsToMove, sourceChangeSets, null, monitor);
    }

    void relocateChanges(List<? extends IChangeSetHandle> targetChangeSets, List<? extends IVersionableHandle> itemsToMove, List<? extends IChangeSetHandle> sourceChangeSets, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (targetChangeSets == null) {
            throw new IllegalArgumentException();
        }
        if (itemsToMove == null) {
            throw new IllegalArgumentException();
        }
        if (sourceChangeSets == null) {
            throw new IllegalArgumentException();
        }
        if (targetChangeSets.size() != sourceChangeSets.size()) {
            throw new IllegalArgumentException();
        }
        int size = itemsToMove.size();
        if (size != sourceChangeSets.size()) {
            throw new IllegalArgumentException();
        }
        HashSet<UUID> itemIds = new HashSet<UUID>();
        int i = 0;
        while (i < size) {
            IChangeSetHandle source = sourceChangeSets.get(i);
            IChangeSetHandle target = targetChangeSets.get(i);
            IVersionableHandle item = itemsToMove.get(i);
            if (item == null) {
                throw new IllegalArgumentException();
            }
            if (!itemIds.add(item.getItemId())) {
                throw new IllegalArgumentException();
            }
            if (source == null) {
                throw new IllegalArgumentException();
            }
            if (target == null) {
                throw new IllegalArgumentException();
            }
            ++i;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ContextLock lock = new ContextLock();
        this.addToLock(lock, sourceChangeSets, targetChangeSets, (IProgressMonitor)progress.newChild(5));
        lock.acquire((IProgressMonitor)progress.newChild(1));
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " relocateChanges begins");
        try {
            try {
                this.validate();
                IScmService service = this.workspaceManager.getServerConfigurationService();
                WorkspaceRefreshParameter deltaParameter = this.getDeltaParameter();
                WorkspaceItemListResult result = service.relocateChanges(this.getWorkspaceHandle(), targetChangeSets.toArray(new IChangeSetHandle[size]), itemsToMove.toArray(new IVersionableHandle[size]), sourceChangeSets.toArray(new IChangeSetHandle[size]), deltaParameter, WorkspaceConnection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor((IProgressMonitor)progress));
                progress.worked(85);
                this.acquire();
                try {
                    HashSet<UUID> sendAlready = new HashSet<UUID>();
                    for (IChangeSetHandle iChangeSetHandle : targetChangeSets) {
                        if (sendAlready.contains(iChangeSetHandle.getItemId())) continue;
                        this.sendCommitEvent(iChangeSetHandle);
                        sendAlready.add(iChangeSetHandle.getItemId());
                    }
                    WorkspaceRefreshResult workspaceRefreshResult = result.getRefreshResult();
                    this.refresh(workspaceRefreshResult, deltaParameter, false, (IProgressMonitor)progress.newChild(5));
                    this.teamRepository().itemManager().applyItemUpdates(result.getItems());
                    result.unsetItems();
                    WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " relocateChanges ends");
                }
                finally {
                    this.release();
                }
            }
            catch (ItemNotFoundException e) {
                throw this.expandItemNotFoundDetails(e);
            }
        }
        finally {
            lock.release();
        }
        progress.done();
    }

    @Override
    public IContextHandle getContextHandle() {
        return this.getWorkspaceHandle();
    }

    private IRepositoryProgressMonitor monitorFor(IProgressMonitor monitor) {
        return IRepositoryProgressMonitor.ITEM_FACTORY.createItem(monitor);
    }

    @Override
    public Object getAdapter(Class clazz) {
        if (clazz == IWorkspaceConnectionInteropAdapter.class) {
            return new IWorkspaceConnectionInteropAdapter(){

                @Override
                public IImportChangeSetResult importChangeSet(IComponentHandle componentHandle, String comment, Collection configOps, long creationTime, IContributorHandle contributor, IProgressMonitor monitor) throws TeamRepositoryException {
                    return WorkspaceConnection.this.importChangeSet(componentHandle, comment, configOps, creationTime, contributor, monitor);
                }

                @Override
                public IBaseline createPostImportBaseline(IComponentHandle componentHandle, String name, String comment, IProgressMonitor monitor) throws TeamRepositoryException {
                    return WorkspaceConnection.this.createPostImportBaseline(componentHandle, name, comment, null, monitor);
                }
            };
        }
        return null;
    }

    IBaseline createPostImportBaseline(IComponentHandle component, String name, String comment, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (!(component instanceof ComponentHandle)) {
            throw new IllegalArgumentException();
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ContextLock lock = new ContextLock();
        lock.addExclusive((IContextHandle)this.getWorkspaceHandle(), component);
        lock.acquire((IProgressMonitor)progress.newChild(1));
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " createPostImportBaseline begins");
        try {
            IBaseline iBaseline;
            this.validate();
            IScmImportService service = this.workspaceManager.getScmImportService();
            WorkspaceRefreshParameter deltaParameter = this.getDeltaParameter();
            WorkspaceItemListResult serviceResult = service.createPostImportBaseline(this.getWorkspaceHandle(), component, name, comment, deltaParameter, WorkspaceConnection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor((IProgressMonitor)progress));
            progress.worked(90);
            this.acquire();
            try {
                this.refresh(serviceResult.getRefreshResult(), deltaParameter, false, (IProgressMonitor)progress.newChild(5));
                IBaseline baseline = (IBaseline)serviceResult.getItems().get(0);
                this.teamRepository().itemManager().applyItemUpdates(serviceResult.getItems());
                serviceResult.unsetItems();
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " createPostImportBaseline ends");
                iBaseline = baseline;
            }
            catch (Throwable throwable) {
                this.release();
                throw throwable;
            }
            this.release();
            return iBaseline;
        }
        finally {
            lock.release();
            progress.done();
        }
    }

    IImportChangeSetResult importChangeSet(IComponentHandle component, String comment, Collection configOps, long creationTime, IContributorHandle contributor, IProgressMonitor monitor) throws TeamRepositoryException {
        if (!(component instanceof ComponentHandle)) {
            throw new IllegalArgumentException();
        }
        if (comment == null) {
            throw new IllegalArgumentException();
        }
        if (configOps == null) {
            throw new IllegalArgumentException();
        }
        if (this.getResolvedWorkspace().isStream()) {
            throw new InvalidStreamOperationException(Messages.WorkspaceConnection_18);
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ContextLock lock = new ContextLock();
        lock.addExclusive((IContextHandle)this.getWorkspaceHandle(), component);
        lock.acquire((IProgressMonitor)progress.newChild(1));
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " importChangeSet begins");
        try {
            this.validate();
            IScmImportService service = this.workspaceManager.getScmImportService();
            HashSet<UUID> itemIds = new HashSet<UUID>();
            HashMap<UUID, IVersionable> toSaveMap = new HashMap<UUID, IVersionable>();
            ICommitParameter instruction = ICommitParameter.FACTORY.create();
            for (IWorkspaceConnection.IConfigurationOp element : configOps) {
                this.processConfigOp(element, itemIds, toSaveMap, instruction);
            }
            WorkspaceRefreshParameter deltaParameter = this.getDeltaParameter();
            WorkspaceImportResult serviceResult = service.importChangeSet(this.getWorkspaceHandle(), component, comment, instruction, creationTime, contributor, deltaParameter, (IRepositoryProgressMonitorHandle)this.monitorFor((IProgressMonitor)progress));
            progress.worked(90);
            IChangeSet changeSet = (IChangeSet)serviceResult.getItem();
            IUpdateReport report = serviceResult.getReport();
            serviceResult.unsetItem();
            WorkspaceConnection.applyUpdatesAfterCommit(toSaveMap, report);
            this.acquire();
            try {
                this.refresh(serviceResult.getRefreshResult(), deltaParameter, false, (IProgressMonitor)progress.newChild(5));
                this.sendEvent(report);
            }
            finally {
                this.release();
            }
            WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " importChangeSet ends");
            ImportChangeSetResult importChangeSetResult = new ImportChangeSetResult(changeSet, report);
            return importChangeSetResult;
        }
        finally {
            lock.release();
            progress.done();
        }
    }

    @Override
    public IBaselineConnection createBaseline(IComponentHandle component, String name, String comment, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.createBaseline(component, name, comment, null, monitor);
    }

    IBaselineConnection createBaseline(IComponentHandle component, String name, String comment, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (name == null) {
            name = "";
        }
        if (comment == null) {
            comment = "";
        }
        if (component == null) {
            throw new IllegalArgumentException("component must not be null");
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ContextLock lock = new ContextLock();
        lock.addExclusive((IContextHandle)this.workspaceHandle, component);
        lock.acquire((IProgressMonitor)progress.newChild(1));
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " createBaseline begins");
        try {
            IBaselineConnection iBaselineConnection;
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            IWorkspaceHandle handle = this.workspaceHandle;
            WorkspaceRefreshParameter deltaParameter = this.getDeltaParameter();
            WorkspaceItemListResult result = service.createBaseline(handle, component, name, comment, deltaParameter, WorkspaceConnection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor((IProgressMonitor)progress));
            progress.worked(90);
            this.acquire();
            try {
                this.refresh(result.getRefreshResult(), deltaParameter, false, (IProgressMonitor)progress.newChild(5));
                IBaseline baseline = (IBaseline)result.getItems().get(0);
                this.teamRepository().itemManager().applyItemUpdates(result.getItems());
                result.unsetItems();
                IBaselineConnection b = this.workspaceManager.getBaselineConnection(baseline, (IProgressMonitor)progress.newChild(4));
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " createBaseline ends");
                iBaselineConnection = b;
            }
            catch (Throwable throwable) {
                try {
                    this.release();
                    throw throwable;
                }
                catch (ItemNotFoundException e) {
                    throw this.expandItemNotFoundDetails(e);
                }
            }
            this.release();
            return iBaselineConnection;
        }
        finally {
            lock.release();
            progress.done();
        }
    }

    @Override
    public IBaselineSetHandle createBaselineSet(Collection excludedComponents, String name, String comment, int flags, IProgressMonitor monitor) throws TeamRepositoryException {
        if (excludedComponents == null) {
            excludedComponents = Collections.EMPTY_LIST;
        }
        ISynchronizationInfo syncInfo = ISynchronizationInfo.FACTORY.newInstance();
        if (this.isStream()) {
            ArrayList<UUID> excludedComUUIDs = new ArrayList<UUID>();
            for (IComponentHandle exludedComponentHandle : excludedComponents) {
                excludedComUUIDs.add(exludedComponentHandle.getItemId());
            }
            for (IComponentHandle component : this.getComponents()) {
                if (excludedComUUIDs.contains(component.getItemId())) continue;
                ICurrentComponentInfo componentInfo = this.getComponentInfo(component);
                syncInfo.addChangeHistoryTime((IWorkspaceHandle)this.workspace, component, componentInfo.changeHistoryTime());
                syncInfo.addConfigurationTime((IWorkspaceHandle)this.workspace, component, componentInfo.configurationTime());
            }
        } else {
            syncInfo = null;
        }
        return this.createBaselineSet(excludedComponents, name, comment, flags, syncInfo, monitor);
    }

    @Override
    public IBaselineSetHandle createBaselineSet(Collection excludedComponents, String name, String comment, boolean createNewBaselines, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.createBaselineSet(excludedComponents, name, comment, createNewBaselines ? 1 : 0, monitor);
    }

    IBaselineSetHandle createBaselineSet(Collection excludedComponents, String name, String comment, int flags, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ComponentHandle[] excludedComponentsArray = null;
        if (excludedComponents != null && excludedComponents.size() > 0) {
            for (Object element : excludedComponents) {
                if (element == null || !(element instanceof IComponentHandle)) {
                    throw new IllegalArgumentException();
                }
                this.checkKnownComponent((IComponentHandle)element, (IProgressMonitor)progress.newChild(0));
            }
            excludedComponentsArray = excludedComponents.toArray(new ComponentHandle[excludedComponents.size()]);
        }
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (comment == null) {
            comment = "";
        }
        ContextLock lock = new ContextLock();
        lock.addExclusive((IContextHandle)this.workspaceHandle);
        lock.acquire((IProgressMonitor)progress.newChild(1));
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " createBaselineSet begins");
        try {
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            IWorkspaceHandle handle = this.workspaceHandle;
            WorkspaceRefreshParameter deltaParameter = this.getDeltaParameter();
            WorkspaceItemListResult result = service.createBaselineSet2(handle, (IComponentHandle[])excludedComponentsArray, name, comment, flags, deltaParameter, WorkspaceConnection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor((IProgressMonitor)progress));
            progress.worked(90);
            IBaselineSet b = (IBaselineSet)result.getItems().get(0);
            this.teamRepository().itemManager().applyItemUpdates(result.getItems());
            result.unsetItems();
            this.acquire();
            try {
                this.sendPropertyChangeEvent("com.ibm.team.repository.PropertyAdd", "baseline sets", null, b);
                this.refresh(result.getRefreshResult(), deltaParameter, false, (IProgressMonitor)progress.newChild(5));
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " createBaselineSet ends");
            }
            finally {
                this.release();
            }
            IBaselineSet iBaselineSet = b;
            return iBaselineSet;
        }
        finally {
            lock.release();
            progress.done();
        }
    }

    @Override
    public IUpdateReport conflictReport() {
        UpdateReport result = ScmDtoFactory.eINSTANCE.createUpdateReport();
        result.setStateAfter(this.workspace.getTime());
        result.setStateBefore(this.workspace.getTime());
        Collection<? extends ICurrentComponentInfo> infos = this.getComponentsInfo();
        for (ClientCurrentComponentInfo clientCurrentComponentInfo : infos) {
            Map<UUID, ClientCurrentComponentInfo.ConflictInfo> conflicts = clientCurrentComponentInfo.getConflicts();
            for (ClientCurrentComponentInfo.ConflictInfo conflict : conflicts.values()) {
                ItemConflictReport icr = conflict.toItemConflictReport();
                result.getConflicts().add(icr);
            }
        }
        return result;
    }

    @Override
    public IUpdateReport conflictReport(IComponentHandle component) throws TeamRepositoryException {
        if (component == null) {
            throw new IllegalArgumentException();
        }
        this.checkKnownComponent(component, null);
        UpdateReport result = ScmDtoFactory.eINSTANCE.createUpdateReport();
        result.setStateAfter(this.workspace.getTime());
        result.setStateBefore(this.workspace.getTime());
        ClientCurrentComponentInfo info = (ClientCurrentComponentInfo)this.getComponentInfo(component);
        Map<UUID, ClientCurrentComponentInfo.ConflictInfo> conflicts = info.getConflicts();
        for (ClientCurrentComponentInfo.ConflictInfo conflict : conflicts.values()) {
            ItemConflictReport icr = conflict.toItemConflictReport();
            result.getConflicts().add(icr);
        }
        return result;
    }

    @Override
    public Visibility getVisibility() {
        if (this.isStream()) {
            throw new IllegalArgumentException();
        }
        UUID customContext = this.workspace.getCustomContext();
        if (customContext == null) {
            return Visibility.PUBLIC;
        }
        if (customContext.equals((Object)SCMClientUtil.CUSTOM_PRIVATE)) {
            return Visibility.PRIVATE;
        }
        return new Visibility(VisibilityEnum.PROTECTED, (IProjectAreaHandle)IProjectArea.ITEM_TYPE.createItemHandle(customContext, null));
    }

    @Override
    public void setVisibility(Visibility visibility, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.isStream()) {
            throw new IllegalArgumentException();
        }
        this.setOwnerAndVisibility(IScmService.NOOP_OWNER, visibility.getReadScope(), monitor);
    }

    @Override
    public List<IComponentLockReport> runDeliverWithPrecondition(IWorkspaceOperationRunner.IWorkspaceOperationRunnable preConditionCheck, IWorkspaceConnection remoteWorkspaceConnection, IChangeHistorySyncReport syncReport, List<IBaselineHandle> baselines, List<IChangeSetHandle> outgoingChangeSets, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.deliver(remoteWorkspaceConnection, syncReport, baselines, outgoingChangeSets, null, preConditionCheck, monitor);
    }

    @Override
    public IWorkspaceConfiguration configuration() {
        return this.workspaceConfiguration;
    }

    @Override
    public ILockSearchResult getLocks(IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor);
        try {
            this.validate();
            if (this.isStream()) {
                ILockSearchResult iLockSearchResult = this.workspaceManager().findLocks(this.criteria, 512, (IProgressMonitor)mon.newChild(99));
                return iLockSearchResult;
            }
            ILockSearchResult iLockSearchResult = NO_LOCKS;
            return iLockSearchResult;
        }
        finally {
            mon.done();
        }
    }

    @Override
    public IUpdateReport harmonizeHistory(IWorkspaceConnection remoteConnection, IComponentHandle componentHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor);
        try {
            this.validate();
            if (remoteConnection == null) {
                throw new IllegalArgumentException();
            }
            if (componentHandle == null) {
                throw new IllegalArgumentException();
            }
            WorkspaceConnection conn = (WorkspaceConnection)remoteConnection;
            conn.validate();
            IWorkspaceHandle remoteWorkspace = conn.getWorkspaceHandle();
            IWorkspaceHandle ws = this.getWorkspaceHandle();
            WorkspaceRefreshParameter delta = this.getDeltaParameter();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            WorkspaceUpdateReportResult result = null;
            RemoteRepoDescriptor remoteDescriptor = null;
            InvalidAuthenticationTokenException authEx = null;
            while (true) {
                RemoteRepoDescriptor newDescriptor = this.extractRemoteDescriptor(conn, mon.newChild(5));
                if (remoteDescriptor != null && newDescriptor.getAuthToken().getTruth().equals(remoteDescriptor.getAuthToken().getTruth())) {
                    throw authEx;
                }
                remoteDescriptor = newDescriptor;
                try {
                    result = service.harmonizeWorkspaceHistory(ws, remoteWorkspace, remoteDescriptor, componentHandle, delta, (IRepositoryProgressMonitorHandle)this.monitorFor((IProgressMonitor)mon));
                }
                catch (InvalidAuthenticationTokenException e) {
                    if (remoteDescriptor == null) {
                        throw e;
                    }
                    this.resetRemoteDescriptor(conn);
                    authEx = e;
                    mon.setWorkRemaining(90);
                    continue;
                }
                break;
            }
            IUpdateReport updateReport = result.getReport();
            mon.worked(75);
            this.acquire();
            try {
                this.refresh(result.getRefreshResult(), delta, false, (IProgressMonitor)mon.newChild(5));
                this.sendEvent(updateReport);
                this.sendEvent("com.ibm.team.scm.HistoryRestructure", Collections.EMPTY_LIST, componentHandle);
            }
            finally {
                this.release();
            }
            WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " harmonizeHistory() ends");
            IUpdateReport iUpdateReport = updateReport;
            return iUpdateReport;
        }
        finally {
            mon.done();
        }
    }

    @Override
    public void setOwnerAndVisibility(IAuditableHandle newOwner, IReadScope newScope, IProgressMonitor mon) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)mon, (int)100);
        ContextLock lock = new ContextLock();
        lock.addExclusive((IContextHandle)this.workspaceHandle);
        lock.acquire((IProgressMonitor)progress.newChild(1));
        try {
            try {
                WorkspaceConnection.log("Workspace " + this.workspace.getItemId().getUuidValue() + " setOwnerAndVisibility() begins");
                this.validate();
                IScmService scm = this.workspaceManager.getServerConfigurationService();
                Workspace workspace = (Workspace)scm.setWorkspaceOwnerAndVisibility(this.getWorkspaceHandle(), newOwner, newScope, null, (IRepositoryProgressMonitorHandle)this.monitorFor((IProgressMonitor)progress));
                this.refreshWorkspace(workspace);
                WorkspaceConnection.log("Workspace " + workspace.getItemId().getUuidValue() + " setOwnerAndVisibility() ends");
            }
            catch (ItemNotFoundException e) {
                throw this.expandItemNotFoundDetails(e);
            }
        }
        finally {
            lock.release();
            progress.done();
        }
    }

    @Override
    public IReadScope getReadScope() {
        return this.workspace.getReadScope();
    }

    @Override
    public void setVersionablePermissions(IVersionableHandle[] versionables, IComponentHandle componentHandle, IPermissionContextProvider contextProvider, IProgressMonitor monitor) throws TeamRepositoryException {
        this.configuration(componentHandle).setVersionablePermissions(versionables, contextProvider, monitor);
        this.queueEvent((Object)new ItemPermissionChangeEvent(this, "item_permission_change_event", versionables, contextProvider.getReadContext()));
    }

    @Override
    public long getAcceptQueueSize(IComponentHandle component) throws ComponentNotInWorkspaceException {
        if (component == null) {
            throw new IllegalArgumentException();
        }
        this.checkKnownComponent(component, null);
        ClientCurrentComponentInfo info = (ClientCurrentComponentInfo)this.getComponentInfo(component);
        return info.numPendingPorts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICurrentPatch getCurrentPatch(IComponentHandle component) {
        Object object = this.lock;
        synchronized (object) {
            return this.currentPorts.get(component.getItemId());
        }
    }

    @Override
    public IUpdateReport abortCurrentPatch(IComponentHandle[] components, int flags, IProgressMonitor monitor) throws TeamRepositoryException {
        if (components == null) {
            throw new IllegalArgumentException();
        }
        ISynchronizationInfo syncInfo = null;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ContextLock lock = new ContextLock();
        IComponentHandle[] iComponentHandleArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            IComponentHandle component = iComponentHandleArray[n2];
            lock.addExclusive((IContextHandle)this.workspaceHandle, component);
            ++n2;
        }
        lock.acquire((IProgressMonitor)progress.newChild(1));
        ArrayList<IChangeSetHandle> changeSets = new ArrayList<IChangeSetHandle>();
        IComponentHandle[] iComponentHandleArray2 = components;
        int n3 = components.length;
        n = 0;
        while (n < n3) {
            IComponentHandle component = iComponentHandleArray2[n];
            ICurrentPatch currentPort = this.getCurrentPatch(component);
            if (currentPort != null && currentPort.getTargetChangeSet() != null) {
                changeSets.add(currentPort.getTargetChangeSet());
            }
            ++n;
        }
        progress.setWorkRemaining(95);
        try {
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            WorkspaceRefreshParameter deltaParameter = this.getDeltaParameter();
            WorkspaceUpdateReportResult result = service.abortCurrentPatches(this.getWorkspaceHandle(), components, flags, deltaParameter, WorkspaceConnection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor((IProgressMonitor)progress));
            IUpdateReport report = result.getReport();
            progress.worked(85);
            this.acquire();
            try {
                this.refresh(result.getRefreshResult(), deltaParameter, false, (IProgressMonitor)progress.newChild(5));
                if (!changeSets.isEmpty()) {
                    this.sendEvent("com.ibm.team.scm.ChangeHistoryEvent.DiscardChangeSet", changeSets);
                }
                this.sendEvent(report);
            }
            finally {
                this.release();
            }
            IUpdateReport iUpdateReport = report;
            return iUpdateReport;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails(e);
        }
        finally {
            lock.release();
            progress.done();
        }
    }

    @Override
    public void completeCurrentPatch(IComponentHandle componentHandle, int flags, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ContextLock lock = new ContextLock();
        lock.addExclusive((IContextHandle)this.workspaceHandle, componentHandle);
        lock.acquire((IProgressMonitor)progress.newChild(1));
        IChangeSetHandle toClose = null;
        ICurrentPatch currentPort = this.getCurrentPatch(componentHandle);
        if (currentPort != null) {
            toClose = currentPort.getTargetChangeSet();
        }
        try {
            try {
                this.validate();
                IScmService service = this.workspaceManager.getServerConfigurationService();
                WorkspaceRefreshParameter deltaParameter = this.getDeltaParameter();
                WorkspaceItemListResult result = service.completeCurrentPatch((IWorkspaceHandle)this.workspace, componentHandle, flags, deltaParameter, WorkspaceConnection.getSyncTimes(null), (IRepositoryProgressMonitorHandle)this.monitorFor((IProgressMonitor)progress));
                progress.worked(85);
                this.acquire();
                try {
                    if (toClose != null) {
                        this.sendEvent("com.ibm.team.scm.ChangeHistoryEvent.CloseChangeSets", Collections.singletonList(toClose));
                    }
                    WorkspaceRefreshResult refreshResult = result.getRefreshResult();
                    this.refresh(refreshResult, deltaParameter, false, (IProgressMonitor)progress.newChild(5));
                    this.teamRepository().itemManager().applyItemUpdates(result.getItems());
                    result.unsetItems();
                }
                finally {
                    this.release();
                }
            }
            catch (ItemNotFoundException e) {
                throw this.expandItemNotFoundDetails(e);
            }
        }
        finally {
            lock.release();
            progress.done();
        }
    }

    @Override
    public IUpdateReport processAcceptQueue(IComponentHandle component, int flags, IProgressMonitor monitor) throws TeamRepositoryException {
        if (component == null) {
            throw new IllegalArgumentException();
        }
        ISynchronizationInfo syncInfo = null;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ContextLock lock = new ContextLock();
        lock.addExclusive((IContextHandle)this.workspaceHandle, component);
        lock.acquire((IProgressMonitor)progress.newChild(1));
        progress.setWorkRemaining(95);
        try {
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            WorkspaceRefreshParameter deltaParameter = this.getDeltaParameter();
            WorkspaceUpdateReportResult result = service.processAcceptQueue((IWorkspaceHandle)this.workspace, component, flags, deltaParameter, WorkspaceConnection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor((IProgressMonitor)progress));
            IUpdateReport report = result.getReport();
            progress.worked(85);
            this.acquire();
            try {
                this.refresh(result.getRefreshResult(), deltaParameter, false, (IProgressMonitor)progress.newChild(5));
                this.sendEvent(report);
            }
            finally {
                this.release();
            }
            IUpdateReport iUpdateReport = report;
            return iUpdateReport;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails(e);
        }
        finally {
            lock.release();
            progress.done();
        }
    }

    @Override
    public IWorkspaceConnection.ICurrentPatchOperationFactory getCurrentPatchOperationFactory() {
        return this.currentPortOpFactory;
    }

    @Override
    public IUpdateReport applyCurrentPatchOperations(IComponentHandle component, List<IWorkspaceConnection.ICurrentPatchOperation> operations, IProgressMonitor monitor) throws TeamRepositoryException {
        if (operations == null) {
            throw new IllegalArgumentException();
        }
        ICurrentPatch currentPort = this.getCurrentPatch(component);
        if (currentPort == null) {
            throw new IllegalArgumentException();
        }
        this.validateCurrentPortOps(currentPort, operations);
        ArrayList<ICurrentPatchOperationDescriptor> descriptors = new ArrayList<ICurrentPatchOperationDescriptor>(operations.size());
        for (CurrentPortOp currentPortOp : operations) {
            descriptors.add(currentPortOp.asCurrentPortOpDescriptor());
        }
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ContextLock contextLock = new ContextLock();
        contextLock.acquire((IProgressMonitor)sm.newChild(1));
        try {
            WorkspaceConnection.log("Workspace " + this.workspace.getItemId().getUuidValue() + " applyCurrentPortOperation() begins");
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            IWorkspaceHandle handle = this.workspaceHandle;
            ISynchronizationInfo syncInfo = null;
            WorkspaceRefreshParameter deltaParameter = this.getDeltaParameter();
            WorkspaceUpdateReportResult result = service.applyCurrentPatchOperations(handle, component, descriptors.toArray(new ICurrentPatchOperationDescriptor[descriptors.size()]), deltaParameter, WorkspaceConnection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor((IProgressMonitor)sm));
            sm.worked(85);
            WorkspaceConnection.log("Workspace " + this.workspace.getItemId().getUuidValue() + " applyCurrentPortOperation() ends");
            IUpdateReport updateReport = result.getReport();
            this.acquire();
            try {
                this.refresh(result.getRefreshResult(), deltaParameter, false, (IProgressMonitor)sm.newChild(5));
                this.sendEvent(updateReport);
                if (currentPort.getTargetChangeSet() != null) {
                    this.sendCommitEvent(currentPort.getTargetChangeSet());
                }
            }
            finally {
                this.release();
            }
            IUpdateReport iUpdateReport = updateReport;
            return iUpdateReport;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails(e);
        }
        finally {
            contextLock.release();
            sm.done();
        }
    }

    private void validateCurrentPortOps(ICurrentPatch port, List<IWorkspaceConnection.ICurrentPatchOperation> operations) {
        HashSet<UUID> versionableWideOps = new HashSet<UUID>();
        HashMap changeDetailOps = new HashMap();
        for (IWorkspaceConnection.ICurrentPatchOperation op : operations) {
            if (op.getVersionable() == null) {
                if (op.getChangeDetailId() == null) {
                    throw new IllegalArgumentException();
                }
                IVersionableHandle versionable = this.getVersionable(port, op.getChangeDetailId());
                if (versionable == null) {
                    throw new IllegalArgumentException();
                }
                if (versionableWideOps.contains(versionable)) {
                    throw new IllegalArgumentException("There cannot be ops at the detail level and versionable level for the same versionable");
                }
                HashSet<UUID> set = (HashSet<UUID>)changeDetailOps.get(versionable.getItemId());
                if (set == null) {
                    set = new HashSet<UUID>();
                    changeDetailOps.put(versionable.getItemId(), set);
                } else if (set.contains(op.getChangeDetailId())) {
                    throw new IllegalArgumentException("There cannot be multiple ops that affect teh same change detail");
                }
                set.add(op.getChangeDetailId());
                continue;
            }
            if (op.getChangeDetailId() == null) {
                if (changeDetailOps.containsKey(op.getVersionable().getItemId())) {
                    throw new IllegalArgumentException("There cannot be ops at the detail level and versionable level for the same versionable");
                }
                versionableWideOps.add(op.getVersionable().getItemId());
                continue;
            }
            if (versionableWideOps.contains(op.getVersionable().getItemId())) {
                throw new IllegalArgumentException("There cannot be ops at the detail level and versionable level for the same versionable");
            }
            HashSet<UUID> set = (HashSet<UUID>)changeDetailOps.get(op.getVersionable().getItemId());
            if (set == null) {
                set = new HashSet<UUID>();
                changeDetailOps.put(op.getVersionable().getItemId(), set);
            } else if (set.contains(op.getChangeDetailId())) {
                throw new IllegalArgumentException("There cannot be multiple ops that affect teh same change detail");
            }
            set.add(op.getChangeDetailId());
        }
    }

    private IVersionableHandle getVersionable(ICurrentPatch port, UUID changeDetailId) {
        for (IVersionableChange vc : port.getVersionableChanges()) {
            for (IChangeDetail cd : vc.getChanges()) {
                if (!cd.getId().equals((Object)changeDetailId)) continue;
                return vc.getVersionable();
            }
        }
        return null;
    }

    @Override
    public void reorderAcceptQueueEntries(IComponentHandle component, UUID[] pendingPorts, UUID afterPendingPort, IProgressMonitor monitor) throws TeamRepositoryException {
        if (component == null) {
            throw new IllegalArgumentException();
        }
        if (pendingPorts == null) {
            throw new IllegalArgumentException();
        }
        UUID[] uUIDArray = pendingPorts;
        int n = pendingPorts.length;
        int n2 = 0;
        while (n2 < n) {
            UUID uuid = uUIDArray[n2];
            if (uuid == null) {
                throw new IllegalArgumentException();
            }
            ++n2;
        }
        ISynchronizationInfo syncInfo = null;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ContextLock lock = new ContextLock();
        lock.addExclusive((IContextHandle)this.workspaceHandle, component);
        lock.acquire((IProgressMonitor)progress.newChild(1));
        progress.setWorkRemaining(95);
        try {
            try {
                this.validate();
                IScmService service = this.workspaceManager.getServerConfigurationService();
                WorkspaceRefreshParameter deltaParameter = this.getDeltaParameter();
                WorkspaceOperationResult result = service.reorderAcceptQueueEntries((IWorkspaceHandle)this.workspace, component, pendingPorts, afterPendingPort, deltaParameter, WorkspaceConnection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor(monitor));
                progress.worked(85);
                this.acquire();
                try {
                    this.refresh(result.getRefreshResult(), deltaParameter, false, (IProgressMonitor)progress.newChild(5));
                }
                finally {
                    this.release();
                }
            }
            catch (ItemNotFoundException e) {
                throw this.expandItemNotFoundDetails(e);
            }
        }
        finally {
            lock.release();
            progress.done();
        }
    }

    @Override
    public void removeAcceptQueueEntries(IComponentHandle component, UUID[] pendingPorts, IProgressMonitor monitor) throws TeamRepositoryException {
        if (component == null) {
            throw new IllegalArgumentException();
        }
        if (pendingPorts == null) {
            throw new IllegalArgumentException();
        }
        UUID[] uUIDArray = pendingPorts;
        int n = pendingPorts.length;
        int n2 = 0;
        while (n2 < n) {
            UUID uuid = uUIDArray[n2];
            if (uuid == null) {
                throw new IllegalArgumentException();
            }
            ++n2;
        }
        ISynchronizationInfo syncInfo = null;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ContextLock lock = new ContextLock();
        lock.addExclusive((IContextHandle)this.workspaceHandle, component);
        lock.acquire((IProgressMonitor)progress.newChild(1));
        progress.setWorkRemaining(95);
        try {
            try {
                this.validate();
                IScmService service = this.workspaceManager.getServerConfigurationService();
                WorkspaceRefreshParameter deltaParameter = this.getDeltaParameter();
                WorkspaceOperationResult result = service.removeAcceptQueueEntries((IWorkspaceHandle)this.workspace, component, pendingPorts, deltaParameter, WorkspaceConnection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor(monitor));
                progress.worked(85);
                this.acquire();
                try {
                    this.refresh(result.getRefreshResult(), deltaParameter, false, (IProgressMonitor)progress.newChild(5));
                }
                finally {
                    this.release();
                }
            }
            catch (ItemNotFoundException e) {
                throw this.expandItemNotFoundDetails(e);
            }
        }
        finally {
            lock.release();
            progress.done();
        }
    }

    @Override
    public IChangeSetSourcesPage fetchFromAcceptQueue(IComponentHandle component, long startIndex, int maxPageSize, IProgressMonitor monitor) throws TeamRepositoryException {
        IPageDescriptor pageDescriptor = IPageDescriptor.FACTORY.initialize(this.getWorkspaceHandle(), component, startIndex, maxPageSize);
        IScmService service = this.workspaceManager.getServerConfigurationService();
        return service.fetchAcceptQueue(pageDescriptor, (IRepositoryProgressMonitorHandle)this.monitorFor(monitor));
    }

    @Override
    public IChangeSetSourcesPage fetchFromAcceptQueue(IPageDescriptor pageDescriptor, IProgressMonitor monitor) throws TeamRepositoryException {
        IScmService service = this.workspaceManager.getServerConfigurationService();
        return service.fetchAcceptQueue(pageDescriptor, (IRepositoryProgressMonitorHandle)this.monitorFor(monitor));
    }

    @Override
    public LineDelimiterHandlingEnum getLineDelimiterHandling(IComponentHandle component, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.lineDelimiterCache.contains(component)) {
            return this.lineDelimiterCache.getLineDelimiterHandling(component);
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IScmService service = this.workspaceManager().getServerConfigurationService();
        SCMClientUtil.checkMonitor((IProgressMonitor)progress);
        LineDelimiterHandling delimiterHandling = service.getLineDelimiterHandling(component, this.monitorFor((IProgressMonitor)progress));
        LineDelimiterHandlingEnum componentLineDelimiterHandling = delimiterHandling.getDirective();
        this.lineDelimiterCache.add(component, componentLineDelimiterHandling);
        return componentLineDelimiterHandling;
    }

    static class ConfigurationOpFactory
    implements IWorkspaceConnection.IConfigurationOpFactory {
        ConfigurationOpFactory() {
        }

        @Override
        public IWorkspaceConnection.ISaveOp save(IVersionable item) {
            if (item == null) {
                throw new IllegalArgumentException();
            }
            if (!item.isWorkingCopy()) {
                throw new IllegalArgumentException();
            }
            return new SaveOp(item, null, null);
        }

        @Override
        public IWorkspaceConnection.IDeleteOp delete(IVersionableHandle itemHandle) {
            if (itemHandle == null) {
                throw new IllegalArgumentException();
            }
            return new DeleteOp(itemHandle);
        }

        @Override
        public IWorkspaceConnection.IRevertOp revert(IVersionableHandle itemStateHandle) {
            if (itemStateHandle == null || !itemStateHandle.hasStateId()) {
                throw new IllegalArgumentException();
            }
            return new RevertOp(itemStateHandle);
        }

        @Override
        public IWorkspaceConnection.IDeleteSubtreeOp deleteSubtree(IFolderHandle folderHandle) {
            if (folderHandle == null) {
                throw new IllegalArgumentException();
            }
            return new DeleteSubtreeOp(folderHandle);
        }

        @Override
        public IWorkspaceConnection.IUndoOp undo(IVersionableHandle itemHandle) {
            if (itemHandle == null) {
                throw new IllegalArgumentException();
            }
            return new UndoOp(itemHandle);
        }

        @Override
        public IWorkspaceConnection.IMarkAsMergedOp markAsMerged(IVersionableHandle item, IVersionableHandle predecessor, IVersionableHandle mergePredecessor) {
            if (item == null) {
                throw new IllegalArgumentException();
            }
            return new MarkAsMergedOp(item, predecessor, mergePredecessor);
        }

        @Override
        public IWorkspaceConnection.IMergeOp merge(IWorkspaceConnection.IMergeResultOp nestedOp, IVersionableHandle predecessor, IVersionableHandle mergePredecessor) {
            if (nestedOp == null) {
                throw new IllegalArgumentException();
            }
            return new MergeOp(nestedOp, predecessor, mergePredecessor);
        }
    }

    private static abstract class CurrentPortOp
    implements IWorkspaceConnection.ICurrentPatchOperation {
        private IVersionableHandle versionable;
        private UUID changeDetailId;

        public CurrentPortOp(IVersionableHandle versionable, UUID changeDetailId) {
            if (versionable == null) {
                throw new InvalidParameterException();
            }
            this.versionable = versionable;
            this.changeDetailId = changeDetailId;
        }

        @Override
        public IVersionableHandle getVersionable() {
            return this.versionable;
        }

        @Override
        public UUID getChangeDetailId() {
            return this.changeDetailId;
        }

        public abstract ICurrentPatchOperationDescriptor asCurrentPortOpDescriptor();
    }

    private static class CurrentPortOpFactory
    implements IWorkspaceConnection.ICurrentPatchOperationFactory {
        private CurrentPortOpFactory() {
        }

        @Override
        public IWorkspaceConnection.ICurrentPatchOperation createMarkAsResolvedOp(IVersionableHandle versionable, boolean force) {
            return new PortMarkAsResolvedOp(versionable, null, force);
        }

        @Override
        public IWorkspaceConnection.ICurrentPatchOperation createMarkAsResolvedOp(IVersionableHandle versionable, UUID changeDetailId, boolean force) {
            return new PortMarkAsResolvedOp(versionable, changeDetailId, force);
        }

        @Override
        public IWorkspaceConnection.ICurrentPatchOperation createResolveWithProposedOp(IVersionableHandle versionable, boolean force) {
            return new PortResolveWithProposedOp(versionable, null, force);
        }

        @Override
        public IWorkspaceConnection.ICurrentPatchOperation createResolveWithProposedOp(IVersionableHandle versionable, UUID changeDetailId, boolean force) {
            return new PortResolveWithProposedOp(versionable, changeDetailId, force);
        }

        @Override
        public IWorkspaceConnection.ICurrentPatchOperation createAttemptAutoResolveOp(IVersionableHandle versionable, boolean bestEffort) {
            return new PortAutoResolveOp(versionable, null, bestEffort);
        }

        @Override
        public IWorkspaceConnection.ICurrentPatchOperation createAttemptAutoResolveOp(IVersionableHandle versionable, UUID changeDetailId, boolean bestEffort) {
            return new PortAutoResolveOp(versionable, changeDetailId, bestEffort);
        }

        @Override
        public IWorkspaceConnection.ICurrentPatchOperation createUndoChangeOp(IVersionableHandle versionable, boolean force) {
            return new PortUndoOp(versionable, null, force);
        }

        @Override
        public IWorkspaceConnection.ICurrentPatchOperation createUndoChangeOp(IVersionableHandle versionable, UUID changeDetailId, boolean force) {
            return new PortUndoOp(versionable, changeDetailId, force);
        }

        @Override
        public IWorkspaceConnection.ICurrentPatchOperation createMarkAsUnresolvedOp(IVersionableHandle versionable, UUID changeDetailId) {
            return new PortMarkAsUnresolvedOp(versionable, changeDetailId);
        }

        @Override
        public IWorkspaceConnection.ICurrentPatchOperation createMarkAsUnresolvedOp(IVersionableHandle versionable) {
            return new PortMarkAsUnresolvedOp(versionable, null);
        }

        @Override
        public IWorkspaceConnection.ICurrentPatchOperation createReparentVersionableOp(IVersionableHandle versionable, IFolderHandle newParent) {
            return new ReparentVersionableOp(versionable, newParent);
        }
    }

    private static class DeleteOp
    implements IWorkspaceConnection.IDeleteOp {
        final IVersionableHandle itemHandle;

        DeleteOp(IVersionableHandle itemHandle) {
            this.itemHandle = itemHandle;
        }

        @Override
        public IVersionableHandle getItemHandle() {
            return this.itemHandle;
        }
    }

    private static class DeleteSubtreeOp
    implements IWorkspaceConnection.IDeleteSubtreeOp {
        final IFolderHandle folderHandle;

        DeleteSubtreeOp(IFolderHandle folderHandle) {
            this.folderHandle = folderHandle;
        }

        @Override
        public IFolderHandle getFolderHandle() {
            return this.folderHandle;
        }
    }

    private static class MarkAsMergedOp
    implements IWorkspaceConnection.IMarkAsMergedOp {
        final IVersionableHandle pred;
        final IVersionableHandle mergePred;
        final IVersionableHandle item;

        public MarkAsMergedOp(IVersionableHandle item, IVersionableHandle predecessor, IVersionableHandle mergePredecessor) {
            this.item = item;
            this.pred = predecessor;
            this.mergePred = mergePredecessor;
        }

        @Override
        public IVersionableHandle getItemHandle() {
            return this.item;
        }

        @Override
        public IVersionableHandle getProposedState() {
            return this.mergePred;
        }

        @Override
        public IVersionableHandle getSelectedState() {
            return this.pred;
        }
    }

    private static class MergeOp
    implements IWorkspaceConnection.IMergeOp {
        final IVersionableHandle pred;
        final IVersionableHandle mergePred;
        final IWorkspaceConnection.IMergeResultOp nestedOp;

        public MergeOp(IWorkspaceConnection.IMergeResultOp nestedOp, IVersionableHandle predecessor, IVersionableHandle mergePredecessor) {
            this.nestedOp = nestedOp;
            this.pred = predecessor;
            this.mergePred = mergePredecessor;
        }

        @Override
        public IWorkspaceConnection.IMergeResultOp getInnerOp() {
            return this.nestedOp;
        }

        @Override
        public IVersionableHandle getProposedState() {
            return this.mergePred;
        }

        @Override
        public IVersionableHandle getSelectedState() {
            return this.pred;
        }
    }

    private static class PortAutoResolveOp
    extends CurrentPortOp
    implements IWorkspaceConnection.IAutoResolveOp {
        private final boolean bestEffort;

        public PortAutoResolveOp(IVersionableHandle versionable, UUID changeDetailId, boolean bestEffort) {
            super(versionable, changeDetailId);
            this.bestEffort = bestEffort;
        }

        @Override
        public ICurrentPatchOperationDescriptor asCurrentPortOpDescriptor() {
            return ICurrentPatchOperationDescriptor.FACTORY.autoResolve(this.getVersionable().getItemId(), this.getChangeDetailId(), this.bestEffort);
        }

        @Override
        public boolean isBestEffort() {
            return this.bestEffort;
        }
    }

    private static class PortMarkAsResolvedOp
    extends CurrentPortOp
    implements IWorkspaceConnection.IMarkAsResolvedOp {
        private boolean force;

        public PortMarkAsResolvedOp(IVersionableHandle versionable, UUID changeDetailId, boolean force) {
            super(versionable, changeDetailId);
            this.force = force;
        }

        @Override
        public ICurrentPatchOperationDescriptor asCurrentPortOpDescriptor() {
            return ICurrentPatchOperationDescriptor.FACTORY.markAsResolved(this.getVersionable().getItemId(), this.getChangeDetailId(), this.force);
        }
    }

    private static class PortMarkAsUnresolvedOp
    extends CurrentPortOp {
        public PortMarkAsUnresolvedOp(IVersionableHandle versionable, UUID changeDetailId) {
            super(versionable, changeDetailId);
        }

        @Override
        public ICurrentPatchOperationDescriptor asCurrentPortOpDescriptor() {
            return ICurrentPatchOperationDescriptor.FACTORY.markAsUnresolved(this.getVersionable().getItemId(), this.getChangeDetailId());
        }
    }

    private static class PortResolveWithProposedOp
    extends CurrentPortOp
    implements IWorkspaceConnection.IResolveWithProposedOp {
        private boolean force;

        public PortResolveWithProposedOp(IVersionableHandle versionable, UUID changeDetailId, boolean force) {
            super(versionable, changeDetailId);
            this.force = force;
        }

        @Override
        public ICurrentPatchOperationDescriptor asCurrentPortOpDescriptor() {
            return ICurrentPatchOperationDescriptor.FACTORY.resolveWithProposed(this.getVersionable().getItemId(), this.getChangeDetailId(), this.force);
        }
    }

    private static class PortUndoOp
    extends CurrentPortOp {
        private boolean force;

        public PortUndoOp(IVersionableHandle versionable, UUID changeDetailId, boolean force) {
            super(versionable, changeDetailId);
            this.force = force;
        }

        @Override
        public ICurrentPatchOperationDescriptor asCurrentPortOpDescriptor() {
            return ICurrentPatchOperationDescriptor.FACTORY.undo(this.getVersionable().getItemId(), this.getChangeDetailId(), this.force);
        }
    }

    private static class ReparentVersionableOp
    extends CurrentPortOp
    implements IWorkspaceConnection.IReparentVersionableOp {
        private IFolderHandle newParent;

        public ReparentVersionableOp(IVersionableHandle versionable, IFolderHandle newParent) {
            super(versionable, null);
            this.newParent = newParent;
        }

        @Override
        public ICurrentPatchOperationDescriptor asCurrentPortOpDescriptor() {
            return ICurrentPatchOperationDescriptor.FACTORY.setParent(this.getVersionable().getItemId(), this.newParent);
        }

        @Override
        public IFolderHandle getNewParent() {
            return this.newParent;
        }
    }

    private static class RevertOp
    implements IWorkspaceConnection.IRevertOp {
        final IVersionableHandle itemStateHandle;

        RevertOp(IVersionableHandle itemStateHandle) {
            this.itemStateHandle = itemStateHandle;
        }

        @Override
        public IVersionableHandle getItemHandle() {
            return this.itemStateHandle;
        }
    }

    private static class SaveOp
    implements IWorkspaceConnection.ISaveOp {
        final IVersionable item;
        final IVersionableHandle pred;
        final IVersionableHandle mergePred;

        SaveOp(IVersionable item, IVersionableHandle predecessor, IVersionableHandle mergePredecessor) {
            this.item = item;
            this.pred = predecessor;
            this.mergePred = mergePredecessor;
        }

        @Override
        public IVersionable getItem() {
            return this.item;
        }

        public IVersionableHandle getMergePredecessor() {
            return this.mergePred;
        }

        public IVersionableHandle getPredecessor() {
            return this.pred;
        }

        @Override
        public IVersionableHandle getItemHandle() {
            return this.item;
        }
    }

    private static class UndoOp
    implements IWorkspaceConnection.IUndoOp {
        final IVersionableHandle itemHandle;

        UndoOp(IVersionableHandle itemHandle) {
            this.itemHandle = itemHandle;
        }

        @Override
        public IVersionableHandle getItemHandle() {
            return this.itemHandle;
        }
    }

    public class WorkspaceConfigurationProxy
    implements IWorkspaceConfiguration {
        @Override
        public List<IComponentizedAncestorList> fetchAncestorsByName(String exactVersionableName, IProgressMonitor monitor) throws TeamRepositoryException {
            monitor = SCMClientUtil.getMonitor(monitor, 100);
            try {
                if (exactVersionableName == null || exactVersionableName.equals("")) {
                    throw new IllegalArgumentException();
                }
                WorkspaceConnection.this.validate();
                IScmService service = WorkspaceConnection.this.workspaceManager().getServerConfigurationService();
                SCMClientUtil.checkMonitor(monitor);
                IComponentizedAncestorList[] reports = service.workspaceFindVersionablesByName(WorkspaceConnection.this.workspaceHandle, exactVersionableName, Connection.getSyncTimes(null), (IRepositoryProgressMonitorHandle)WorkspaceConnection.this.monitorFor(monitor));
                List<IComponentizedAncestorList> list = Arrays.asList(reports);
                return list;
            }
            finally {
                monitor.done();
            }
        }

        @Override
        public Map<UUID, Map<UUID, ? extends IVersionable>> fetchCompleteItems(List<? extends IComponentHandle> components, List<List<? extends IVersionableHandle>> versionableItemsByComponent, IProgressMonitor monitor) throws TeamRepositoryException {
            monitor = SCMClientUtil.getMonitor(monitor, 100);
            try {
                if (components == null) {
                    throw new IllegalArgumentException();
                }
                HashSet<UUID> componentIds = new HashSet<UUID>();
                HashMap<UUID, ServiceConfigurationProvider> configProviders = new HashMap<UUID, ServiceConfigurationProvider>((int)((double)components.size() / 0.75));
                for (IComponentHandle iComponentHandle : components) {
                    if (iComponentHandle == null) {
                        throw new IllegalArgumentException();
                    }
                    if (!componentIds.add(iComponentHandle.getItemId())) {
                        throw new IllegalArgumentException();
                    }
                    WorkspaceConnection.this.checkKnownComponent(iComponentHandle, monitor);
                    configProviders.put(iComponentHandle.getItemId(), ServiceConfigurationProvider.FACTORY.create(WorkspaceConnection.this.workspaceHandle, iComponentHandle));
                }
                if (versionableItemsByComponent == null) {
                    throw new IllegalArgumentException();
                }
                if (versionableItemsByComponent.size() != components.size()) {
                    throw new IllegalArgumentException();
                }
                boolean bl = false;
                int i = 0;
                ArrayList batches = new ArrayList();
                HashMap<UUID, ComponentizedFetchParameter> current = new HashMap<UUID, ComponentizedFetchParameter>();
                for (List<? extends IVersionableHandle> items : versionableItemsByComponent) {
                    ComponentizedFetchParameter param = ScmDtoFactory.eINSTANCE.createComponentizedFetchParameter();
                    IComponentHandle ch = components.get(i++);
                    current.put(ch.getItemId(), param);
                    if (items == null) {
                        throw new IllegalArgumentException();
                    }
                    for (IVersionableHandle iVersionableHandle : items) {
                        int n;
                        if (iVersionableHandle == null) {
                            throw new IllegalArgumentException();
                        }
                        if (n < 2048) {
                            param.getHandles().add(iVersionableHandle);
                            n += 1;
                            continue;
                        }
                        batches.add(current);
                        current = new HashMap();
                        param = ScmDtoFactory.eINSTANCE.createComponentizedFetchParameter();
                        n = 1;
                        current.put(ch.getItemId(), param);
                        param.getHandles().add(iVersionableHandle);
                    }
                }
                batches.add(current);
                SCMClientUtil.checkMonitor(monitor);
                WorkspaceConnection.this.validate();
                IScmService service = WorkspaceConnection.this.workspaceManager().getServerConfigurationService();
                monitor.worked(20);
                HashMap<UUID, Map<UUID, ? extends IVersionable>> result = new HashMap<UUID, Map<UUID, ? extends IVersionable>>();
                for (UUID compId : componentIds) {
                    result.put(compId, new HashMap());
                }
                VersionableManager vman = (VersionableManager)WorkspaceConnection.this.workspaceManager().versionableManager();
                int ticks = 75 / batches.size();
                for (Map map : batches) {
                    int size = map.size();
                    ServiceConfigurationProvider[] cfgs = new ServiceConfigurationProvider[size];
                    ComponentizedFetchParameter[] parm = new ComponentizedFetchParameter[size];
                    UUID[] compId = new UUID[size];
                    int j = 0;
                    for (Map.Entry e : map.entrySet()) {
                        UUID componentId = (UUID)e.getKey();
                        cfgs[j] = (ServiceConfigurationProvider)configProviders.get(componentId);
                        compId[j] = componentId;
                        parm[j++] = (ComponentizedFetchParameter)e.getValue();
                    }
                    ComponentizedFetchResult[] fromServer = service.configurationBatchFetch(cfgs, parm, null, null, (IRepositoryProgressMonitorHandle)WorkspaceConnection.this.monitorFor(monitor));
                    SCMClientUtil.checkMonitor(monitor);
                    monitor.worked(ticks);
                    j = 0;
                    while (j < size) {
                        UUID componentId = compId[j];
                        Map perComponent = (Map)result.get(componentId);
                        ComponentizedFetchResult r = fromServer[j];
                        i = 0;
                        while (i < r.getItemIds().size()) {
                            Object v = (IVersionable)r.getStates().get(i);
                            v = v.getStateId().equals((Object)ItemUtil.DELETED_UUID) ? null : (IVersionable)vman.applyItemStates(Collections.singletonList(v)).get(0);
                            UUID itemId = (UUID)r.getItemIds().get(i);
                            perComponent.put(itemId, v);
                            ++i;
                        }
                        ++j;
                    }
                }
                HashMap<UUID, Map<UUID, ? extends IVersionable>> hashMap = result;
                return hashMap;
            }
            finally {
                monitor.done();
            }
        }

        @Override
        public Map<UUID, Map<String, IVersionableHandle>> childEntriesForRoots(IProgressMonitor monitor) throws TeamRepositoryException {
            monitor = SCMClientUtil.getMonitor(monitor, 100);
            try {
                WorkspaceConnection.this.validate();
                IScmService service = WorkspaceConnection.this.workspaceManager().getServerConfigurationService();
                SCMClientUtil.checkMonitor(monitor);
                ComponentizedFolderEntryReport[] fromServer = service.configurationBatchChildEntriesForRoot(WorkspaceConnection.this.workspaceHandle, Connection.getSyncTimes(null), (IRepositoryProgressMonitorHandle)WorkspaceConnection.this.monitorFor(monitor));
                HashMap<UUID, Map<String, IVersionableHandle>> result = new HashMap<UUID, Map<String, IVersionableHandle>>((int)((double)fromServer.length / 0.75));
                ComponentizedFolderEntryReport[] componentizedFolderEntryReportArray = fromServer;
                int n = fromServer.length;
                int n2 = 0;
                while (n2 < n) {
                    ComponentizedFolderEntryReport report = componentizedFolderEntryReportArray[n2];
                    result.put(report.getComponent().getItemId(), report.getReport().getEntries());
                    ++n2;
                }
                HashMap<UUID, Map<String, IVersionableHandle>> hashMap = result;
                return hashMap;
            }
            finally {
                monitor.done();
            }
        }
    }
}

