/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.client.rest.internal;

import com.ibm.team.interop.client.rest.json.JSONArray;
import com.ibm.team.interop.client.rest.json.JSONObject;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SimpleTimeZone;

public class InteropItem
extends JSONObject {
    public static final String QUALIFIED_CLASS_NAME_PROPERTY = "_eQualifiedClassName";
    public static final String ITEM_TYPE_NAME_PROPERTY = "com.ibm.team.repository.typeName";
    private static final String ITEMID_PROPERTY = "itemId";
    private static final String STATEID_PROPERTY = "stateId";
    private static final String URI_PROPERTY = "uri";
    private static final String ETAG_PROPERTY = "etag";
    private static final String NAME_PROPERTY = "name";
    private static final String STRING_EXTENSIONS_PROPERTY = "stringExtensions";
    private static final String MEDIUM_STRING_EXTENSIONS_PROPERTY = "mediumStringExtensions";
    private static final String LARGE_STRING_EXTENSIONS_PROPERTY = "largeStringExtensions";
    private static final String INT_EXTENSIONS_PROPERTY = "intExtensions";
    private static final String LONG_EXTENSIONS_PROPERTY = "longExtensions";
    private static final String BOOLEAN_EXTENSIONS_PROPERTY = "booleanExtensions";
    private static final String BIGDECIMAL_EXTENSIONS_PROPERTY = "bigdecimalExtensions";
    private static final String TIMESTAMP_EXTENSIONS_PROPERTY = "timestampExtensions";
    private static final String WORKINGCOPY_PROPERTY = "workingCopy";
    private static long MAX_SMALL_STRING_BYTES = 250L;
    private static long MAX_MEDIUM_STRING_BYTES = 1000L;
    private static long MAX_LARGE_STRING_BYTES = 32768L;
    private static final long serialVersionUID = -10086753633794709L;
    private String fETag;

    public InteropItem() {
        this.setWorkingCopy(true);
    }

    public InteropItem(JSONObject other) {
        super(other);
        if (other instanceof InteropItem) {
            this.setETag(((InteropItem)other).getETag());
        }
    }

    public boolean isNewItem() {
        return this.getItemId() == null;
    }

    public String getETag() {
        if (this.fETag == null) {
            this.fETag = (String)this.get(ETAG_PROPERTY);
        }
        if (this.fETag == null) {
            return this.fETag;
        }
        if (this.fETag.charAt(0) == '\"') {
            return this.fETag;
        }
        return "\"" + this.fETag + "\"";
    }

    public void setETag(String eTag) {
        this.fETag = eTag;
    }

    void setWorkingCopy(boolean workingCopy) {
        this.put(WORKINGCOPY_PROPERTY, Boolean.toString(workingCopy));
    }

    public String getItemId() {
        return (String)this.get(ITEMID_PROPERTY);
    }

    public String getUri() {
        return (String)this.get(URI_PROPERTY);
    }

    public void setUri(String uri) {
        this.put(URI_PROPERTY, uri);
    }

    public String getName() {
        return (String)this.get(NAME_PROPERTY);
    }

    protected void setItemId(String itemId) {
        if (itemId == null || itemId.length() == 0) {
            throw new IllegalArgumentException("The itemId argument must not be null or empty");
        }
        this.put(ITEMID_PROPERTY, itemId);
    }

    protected String getStateId() {
        return (String)this.get(STATEID_PROPERTY);
    }

    protected void setStateId(String stateId) {
        if (stateId == null || stateId.length() == 0) {
            throw new IllegalArgumentException("The stateId argument must not be null or empty");
        }
        this.put(STATEID_PROPERTY, stateId);
    }

    protected String getItemTypeName() {
        return (String)this.get(ITEM_TYPE_NAME_PROPERTY);
    }

    protected void setItemTypeName(String typeName) {
        if (typeName == null || typeName.length() == 0) {
            throw new IllegalArgumentException("The typeName argument must not be null or empty");
        }
        this.put(ITEM_TYPE_NAME_PROPERTY, typeName);
    }

    protected String getQualifiedClassName() {
        return (String)this.get(QUALIFIED_CLASS_NAME_PROPERTY);
    }

    protected void setQualifiedClassName(String className) {
        if (className == null || className.length() == 0) {
            throw new IllegalArgumentException("The className argument must not be null or empty");
        }
        this.put(QUALIFIED_CLASS_NAME_PROPERTY, className);
    }

    protected Map<String, Object> getStateExtensions() {
        StateExtensionEntry entry;
        Iterator iterator;
        HashMap<String, Object> stateExtensions = new HashMap<String, Object>();
        JSONArray entries = (JSONArray)this.get(STRING_EXTENSIONS_PROPERTY);
        if (entries != null) {
            iterator = entries.iterator();
            while (iterator.hasNext()) {
                entry = new StringExtensionEntry((JSONObject)iterator.next());
                stateExtensions.put(entry.getKey(), entry.getValue());
            }
        }
        if ((entries = (JSONArray)this.get(MEDIUM_STRING_EXTENSIONS_PROPERTY)) != null) {
            iterator = entries.iterator();
            while (iterator.hasNext()) {
                entry = new MediumStringExtensionEntry((JSONObject)iterator.next());
                stateExtensions.put(entry.getKey(), entry.getValue());
            }
        }
        if ((entries = (JSONArray)this.get(LARGE_STRING_EXTENSIONS_PROPERTY)) != null) {
            iterator = entries.iterator();
            while (iterator.hasNext()) {
                entry = new LargeStringExtensionEntry((JSONObject)iterator.next());
                stateExtensions.put(entry.getKey(), entry.getValue());
            }
        }
        if ((entries = (JSONArray)this.get(INT_EXTENSIONS_PROPERTY)) != null) {
            iterator = entries.iterator();
            while (iterator.hasNext()) {
                entry = new IntExtensionEntry((JSONObject)iterator.next());
                stateExtensions.put(entry.getKey(), entry.getValue());
            }
        }
        if ((entries = (JSONArray)this.get(LONG_EXTENSIONS_PROPERTY)) != null) {
            iterator = entries.iterator();
            while (iterator.hasNext()) {
                entry = new LongExtensionEntry((JSONObject)iterator.next());
                stateExtensions.put(entry.getKey(), entry.getValue());
            }
        }
        if ((entries = (JSONArray)this.get(BOOLEAN_EXTENSIONS_PROPERTY)) != null) {
            iterator = entries.iterator();
            while (iterator.hasNext()) {
                entry = new BooleanExtensionEntry((JSONObject)iterator.next());
                stateExtensions.put(entry.getKey(), entry.getValue());
            }
        }
        if ((entries = (JSONArray)this.get(BIGDECIMAL_EXTENSIONS_PROPERTY)) != null) {
            iterator = entries.iterator();
            while (iterator.hasNext()) {
                entry = new BigDecimalExtensionEntry((JSONObject)iterator.next());
                stateExtensions.put(entry.getKey(), entry.getValue());
            }
        }
        if ((entries = (JSONArray)this.get(TIMESTAMP_EXTENSIONS_PROPERTY)) != null) {
            iterator = entries.iterator();
            while (iterator.hasNext()) {
                entry = new TimestampExtensionEntry((JSONObject)iterator.next());
                stateExtensions.put(entry.getKey(), entry.getValue());
            }
        }
        return stateExtensions;
    }

    protected void setStateExtensions(Map<String, Object> state, boolean replace) {
        Map<String, Object> newStateExtensions;
        if (state == null) {
            throw new IllegalArgumentException("The state argument cannot be null");
        }
        if (replace) {
            newStateExtensions = state;
        } else {
            newStateExtensions = this.getStateExtensions();
            newStateExtensions.putAll(state);
        }
        JSONArray stringEntries = new JSONArray();
        JSONArray mediumStringEntries = new JSONArray();
        JSONArray largeStringEntries = new JSONArray();
        JSONArray intEntries = new JSONArray();
        JSONArray longEntries = new JSONArray();
        JSONArray booleanEntries = new JSONArray();
        JSONArray bigDecimalEntries = new JSONArray();
        JSONArray timestampEntries = new JSONArray();
        for (Map.Entry<String, Object> entry : newStateExtensions.entrySet()) {
            byte[] bytes;
            Object value = entry.getValue();
            if (value == null) {
                throw new IllegalArgumentException(MessageFormat.format("Value of state extension \"{0}\" cannot be null", entry.getKey()));
            }
            if (value instanceof Integer) {
                intEntries.add(new IntExtensionEntry(entry.getKey(), (Integer)value));
                continue;
            }
            if (value instanceof Long) {
                longEntries.add(new LongExtensionEntry(entry.getKey(), (Long)value));
                continue;
            }
            if (value instanceof Boolean) {
                booleanEntries.add(new BooleanExtensionEntry(entry.getKey(), (Boolean)value));
                continue;
            }
            if (value instanceof BigDecimal) {
                bigDecimalEntries.add(new BigDecimalExtensionEntry(entry.getKey(), (BigDecimal)value));
                continue;
            }
            if (value instanceof Timestamp) {
                timestampEntries.add(new TimestampExtensionEntry(entry.getKey(), (Timestamp)value));
                continue;
            }
            String stringValue = value.toString();
            try {
                bytes = stringValue.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Value cannot be encoded as UTF-8", e);
            }
            if ((long)bytes.length <= MAX_SMALL_STRING_BYTES) {
                stringEntries.add(new StringExtensionEntry(entry.getKey(), stringValue));
                continue;
            }
            if ((long)bytes.length <= MAX_MEDIUM_STRING_BYTES) {
                mediumStringEntries.add(new MediumStringExtensionEntry(entry.getKey(), stringValue));
                continue;
            }
            largeStringEntries.add(new LargeStringExtensionEntry(entry.getKey(), stringValue));
        }
        this.put(STRING_EXTENSIONS_PROPERTY, stringEntries);
        this.put(MEDIUM_STRING_EXTENSIONS_PROPERTY, mediumStringEntries);
        this.put(LARGE_STRING_EXTENSIONS_PROPERTY, largeStringEntries);
        this.put(INT_EXTENSIONS_PROPERTY, intEntries);
        this.put(LONG_EXTENSIONS_PROPERTY, longEntries);
        this.put(BOOLEAN_EXTENSIONS_PROPERTY, booleanEntries);
        this.put(TIMESTAMP_EXTENSIONS_PROPERTY, timestampEntries);
    }

    private static class BigDecimalExtensionEntry
    extends StateExtensionEntry {
        static final String QUALIFIED_CLASS_NAME = "com.ibm.team.repository:BigDecimalExtensionEntry";
        private static final long serialVersionUID = -8213678572718227603L;

        BigDecimalExtensionEntry(String key, BigDecimal value) {
            super(QUALIFIED_CLASS_NAME, key, value);
        }

        BigDecimalExtensionEntry(JSONObject other) {
            super(other);
            if (this.getValue() instanceof String) {
                this.setValue(new BigDecimal((String)this.getValue()));
            }
        }
    }

    private static class BooleanExtensionEntry
    extends StateExtensionEntry {
        static final String QUALIFIED_CLASS_NAME = "com.ibm.team.repository:BooleanExtensionEntry";
        private static final long serialVersionUID = 2269296141523502891L;

        BooleanExtensionEntry(String key, Boolean value) {
            super(QUALIFIED_CLASS_NAME, key, value);
        }

        BooleanExtensionEntry(JSONObject other) {
            super(other);
            if (!(this.getValue() instanceof Boolean)) {
                throw new IllegalArgumentException("JSONObject value must be Boolean");
            }
        }
    }

    private static class IntExtensionEntry
    extends StateExtensionEntry {
        static final String QUALIFIED_CLASS_NAME = "com.ibm.team.repository:IntExtensionEntry";
        private static final long serialVersionUID = 7433389525103318476L;

        IntExtensionEntry(String key, Integer value) {
            super(QUALIFIED_CLASS_NAME, key, value);
        }

        IntExtensionEntry(JSONObject other) {
            super(other);
            if (this.getValue() instanceof Long) {
                this.setValue(new Integer(((Long)this.getValue()).intValue()));
            } else if (!(this.getValue() instanceof Integer)) {
                throw new IllegalArgumentException("JSONObject value must be Integer");
            }
        }
    }

    private static class LargeStringExtensionEntry
    extends StateExtensionEntry {
        static final String QUALIFIED_CLASS_NAME = "com.ibm.team.repository:LargeStringExtensionEntry";
        private static final long serialVersionUID = 4942247987885295777L;

        LargeStringExtensionEntry(String key, String value) {
            super(QUALIFIED_CLASS_NAME, key, value);
        }

        LargeStringExtensionEntry(JSONObject other) {
            super(other);
        }
    }

    private static class LongExtensionEntry
    extends StateExtensionEntry {
        static final String QUALIFIED_CLASS_NAME = "com.ibm.team.repository:LongExtensionEntry";
        private static final long serialVersionUID = -5304810236383153089L;

        LongExtensionEntry(String key, Long value) {
            super(QUALIFIED_CLASS_NAME, key, value);
        }

        LongExtensionEntry(JSONObject other) {
            super(other);
            if (!(this.getValue() instanceof Long)) {
                throw new IllegalArgumentException("JSONObject value must be Long");
            }
        }
    }

    private static class MediumStringExtensionEntry
    extends StateExtensionEntry {
        static final String QUALIFIED_CLASS_NAME = "com.ibm.team.repository:MediumStringExtensionEntry";
        private static final long serialVersionUID = -507939841418520531L;

        MediumStringExtensionEntry(String key, String value) {
            super(QUALIFIED_CLASS_NAME, key, value);
        }

        MediumStringExtensionEntry(JSONObject other) {
            super(other);
        }
    }

    private static abstract class StateExtensionEntry
    extends JSONObject {
        private static final String KEY_PROPERTY = "key";
        private static final String VALUE_PROPERTY = "value";
        private static final long serialVersionUID = -3010545884373528151L;

        protected StateExtensionEntry(String className, String key, Object value) {
            if (className == null || className.length() == 0) {
                throw new IllegalArgumentException("The className argument must not be null or empty");
            }
            if (key == null || key.length() == 0) {
                throw new IllegalArgumentException("The key argument must not be null or empty");
            }
            if (value == null) {
                throw new IllegalArgumentException("The value argument must not be null");
            }
            this.put(InteropItem.QUALIFIED_CLASS_NAME_PROPERTY, className);
            this.put(KEY_PROPERTY, key);
            this.put(VALUE_PROPERTY, value);
        }

        protected StateExtensionEntry(JSONObject other) {
            super(other);
        }

        String getKey() {
            return (String)this.get(KEY_PROPERTY);
        }

        Object getValue() {
            return this.get(VALUE_PROPERTY);
        }

        protected void setValue(Object value) {
            this.put(VALUE_PROPERTY, value);
        }
    }

    private static class StringExtensionEntry
    extends StateExtensionEntry {
        static final String QUALIFIED_CLASS_NAME = "com.ibm.team.repository:StringExtensionEntry";
        private static final long serialVersionUID = 1424757847353151045L;

        StringExtensionEntry(String key, String value) {
            super(QUALIFIED_CLASS_NAME, key, value);
        }

        StringExtensionEntry(JSONObject other) {
            super(other);
        }
    }

    private static class TimestampExtensionEntry
    extends StateExtensionEntry {
        static final String QUALIFIED_CLASS_NAME = "com.ibm.team.repository:TimestampExtensionEntry";
        private static final SimpleDateFormat TIMESTAMP_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSS'Z'");
        private static final long serialVersionUID = -5267145316511527465L;

        static {
            TIMESTAMP_DATE_FORMAT.setTimeZone(new SimpleTimeZone(0, "GMT"));
        }

        TimestampExtensionEntry(String key, Timestamp value) {
            super(QUALIFIED_CLASS_NAME, key, TIMESTAMP_DATE_FORMAT.format(value));
        }

        TimestampExtensionEntry(JSONObject other) {
            super(other);
            if (this.getValue() instanceof String) {
                String val = (String)this.getValue();
                try {
                    Date date = TIMESTAMP_DATE_FORMAT.parse(val);
                    this.setValue(new Timestamp(date.getTime()));
                }
                catch (ParseException parseException) {
                    throw new RuntimeException(MessageFormat.format("Cannot parse timestamp string \"{0}\"", (String)this.getValue()));
                }
            } else if (!(this.getValue() instanceof Timestamp)) {
                throw new IllegalArgumentException("JSONObject value must be Timestamp");
            }
        }
    }
}

