/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.client.rest.json;

import com.ibm.team.interop.client.rest.json.JSONArray;
import com.ibm.team.interop.client.rest.json.internal.Parser;
import com.ibm.team.interop.client.rest.json.internal.Serializer;
import com.ibm.team.interop.client.rest.json.internal.SerializerVerbose;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Timestamp;
import java.util.HashMap;

public class JSONObject
extends HashMap {
    private static final long serialVersionUID = -3269263069889337298L;

    public static boolean isValidObject(Object object) {
        if (object == null) {
            return true;
        }
        return JSONObject.isValidType(object.getClass());
    }

    public static boolean isValidType(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        if (String.class == clazz) {
            return true;
        }
        if (Boolean.class == clazz) {
            return true;
        }
        if (Timestamp.class == clazz) {
            return true;
        }
        if (JSONObject.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (JSONArray.class.isAssignableFrom(clazz)) {
            return true;
        }
        return Number.class.isAssignableFrom(clazz);
    }

    public static JSONObject parse(Reader reader) throws IOException {
        Object obj = new Parser(reader = new BufferedReader(reader)).parse();
        if (!(obj instanceof JSONObject)) {
            throw new IOException(String.format("JSON text does not refer to a JSONObject: type is '%s'", obj.getClass()));
        }
        return (JSONObject)obj;
    }

    public static Object parseAny(Reader reader) throws IOException {
        reader = new BufferedReader(reader);
        return new Parser(reader).parse();
    }

    public JSONObject() {
    }

    public JSONObject(JSONObject other) {
        super(other);
    }

    public void serialize(Writer writer) throws IOException {
        this.serialize(writer, false);
    }

    public void serialize(Writer writer, boolean verbose) throws IOException {
        writer = new BufferedWriter(writer);
        Serializer serializer = verbose ? new SerializerVerbose(writer) : new Serializer(writer);
        serializer.writeObject(this).flush();
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean verbose) {
        StringWriter writer = new StringWriter();
        try {
            this.serialize(writer, verbose);
        }
        catch (IOException e) {
            return "Error serializing JSON object: " + e;
        }
        return writer.toString();
    }

    @Override
    public Object put(Object key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (!(key instanceof String)) {
            throw new IllegalArgumentException("key must be a String");
        }
        if (!JSONObject.isValidObject(value)) {
            throw new IllegalArgumentException("Invalid type of value.");
        }
        return super.put(key, value);
    }
}

