/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.client.rest.json.internal;

import com.ibm.team.interop.client.rest.json.internal.Token;
import java.io.IOException;
import java.io.Reader;

public class Tokenizer {
    private final Reader reader;
    private int lineNo;
    private int colNo;
    private int lastChar;

    public Tokenizer(Reader reader) throws IOException {
        this.reader = reader;
        this.lineNo = 0;
        this.colNo = 0;
        this.lastChar = 10;
        this.readChar();
    }

    public Token next() throws IOException {
        while (Character.isWhitespace((char)this.lastChar)) {
            this.readChar();
        }
        switch (this.lastChar) {
            case -1: {
                this.readChar();
                return Token.TokenEOF;
            }
            case 123: {
                this.readChar();
                return Token.TokenBraceL;
            }
            case 125: {
                this.readChar();
                return Token.TokenBraceR;
            }
            case 91: {
                this.readChar();
                return Token.TokenBrackL;
            }
            case 93: {
                this.readChar();
                return Token.TokenBrackR;
            }
            case 58: {
                this.readChar();
                return Token.TokenColon;
            }
            case 44: {
                this.readChar();
                return Token.TokenComma;
            }
            case 34: 
            case 39: {
                String stringValue = this.readString();
                return new Token(stringValue);
            }
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                Number numberValue = this.readNumber();
                return new Token(numberValue);
            }
            case 102: 
            case 110: 
            case 116: {
                String ident = this.readIdentifier();
                if (ident.equals("null")) {
                    return Token.TokenNull;
                }
                if (ident.equals(Boolean.TRUE.toString())) {
                    return Token.TokenTrue;
                }
                if (ident.equals(Boolean.FALSE.toString())) {
                    return Token.TokenFalse;
                }
                throw new IOException("Unexpected identifier '" + ident + "' " + this.onLineCol());
            }
        }
        throw new IOException("Unexpected character '" + this.lastChar + "' " + this.onLineCol());
    }

    private String readString() throws IOException {
        StringBuffer sb = new StringBuffer();
        int delim = this.lastChar;
        int l = this.lineNo;
        int c = this.colNo;
        this.readChar();
        while (-1 != this.lastChar && delim != this.lastChar) {
            if (this.lastChar != 92) {
                sb.append((char)this.lastChar);
                this.readChar();
                continue;
            }
            this.readChar();
            switch (this.lastChar) {
                case 98: {
                    this.readChar();
                    sb.append('\b');
                    break;
                }
                case 102: {
                    this.readChar();
                    sb.append('\f');
                    break;
                }
                case 110: {
                    this.readChar();
                    sb.append('\n');
                    break;
                }
                case 114: {
                    this.readChar();
                    sb.append('\r');
                    break;
                }
                case 116: {
                    this.readChar();
                    sb.append('\t');
                    break;
                }
                case 39: {
                    this.readChar();
                    sb.append('\'');
                    break;
                }
                case 34: {
                    this.readChar();
                    sb.append('\"');
                    break;
                }
                case 92: {
                    this.readChar();
                    sb.append('\\');
                    break;
                }
                case 47: {
                    this.readChar();
                    sb.append('/');
                    break;
                }
                case 117: 
                case 120: {
                    int digitValue;
                    StringBuffer digitBuffer = new StringBuffer();
                    int toRead = 2;
                    if (this.lastChar == 117) {
                        toRead = 4;
                    }
                    int i = 0;
                    while (i < toRead) {
                        this.readChar();
                        if (!this.isHexDigit(this.lastChar)) {
                            throw new IOException("non-hex digit " + this.onLineCol());
                        }
                        digitBuffer.append((char)this.lastChar);
                        ++i;
                    }
                    this.readChar();
                    try {
                        digitValue = Integer.parseInt(digitBuffer.toString(), 16);
                        sb.append((char)digitValue);
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IOException("non-hex digit " + this.onLineCol());
                    }
                }
                default: {
                    int digitValue;
                    if (!this.isOctalDigit(this.lastChar)) {
                        throw new IOException("non-hex digit " + this.onLineCol());
                    }
                    StringBuffer digitBuffer = new StringBuffer();
                    digitBuffer.append((char)this.lastChar);
                    int i = 0;
                    while (i < 2) {
                        this.readChar();
                        if (!this.isOctalDigit(this.lastChar)) break;
                        digitBuffer.append((char)this.lastChar);
                        ++i;
                    }
                    try {
                        digitValue = Integer.parseInt(digitBuffer.toString(), 8);
                        sb.append((char)digitValue);
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IOException("non-hex digit " + this.onLineCol());
                    }
                }
            }
        }
        if (-1 == this.lastChar) {
            throw new IOException("String not terminated " + this.onLineCol(l, c));
        }
        this.readChar();
        return sb.toString();
    }

    private Number readNumber() throws IOException {
        StringBuffer sb = new StringBuffer();
        int l = this.lineNo;
        int c = this.colNo;
        while (this.isDigitChar(this.lastChar)) {
            sb.append((char)this.lastChar);
            this.readChar();
        }
        String string = sb.toString();
        try {
            if (-1 != string.indexOf(46)) {
                return Double.valueOf(string);
            }
            String sign = "";
            if (string.startsWith("-")) {
                sign = "-";
                string = string.substring(1);
            }
            if (string.toUpperCase().startsWith("0X")) {
                return Long.valueOf(String.valueOf(sign) + string.substring(2), 16);
            }
            if (string.startsWith("0") && string.length() > 1) {
                return Long.valueOf(String.valueOf(sign) + string.substring(1), 8);
            }
            return Long.valueOf(String.valueOf(sign) + string, 10);
        }
        catch (NumberFormatException e) {
            String msg = String.format("Invalid number literal: '%s' - Exception message: %s", this.onLineCol(l, c), e.getMessage());
            throw new IOException(msg);
        }
    }

    private boolean isHexDigit(int c) {
        switch (c) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 76: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 108: {
                return true;
            }
        }
        return false;
    }

    private boolean isOctalDigit(int c) {
        switch (c) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                return true;
            }
        }
        return false;
    }

    private boolean isDigitChar(int c) {
        switch (c) {
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 69: 
            case 76: 
            case 88: 
            case 101: 
            case 108: 
            case 120: {
                return true;
            }
        }
        return false;
    }

    private String readIdentifier() throws IOException {
        StringBuffer sb = new StringBuffer();
        while (-1 != this.lastChar && Character.isLetter((char)this.lastChar)) {
            sb.append((char)this.lastChar);
            this.readChar();
        }
        return sb.toString();
    }

    private void readChar() throws IOException {
        if (10 == this.lastChar) {
            this.colNo = 0;
            ++this.lineNo;
        }
        this.lastChar = this.reader.read();
        if (-1 == this.lastChar) {
            return;
        }
        ++this.colNo;
    }

    private String onLineCol(int line, int col) {
        return "on line " + line + ", column " + col;
    }

    public String onLineCol() {
        return this.onLineCol(this.lineNo, this.colNo);
    }
}

