/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.common.internal.impl;

import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.internal.FileContent;
import com.ibm.team.filesystem.common.internal.FilesystemPackage;
import com.ibm.team.filesystem.common.internal.Messages;
import com.ibm.team.filesystem.common.internal.impl.PropertyImpl;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.IVersionedContent;
import com.ibm.team.scm.common.internal.impl.VersionedContentImpl;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.util.InternalEList;

public class FileContentImpl
extends VersionedContentImpl
implements FileContent {
    protected int ALL_FLAGS = 0;
    protected static final String CHARACTER_ENCODING_EDEFAULT = null;
    protected String characterEncoding = CHARACTER_ENCODING_EDEFAULT;
    protected static final int CHARACTER_ENCODING_ESETFLAG = 32;
    protected static final int LINE_DELIMITER_SETTING_EDEFAULT = 0;
    private static final String id = "com.ibm.team.filesystem.common";
    protected int lineDelimiterSetting = 0;
    protected static final int LINE_DELIMITER_SETTING_ESETFLAG = 64;
    protected EMap properties;
    private static final int EOFFSET_CORRECTION = FilesystemPackage.Literals.FILE_CONTENT.getFeatureID((EStructuralFeature)FilesystemPackage.Literals.FILE_CONTENT__CHARACTER_ENCODING) - 5;

    protected FileContentImpl() {
    }

    protected EClass eStaticClass() {
        return FilesystemPackage.Literals.FILE_CONTENT;
    }

    @Override
    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    @Override
    public Map getProperties() {
        if (this.properties == null) {
            this.properties = new EcoreEMap.Unsettable(FilesystemPackage.Literals.PROPERTY, PropertyImpl.class, (InternalEObject)this, 7 + EOFFSET_CORRECTION);
        }
        return this.properties.map();
    }

    @Override
    public void unsetProperties() {
        if (this.properties != null) {
            ((InternalEList.Unsettable)this.properties).unset();
        }
    }

    @Override
    public boolean isSetProperties() {
        return this.properties != null && ((InternalEList.Unsettable)this.properties).isSet();
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID - EOFFSET_CORRECTION) {
            case 7: {
                return ((InternalEList)((EMap.InternalMapView)this.getProperties()).eMap()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID - EOFFSET_CORRECTION) {
            case 5: {
                return this.getCharacterEncoding();
            }
            case 6: {
                return new Integer(this.getLineDelimiterSetting());
            }
            case 7: {
                if (coreType) {
                    return ((EMap.InternalMapView)this.getProperties()).eMap();
                }
                return this.getProperties();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID - EOFFSET_CORRECTION) {
            case 5: {
                this.setCharacterEncoding((String)newValue);
                return;
            }
            case 6: {
                this.setLineDelimiterSetting((Integer)newValue);
                return;
            }
            case 7: {
                ((EStructuralFeature.Setting)((EMap.InternalMapView)this.getProperties()).eMap()).set(newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID - EOFFSET_CORRECTION) {
            case 5: {
                this.unsetCharacterEncoding();
                return;
            }
            case 6: {
                this.unsetLineDelimiterSetting();
                return;
            }
            case 7: {
                this.unsetProperties();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID - EOFFSET_CORRECTION) {
            case 5: {
                return this.isSetCharacterEncoding();
            }
            case 6: {
                return this.isSetLineDelimiterSetting();
            }
            case 7: {
                return this.isSetProperties();
            }
        }
        return super.eIsSet(featureID);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class baseClass) {
        if (baseClass == IFileContent.class) {
            return -1;
        }
        if (baseClass == FileContent.class) {
            switch (baseFeatureID - EOFFSET_CORRECTION) {
                case 5: {
                    return 5 + EOFFSET_CORRECTION;
                }
                case 6: {
                    return 6 + EOFFSET_CORRECTION;
                }
                case 7: {
                    return 7 + EOFFSET_CORRECTION;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (characterEncoding: ");
        if ((this.ALL_FLAGS & 0x20) != 0) {
            result.append(this.characterEncoding);
        } else {
            result.append("<unset>");
        }
        result.append(", lineDelimiterSetting: ");
        if ((this.ALL_FLAGS & 0x40) != 0) {
            result.append(this.lineDelimiterSetting);
        } else {
            result.append("<unset>");
        }
        result.append(')');
        return result.toString();
    }

    @Override
    public FileLineDelimiter getLineDelimiter() {
        return FileLineDelimiter.getLineDelimiter(this.getLineDelimiterSetting());
    }

    @Override
    public long getRawLength() {
        return this.getSize();
    }

    @Override
    public long getEstimatedConvertedLength() {
        return this.getEstimatedConvertedLength(FileLineDelimiter.getPlatformDelimiter());
    }

    @Override
    public long getEstimatedConvertedLength(FileLineDelimiter requestedDelimiter) {
        if (this.getLineDelimiter() == FileLineDelimiter.LINE_DELIMITER_PLATFORM && requestedDelimiter != FileLineDelimiter.LINE_DELIMITER_LF) {
            int lineFeedLength = 1;
            String encoding = this.getCharacterEncoding();
            try {
                if (encoding != null) {
                    lineFeedLength = "\n".getBytes(encoding).length;
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            int adjustment = 0;
            switch (requestedDelimiter) {
                case LINE_DELIMITER_CR: {
                    int carriageReturnLength = 1;
                    try {
                        if (encoding != null) {
                            carriageReturnLength = "\r".getBytes(encoding).length;
                        }
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                    adjustment = carriageReturnLength - lineFeedLength;
                    break;
                }
                case LINE_DELIMITER_CRLF: {
                    int carriageReturnLineFeedLength = 2;
                    try {
                        if (encoding != null) {
                            carriageReturnLineFeedLength = "\r\n".getBytes(encoding).length;
                        }
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                    adjustment = carriageReturnLineFeedLength - lineFeedLength;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            return this.getRawLength() + (long)adjustment * this.getLineDelimiterCount();
        }
        return this.getRawLength();
    }

    @Override
    public boolean sameContent(IFileContent other) {
        if (other == null) {
            return false;
        }
        if (!super.sameContent((IVersionedContent)other)) {
            return false;
        }
        if (this.getCharacterEncoding() == null ? other.getCharacterEncoding() != null : !this.getCharacterEncoding().equals(other.getCharacterEncoding())) {
            return false;
        }
        return this.getLineDelimiter() == other.getLineDelimiter();
    }

    @Override
    public void setCharacterEncoding(String newCharacterEncoding) {
        String oldCharacterEncoding = this.characterEncoding;
        this.characterEncoding = newCharacterEncoding;
        boolean oldCharacterEncodingESet = (this.ALL_FLAGS & 0x20) != 0;
        this.ALL_FLAGS |= 0x20;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5 + EOFFSET_CORRECTION, (Object)oldCharacterEncoding, (Object)this.characterEncoding, !oldCharacterEncodingESet));
        }
    }

    @Override
    public void unsetCharacterEncoding() {
        String oldCharacterEncoding = this.characterEncoding;
        boolean oldCharacterEncodingESet = (this.ALL_FLAGS & 0x20) != 0;
        this.characterEncoding = CHARACTER_ENCODING_EDEFAULT;
        this.ALL_FLAGS &= 0xFFFFFFDF;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 5 + EOFFSET_CORRECTION, (Object)oldCharacterEncoding, (Object)CHARACTER_ENCODING_EDEFAULT, oldCharacterEncodingESet));
        }
    }

    @Override
    public boolean isSetCharacterEncoding() {
        return (this.ALL_FLAGS & 0x20) != 0;
    }

    @Override
    public int getLineDelimiterSetting() {
        return this.lineDelimiterSetting;
    }

    @Override
    public void setLineDelimiterSetting(int newLineDelimiterSetting) {
        int oldLineDelimiterSetting = this.lineDelimiterSetting;
        this.lineDelimiterSetting = newLineDelimiterSetting;
        boolean oldLineDelimiterSettingESet = (this.ALL_FLAGS & 0x40) != 0;
        this.ALL_FLAGS |= 0x40;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6 + EOFFSET_CORRECTION, oldLineDelimiterSetting, this.lineDelimiterSetting, !oldLineDelimiterSettingESet));
        }
    }

    @Override
    public void unsetLineDelimiterSetting() {
        int oldLineDelimiterSetting = this.lineDelimiterSetting;
        boolean oldLineDelimiterSettingESet = (this.ALL_FLAGS & 0x40) != 0;
        this.lineDelimiterSetting = 0;
        this.ALL_FLAGS &= 0xFFFFFFBF;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 6 + EOFFSET_CORRECTION, oldLineDelimiterSetting, 0, oldLineDelimiterSettingESet));
        }
    }

    @Override
    public boolean isSetLineDelimiterSetting() {
        return (this.ALL_FLAGS & 0x40) != 0;
    }

    @Override
    public void setLineDelimiter(FileLineDelimiter value) {
        if (value != FileLineDelimiter.LINE_DELIMITER_NONE && value != FileLineDelimiter.LINE_DELIMITER_CR && value != FileLineDelimiter.LINE_DELIMITER_LF && value != FileLineDelimiter.LINE_DELIMITER_CRLF && value != FileLineDelimiter.LINE_DELIMITER_PLATFORM) {
            throw new IllegalArgumentException();
        }
        this.setLineDelimiterSetting(value.dbValue());
    }

    @Override
    public long getLineDelimiterCount() {
        String lineDelimiterCountValue = (String)this.getProperties().get("numLineDelim");
        long lineDelimiterCount = 0L;
        if (lineDelimiterCountValue != null && lineDelimiterCountValue.trim().length() > 0) {
            lineDelimiterCount = Long.valueOf(lineDelimiterCountValue);
        }
        return lineDelimiterCount;
    }

    @Override
    public void setLineDelimiterCount(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException(Messages.getString("FileContentImpl_0"));
        }
        this.getProperties().put("numLineDelim", Long.toString(value));
    }

    @Override
    public IStatus validate() {
        ArrayList<Status> errors = new ArrayList<Status>();
        FileLineDelimiter lineDelimiter = this.getLineDelimiter();
        String encoding = this.getCharacterEncoding();
        long numLineDelimiters = this.getLineDelimiterCount();
        if (lineDelimiter != FileLineDelimiter.LINE_DELIMITER_NONE && (encoding == null || encoding.trim().length() == 0)) {
            errors.add(new Status(4, id, Messages.getString("FileContentImpl_1")));
        }
        if (lineDelimiter == FileLineDelimiter.LINE_DELIMITER_NONE && numLineDelimiters != 0L) {
            errors.add(new Status(4, id, Messages.getString("FileContentImpl_2")));
        }
        for (String property : this.getProperties().keySet()) {
            if (property.equals("numLineDelim")) continue;
            errors.add(new Status(4, id, NLS.bind((String)Messages.getString("FileContentImpl_3"), (Object)property, (Object[])new Object[0])));
        }
        if (errors.isEmpty()) {
            return Status.OK_STATUS;
        }
        if (errors.size() == 1) {
            return (IStatus)errors.get(0);
        }
        return new MultiStatus(id, 4, errors.toArray(new IStatus[errors.size()]), Messages.getString("FileContentImpl_4"), null);
    }
}

