/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.common.internal.analysis;

import com.ibm.team.fulltext.common.TokenizerTypes;
import com.ibm.team.fulltext.common.internal.analysis.ArtifactAttribute;
import com.ibm.team.fulltext.common.internal.analysis.ArtifactAttributeImpl;
import java.io.IOException;
import java.util.Set;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

public final class StopFilter
extends TokenFilter {
    public static final Set<?> STOP_WORD_SET = StopAnalyzer.ENGLISH_STOP_WORDS_SET;
    private final boolean fIgnoreCase;
    private ArtifactAttribute attribute;

    public StopFilter(TokenStream in) {
        this(in, false);
    }

    public StopFilter(TokenStream in, boolean ignoreCase) {
        super(in);
        this.fIgnoreCase = ignoreCase;
        this.attribute = ArtifactAttributeImpl.addAttributeToStream((TokenStream)this);
    }

    public boolean incrementToken() throws IOException {
        while (this.input.incrementToken()) {
            String termText;
            if (this.attribute.isArtifact() && !this.attribute.applies(TokenizerTypes.FILTER_STOP_WORDS)) {
                return true;
            }
            String string = termText = this.fIgnoreCase ? this.attribute.term().toLowerCase() : this.attribute.term();
            if (STOP_WORD_SET.contains(termText)) continue;
            return true;
        }
        return false;
    }
}

