/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.providers.header;

import javax.ws.rs.core.NewCookie;
import javax.ws.rs.ext.RuntimeDelegate;
import org.apache.wink.common.internal.i18n.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewCookieHeaderDelegate
implements RuntimeDelegate.HeaderDelegate<NewCookie> {
    @Override
    public NewCookie fromString(String cookie) throws IllegalArgumentException {
        if (cookie == null) {
            throw new IllegalArgumentException(Messages.getMessage("cookieIsNull"));
        }
        String[] tokens = cookie.split(";");
        ModifiableCookie modifiableCookie = null;
        for (String token : tokens) {
            String value;
            String[] subTokens = token.split("=", 2);
            String name = subTokens.length > 0 ? subTokens[0] : null;
            String string = value = subTokens.length > 1 ? subTokens[1] : null;
            if (value != null && value.startsWith("\"") && value.endsWith("\"") && value.length() > 1) {
                value = value.substring(1, value.length() - 1);
            }
            if (modifiableCookie == null) {
                if (name == null) {
                    throw new IllegalArgumentException(Messages.getMessage("cookieNameNotValid", name));
                }
                if (value == null) {
                    throw new IllegalArgumentException(Messages.getMessage("cookieNameValueNotValid", value));
                }
                modifiableCookie = new ModifiableCookie();
                modifiableCookie.name = name;
                modifiableCookie.value = value;
                continue;
            }
            if (name.trim().startsWith("Version")) {
                modifiableCookie.version = Integer.parseInt(value);
                continue;
            }
            if (name.trim().startsWith("Path")) {
                modifiableCookie.path = value;
                continue;
            }
            if (name.trim().startsWith("Domain")) {
                modifiableCookie.domain = value;
                continue;
            }
            if (name.trim().startsWith("Comment")) {
                modifiableCookie.comment = value;
                continue;
            }
            if (name.trim().startsWith("Max-Age")) {
                modifiableCookie.maxAge = Integer.parseInt(value);
                continue;
            }
            if (!name.trim().startsWith("Secure")) continue;
            modifiableCookie.secure = true;
        }
        return this.buildNewCookie(modifiableCookie);
    }

    private NewCookie buildNewCookie(ModifiableCookie modifiableCookie) {
        NewCookie newCookie = new NewCookie(modifiableCookie.name, modifiableCookie.value, modifiableCookie.path, modifiableCookie.domain, modifiableCookie.comment, modifiableCookie.maxAge, modifiableCookie.secure);
        return newCookie;
    }

    @Override
    public String toString(NewCookie cookie) {
        if (cookie == null) {
            throw new IllegalArgumentException(Messages.getMessage("cookieIsNull"));
        }
        return this.buildCookie(cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getDomain(), cookie.getVersion(), cookie.getComment(), cookie.getMaxAge(), cookie.isSecure());
    }

    private String buildCookie(String name, String value, String path, String domain, int version2, String comment, int maxAge, boolean secure) {
        StringBuilder sb = new StringBuilder();
        sb.append(name).append("=");
        if (value == null || value.length() == 0) {
            sb.append("\"\"");
        } else {
            sb.append(value);
        }
        sb.append(";").append("Version=").append(version2);
        if (path != null) {
            sb.append(";Path=").append(path);
        }
        if (domain != null) {
            sb.append(";Domain=").append(domain);
        }
        if (comment != null) {
            sb.append(";Comment=").append(comment);
        }
        if (maxAge >= 0) {
            sb.append(";Max-Age=").append(maxAge);
        }
        if (secure) {
            sb.append(";Secure");
        }
        return sb.toString();
    }

    private static class ModifiableCookie {
        public String name;
        public String value;
        public int version = 1;
        public String path;
        public String domain;
        public String comment = null;
        public int maxAge = -1;
        public boolean secure = false;

        private ModifiableCookie() {
        }
    }
}

