/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.wink.common.RuntimeContext;
import org.apache.wink.common.http.HttpStatus;
import org.apache.wink.common.internal.application.ApplicationValidator;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.lifecycle.LifecycleManagersRegistry;
import org.apache.wink.common.internal.registry.Injectable;
import org.apache.wink.common.internal.registry.metadata.MethodMetadata;
import org.apache.wink.common.internal.uritemplate.UriTemplateMatcher;
import org.apache.wink.common.internal.uritemplate.UriTemplateProcessor;
import org.apache.wink.common.internal.utils.HeaderUtils;
import org.apache.wink.common.internal.utils.MediaTypeUtils;
import org.apache.wink.common.internal.utils.SoftConcurrentMap;
import org.apache.wink.server.internal.registry.MethodMetadataRecord;
import org.apache.wink.server.internal.registry.MethodRecord;
import org.apache.wink.server.internal.registry.ResourceInstance;
import org.apache.wink.server.internal.registry.ResourceRecord;
import org.apache.wink.server.internal.registry.ResourceRecordFactory;
import org.apache.wink.server.internal.registry.SubResourceInstance;
import org.apache.wink.server.internal.registry.SubResourceMethodRecord;
import org.apache.wink.server.internal.registry.SubResourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceRegistry {
    private static final Logger logger = LoggerFactory.getLogger(ResourceRegistry.class);
    private List<ResourceRecord> rootResources;
    private ResourceRecordFactory resourceRecordsFactory;
    private Lock readersLock;
    private Lock writersLock;
    private final ApplicationValidator applicationValidator;
    private HashMap<Boolean, SoftConcurrentMap<String, ArrayList<ResourceRecord>>> uriToResourceCache = new HashMap();

    public ResourceRegistry(LifecycleManagersRegistry factoryRegistry, ApplicationValidator applicationValidator) {
        this(factoryRegistry, applicationValidator, new Properties());
    }

    public ResourceRegistry(LifecycleManagersRegistry factoryRegistry, ApplicationValidator applicationValidator, Properties properties) {
        this.applicationValidator = applicationValidator;
        this.rootResources = new LinkedList<ResourceRecord>();
        this.resourceRecordsFactory = new ResourceRecordFactory(factoryRegistry, properties);
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readersLock = readWriteLock.readLock();
        this.writersLock = readWriteLock.writeLock();
        this.uriToResourceCache.put(Boolean.TRUE, new SoftConcurrentMap());
        this.uriToResourceCache.put(Boolean.FALSE, new SoftConcurrentMap());
    }

    public void addResource(Object instance) {
        this.addResource(instance, 0.5);
    }

    public void addResource(Class<?> clazz) {
        this.addResource(clazz, 0.5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResource(Object instance, double priority) {
        logger.trace("Adding resource instance: {} with priority: {}", instance, (Object)priority);
        this.writersLock.lock();
        try {
            if (!this.applicationValidator.isValidResource(instance.getClass())) {
                if (logger.isWarnEnabled()) {
                    logger.warn(Messages.getMessage("resourceClassNotValid", instance.getClass().getName()));
                }
                return;
            }
            ResourceRecord record = this.getRecord(instance);
            record.setPriority(priority);
            this.rootResources.add(record);
            this.assertSorted();
        }
        finally {
            this.writersLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResource(Class<?> clazz, double priority) {
        logger.trace("Adding resource class: {} with priority: {}", clazz, (Object)priority);
        this.writersLock.lock();
        try {
            if (!this.applicationValidator.isValidResource(clazz)) {
                if (logger.isWarnEnabled()) {
                    logger.warn(Messages.getMessage("resourceClassNotValid", clazz.getName()));
                }
                return;
            }
            ResourceRecord record = this.getRecord(clazz);
            record.setPriority(priority);
            this.rootResources.add(record);
            this.assertSorted();
        }
        finally {
            this.writersLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllResources() {
        this.writersLock.lock();
        try {
            for (ResourceRecord record : this.rootResources) {
                record.getObjectFactory().releaseAll(null);
            }
            this.rootResources.clear();
            this.assertSorted();
        }
        finally {
            this.writersLock.unlock();
        }
    }

    public ResourceRecord getRecord(Object instance) {
        return this.getRecord(instance, true);
    }

    public ResourceRecord getRecord(Object instance, boolean isRootResource) {
        return this.resourceRecordsFactory.getResourceRecord(instance, isRootResource);
    }

    public ResourceRecord getRecord(Class<?> clazz) {
        return this.resourceRecordsFactory.getResourceRecord(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResourceRecord> getRecords() {
        this.readersLock.lock();
        try {
            List<ResourceRecord> list = Collections.unmodifiableList(this.rootResources);
            return list;
        }
        finally {
            this.readersLock.unlock();
        }
    }

    public Set<String> getOptions(ResourceInstance resource) {
        List<MethodMetadata> resourceMethods;
        HashSet<String> set = new HashSet<String>();
        if (resource.isExactMatch()) {
            resourceMethods = resource.getRecord().getMetadata().getResourceMethods();
        } else {
            String uri = UriTemplateProcessor.normalizeUri(resource.getMatcher().getTail(false));
            List<SubResourceInstance> matchingMethods = resource.getRecord().getMatchingSubResourceMethods(uri);
            resourceMethods = new LinkedList<MethodMetadata>();
            for (SubResourceInstance subResource : matchingMethods) {
                resourceMethods.add(subResource.getRecord().getMetadata());
            }
        }
        for (MethodMetadata method : resourceMethods) {
            set.add(method.getHttpMethod());
        }
        return set;
    }

    private void assertSorted() {
        Collections.sort(this.rootResources, Collections.reverseOrder());
        this.uriToResourceCache.get(Boolean.TRUE).clear();
        this.uriToResourceCache.get(Boolean.FALSE).clear();
    }

    public List<ResourceInstance> getMatchingRootResources(String uri) {
        return this.getMatchingRootResources(uri, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResourceInstance> getMatchingRootResources(String uri, boolean isContinuedSearchPolicy) {
        if (uri == null) {
            uri = "";
        }
        if (uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        ArrayList<ResourceInstance> found = new ArrayList<ResourceInstance>(1);
        ArrayList<ResourceRecord> previousMatched = null;
        previousMatched = this.uriToResourceCache.get(isContinuedSearchPolicy).get(uri);
        if (previousMatched != null) {
            for (ResourceRecord record : previousMatched) {
                UriTemplateMatcher matcher = record.getTemplateProcessor().matcher();
                if (!matcher.matches(uri)) continue;
                found.add(new ResourceInstance(record, matcher));
            }
            return found;
        }
        this.readersLock.lock();
        try {
            previousMatched = new ArrayList();
            for (ResourceRecord record : this.rootResources) {
                UriTemplateMatcher matcher = record.getTemplateProcessor().matcher();
                if (!matcher.matches(uri) || !matcher.isExactMatch() && !record.hasSubResources()) continue;
                previousMatched.add(record);
                found.add(new ResourceInstance(record, matcher));
                if (isContinuedSearchPolicy) continue;
                break;
            }
            this.uriToResourceCache.get(isContinuedSearchPolicy).put(uri, previousMatched);
        }
        finally {
            this.readersLock.unlock();
        }
        return found;
    }

    public MethodRecord findMethod(ResourceInstance resource, RuntimeContext context) throws WebApplicationException {
        List<MethodMetadata> methods = resource.getRecord().getMetadata().getResourceMethods();
        LinkedList<MethodMetadataRecord> records = new LinkedList<MethodMetadataRecord>();
        for (MethodMetadata metadata : methods) {
            records.add(new MethodMetadataRecord(metadata));
        }
        this.filterDispatchMethods(resource, records, context);
        return this.selectBestMatchingMethod(records, context);
    }

    public SubResourceInstance findSubResourceMethod(String pattern, List<SubResourceInstance> subResourceRecords, ResourceInstance resource, RuntimeContext context) throws WebApplicationException {
        List<SubResourceInstance> subResourceMethods = this.extractSubResourceMethods(pattern, subResourceRecords);
        this.filterDispatchMethods(resource, subResourceMethods, context);
        return (SubResourceInstance)this.selectBestMatchingMethod(subResourceMethods, context);
    }

    private List<SubResourceInstance> extractSubResourceMethods(String pattern, List<SubResourceInstance> subResourceRecords) {
        LinkedList<SubResourceInstance> subResourceMethods = new LinkedList<SubResourceInstance>();
        for (SubResourceInstance instance : subResourceRecords) {
            SubResourceRecord record = instance.getRecord();
            String recordPattern = record.getTemplateProcessor().getPatternString();
            if (!(record instanceof SubResourceMethodRecord) || !recordPattern.equals(pattern)) continue;
            subResourceMethods.add(instance);
        }
        return subResourceMethods;
    }

    private void filterDispatchMethods(ResourceInstance resource, List<? extends MethodRecord> methodRecords, RuntimeContext context) throws WebApplicationException {
        MethodRecord record;
        ListIterator<? extends MethodRecord> iterator = methodRecords.listIterator();
        while (iterator.hasNext()) {
            record = iterator.next();
            if (!this.filterByHttpMethod(record, context)) continue;
            iterator.remove();
        }
        if (methodRecords.size() == 0) {
            if (logger.isInfoEnabled()) {
                logger.info(Messages.getMessage("noMethodInClassSupportsHTTPMethod", resource.getResourceClass().getName(), context.getRequest().getMethod()));
            }
            Set<String> httpMethods = this.getOptions(resource);
            Response.ResponseBuilder builder = Response.status(HttpStatus.METHOD_NOT_ALLOWED.getCode());
            String allowHeader = HeaderUtils.buildOptionsHeader(httpMethods);
            builder.header("Allow", allowHeader);
            throw new WebApplicationException(builder.build());
        }
        iterator = methodRecords.listIterator();
        while (iterator.hasNext()) {
            record = iterator.next();
            if (!this.filterByConsumes(record, context)) continue;
            iterator.remove();
        }
        if (methodRecords.size() == 0) {
            logger.info(Messages.getMessage("noMethodInClassConsumesHTTPMethod", resource.getResourceClass().getName(), context.getHttpHeaders().getMediaType()));
            throw new WebApplicationException(Response.Status.UNSUPPORTED_MEDIA_TYPE);
        }
        iterator = methodRecords.listIterator();
        while (iterator.hasNext()) {
            record = iterator.next();
            if (!this.filterByProduces(record, context)) continue;
            iterator.remove();
        }
        if (methodRecords.size() == 0) {
            logger.info(Messages.getMessage("noMethodInClassProducesHTTPMethod", resource.getResourceClass().getName(), context.getHttpHeaders().getRequestHeader("Accept")));
            throw new WebApplicationException(Response.Status.NOT_ACCEPTABLE);
        }
    }

    private boolean filterByHttpMethod(MethodRecord record, RuntimeContext context) {
        String httpMethod = context.getRequest().getMethod();
        String recordHttpMethod = record.getMetadata().getHttpMethod();
        if (recordHttpMethod == null) {
            return false;
        }
        return !recordHttpMethod.equals(httpMethod);
    }

    private boolean filterByConsumes(MethodRecord record, RuntimeContext context) {
        Set<MediaType> consumedMimes = record.getMetadata().getConsumes();
        if (consumedMimes.size() == 0) {
            return false;
        }
        MediaType inputMediaType = context.getHttpHeaders().getMediaType();
        if (inputMediaType == null) {
            inputMediaType = MediaType.APPLICATION_OCTET_STREAM_TYPE;
        }
        for (MediaType mediaType : consumedMimes) {
            if (!mediaType.isCompatible(inputMediaType)) continue;
            return false;
        }
        return true;
    }

    private boolean filterByProduces(MethodRecord record, RuntimeContext context) {
        Set<MediaType> producedMimes = record.getMetadata().getProduces();
        if (producedMimes.size() == 0) {
            return false;
        }
        List<MediaType> receivedMediaTypes = context.getHttpHeaders().getAcceptableMediaTypes();
        if (receivedMediaTypes.size() == 0) {
            return false;
        }
        LinkedList<MediaType> deniableMediaTypes = new LinkedList<MediaType>();
        LinkedList<MediaType> acceptableMediaTypes = new LinkedList<MediaType>();
        for (MediaType received : receivedMediaTypes) {
            String q = received.getParameters().get("q");
            if (q != null && Double.valueOf(q).equals(0.0)) {
                deniableMediaTypes.add(received);
                continue;
            }
            acceptableMediaTypes.add(received);
        }
        block1: for (MediaType mediaType : producedMimes) {
            for (MediaType deniable : deniableMediaTypes) {
                if (!MediaTypeUtils.isCompatibleNonCommutative(deniable, mediaType)) continue;
                continue block1;
            }
            for (MediaType acceptableMediaType : acceptableMediaTypes) {
                if (!mediaType.isCompatible(acceptableMediaType)) continue;
                return false;
            }
        }
        return true;
    }

    private MethodRecord selectBestMatchingMethod(List<? extends MethodRecord> methodRecords, RuntimeContext context) {
        HttpHeaders httpHeaders = context.getHttpHeaders();
        MediaType inputMediaType = httpHeaders.getMediaType();
        List<MediaType> acceptableMediaTypes = httpHeaders.getAcceptableMediaTypes();
        MethodRecord bestMatch = null;
        for (MethodRecord methodRecord : methodRecords) {
            if (this.compareMethods(methodRecord, bestMatch, inputMediaType, acceptableMediaTypes) <= 0) continue;
            bestMatch = methodRecord;
        }
        return bestMatch;
    }

    private int compareMethods(MethodRecord record1, MethodRecord record2, MediaType inputMediaType, List<MediaType> acceptableMediaTypes) {
        if (record1 == null && record2 == null) {
            return 0;
        }
        if (record1 != null && record2 == null) {
            return 1;
        }
        if (record1 == null && record2 != null) {
            return -1;
        }
        int res = this.compareMethodsConsumes(record1, record2, inputMediaType);
        if (res != 0) {
            return res;
        }
        res = this.compareMethodsProduces(record1, record2, acceptableMediaTypes);
        if (res != 0) {
            return res;
        }
        return this.compareMethodsParameters(record1, record2);
    }

    private int compareMethodsParameters(MethodRecord record1, MethodRecord record2) {
        List<Injectable> params1 = record1.getMetadata().getFormalParameters();
        List<Injectable> params2 = record2.getMetadata().getFormalParameters();
        return params1.size() - params2.size();
    }

    private int compareMethodsConsumes(MethodRecord record1, MethodRecord record2, MediaType inputMediaType) {
        MediaType bestMatch1 = this.selectBestMatchingMediaType(inputMediaType, record1.getMetadata().getConsumes());
        MediaType bestMatch2 = this.selectBestMatchingMediaType(inputMediaType, record2.getMetadata().getConsumes());
        if (bestMatch1 == null && bestMatch2 == null) {
            return 0;
        }
        if (bestMatch1 != null && bestMatch2 == null) {
            return 1;
        }
        if (bestMatch1 == null && bestMatch2 != null) {
            return -1;
        }
        int retVal = MediaTypeUtils.compareTo(bestMatch1, bestMatch2);
        if (retVal != 0) {
            return retVal;
        }
        Map<String, String> inputParameters = inputMediaType.getParameters();
        Map<String, String> bestMatch1Params = bestMatch1.getParameters();
        boolean didMatchAllParamsForBestMatch1 = true;
        for (String key : bestMatch1Params.keySet()) {
            String inputValue = inputParameters.get(key);
            String value1 = bestMatch1Params.get(key);
            if (value1.equals(inputValue)) continue;
            didMatchAllParamsForBestMatch1 = false;
            break;
        }
        Map<String, String> bestMatch2Params = bestMatch2.getParameters();
        boolean didMatchAllParamsForBestMatch2 = true;
        for (String key : bestMatch2Params.keySet()) {
            String inputValue = inputParameters.get(key);
            String value2 = bestMatch2Params.get(key);
            if (value2.equals(inputValue)) continue;
            didMatchAllParamsForBestMatch2 = false;
            break;
        }
        if (didMatchAllParamsForBestMatch1 && !didMatchAllParamsForBestMatch2) {
            return 1;
        }
        if (!didMatchAllParamsForBestMatch1 && didMatchAllParamsForBestMatch2) {
            return -1;
        }
        if (didMatchAllParamsForBestMatch1 && didMatchAllParamsForBestMatch2) {
            int size2;
            int size1 = bestMatch1Params.size();
            if (size1 > (size2 = bestMatch2Params.size())) {
                return 1;
            }
            if (size2 > size1) {
                return -1;
            }
        }
        return 0;
    }

    private int compareMethodsProduces(MethodRecord record1, MethodRecord record2, List<MediaType> acceptableMediaTypes) {
        MediaType bestMatch1 = null;
        MediaType bestMatch2 = null;
        for (MediaType acceptableMediaType : acceptableMediaTypes) {
            bestMatch1 = this.selectBestMatchingMediaType(acceptableMediaType, record1.getMetadata().getProduces());
            bestMatch2 = this.selectBestMatchingMediaType(acceptableMediaType, record2.getMetadata().getProduces());
            if (bestMatch1 == null && bestMatch2 == null) continue;
            break;
        }
        if (bestMatch1 == null && bestMatch2 == null) {
            return 0;
        }
        if (bestMatch1 != null && bestMatch2 == null) {
            return 1;
        }
        if (bestMatch1 == null && bestMatch2 != null) {
            return -1;
        }
        return MediaTypeUtils.compareTo(bestMatch1, bestMatch2);
    }

    private MediaType selectBestMatchingMediaType(MediaType mediaType, Set<MediaType> mediaTypes) {
        MediaType bestMatch = null;
        for (MediaType mt : mediaTypes) {
            if (!mt.isCompatible(mediaType) || bestMatch != null && MediaTypeUtils.compareTo(mt, bestMatch) <= 0) continue;
            bestMatch = mt;
        }
        if (bestMatch == null) {
            return null;
        }
        return bestMatch;
    }
}

