/*
 * Decompiled with CFR 0.152.
 */
package javax.wvcm;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.wvcm.Feedback;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;

public interface PropertyRequestItem {

    public static class NestedPropertyName<T>
    implements PropertyRequestItem {
        private final PropertyNameList.PropertyName<T> _root;
        private final PropertyRequest _nested;
        private volatile int _hashCode = 0;

        public NestedPropertyName(PropertyNameList.PropertyName<T> root, PropertyRequestItem ... items) {
            if (root == null) {
                throw new UnsupportedOperationException("The root PropertyName of a NestedPropertyName cannot be null.");
            }
            this._root = root;
            Map itemMap = PropertyRequest.getItemMap(items);
            this._nested = itemMap == null || itemMap.isEmpty() ? null : new PropertyRequest(itemMap);
        }

        public NestedPropertyName(PropertyNameList.PropertyName<T> root, PropertyNameList.PropertyName<?>[] items) {
            this(root, (PropertyRequestItem[])items);
        }

        public NestedPropertyName(PropertyNameList.PropertyName<T> root, NestedPropertyName<?>[] items) {
            this(root, (PropertyRequestItem[])items);
        }

        public PropertyNameList.PropertyName<T> getRoot() {
            return this._root;
        }

        public PropertyRequest getNested() {
            return this._nested == null ? PropertyRequest.EMPTY : this._nested;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NestedPropertyName npn = (NestedPropertyName)o;
            return this._root.equals(npn.getRoot()) && this.getNested().equals(npn.getNested());
        }

        public int hashCode() {
            if (this._hashCode == 0) {
                int result = 17;
                result = 37 * result + this._root.hashCode();
                this._hashCode = result = 37 * result + this.getNested().hashCode();
            }
            return this._hashCode;
        }

        public String toString() {
            if (this.getNested().isEmpty()) {
                return this._root.toString();
            }
            return String.valueOf(this._root.toString()) + this.getNested().toString();
        }
    }

    public static class PropertyRequest
    implements PropertyRequestItem,
    Feedback {
        private Map<PropertyNameList.PropertyName<?>, PropertyRequest> _itemMap;
        private NestedPropertyName<?>[] _itemArray;
        private static final NestedPropertyName<?>[] EMPTY_PNA = new NestedPropertyName[0];
        public static final PropertyRequest EMPTY = new PropertyRequest(new PropertyRequestItem[0]);
        private static final Map<PropertyNameList.PropertyName<?>, PropertyRequest> EMPTY_MAP = Collections.emptyMap();

        public PropertyRequest(PropertyRequestItem ... items) {
            this(PropertyRequest.getItemMap(items));
        }

        public PropertyRequest(PropertyNameList.PropertyName<?>[] items) {
            this((PropertyRequestItem[])items);
        }

        public PropertyRequest(NestedPropertyName<?>[] items) {
            this((PropertyRequestItem[])items);
        }

        private PropertyRequest(Map<PropertyNameList.PropertyName<?>, PropertyRequest> itemMap) {
            this._itemMap = itemMap == null || itemMap.isEmpty() ? null : Collections.unmodifiableMap(itemMap);
        }

        private static Map<PropertyNameList.PropertyName<?>, PropertyRequest> getItemMap(PropertyRequestItem ... items) {
            if (items == null || items.length == 0) {
                return null;
            }
            HashMap itemMap = new HashMap(items.length);
            PropertyRequestItem[] propertyRequestItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyRequestItem request = propertyRequestItemArray[n2];
                if (request != null) {
                    if (request instanceof PropertyNameList.PropertyName) {
                        PropertyRequest.put(itemMap, (PropertyNameList.PropertyName)request, null);
                    } else if (request instanceof NestedPropertyName) {
                        NestedPropertyName npn = (NestedPropertyName)request;
                        PropertyRequest.put(itemMap, npn.getRoot(), npn.getNested());
                    } else if (request instanceof PropertyNameList) {
                        PropertyNameList list = (PropertyNameList)request;
                        PropertyNameList.PropertyName<?>[] propertyNameArray = list.getPropertyNames();
                        int n3 = propertyNameArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            PropertyNameList.PropertyName<?> name = propertyNameArray[n4];
                            PropertyRequest.put(itemMap, name, null);
                            ++n4;
                        }
                    } else if (request instanceof PropertyRequest) {
                        Map<PropertyNameList.PropertyName<?>, PropertyRequest> map = ((PropertyRequest)request).toMap();
                        for (Map.Entry<PropertyNameList.PropertyName<?>, PropertyRequest> entry : map.entrySet()) {
                            PropertyRequest.put(itemMap, entry.getKey(), entry.getValue());
                        }
                    } else {
                        throw new UnsupportedOperationException(String.valueOf(request.getClass().getName()) + " cannot be a PropertyRequest item");
                    }
                }
                ++n2;
            }
            return itemMap.isEmpty() ? null : itemMap;
        }

        private static void put(Map<PropertyNameList.PropertyName<?>, PropertyRequest> itemMap, PropertyNameList.PropertyName<?> propertyName, PropertyRequest propertyRequest) {
            PropertyRequest pr = itemMap.get(propertyName);
            itemMap.put(propertyName, PropertyRequest.merge(pr, propertyRequest));
        }

        private static PropertyRequest merge(PropertyRequest pr1, PropertyRequest pr2) {
            if (pr1 == null) {
                return pr2;
            }
            if (pr2 == null) {
                return pr1;
            }
            HashMap itemMap = new HashMap(pr1.size() + pr2.size());
            for (PropertyNameList.PropertyName<?> pName : pr1.toMap().keySet()) {
                PropertyRequest.put(itemMap, pName, pr1.toMap().get(pName));
            }
            for (PropertyNameList.PropertyName<?> pName : pr2.toMap().keySet()) {
                PropertyRequest.put(itemMap, pName, pr2.toMap().get(pName));
            }
            PropertyRequest result = new PropertyRequest(new PropertyRequestItem[0]);
            result._itemMap = Collections.unmodifiableMap(itemMap);
            return result;
        }

        public Map<PropertyNameList.PropertyName<?>, PropertyRequest> toMap() {
            return this._itemMap == null ? EMPTY_MAP : this._itemMap;
        }

        public NestedPropertyName<?>[] toArray() {
            if (this._itemMap == null) {
                return EMPTY_PNA;
            }
            if (this._itemArray == null) {
                this._itemArray = new NestedPropertyName[this._itemMap.size()];
                int i = 0;
                for (PropertyNameList.PropertyName<?> propName : this._itemMap.keySet()) {
                    PropertyRequest propRequest = this._itemMap.get(propName);
                    this._itemArray[i++] = propName.nest(propRequest);
                }
            }
            return this._itemArray;
        }

        public boolean isEmpty() {
            return this.toMap().isEmpty();
        }

        public int size() {
            return this.toMap().size();
        }

        public PropertyRequest get(PropertyNameList.PropertyName<?> key) {
            return this.toMap().get(key);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            return this.toMap().entrySet().equals(((PropertyRequest)object).toMap().entrySet());
        }

        public int hashCode() {
            return this.toMap().hashCode();
        }

        public String toString() {
            StringBuffer builder = new StringBuffer();
            NestedPropertyName<?>[] items = this.toArray();
            builder.append('[');
            int i = 0;
            while (i < items.length) {
                if (builder.length() > 1) {
                    builder.append(", ");
                }
                builder.append(items[i].toString());
                ++i;
            }
            builder.append(']');
            return builder.toString();
        }

        @Override
        public PropertyRequest getPropertyRequestForModified() {
            return null;
        }

        @Override
        public PropertyRequest getPropertyRequestForResult() {
            return this;
        }

        @Override
        public void abortRequested(boolean isAbortRequested) {
        }

        @Override
        public boolean isAbortRequested() {
            return false;
        }

        @Override
        public Feedback nest() {
            return EMPTY;
        }

        @Override
        public Feedback nest(PropertyRequest propertyRequest) {
            return propertyRequest;
        }

        @Override
        public Feedback nest(int percentCompleted) {
            return EMPTY;
        }

        @Override
        public Feedback nest(PropertyRequest resultPropertyRequest, int percentCompleted) {
            return resultPropertyRequest;
        }

        @Override
        public String format(String fmt, Object ... arguments) {
            return MessageFormat.format(fmt, arguments);
        }

        @Override
        public void notifyActive(String message) {
        }

        @Override
        public void notifyCompleted(String message) {
        }

        @Override
        public void notifyWarning(String message) {
        }

        @Override
        public void notifyIsModified(Resource resource) {
        }

        @Override
        public void notifyPercentComplete(int percentComplete) {
        }
    }
}

