/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models;

import com.google.common.collect.Sets;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.internal.mapper.ObjectMapperType;
import com.jayway.restassured.response.Response;
import com.urbancode.release.rest.framework.ClientDescribed;
import com.urbancode.release.rest.framework.JsonReadOnly;
import java.util.Set;

public class Role
extends ClientDescribed<Role> {
    public static final Role ADMIN = (Role)new Role().id("00000000-0000-0000-0000-000000000003");
    public static final Role RELEASE_MANAGER = (Role)new Role().id("00000000-0000-0000-0000-000000000004");
    public static final Role OBSERVER = (Role)new Role().id("00000000-0000-0000-0000-000000000005");
    public static final Role DEVELOPMENT_MANAGER = (Role)new Role().id("00000000-0000-0000-0000-000000000301");
    public static final Role QA_MANAGER = (Role)new Role().id("00000000-0000-0000-0000-000000000302");
    public static final Role PARTICIPANT = (Role)new Role().id("00000000-0000-0000-0000-000000000303");
    public Action[] actions;
    @Deprecated
    @JsonReadOnly
    public Boolean enabled;

    public Role() {
        this.path = "/roles/";
    }

    public Action[] getActions() {
        return this.actions;
    }

    public Role setActions(Action ... actions) {
        return this.actions(actions);
    }

    public Role actions(Action ... actions) {
        this.actions = actions;
        return this;
    }

    public Action[] getAllActions() {
        return ((Response)RestAssured.given().get(this.path() + "actions", new Object[0])).as(Action[].class, ObjectMapperType.GSON);
    }

    public Set<Action> getActionSet() {
        if (this.actions == null) {
            return Sets.newHashSet();
        }
        return Sets.newHashSet(this.actions);
    }

    public Role addAction(Action action) {
        Set<Action> actions = this.getActionSet();
        actions.add(action);
        return this.actions(actions.toArray(new Action[actions.size()]));
    }

    public Role removeAction(Action action) {
        Set<Action> actions = this.getActionSet();
        actions.remove(action);
        return this.actions(actions.toArray(new Action[actions.size()]));
    }

    public static class Action
    extends ClientDescribed<Action> {
        public static final Action EDIT_APPLICATION = (Action)new Action().id("00000000-0000-0000-0000-000000000088");
        public static final Action EDIT_STATUS_COMMENTS_ATTACHMENTS = (Action)new Action().id("00000000-0000-0000-0000-000000000205");
        public static final Action VIEW_RELEASE = (Action)new Action().id("00000000-0000-0000-0000-000000000005");
        public static final Action EDIT_RELEASE = (Action)new Action().id("00000000-0000-0000-0000-000000000006");
        public static final Action EDIT_SEGMENTS = (Action)new Action().id("00000000-0000-0000-0000-000000000007");
        public static final Action OVERRIDE_TASK_STATE = (Action)new Action().id("00000000-0000-0000-0000-000000000202");
        public static final Action EXEMPT_GATES = (Action)new Action().id("00000000-0000-0000-0000-000000000203");
        public static final Action EDIT_LIFECYCLE = (Action)new Action().id("00000000-0000-0000-0000-000000000204");
        public static final Action EDIT_STATUS = (Action)new Action().id("00000000-0000-0000-0000-000000000201");
        public static final Action EDIT_ENTERPRISE_EVENT = (Action)new Action().id("00000000-0000-0000-0000-000000001206");
        public static final Action EDIT_INITIATIVES = (Action)new Action().id("00000000-0000-0000-0000-000000000207");
        public static final Action EDIT_ENVIRONMENTS = (Action)new Action().id("00000000-0000-0000-0000-000000000206");
        public static final Action EDIT_ACTIVITIES = (Action)new Action().id("00000000-0000-0000-0000-000000000209");
        public static final Action SECURITY_ADMIN = (Action)new Action().id("00000000-0000-0000-0000-000000000001");
        public static final Action USER_ADMIN = (Action)new Action().id("00000000-0000-0000-0000-000000000002");
        public static final Action ROLE_ADMIN = (Action)new Action().id("00000000-0000-0000-0000-000000000003");
        public static final Action TEAM_ADMIN = (Action)new Action().id("00000000-0000-0000-0000-000000000004");
        public static final Action INTEGRATION_ADMIN = (Action)new Action().id("00000000-0000-0000-0000-000000000208");
        public static final Action MANUAL_QA_PASS = (Action)new Action().id("00000000-0000-0000-0000-000000000101");
        public static final Action QA_MANAGER_REVIEW_PASS = (Action)new Action().id("00000000-0000-0000-0000-000000000102");
        public static final Action UNIT_TESTS_PASS = (Action)new Action().id("00000000-0000-0000-0000-000000000103");
        public String resourceType;

        public String getResourceType() {
            return this.resourceType;
        }

        public Action setResourceType(String resourceType) {
            return this.resourceType(resourceType);
        }

        public Action resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }
    }
}

