/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ri.repo;

import com.ibm.rational.wvcm.ri.impl.BaselineImpl;
import com.ibm.rational.wvcm.ri.repo.RiRepo;
import com.ibm.rational.wvcm.ri.repo.RiRepoActivity;
import com.ibm.rational.wvcm.ri.repo.RiRepoComponent;
import com.ibm.rational.wvcm.ri.repo.RiRepoControllableFolder;
import com.ibm.rational.wvcm.ri.repo.RiRepoControllableResource;
import com.ibm.rational.wvcm.ri.repo.RiRepoFolderVersion;
import com.ibm.rational.wvcm.ri.repo.RiRepoResource;
import com.ibm.rational.wvcm.ri.repo.RiRepoStream;
import com.ibm.rational.wvcm.ri.repo.RiRepoVersion;
import com.ibm.rational.wvcm.ri.repo.RiRepoVersionHistory;
import com.ibm.rational.wvcm.ri.repo.RiRepoWorkspace;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcProvider;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wvcm.Baseline;
import javax.wvcm.ControllableResource;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Version;
import javax.wvcm.VersionSet;
import javax.wvcm.WorkspaceProvider;
import javax.wvcm.WvcmException;

public class RiRepoBaseline
extends RiRepoVersion {
    protected Map<RiRepoVersionHistory, RiRepoVersion> versionMap;

    @Override
    public Class<?> get_proxyClass() {
        return BaselineImpl.class;
    }

    protected RiRepoBaseline(RiRepoResource parent, String bindingName, SrvcProvider provider, RiRepo repo) {
        super(parent, bindingName, provider, repo);
        this.initialize();
    }

    private void initialize() {
        this.createProperty(Baseline.VERSION_LIST, null);
        this.createProperty(Baseline.SUB_BASELINE_LIST, null);
    }

    @Override
    protected void postSetPropertyEx(PropertyNameList.PropertyName<?> propertyName, Object oldValue, Object value) {
        super.postSetPropertyEx(propertyName, oldValue, value);
        if (propertyName.equals((Object)Baseline.VERSION_LIST)) {
            RiRepoVersion version = (RiRepoVersion)oldValue;
            if (version != null) {
                version.setProperty_RemoveFromList(Version.IN_BASELINE_LIST, this);
            }
            if ((version = (RiRepoVersion)value) != null) {
                version.setProperty_AppendUniqueToList(Version.IN_BASELINE_LIST, this);
            }
        }
    }

    public void recursivelySetBaselineControlledFolderMembers(RiRepoControllableResource resource, SrvcFeedback feedback) throws WvcmException {
        RiRepoVersion newVersion;
        RiRepoBaseline bl = this;
        RiRepoVersion oldVersion = resource.getCheckedIn();
        if (oldVersion != (newVersion = bl.getVersion(oldVersion.getVersionHistory()))) {
            RiRepoControllableResource.copyVersionToVCR(newVersion, resource);
            resource.setPropertyEx(ControllableResource.CHECKED_IN, newVersion);
            if (feedback != null) {
                feedback.notifyIsModified(resource);
            }
        }
        if (oldVersion instanceof RiRepoFolderVersion) {
            RiRepoControllableFolder folder = (RiRepoControllableFolder)resource;
            RiRepoFolderVersion oldFolderVersion = (RiRepoFolderVersion)oldVersion;
            RiRepoFolderVersion newFolderVersion = (RiRepoFolderVersion)newVersion;
            folder.updateVersionControlledFolderMembers(oldFolderVersion, newFolderVersion, bl, feedback);
            Map<String, RiRepoResource> childMap = folder.getChildMap();
            for (String name : childMap.keySet()) {
                RiRepoControllableResource child = (RiRepoControllableResource)childMap.get(name);
                this.recursivelySetBaselineControlledFolderMembers(child, feedback);
            }
        }
    }

    public RiRepoControllableResource setBaselineControlledFolderMember(RiRepoWorkspace ws, RiRepoVersion blVer, SrvcFeedback feedback) throws WvcmException {
        RiRepoVersionHistory vh = blVer.getVersionHistory();
        RiRepoControllableResource resource = ws.locateByHistoryReport(vh);
        if (resource == null) {
            RiRepoVersionHistory parentVH = blVer.getParentVersionHistory(feedback);
            RiRepoControllableFolder parent = (RiRepoControllableFolder)this.setBaselineControlledFolderMember(ws, this.getVersion(parentVH), feedback);
            return parent.updateAdded(ws, vh, blVer, blVer.getBindingName(feedback), feedback);
        }
        if (resource.getCheckedIn() != this.getVersion(vh)) {
            RiRepoControllableResource.copyVersionToVCR(blVer, resource);
            resource.setPropertyEx(ControllableResource.CHECKED_IN, blVer);
            if (feedback != null) {
                feedback.notifyIsModified(resource);
            }
        }
        return resource;
    }

    public static void pruneControlledFolderMembers(RiRepoControllableFolder folder, Set<RiRepoVersionHistory> vhSet, SrvcFeedback feedback) throws WvcmException {
        Map<String, RiRepoResource> childMap = folder.getChildMap();
        for (String bindingName : childMap.keySet()) {
            RiRepoControllableResource child = (RiRepoControllableResource)childMap.get(bindingName);
            if (vhSet.contains(child.getVersionHistory())) {
                if (!(child instanceof RiRepoControllableFolder)) continue;
                RiRepoControllableFolder childFolder = (RiRepoControllableFolder)child;
                RiRepoBaseline.pruneControlledFolderMembers(childFolder, vhSet, feedback);
                continue;
            }
            folder.doUnbindChild(bindingName, feedback);
        }
    }

    public void setBaselineControlledFolderMembers(RiRepoControllableFolder rootFolder, SrvcFeedback feedback) throws WvcmException {
        if (this.versionKnowsParent()) {
            List<RiRepoVersion> versions = this.getVersionList();
            for (RiRepoVersion blVer : versions) {
                this.setBaselineControlledFolderMember(rootFolder.getWorkspace(), blVer, feedback);
            }
            RiRepoBaseline.pruneControlledFolderMembers(rootFolder, this.getVersionMap().keySet(), feedback);
        } else {
            this.recursivelySetBaselineControlledFolderMembers(rootFolder, feedback);
        }
    }

    public RiRepoVersion getVersion(RiRepoVersionHistory versionHistory) {
        return this.getVersionMap().get(versionHistory);
    }

    @Override
    public Map<RiRepoVersionHistory, RiRepoVersion> getVersionMap() {
        if (this.versionMap == null) {
            this.versionMap = this.getVersionMapImpl();
        }
        return this.versionMap;
    }

    public RiRepoFolderVersion getRootVersion() {
        RiRepoComponent component = (RiRepoComponent)this.getVersionHistory();
        return (RiRepoFolderVersion)this.getVersion(component.getComponentRoot());
    }

    protected static List<SrvcResource.SrvcCompareReport> compareVersions(WorkspaceProvider provider, Map<RiRepoVersionHistory, RiRepoVersion> vhMapOld, Map<RiRepoVersionHistory, RiRepoVersion> vhMapNew, boolean isActivityCompare, boolean newOnly) throws WvcmException {
        RiRepoVersion versionNew;
        ArrayList<SrvcResource.SrvcCompareReport> report = new ArrayList<SrvcResource.SrvcCompareReport>();
        HashSet<RiRepoVersion> oldActivityVersions = new HashSet<RiRepoVersion>();
        HashSet<RiRepoVersion> newActivityVersions = new HashSet<RiRepoVersion>();
        HashSet<RiRepoActivity> activities = new HashSet<RiRepoActivity>();
        Set<RiRepoVersionHistory> oldKeys = vhMapOld.keySet();
        for (RiRepoVersionHistory key : oldKeys) {
            RiRepoVersion versionOld = vhMapOld.get(key);
            versionNew = vhMapNew.get(key);
            if (versionNew == null) {
                if (versionOld.versionKnowsParent() || !newOnly) {
                    report.add(new SrvcResource.SrvcDeletedVersion(versionOld));
                }
                if (!isActivityCompare) continue;
                RiRepoBaseline.addActivityCompare(activities, oldActivityVersions, newActivityVersions, versionOld, null);
                continue;
            }
            if (versionOld == versionNew) continue;
            if (newOnly) {
                report.add(new SrvcResource.SrvcAddedVersion(versionNew));
            } else {
                report.add(new SrvcResource.SrvcChangedVersion(versionOld, versionNew));
            }
            if (!isActivityCompare) continue;
            RiRepoBaseline.addActivityCompare(activities, oldActivityVersions, newActivityVersions, versionOld, versionNew);
        }
        Set<RiRepoVersionHistory> newKeys = vhMapNew.keySet();
        for (RiRepoVersionHistory key : newKeys) {
            if (vhMapOld.get(key) != null) continue;
            versionNew = vhMapNew.get(key);
            report.add(new SrvcResource.SrvcAddedVersion(versionNew));
            if (!isActivityCompare) continue;
            RiRepoBaseline.addActivityCompare(activities, oldActivityVersions, newActivityVersions, null, versionNew);
        }
        if (isActivityCompare) {
            RiRepoBaseline.doActivityCompare(report, activities, oldActivityVersions, newActivityVersions);
        }
        return report;
    }

    private static void addActivityCompare(Set<RiRepoActivity> activities, Set<RiRepoVersion> oldActivityVersions, Set<RiRepoVersion> newActivityVersions, RiRepoVersion versionOld, RiRepoVersion versionNew) {
        ArrayList<RiRepoVersion> oldPreds = new ArrayList<RiRepoVersion>();
        if (versionOld != null) {
            RiRepoBaseline.addPreds(oldPreds, versionOld);
        }
        ArrayList<RiRepoVersion> newPreds = new ArrayList<RiRepoVersion>();
        if (versionNew != null) {
            RiRepoBaseline.addPreds(newPreds, versionNew);
        }
        HashSet<RiRepoVersion> oldPredsDiff = new HashSet<RiRepoVersion>();
        oldPredsDiff.addAll(oldPreds);
        oldPredsDiff.removeAll(newPreds);
        Iterator oldVers = oldPredsDiff.iterator();
        while (oldVers.hasNext()) {
            activities.add(((RiRepoVersion)oldVers.next()).getActivity());
        }
        oldActivityVersions.addAll(oldPredsDiff);
        HashSet<RiRepoVersion> newPredsDiff = new HashSet<RiRepoVersion>();
        newPredsDiff.addAll(newPreds);
        newPredsDiff.removeAll(oldPreds);
        Iterator newVers = newPredsDiff.iterator();
        while (newVers.hasNext()) {
            activities.add(((RiRepoVersion)newVers.next()).getActivity());
        }
        newActivityVersions.addAll(newPredsDiff);
    }

    private static void addPreds(List<RiRepoVersion> predecessors, RiRepoVersion version) {
        predecessors.add(version);
        List<RiRepoVersion> directPreds = version.getPredecessorList();
        int i = 0;
        while (i < directPreds.size()) {
            RiRepoBaseline.addPreds(predecessors, directPreds.get(i));
            ++i;
        }
    }

    private static void doActivityCompare(List<SrvcResource.SrvcCompareReport> report, Set<RiRepoActivity> activities, Set<RiRepoVersion> oldActivityVersions, Set<RiRepoVersion> newActivityVersions) throws WvcmException {
        for (RiRepoActivity act : activities) {
            if (act == null) continue;
            List<RiRepoVersion> actVersions = act.getActivityVersionList();
            if (oldActivityVersions.containsAll(actVersions)) {
                report.add(new SrvcResource.SrvcDeletedActivity(act));
                continue;
            }
            if (newActivityVersions.containsAll(actVersions)) {
                report.add(new SrvcResource.SrvcAddedActivity(act));
                continue;
            }
            boolean inOld = false;
            boolean inNew = false;
            int j = 0;
            while (j < actVersions.size()) {
                RiRepoVersion v = actVersions.get(j);
                if (oldActivityVersions.contains(v)) {
                    inOld = true;
                } else if (newActivityVersions.contains(v)) {
                    inNew = true;
                }
                ++j;
            }
            if (inOld && inNew) {
                report.add(new SrvcResource.SrvcChangedActivity(act));
                continue;
            }
            if (inOld) {
                report.add(new SrvcResource.SrvcPartiallyDeletedActivity(act));
                continue;
            }
            if (!inNew) continue;
            report.add(new SrvcResource.SrvcPartiallyAddedActivity(act));
        }
    }

    @Override
    protected RiRepoVersion locateByHistory(SrvcResource versionHistory, SrvcFeedback feedback) throws WvcmException {
        return this.getVersionMap().get(versionHistory);
    }

    @Override
    public Map<String, SrvcResource> getFolderVersionChildMap(SrvcResource folderVersion, SrvcFeedback feedback) throws WvcmException {
        if (!this.versionKnowsParent()) {
            throw new IllegalStateException("No need to compute folder versions children");
        }
        if (!(folderVersion instanceof RiRepoVersion)) {
            throw new RuntimeException("getChildMap expects a folder version history argument");
        }
        RiRepoFolderVersion parentVersion = (RiRepoFolderVersion)folderVersion;
        RiRepoVersionHistory parentVH = parentVersion.getVersionHistory();
        HashMap<String, SrvcResource> result = new HashMap<String, SrvcResource>();
        for (RiRepoVersion v : this.getVersionList()) {
            if (v.getParentVersionHistory(feedback) != parentVH) continue;
            result.put(v.getBindingName(feedback), v.getVersionHistory());
        }
        return result;
    }

    @Override
    public List<SrvcResource> getFolderVersionChildList(SrvcResource folderVersion, SrvcFeedback feedback) throws WvcmException {
        if (!this.versionKnowsParent()) {
            throw new IllegalStateException("No need to compute folder versions children");
        }
        if (!(folderVersion instanceof RiRepoVersion)) {
            throw new RuntimeException("getChildMap expects a folder version history argument");
        }
        RiRepoFolderVersion parentVersion = (RiRepoFolderVersion)folderVersion;
        RiRepoVersionHistory parentVH = parentVersion.getVersionHistory();
        ArrayList<SrvcResource> result = new ArrayList<SrvcResource>();
        for (RiRepoVersion v : this.getVersionList()) {
            if (v.getParentVersionHistory(feedback) != parentVH) continue;
            result.add(v.getVersionHistory());
        }
        return result;
    }

    @Override
    public List<SrvcResource.SrvcCompareReport> doCompareReport(SrvcResource newResource, VersionSet.CompareFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        RiRepoResource resource = (RiRepoResource)newResource;
        if (resource == null) {
            throw new WvcmException("BAD_ARGUMENT_TYPE", WvcmException.ReasonCode.BAD_ARGUMENT_TYPE);
        }
        if (!(resource instanceof RiRepoBaseline || resource instanceof RiRepoStream || resource instanceof RiRepoWorkspace)) {
            throw new WvcmException("BAD_ARGUMENT_TYPE", WvcmException.ReasonCode.BAD_ARGUMENT_TYPE);
        }
        boolean isActivityCompare = false;
        boolean newOnly = false;
        if (flags != null) {
            int i = 0;
            while (i < flags.length) {
                if (flags[i] == VersionSet.CompareFlag.ACTIVITIES) {
                    isActivityCompare = true;
                } else if (flags[i] == VersionSet.CompareFlag.NEW_ONLY) {
                    newOnly = true;
                } else {
                    throw new WvcmException("Compare flag not supported: " + flags[i].toString(), WvcmException.ReasonCode.BAD_ARGUMENT_TYPE);
                }
                ++i;
            }
        }
        Map<RiRepoVersionHistory, RiRepoVersion> resourceVersionMap = null;
        resourceVersionMap = resource instanceof RiRepoStream ? ((RiRepoStream)resource).getVersionMap(this.getVersionHistory()) : (resource instanceof RiRepoWorkspace ? ((RiRepoWorkspace)resource).getVersionMap(this.getVersionHistory()) : resource.getVersionMap());
        List<SrvcResource.SrvcCompareReport> results = RiRepoBaseline.compareVersions(this.provider(), this.getVersionMap(), resourceVersionMap, isActivityCompare, newOnly);
        return results;
    }

    @Override
    public List<RiRepoVersion> getVersionList() {
        return this.getListProperty(Baseline.VERSION_LIST);
    }
}

