/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal;

import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProcessAttachment;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IAuditableCommonProcess;
import com.ibm.team.workitem.common.internal.util.CacheHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class ProcessScriptsManager
extends CacheHelper {
    private static Map<UUID, Map<String, IProcessAttachment>> fProcessScripts = new HashMap<UUID, Map<String, IProcessAttachment>>();
    public static final String PROVIDERS_CONFIGURATION_DATA_POINT = "com.ibm.team.workitem.configuration.providers";

    public ProcessScriptsManager(IAuditableCommon auditableCommon) {
        super(auditableCommon);
    }

    @Override
    protected void updateCache(IProjectAreaHandle projectAreaHandle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        HashMap<String, IProcessAttachment> scripts = this.fetchScripts(projectAreaHandle, monitor);
        fProcessScripts.put(projectAreaHandle.getItemId(), scripts);
    }

    private HashMap<String, IProcessAttachment> fetchScripts(IProjectAreaHandle projectAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessAttachment[] attachments;
        IAuditableCommonProcess processArea = this.getAuditableCommon().getProcess((IProcessAreaHandle)projectAreaHandle, monitor);
        HashMap<String, IProcessAttachment> scripts = new HashMap<String, IProcessAttachment>();
        IProcessAttachment[] iProcessAttachmentArray = attachments = processArea.getProcessAttachments(monitor);
        int n = attachments.length;
        int n2 = 0;
        while (n2 < n) {
            IProcessAttachment attachment = iProcessAttachmentArray[n2];
            if (attachment.getPath().startsWith("/workitem/scripts/common/")) {
                String scriptName = attachment.getPath().substring("/workitem/scripts/common/".length());
                scripts.put(scriptName, attachment);
            }
            ++n2;
        }
        return scripts;
    }

    public IProcessAttachment getProcessScript(IProjectAreaHandle projectArea, String scriptName, IProgressMonitor monitor) throws TeamRepositoryException {
        this.checkCache(projectArea, monitor);
        Map<String, IProcessAttachment> scripts = fProcessScripts.get(projectArea.getItemId());
        if (scripts != null) {
            return scripts.get(scriptName);
        }
        return null;
    }

    public Collection<IProcessAttachment> getProcessScripts(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        this.checkCache(projectArea, monitor);
        Map<String, IProcessAttachment> scripts = fProcessScripts.get(projectArea.getItemId());
        if (scripts != null) {
            return scripts.values();
        }
        return Collections.emptyList();
    }
}

