/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.emailtemplates;

import com.ibm.team.repository.common.IContributor;
import com.ibm.team.workitem.common.internal.model.DefaultModel;
import java.util.Set;

public class Recipient {
    private String fId;
    private String fName;
    private Relation fRelation;
    private String fMail;
    private boolean fPrefersHtmlFormat;
    private boolean fIsValid = true;

    public Recipient(String id, String name, String email, Relation relation, boolean preferHtmlFormat) {
        this.fId = id;
        this.fName = name;
        this.fRelation = relation;
        this.fMail = email;
        this.fPrefersHtmlFormat = preferHtmlFormat;
    }

    public static Recipient createFromContributor(IContributor contributor, Relation relation, boolean preferHtmlFormat) {
        if (contributor == null) {
            throw new IllegalArgumentException("Invalid Contributor");
        }
        String id = contributor.getItemId().getUuidValue();
        String emailAddress = contributor.getEmailAddress().trim();
        String name = contributor.getName();
        Recipient recipient = new Recipient(id, name, emailAddress, relation, preferHtmlFormat);
        recipient.fIsValid = !contributor.isArchived() && !contributor.getItemId().equals((Object)DefaultModel.NULL_CONTRIBUTOR_ITEM_ID) && recipient.hasValidEmailAddress();
        return recipient;
    }

    public String getId() {
        return this.fId;
    }

    public Relation getRelation() {
        return this.fRelation;
    }

    public String getName() {
        return this.fName;
    }

    public String getEmailAddress() {
        return this.fMail;
    }

    public boolean isValid() {
        return this.fIsValid;
    }

    public boolean hasValidEmailAddress() {
        return this.fMail.length() > 2 && this.fMail.contains("@");
    }

    public void addToSetIfValid(Set<Recipient> set) {
        if (this.fIsValid) {
            set.add(this);
        }
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Recipient) {
            return this.fId.equals(((Recipient)other).fId);
        }
        return false;
    }

    public int hashCode() {
        return this.fId.hashCode();
    }

    public boolean prefersHtmlFormat() {
        return this.fPrefersHtmlFormat;
    }

    public void setId(String id) {
        this.fId = id;
    }

    public void setName(String name) {
        this.fName = name;
    }

    public void setRelation(Relation relation) {
        this.fRelation = relation;
    }

    public void setMail(String mail) {
        this.fMail = mail;
    }

    public void setPrefersHtmlFormat(boolean prefersHtmlFormat) {
        this.fPrefersHtmlFormat = prefersHtmlFormat;
    }

    public void setIsValid(boolean isValid) {
        this.fIsValid = isValid;
    }

    public static enum Relation {
        UNKNOWN("unknown"),
        CONSUMER("consumer"),
        MODIFIER("modifier"),
        SUBSCRIBER("subscriber"),
        CREATOR("creator"),
        OWNER("owner");

        private final String fIdentifier;

        private Relation(String name) {
            this.fIdentifier = name;
        }

        public String getIdentifier() {
            return this.fIdentifier;
        }
    }
}

