/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.oslc.mappings;

import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.workitem.common.internal.oslc.mappings.AbstractVersionedDescriptor;
import com.ibm.team.workitem.common.internal.oslc.mappings.AttributeTypeMapping;
import com.ibm.team.workitem.common.internal.oslc.mappings.IAttributeDescriptor;
import com.ibm.team.workitem.common.model.WorkItemLinkTypes;
import org.eclipse.core.runtime.Assert;

public class LinkAttributeDescriptor
extends AbstractVersionedDescriptor
implements IAttributeDescriptor {
    private final IEndPointDescriptor fEndPoint;
    private final String fOwnerType;
    private final String fAttributeType;
    private final String fInternalId;
    private final boolean fInline;
    private final boolean fIsCollection;
    private final String fDescription;

    public LinkAttributeDescriptor(String ownerType, String internalId, IEndPointDescriptor endPoint, boolean inline, boolean isSingleValued, String description) {
        Assert.isNotNull((Object)endPoint);
        this.fOwnerType = ownerType;
        this.fEndPoint = endPoint;
        this.fAttributeType = AttributeTypeMapping.getAttributeType(endPoint);
        this.fInternalId = internalId;
        this.fInline = inline;
        this.fIsCollection = !isSingleValued;
        this.fDescription = description;
    }

    public IEndPointDescriptor getEndPointDescriptor() {
        return this.fEndPoint;
    }

    @Override
    public String getDeclaringType() {
        return this.fOwnerType;
    }

    @Override
    public String getAttributeType() {
        return this.fAttributeType;
    }

    @Override
    public String getDisplayName() {
        return this.fEndPoint.getDisplayName();
    }

    @Override
    public String getDescription() {
        return this.fDescription;
    }

    @Override
    public String getInternalIdentifier() {
        return this.fInternalId;
    }

    @Override
    public boolean isReadOnly() {
        return WorkItemLinkTypes.isUserWritable(this.fEndPoint);
    }

    @Override
    public int getMinOccurs() {
        return 0;
    }

    @Override
    public int getMaxOccurs() {
        return this.isCollection() ? -1 : 1;
    }

    @Override
    public boolean isCollection() {
        return this.fIsCollection;
    }

    @Override
    public boolean isInlined() {
        return this.fInline;
    }

    @Override
    public String getRepresentation() {
        return null;
    }

    @Override
    public Boolean getMemberProperty() {
        return null;
    }

    public String toString() {
        return "LinkAttributeDescriptor [oslcId=" + this.getPublicIdentifier() + ", Namespace=" + this.getNamespace() + ", EndPoint=" + this.fEndPoint.getId() + "]";
    }
}

