/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import com.ibm.team.repository.common.IItemHandle;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class ItemHandleHashSet<H extends IItemHandle>
extends AbstractSet<H> {
    private final HashSet<Entry<H>> fBaseSet = new HashSet();
    private boolean fIsHashCodeInitialized = false;
    private int fHashCode;

    public ItemHandleHashSet() {
    }

    public ItemHandleHashSet(Collection<H> collection) {
        this.addAll(collection);
    }

    @Override
    public int hashCode() {
        if (!this.fIsHashCodeInitialized) {
            this.fIsHashCodeInitialized = true;
            this.fHashCode = 1;
            for (IItemHandle next : this) {
                if (next == null) continue;
                this.fHashCode += next.getItemId().hashCode();
            }
        }
        return this.fHashCode;
    }

    @Override
    public boolean add(H e) {
        boolean added = this.fBaseSet.add(new Entry<H>(e));
        if (added) {
            this.fIsHashCodeInitialized = false;
        }
        return added;
    }

    @Override
    public void clear() {
        this.fBaseSet.clear();
        this.fIsHashCodeInitialized = false;
    }

    @Override
    public boolean contains(Object o) {
        if (o != null && !(o instanceof IItemHandle)) {
            return false;
        }
        return this.fBaseSet.contains(new Entry<IItemHandle>((IItemHandle)o));
    }

    @Override
    public boolean remove(Object o) {
        if (o != null && !(o instanceof IItemHandle)) {
            return false;
        }
        boolean removed = this.fBaseSet.remove(new Entry<IItemHandle>((IItemHandle)o));
        if (removed) {
            this.fIsHashCodeInitialized = false;
        }
        return removed;
    }

    @Override
    public int size() {
        return this.fBaseSet.size();
    }

    @Override
    public Iterator<H> iterator() {
        return new Iterator<H>(){
            Iterator<Entry<H>> fBaseIterator;
            {
                this.fBaseIterator = ItemHandleHashSet.this.fBaseSet.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.fBaseIterator.hasNext();
            }

            @Override
            public H next() {
                return this.fBaseIterator.next().fHandle;
            }

            @Override
            public void remove() {
                this.fBaseIterator.remove();
            }
        };
    }

    private static class Entry<H extends IItemHandle> {
        H fHandle;

        public Entry(H handle) {
            this.fHandle = handle;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Entry)) {
                throw new AssertionError();
            }
            H otherHandle = ((Entry)o).fHandle;
            if (otherHandle == null || this.fHandle == null) {
                return !(this.fHandle == null ^ otherHandle == null);
            }
            return this.fHandle.sameItemId(otherHandle);
        }

        public int hashCode() {
            return this.fHandle != null ? this.fHandle.getItemId().hashCode() : 0;
        }
    }
}

