/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ct;

import com.ibm.rational.wvcm.ct.CCaseElemInfo;
import com.ibm.rational.wvcm.ct.CCaseLib;
import com.ibm.rational.wvcm.ct.CCaseObjInfo;
import com.ibm.rational.wvcm.ct.CCaseVerInfo;
import com.ibm.rational.wvcm.ct.CTBaseCCView;
import com.ibm.rational.wvcm.ct.CTFolder;
import com.ibm.rational.wvcm.ct.CTLocation;
import com.ibm.rational.wvcm.ct.CTProvider;
import com.ibm.rational.wvcm.ct.CTResource;
import com.ibm.rational.wvcm.ct.CTVersion;
import com.ibm.rational.wvcm.ct.CTView;
import com.ibm.rational.wvcm.ct.CommonUtils;
import com.ibm.rational.wvcm.ct.ObjSelUtils;
import com.ibm.rational.wvcm.interop.InteropUtilities;
import com.ibm.rational.wvcm.ri.impl.VersionHistoryImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.wvcm.ControllableResource;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.VersionHistory;
import javax.wvcm.WvcmException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class CTElement
extends CTFolder {
    private static final String FILE_ENCODING = "file.encoding";
    public static Comparator<String> verComp = new VersionComparator();
    final CCaseLib cc;
    private ElementTypeInfo _elementTypeInfo = null;
    public static final Pattern CONTENT_THEN_LABEL_INFO = Pattern.compile("(.+?) \\(.+?\\)$");

    CTElement(Location location, CTProvider provider) {
        super(location, provider);
        this.cc = provider.getCCaseLib();
    }

    @Override
    public Class<?> get_proxyClass() {
        return VersionHistoryImpl.class;
    }

    @Override
    public boolean isImmutable() throws WvcmException {
        return !this.getObjInfo(null).getMtype().equals("symbolic link");
    }

    @Override
    protected Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Resource.RESOURCE_IDENTIFIER)) {
            CTLocation myLoc = this.location();
            if (this.lookupBaseCcSubVobcomponentLoc(myLoc) != null) {
                return myLoc.string();
            }
            return super.getThisProperty(propertyName, configuration, feedback);
        }
        if (propertyName.equals((Object)VersionHistory.ROOT_VERSION)) {
            return this.getRootVersion(feedback);
        }
        if (propertyName.equals((Object)Resource.CONTENT_TYPE)) {
            return this.getContentType(feedback);
        }
        if (propertyName.equals((Object)Resource.CONTENT_CHARACTER_SET)) {
            return this.lookupCharacterSet(feedback);
        }
        if (propertyName.equals((Object)InteropUtilities.PN_LINE_SEPARATOR)) {
            return this.lookupLineSeparator(feedback);
        }
        if (propertyName.equals((Object)ControllableResource.IS_EXECUTABLE)) {
            return this.getIsExecutable(feedback);
        }
        if (propertyName.equals((Object)VersionHistory.CHILD_LIST)) {
            if (this.getObjInfo(feedback).isDirectory()) {
                return null;
            }
            return this.getVersionTree(feedback);
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    protected CTLocation lookupBaseCcSubVobcomponentLoc(CTLocation myLoc) throws WvcmException {
        CTLocation baseCcSubVobComponentLoc = CTLocation.Kind.ELEMENT_IN_SVC.equals((Object)myLoc.getKind()) ? myLoc.getContextLocation(CTLocation.Kind.VOBCOMPONENT) : null;
        return baseCcSubVobComponentLoc;
    }

    private boolean getIsExecutable(SrvcFeedback feedback) throws WvcmException {
        boolean result;
        CCaseObjInfo info = this.getObjInfo(feedback);
        if (info instanceof CCaseElemInfo) {
            CCaseElemInfo elemInfo = (CCaseElemInfo)info;
            result = CCaseLib.isExecutable(elemInfo.getPermissions());
        } else {
            result = this.cc.getExecutePermission(info.getUniversalSelector(), feedback);
        }
        return result;
    }

    public CTLocation lookupMyControllableResourceLoc(CTView view, SrvcFeedback feedback) throws WvcmException {
        String myID = this.location().getDisplayName();
        String gpath = this.cc.gpath(myID, view.getViewTag(), feedback);
        return CTElement.gpathToCrLoc(gpath);
    }

    public static CTLocation gpathToCrLoc(String gpath) {
        if (gpath == null) {
            return null;
        }
        String versionPath = ObjSelUtils.stripTrailingElementSuffix(gpath);
        String[] gpathSegments = gpath.split(CommonUtils.FWDSLASH);
        if (gpathSegments.length < 4 || gpathSegments[gpathSegments.length - 2].equals("lost+found")) {
            return null;
        }
        CTLocation result = null;
        if (!versionPath.contains("@@")) {
            result = CTLocation.valueOf(CTLocation.Kind.CONTROLLABLE_RESOURCE, versionPath);
        }
        return result;
    }

    public CTVersion getRootVersion(SrvcFeedback feedback) throws WvcmException {
        CTLocation myLoc = this.location();
        CTLocation baseCcSubVobComponentLoc = CTLocation.Kind.ELEMENT_IN_SVC.equals((Object)this._location.getKind()) ? myLoc.getContextLocation(CTLocation.Kind.VOBCOMPONENT) : null;
        String elementSel = myLoc.getDisplayName();
        String elementGpath = this.cc.gpath(elementSel, null, feedback);
        CTVersion ver = null;
        CTLocation rootVerLoc = null;
        if (!ObjSelUtils.getObjSelKind(elementSel).equals("oid") || !elementGpath.equals(ObjSelUtils.getObjSelName(elementSel))) {
            String vobTag = this.cc.getVobTagFromGpath(elementGpath, feedback);
            String mainZeroSuffix = String.valueOf(CommonUtils.FWDSLASH) + this.cc.getMainBranchName(vobTag, feedback) + "/0";
            rootVerLoc = CTLocation.valueOf(CTLocation.Kind.VERSION, String.valueOf(elementGpath) + mainZeroSuffix);
            if (baseCcSubVobComponentLoc != null) {
                rootVerLoc = CTLocation.createJoinedLocation(CTLocation.Kind.VERSION_IN_SVC, rootVerLoc.getDisplayName(), rootVerLoc, baseCcSubVobComponentLoc);
            }
            ver = (CTVersion)this.provider().lookup((Location)rootVerLoc, feedback);
        }
        if (ver == null && this.getObjInfo(feedback).getMtype().equals("symbolic link")) {
            rootVerLoc = CTLocation.valueOf(CTLocation.Kind.SYMBOLIC_LINK_VERSION, this.location().getDisplayName());
            ver = (CTVersion)this.provider().lookup((Location)rootVerLoc, feedback);
        }
        if (ver == null) {
            throw new IllegalStateException("Root version is null");
        }
        return ver;
    }

    public synchronized ElementTypeInfo getElementTypeInfo(SrvcFeedback feedback) throws WvcmException {
        if (this._elementTypeInfo == null) {
            this._elementTypeInfo = new ElementTypeInfo(feedback);
        }
        return this._elementTypeInfo;
    }

    public String getContentType(SrvcFeedback feedback) throws WvcmException {
        String contentType = null;
        if (this.getObjInfo(feedback).isDirectory()) {
            contentType = "text/directory";
        } else {
            ElementTypeInfo info = this.getElementTypeInfo(feedback);
            contentType = this.cc.elementTypeToMimeContentType(info.vobSelector, info.elementType, feedback);
        }
        return contentType;
    }

    public String lookupCharacterSet(SrvcFeedback feedback) throws WvcmException {
        String result = null;
        if (this.isPlainText(this.getContentType(feedback))) {
            result = this.provider().getDefaultCharacterSet();
            if (result.length() == 0) {
                result = System.getProperty(FILE_ENCODING);
            }
            ElementTypeInfo info = this.getElementTypeInfo(feedback);
            String characterSet = this.cc.elementTypeToCharacterSet(info.vobSelector, info.elementType, feedback);
            if (characterSet != null && characterSet.length() > 0) {
                result = characterSet;
            }
        }
        return result;
    }

    public String lookupLineSeparator(SrvcFeedback feedback) throws WvcmException {
        if (this.isPlainText(this.getContentType(feedback))) {
            return this.cc.getWorkspaceLineSeparator();
        }
        return null;
    }

    private boolean isPlainText(String contentType) {
        return "text/plain".equals(contentType) || "application/html".equals(contentType) || "application/xml".equals(contentType);
    }

    public static List<Object> lookupControlledResourceLocs(CTView view, List<Location> locations, SrvcFeedback feedback) throws WvcmException {
        if (locations == null || locations.size() < 1) {
            return null;
        }
        ArrayList<String> ids = new ArrayList<String>(locations.size());
        for (Location loc : locations) {
            ids.add(((CTLocation)loc).getDisplayName());
        }
        CTProvider provider = view.provider();
        CCaseLib cc = provider.getCCaseLib();
        List<String> gpaths = cc.gpath(ids, view.getViewTag(), true, feedback);
        ArrayList<Object> results = new ArrayList<Object>(gpaths.size());
        ArrayList<String> pathnames = new ArrayList<String>(gpaths.size());
        boolean okToCache = true;
        for (String gpath : gpaths) {
            CTLocation cTLocation = CTElement.gpathToCrLoc(gpath);
            results.add((Object)cTLocation);
            if (cTLocation == null) {
                okToCache = false;
                continue;
            }
            pathnames.add(cTLocation.getDisplayName());
        }
        if (okToCache) {
            List<CCaseObjInfo> infos = CCaseObjInfo.lookupObjInfos(cc, pathnames, feedback);
            Iterator<CCaseObjInfo> infoIterator = infos.iterator();
            for (Object e : results) {
                if (!(e instanceof CTLocation)) continue;
                provider.createAndCacheCTResource((CTLocation)((Object)e), infoIterator.next(), feedback);
            }
        }
        return results;
    }

    public static CTLocation createElemLocation(CTProvider p, CTView view, String pathname, String elemUSel, SrvcFeedback feedback) throws WvcmException {
        String baseCcSubVobComponentPath;
        CTLocation compLoc = null;
        String string = baseCcSubVobComponentPath = view instanceof CTBaseCCView ? CTElement.lookupBaseCcSubVobComponent(p, view.getViewTag(), pathname, feedback) : null;
        if (baseCcSubVobComponentPath != null) {
            compLoc = CTLocation.valueOf(CTLocation.Kind.VOBCOMPONENT, baseCcSubVobComponentPath);
        }
        return CTElement.createElemLocation(compLoc, elemUSel);
    }

    public static CTLocation createElemLocation(CTLocation baseCcSubVobComponentLoc, String elemUSel) throws WvcmException {
        CTLocation result = CTLocation.valueOf(elemUSel);
        if (baseCcSubVobComponentLoc != null) {
            if (!CTLocation.Kind.VOBCOMPONENT.equals((Object)baseCcSubVobComponentLoc.getKind())) {
                throw new IllegalArgumentException(String.format("unexpected sub VOB component location: %s", new Object[]{baseCcSubVobComponentLoc}));
            }
            result = CTLocation.createJoinedLocation(CTLocation.Kind.ELEMENT_IN_SVC, elemUSel, baseCcSubVobComponentLoc);
        }
        return result;
    }

    public static Map<IPath, CTVersion> getRootVersions(CTProvider p, String vobTag, Collection<IPath> elemGpaths, SrvcFeedback feedback) throws WvcmException {
        int count = elemGpaths.size();
        if (count == 0) {
            return Collections.emptyMap();
        }
        CCaseLib cc = p.getCCaseLib();
        String mainZeroSuffix = "@@" + CommonUtils.FWDSLASH + cc.getMainBranchName(vobTag, feedback) + "/0";
        ArrayList<String> verPaths = new ArrayList<String>(count);
        for (IPath gpath : elemGpaths) {
            verPaths.add(gpath + mainZeroSuffix);
        }
        return CTElement.getVersions(p, elemGpaths, verPaths, feedback);
    }

    public static Map<IPath, CTVersion> getVersions(CTProvider p, Collection<IPath> elemGpaths, List<String> verPaths, SrvcFeedback feedback) throws WvcmException {
        List<CTVersion> versions = CTElement.getVersions(p, verPaths, feedback);
        Iterator<IPath> elemGpathIt = elemGpaths.iterator();
        HashMap<IPath, CTVersion> results = new HashMap<IPath, CTVersion>(verPaths.size());
        for (CTVersion v : versions) {
            results.put(elemGpathIt.next(), v);
        }
        return results;
    }

    public static List<CTVersion> getVersions(CTProvider p, Collection<String> verPaths, SrvcFeedback feedback) throws WvcmException {
        ArrayList<CTVersion> versions = new ArrayList<CTVersion>(verPaths.size());
        Map<String, CCaseVerInfo> verInfos = CCaseVerInfo.getVerInfos(p.getCCaseLib(), verPaths, feedback);
        for (String verPath : verPaths) {
            CTVersion v = null;
            CCaseObjInfo verInfo = verInfos.get(verPath);
            if (verInfo != null) {
                v = CTVersion.valueOf(p, verInfo, feedback);
            }
            versions.add(v);
        }
        return versions;
    }

    public void markAsBaseCcSubVobComponentRoot(String componentName, SrvcFeedback feedback) throws WvcmException {
        this.cc.setAttr("com.ibm.rational.interop.ClearCase.subVOB_Component", this.getUniversalSelector(feedback), componentName, true, feedback);
    }

    public void unmarkAsBaseCcSubVobComponentRootForTest(SrvcFeedback feedback) throws WvcmException {
        this.cc.rmAttrIgnoreExpectedFailures("com.ibm.rational.interop.ClearCase.subVOB_Component", this.getUniversalSelector(feedback), feedback);
    }

    public static CTResource lookupInSVC(CTLocation loc, CTProvider p, SrvcFeedback feedback) throws WvcmException {
        CTLocation elemLoc = CTLocation.valueOf(loc.getDisplayName());
        CTElement element = (CTElement)p.get((Location)elemLoc, feedback);
        CTResource result = p.createAndCacheCTResource(loc, element.getObjInfo(feedback), feedback);
        return result;
    }

    public static CTElement valueOf(CTProvider p, CCaseElemInfo elemInfo, CTView view, String elemPName, SrvcFeedback feedback) throws WvcmException {
        CTLocation loc = CTElement.createElemLocation(p, view, elemPName, elemInfo.getUniversalSelector(), feedback);
        CTElement result = (CTElement)p.createAndCacheCTResource(loc, elemInfo, feedback);
        return result;
    }

    public static String stripLabelInfo(String str) {
        Matcher m = CONTENT_THEN_LABEL_INFO.matcher(str);
        if (m.matches()) {
            return m.group(1);
        }
        return str;
    }

    private List<CTVersion> getVersionTree(SrvcFeedback feedback) throws WvcmException {
        CTProvider p = this.provider();
        String viewTag = p.getTagForDefaultView();
        CCaseObjInfo info = this.getObjInfo(feedback);
        String elemPname = info.getPathName();
        IPath elemPath = Path.fromOSString((String)elemPname.split("@@")[0]);
        String elemUSel = info.getUniversalSelector();
        List<CCaseLib.VersionHistoryEntry> historyEntries = this.cc.getVersionHistoryEntries(elemPname, feedback);
        Collections.reverse(historyEntries);
        int count = historyEntries.size();
        ArrayList<CTVersion> results = new ArrayList<CTVersion>(count);
        HashMap<String, CTVersion> verName2Version = new HashMap<String, CTVersion>(count);
        HashMap version2PredVerNames = new HashMap(count);
        for (CCaseLib.VersionHistoryEntry e : historyEntries) {
            boolean isDirectory = e.mtype.startsWith("directory");
            String versionName = e.versionName;
            String pathName = new StringBuffer(elemPname).append(versionName).toString();
            CCaseVerInfo versInfo = new CCaseVerInfo(this.cc, e.universalSelector, isDirectory, pathName, e.mtype, e.creationDate, elemPname, e.comment, e.groupUser);
            CTVersion v = CTVersion.valueOf(p, versInfo, pathName, true, viewTag, feedback);
            v.setElemUSel(elemUSel);
            String brtypeName = Path.fromOSString((String)versionName).removeLastSegments(1).lastSegment();
            v.setBrtypeName(brtypeName);
            v.setVersionName(versionName, feedback);
            verName2Version.put(new Path(pathName).toPortableString().split("@@")[1], v);
            List<String> mergeSourceVersionNames = CTElement.computeMergeSourceVersionNames(elemPath, e.merges);
            ArrayList<String> predVerNames = new ArrayList<String>(1 + mergeSourceVersionNames.size());
            if (!e.predVersionName.isEmpty()) {
                predVerNames.add(new Path(String.valueOf(elemPname) + e.predVersionName).toPortableString().split("@@")[1]);
            } else if (!mergeSourceVersionNames.isEmpty()) {
                StringBuffer sb = new StringBuffer();
                for (String mergeSourceVersionName : mergeSourceVersionNames) {
                    sb.append(mergeSourceVersionName);
                    sb.append(",");
                }
                sb.deleteCharAt(sb.length() - 1);
                String msg = NLS.bind((String)"Main zero version of {0} has invalid merge hyper links from {1}. These merge hyper links are ignored.", (Object)elemPname, (Object)sb.toString());
                feedback.notifyWarning(msg);
                mergeSourceVersionNames.clear();
            }
            for (String mergeSourceVersionName : mergeSourceVersionNames) {
                String lastSeg = new Path(mergeSourceVersionName).lastSegment();
                if (lastSeg.startsWith("CHECKEDOUT") || predVerNames.contains(mergeSourceVersionName)) continue;
                predVerNames.add(mergeSourceVersionName);
            }
            if (predVerNames.size() > 2) {
                Collections.sort(predVerNames.subList(1, predVerNames.size()), verComp);
            }
            version2PredVerNames.put(v, predVerNames);
            results.add(v);
        }
        for (CTVersion v : results) {
            List mergeSourceVersionNames = (List)version2PredVerNames.get((Object)v);
            ArrayList<CTVersion> preds = new ArrayList<CTVersion>(mergeSourceVersionNames.size());
            for (String predVerName : mergeSourceVersionNames) {
                CTVersion predVer = (CTVersion)((Object)verName2Version.get(predVerName));
                if (predVer != null) {
                    preds.add(predVer);
                    continue;
                }
                feedback.notifyWarning(NLS.bind((String)"Merge hyper link source {0} is not found for the link target {1}.", (Object)predVerName, (Object)v.getVersionName(null)));
            }
            v.setPredecessorList(preds, feedback);
        }
        return results;
    }

    public static List<String> computeMergeSourceVersionNames(IPath elemPath, List<String> merges) {
        ArrayList<String> results = new ArrayList<String>();
        for (String pathname : merges) {
            String[] parts = pathname.split("@@");
            IPath prefixPath = Path.fromPortableString((String)parts[0]);
            if (!elemPath.isPrefixOf(prefixPath)) continue;
            results.add(parts[1]);
        }
        return results;
    }

    public class ElementTypeInfo {
        public final String vobSelector;
        public final String elementType;

        public ElementTypeInfo(SrvcFeedback feedback) throws WvcmException {
            CCaseObjInfo objInfo = CTElement.this.getObjInfo(feedback);
            String uSel = null;
            if (objInfo instanceof CCaseElemInfo) {
                CCaseElemInfo elemInfo = (CCaseElemInfo)objInfo;
                uSel = objInfo.getUniversalSelector();
                this.elementType = elemInfo.getElemType();
            } else {
                uSel = CTElement.this.location().getDisplayName();
                this.elementType = CTElement.this.cc.getElementType(uSel, feedback);
            }
            this.vobSelector = ObjSelUtils.getObjSelVobSel(uSel);
        }
    }

    public static class VersionComparator
    implements Comparator<String> {
        @Override
        public int compare(String ver1, String ver2) {
            Path path1 = new Path(ver1);
            Path path2 = new Path(ver2);
            int num1 = path1.segmentCount();
            int num2 = path2.segmentCount();
            int minSegCount = Math.min(num1, num2);
            int commonBranchCount = -1;
            int count = 0;
            while (count < minSegCount) {
                if (!path1.segment(count).equals(path2.segment(count))) {
                    commonBranchCount = count - 1;
                    break;
                }
                ++count;
            }
            int val = 0;
            val = num1 == num2 ? (commonBranchCount == num1 - 2 ? (Integer.parseInt(path1.lastSegment()) < Integer.parseInt(path2.lastSegment()) ? -1 : 1) : ver1.compareTo(ver2)) : (num1 < num2 ? -1 : 1);
            return val;
        }
    }

    public static class VersionTreeNodeInfo {
        public final String branchTypeName;
        public final String predVerPname;
        public final String versionName;

        public VersionTreeNodeInfo(String branchTypeName, String predVerPname, String versionName) {
            this.branchTypeName = branchTypeName;
            this.predVerPname = predVerPname;
            this.versionName = versionName;
        }
    }
}

