/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.client.workitem;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.common.model.query.IBaseBuildResultQueryModel;
import com.ibm.team.build.internal.client.ITeamBuildRecordClient;
import com.ibm.team.build.internal.client.iterator.ItemQueryIterator;
import com.ibm.team.build.internal.client.util.ContentUtil;
import com.ibm.team.build.internal.client.workitem.ClientWorkItemMessages;
import com.ibm.team.build.internal.common.helper.ItemHelper;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.common.model.dto.IBuildResultRecord;
import com.ibm.team.links.client.ILinkManager;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.ILinkCollection;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.internal.links.LinksPackage;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IHelperType;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class WorkItemHelper {
    private static final char EXTENDED_DATA_DELIMITER = '\n';

    static {
        new WorkItemHelper();
    }

    private WorkItemHelper() {
    }

    public static IBuildResult setFixedInBuild(ITeamRepository teamRepository, IBuildResultHandle buildResultHandle, IWorkItemHandle[] workItemHandles) throws TeamRepositoryException {
        ValidationHelper.validateNotNull((String)"teamRepository", (Object)teamRepository);
        ValidationHelper.validateNotNull((String)"buildResultHandle", (Object)buildResultHandle);
        ValidationHelper.validateNotNull((String)"workItemHandles", (Object[])workItemHandles);
        ValidationHelper.validateNotNullElements((String)"workItemHandles", (Object[])workItemHandles);
        String[] handleIds = new String[workItemHandles.length];
        int i = 0;
        while (i < workItemHandles.length) {
            handleIds[i] = workItemHandles[i].getItemId().getUuidValue();
            ++i;
        }
        IBuildResultContribution contribution = BuildItemFactory.createBuildResultContribution();
        contribution.setExtendedContributionTypeId("fixedWorkItems");
        contribution.setExtendedContributionData(ContentUtil.stringArrayToContent(teamRepository, handleIds, '\n'));
        return ClientFactory.getTeamBuildClient(teamRepository).addBuildResultContribution(buildResultHandle, contribution, IBuildResult.PROPERTIES_COMPLETE, null);
    }

    public static IWorkItemHandle[] getFixedInBuild(ITeamRepository teamRepository, IBuildResultHandle buildResultHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        ValidationHelper.validateNotNull((String)"teamRepository", (Object)teamRepository);
        ValidationHelper.validateNotNull((String)"buildResultHandle", (Object)buildResultHandle);
        ArrayList<IItemHandle> workItemHandles = new ArrayList<IItemHandle>();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        IBuildResultContribution[] buildResultContributions = ClientFactory.getTeamBuildClient(teamRepository).getBuildResultContributions(buildResultHandle, "fixedWorkItems", (IProgressMonitor)subMonitor.newChild(1));
        subMonitor.setWorkRemaining(buildResultContributions.length);
        IBuildResultContribution[] iBuildResultContributionArray = buildResultContributions;
        int n = buildResultContributions.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildResultContribution contribution = iBuildResultContributionArray[n2];
            IContent content = contribution.getExtendedContributionData();
            if (content != null) {
                String[] workItemHandleIds = ContentUtil.contentToStringArray(teamRepository, content, '\n', (IProgressMonitor)subMonitor.newChild(1));
                int i = 0;
                while (i < workItemHandleIds.length) {
                    workItemHandles.add(IWorkItem.ITEM_TYPE.createItemHandle(UUID.valueOf((String)workItemHandleIds[i]), null));
                    ++i;
                }
            }
            ++n2;
        }
        return workItemHandles.toArray(new IWorkItemHandle[workItemHandles.size()]);
    }

    public static IWorkItemHandle[] getIncludedWorkItems(ITeamRepository teamRepository, IBuildResultHandle buildResultHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        String buildLinkType = "com.ibm.team.build.linktype.includedWorkItems";
        return WorkItemHelper.getLinkedWorkItems(teamRepository, buildResultHandle, buildLinkType, monitor);
    }

    public static IWorkItemHandle[] getReportedWorkItems(ITeamRepository teamRepository, IBuildResultHandle buildResultHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        String buildLinkType = "com.ibm.team.build.linktype.reportedWorkItems";
        return WorkItemHelper.getLinkedWorkItems(teamRepository, buildResultHandle, buildLinkType, monitor);
    }

    public static IWorkItemHandle[] getLinkedWorkItems(ITeamRepository teamRepository, IBuildResultHandle buildResultHandle, String buildLinkType, IProgressMonitor monitor) throws TeamRepositoryException {
        ValidationHelper.validateNotNull((String)"teamRepository", (Object)teamRepository);
        ValidationHelper.validateNotNull((String)"buildResultHandle", (Object)buildResultHandle);
        ValidationHelper.validateNotNull((String)"buildLinkType", (Object)buildLinkType);
        ArrayList<IWorkItemHandle> reportedWorkItems = new ArrayList<IWorkItemHandle>();
        ILinkManager linkManager = (ILinkManager)teamRepository.getClientLibrary(ILinkManager.class);
        IItemReference source = linkManager.referenceFactory().createReferenceToItem((IItemHandle)buildResultHandle);
        ILinkCollection referencesToResults = linkManager.findLinksBySource(buildLinkType, (IReference)source, monitor).getAllLinksFromHereOn();
        for (Object object : referencesToResults) {
            ILink link = (ILink)object;
            IWorkItemHandle workItemHandle = (IWorkItemHandle)link.getTargetRef().resolve();
            if (workItemHandle == null) continue;
            reportedWorkItems.add(workItemHandle);
        }
        return reportedWorkItems.toArray(new IWorkItemHandle[reportedWorkItems.size()]);
    }

    public static IWorkItemHandle[] getUnresolvedWorkItems(ITeamRepository teamRepository, IBuildDefinitionHandle buildDefinition, IProgressMonitor monitor) throws TeamRepositoryException {
        ValidationHelper.validateNotNull((String)"teamRepository", (Object)teamRepository);
        ValidationHelper.validateNotNull((String)"buildDefinition", (Object)buildDefinition);
        ITeamBuildClient client = (ITeamBuildClient)teamRepository.getClientLibrary(ITeamBuildClient.class);
        IBaseBuildResultQueryModel.IBuildResultQueryModel queryModel = IBaseBuildResultQueryModel.IBuildResultQueryModel.ROOT;
        IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)queryModel);
        query.filter(queryModel.buildDefinition()._eq(query.newItemHandleArg()));
        ItemQueryIterator iter = new ItemQueryIterator(client, query, new Object[]{buildDefinition});
        ILinkManager linkManager = (ILinkManager)teamRepository.getClientLibrary(ILinkManager.class);
        IReference[] sources = new IReference[iter.size(monitor)];
        int i = 0;
        while (i < iter.size(monitor)) {
            sources[i] = linkManager.referenceFactory().createReferenceToItem(iter.next(monitor));
            ++i;
        }
        ILinkCollection referencesToResults = linkManager.findLinksBySource(new String[]{"com.ibm.team.build.linktype.reportedWorkItems"}, sources, monitor).getAllLinksFromHereOn();
        ArrayList<IWorkItemHandle> reportedWorkItems = new ArrayList<IWorkItemHandle>();
        for (Object object : referencesToResults) {
            ILink link = (ILink)object;
            IWorkItemHandle workItemHandle = (IWorkItemHandle)link.getTargetRef().resolve();
            if (workItemHandle == null) continue;
            reportedWorkItems.add(workItemHandle);
        }
        ArrayList<String> properties = new ArrayList<String>();
        properties.add(IWorkItem.TYPE_PROPERTY);
        properties.add(IWorkItem.STATE_PROPERTY);
        properties.add(IWorkItem.WORKFLOW_SURROGATE_PROPERTY);
        properties.add(IWorkItem.PROJECT_AREA_PROPERTY);
        List workItems = teamRepository.itemManager().fetchPartialItems(reportedWorkItems, 0, properties, monitor);
        HashMap<String, IWorkItem> unresolvedWorkItems = new HashMap<String, IWorkItem>();
        for (Object object : workItems) {
            IWorkItem workItem;
            if (object == null || WorkItemHelper.isResolved(workItem = (IWorkItem)object, teamRepository, monitor)) continue;
            unresolvedWorkItems.put(workItem.getItemId().getUuidValue(), workItem);
        }
        return unresolvedWorkItems.values().toArray(new IWorkItemHandle[unresolvedWorkItems.size()]);
    }

    private static boolean isResolved(IWorkItem workItem, ITeamRepository repository, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItemClient client = (IWorkItemClient)repository.getClientLibrary(IWorkItemClient.class);
        IWorkflowInfo workflowInfo = client.findWorkflowInfo(workItem, monitor);
        return workflowInfo != null && workflowInfo.getStateGroup(workItem.getState2()) == 2;
    }

    public static void linkReportedWorkItem(ITeamRepository teamRepository, IBuildResultHandle buildResultHandle, IWorkItemHandle workItemHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItemHandle[] reportedWorkItems;
        ValidationHelper.validateNotNull((String)"teamRepository", (Object)teamRepository);
        ValidationHelper.validateNotNull((String)"buildResultHandle", (Object)buildResultHandle);
        ValidationHelper.validateNotNull((String)"workItemHandle", (Object)workItemHandle);
        IWorkItemHandle[] iWorkItemHandleArray = reportedWorkItems = WorkItemHelper.getReportedWorkItems(teamRepository, buildResultHandle, monitor);
        int n = reportedWorkItems.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkItemHandle reportedWorkItem = iWorkItemHandleArray[n2];
            if (reportedWorkItem.sameItemId((IItemHandle)workItemHandle)) {
                return;
            }
            ++n2;
        }
        WorkItemHelper.linkWorkItem(teamRepository, buildResultHandle, workItemHandle, "com.ibm.team.build.linktype.reportedWorkItems", monitor);
    }

    public static void linkIncludedWorkItem(ITeamRepository teamRepository, IBuildResultHandle buildResultHandle, IWorkItemHandle workItemHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        WorkItemHelper.linkWorkItem(teamRepository, buildResultHandle, workItemHandle, "com.ibm.team.build.linktype.includedWorkItems", monitor);
    }

    public static void linkWorkItem(ITeamRepository teamRepository, IBuildResultHandle buildResultHandle, IWorkItemHandle workItemHandle, String linkType, IProgressMonitor monitor) throws TeamRepositoryException {
        ValidationHelper.validateNotNull((String)"teamRepository", (Object)teamRepository);
        ValidationHelper.validateNotNull((String)"buildResultHandle", (Object)buildResultHandle);
        ValidationHelper.validateNotNull((String)"workItemHandle", (Object)workItemHandle);
        ILinkManager linkManager = (ILinkManager)teamRepository.getClientLibrary(ILinkManager.class);
        String commentText = WorkItemHelper.getCommentText(buildResultHandle, monitor, teamRepository);
        IItemReference sourceReference = linkManager.referenceFactory().createReferenceToItem((IItemHandle)buildResultHandle, commentText);
        IItemReference targetReference = linkManager.referenceFactory().createReferenceToItem((IItemHandle)workItemHandle);
        ILink link = linkManager.createLink(linkType, (IReference)sourceReference, (IReference)targetReference);
        linkManager.saveLink(link, monitor);
    }

    private static String getCommentText(IBuildResultHandle buildResultHandle, IProgressMonitor monitor, ITeamRepository teamRepository) throws TeamRepositoryException {
        ITeamBuildRecordClient buildClient = (ITeamBuildRecordClient)teamRepository.getClientLibrary(ITeamBuildRecordClient.class);
        IBuildResultRecord buildResultRecord = buildClient.getBuildResultRecord(buildResultHandle, new String[]{IBuildResult.PROPERTY_LABEL, IBuildResult.PROPERTY_BUILD_DEFINITION}, monitor);
        IBuildDefinition buildDefinition = buildResultRecord.getBuildDefinition();
        String comment = NLS.bind((String)ClientWorkItemMessages.WorkItemHelper_BUILD_LINK_LABEL, (Object)buildDefinition.getId(), (Object)buildResultRecord.getBuildResult().getLabel());
        IHelperType helperType = IHelperType.IRegistry.INSTANCE.getHelperType(LinksPackage.eINSTANCE.getReference().getName(), "com.ibm.team.links");
        return ItemHelper.validateStringAttributeLength((String)comment, (IType)helperType, (String)LinksPackage.eINSTANCE.getReference_Comment().getName());
    }
}

