/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.repository.rcp.streams;

import java.io.IOException;
import java.io.InputStream;

public class LengthCountingInputStream
extends InputStream {
    private long bytesRead;
    private long readSinceMark;
    private final InputStream in;

    public LengthCountingInputStream(InputStream in) {
        if (in == null) {
            throw new IllegalArgumentException();
        }
        this.in = in;
    }

    @Override
    public int read() throws IOException {
        int r = this.in.read();
        if (r != -1) {
            ++this.readSinceMark;
            ++this.bytesRead;
        }
        return r;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int r = this.in.read(b, off, len);
        if (r != -1) {
            this.readSinceMark += (long)r;
            this.bytesRead += (long)r;
        }
        return r;
    }

    @Override
    public long skip(long n) throws IOException {
        long r = this.in.skip(n);
        this.bytesRead += r;
        this.readSinceMark += r;
        return r;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
        this.bytesRead -= this.readSinceMark;
        this.readSinceMark = 0L;
    }

    @Override
    public void mark(int readlimit) {
        this.in.mark(readlimit);
        this.readSinceMark = 0L;
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    public long bytesRead() {
        return this.bytesRead;
    }
}

