/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas.validator;

import com.ibm.team.filesystem.client.internal.copyfileareas.GlobalMetadataValidator;
import com.ibm.team.filesystem.client.internal.copyfileareas.validator.DiskBackedHashMapEntriesValidator;
import com.ibm.team.filesystem.client.internal.copyfileareas.validator.HeapValidator;
import com.ibm.team.internal.repository.rcp.util.RAFWrapper;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.util.Date;
import java.util.GregorianCalendar;

public class MetaMetaMapValidator
extends DiskBackedHashMapEntriesValidator {
    private static final int METADATA_VERSION = 0;
    private static final String LAST_SANDBOX_LISTENER_EVENT = "lastSandboxListenerEvent";
    protected File cfaRoot;

    public MetaMetaMapValidator(File rootPath, HeapValidator hv, GlobalMetadataValidator gv) throws IOException {
        super(hv, gv);
        this.cfaRoot = rootPath;
    }

    @Override
    public void beginValidation() throws IOException {
        super.beginValidation();
        if (!this.hv.getHeapFile().getName().equals(".metameta")) {
            this.log.append("Invalid meta meta data map file name " + this.hv.getHeapFile() + "\n");
        }
        if (!this.hv.getHeapFile().getParentFile().equals(this.cfaRoot)) {
            this.log.append("Invalid meta meta data map file location " + this.hv.getHeapFile() + " relative to root " + this.cfaRoot + "\n");
        }
    }

    @Override
    public void validateEntry(long entryOffset, long keyOffset, boolean keyIsHeapADT, long valueOffset, boolean valueIsHeapADT, int hash, RAFWrapper raf) throws IOException {
        String key;
        if (keyIsHeapADT) {
            this.log.append("HeapADT attribute unexpectedly set on meta meta key of entry at " + entryOffset + "\n");
        }
        if (valueIsHeapADT) {
            this.log.append("HeapADT attribute unexpectedly set on meta meta value of entry at " + entryOffset + "\n");
        }
        if ((key = this.validateKey(entryOffset, keyOffset, hash, raf)) != null) {
            this.validateValue(entryOffset, valueOffset, raf, key);
        }
    }

    protected String validateKey(long entryOffset, long keyOffset, int hashCode, RAFWrapper raf) throws IOException {
        if (keyOffset < 0L || keyOffset > this.hv.getWorkingAreaSize()) {
            this.log.append("The meta meta key pointer is at an impossible location " + keyOffset + " at " + entryOffset + "\n");
            return null;
        }
        this.setPosition(keyOffset);
        try {
            String key = this.validateSerializableString("meta meta key", keyOffset, "meta meta key", raf);
            if (LAST_SANDBOX_LISTENER_EVENT.equals(key)) {
                String string = key;
                return string;
            }
            this.log.append("Unknown key " + key + " in meta meta data map.\n");
        }
        finally {
            this.hv.claim(new HeapValidator.HeapClaimant(keyOffset, this.getPosition() - keyOffset, "meta meta key"));
        }
        return null;
    }

    protected void validateValue(long entryOffset, long valueOffset, RAFWrapper raf, String key) throws IOException {
        block9: {
            if (valueOffset < 0L || valueOffset > this.hv.getWorkingAreaSize()) {
                this.log.append("The loaded components value pointer is at an impossible location " + valueOffset + " at " + entryOffset + "\n");
                return;
            }
            this.setPosition(valueOffset);
            try {
                String value = this.validateSerializableString("meta meta value", valueOffset, "meta meta value", raf);
                if (!LAST_SANDBOX_LISTENER_EVENT.equals(key)) break block9;
                try {
                    long timeStamp = Long.parseLong(value);
                    if (timeStamp <= 0L) {
                        this.log.append("Negative value for the last sandbox event value in the meta meta data map.");
                        break block9;
                    }
                    Date d = new Date(timeStamp);
                    if (d.before(new GregorianCalendar(2011, 12, 1).getTime())) {
                        this.log.append("Impossible value (too early) for the last sandbox event value in the meta meta data map.");
                    }
                    if (d.after(new GregorianCalendar(2038, 1, 1).getTime())) {
                        this.log.append("Impossible value (too late) for the last sandbox event value in the meta meta data map.");
                    }
                    this.gv.addLastSandboxListenerEvent(d);
                }
                catch (NumberFormatException numberFormatException) {
                    this.log.append("Non-long string value for the last sandbox event value in the meta meta data map.");
                }
            }
            finally {
                this.hv.claim(new HeapValidator.HeapClaimant(valueOffset, this.getPosition() - valueOffset, "meta meta value"));
            }
        }
    }

    protected String validateSerializableString(String fieldDesc, long fieldOffset, String strDesc, RAFWrapper raf) throws IOException {
        String str;
        if (this.getPosition() + 7L > this.hv.getWorkingAreaSize()) {
            this.log.append("The " + fieldDesc + " pointer at " + fieldOffset + " does not have enough room to store the length field for " + strDesc + "\n");
            return null;
        }
        if (this.buf.remaining() < 7) {
            this.buf.compact();
            while (this.buf.position() < 7) {
                int read = raf.getFile().getChannel().read(this.buf, this.currentOffset);
                if (read == -1) {
                    throw new EOFException();
                }
                this.currentOffset += (long)read;
            }
            this.buf.flip();
        }
        this.buf.get(new byte[5]);
        int length = this.buf.getShort() & 0xFFFF;
        if (this.getPosition() + (long)length > this.hv.getWorkingAreaSize()) {
            this.log.append("The " + fieldDesc + " contains a " + strDesc + " length of impossible size " + length + " at offset " + fieldOffset + "\n");
            return null;
        }
        if (length == 0) {
            return "";
        }
        byte[] uuid = new byte[length + 2];
        uuid[0] = (byte)(length >> 8);
        uuid[1] = (byte)length;
        int read = Math.min(length, this.buf.remaining());
        this.buf.get(uuid, 2, read);
        while (read != length) {
            this.buf.compact();
            int currRead = raf.getFile().getChannel().read(this.buf, this.currentOffset);
            if (currRead == -1) {
                throw new EOFException();
            }
            this.currentOffset += (long)currRead;
            this.buf.flip();
            currRead = Math.min(length - read, currRead);
            this.buf.get(uuid, read + 2, currRead);
            read += currRead;
        }
        try {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(uuid));
            str = in.readUTF();
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            this.log.append("The " + fieldDesc + " contains a " + strDesc + " of length " + length + " at offset " + fieldOffset + " that is not a valid UTF-8 byte sequence\n");
            return null;
        }
        return str;
    }

    @Override
    public boolean validateCustomMetadata(DataInputStream in) throws IOException {
        int v = in.readInt();
        if (v != 0) {
            this.log.append("Metadata version mismatch for meta meta data map: " + v + " != " + 0);
            return false;
        }
        return true;
    }
}

