/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.ignore;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreManager;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreReason;
import com.ibm.team.filesystem.client.internal.ignore.PathPair;
import com.ibm.team.filesystem.client.internal.utils.ILRUCache;
import com.ibm.team.filesystem.client.internal.utils.LRUCache;
import com.ibm.team.filesystem.client.internal.utils.SynchronizedLRUCache;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.client.util.IListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class IgnoreManager
implements IIgnoreManager {
    private static String PT_IGNORE_PROVIDER = "ignoreProvider";
    private static String ATTR_CLASS = "class";
    private static String ATTR_NAME = "name";
    private final Object providersLock = new Object();
    HashMap<String, IIgnoreProvider> providers = new HashMap();
    private boolean providersLoadedFromExtensionPoint = false;
    protected EventSource eventSource = new EventSource();
    ILRUCache<PathPair, Boolean> cache = new SynchronizedLRUCache<PathPair, Boolean>(new LRUCache(400));
    private static IgnoreManager instance;

    public static synchronized IIgnoreManager getInstance() {
        if (instance == null) {
            instance = new IgnoreManager();
        }
        return instance;
    }

    private IgnoreManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addIgnoreProvider(String name, IIgnoreProvider provider, IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress);
        Object object = this.providersLock;
        synchronized (object) {
            if (this.providers.containsKey(name)) {
                throw new IllegalStateException(NLS.bind((String)Messages.IgnoreManager_0, (Object)name));
            }
            this.providers = (HashMap)this.providers.clone();
            this.providers.put(name, provider);
            provider.setIgnoreManager(this, this.eventSource, (IProgressMonitor)monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeIgnoreProvider(String name) throws NoSuchElementException {
        Object object = this.providersLock;
        synchronized (object) {
            HashMap newProviders = (HashMap)this.providers.clone();
            IIgnoreProvider removed = (IIgnoreProvider)newProviders.remove(name);
            if (removed == null) {
                throw new NoSuchElementException();
            }
            this.providers = newProviders;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, IIgnoreProvider> getProviders(SubMonitor monitor) {
        Object object = this.providersLock;
        synchronized (object) {
            this.loadProvidersFromExtensionPoint((IProgressMonitor)monitor);
            return this.providers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void loadProvidersFromExtensionPoint(IProgressMonitor progress) {
        try {
            Object object = this.providersLock;
            synchronized (object) {
                block14: {
                    if (!this.providersLoadedFromExtensionPoint) break block14;
                    return;
                }
                this.providersLoadedFromExtensionPoint = true;
                SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (String)Messages.IgnoreManager_INITIALIZING_PLUGIN_CLASS, (int)1);
                IConfigurationElement[] configs = RegistryFactory.getRegistry().getConfigurationElementsFor("com.ibm.team.filesystem.client", PT_IGNORE_PROVIDER);
                monitor.setWorkRemaining(configs.length);
                IConfigurationElement[] iConfigurationElementArray = configs;
                int n = configs.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement config = iConfigurationElementArray[n2];
                    String name = config.getAttribute(ATTR_NAME);
                    monitor.subTask(NLS.bind((String)Messages.IgnoreManager_INITIALIZING_PLUGIN_NAMED, (Object)name));
                    try {
                        IIgnoreProvider provider = (IIgnoreProvider)config.createExecutableExtension(ATTR_CLASS);
                        this.addIgnoreProvider(name, provider, (IProgressMonitor)monitor.newChild(1));
                    }
                    catch (IllegalStateException e) {
                        LoggingHelper.log(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.IgnoreManager_ALREADY_LOADED, (Object)name), e));
                    }
                    catch (FileSystemException e) {
                        LoggingHelper.log(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.IgnoreManager_PROBLEM_STARTING, (Object)name), (Throwable)((Object)e)));
                    }
                    catch (CoreException e) {
                        LoggingHelper.log(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.IgnoreManager_PLUGIN_LOAD_FAILED, (Object)name), e));
                    }
                    ++n2;
                }
            }
        }
        finally {
            if (progress != null) {
                progress.done();
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IIgnoreManager.IIgnoreReason findIgnoreReasons(IShareable shareable, IProgressMonitor progress) {
        monitor = SubMonitor.convert((IProgressMonitor)progress, (String)NLS.bind((String)Messages.IgnoreManager_FIND_WHY_FILE_OR_FOLDER_IS_IGNORED, (Object)shareable.getLocalPath().toString()), (int)3);
        if (!this.shouldBeIgnored(shareable, (IProgressMonitor)monitor.newChild(1))) {
            return null;
        }
        myProviders = this.getProviders(monitor.newChild(1));
        fullPath = new PathPair(shareable);
        sandbox = shareable.getSandbox();
        monitor.setWorkRemaining(fullPath.getInnerPath().segmentCount() * myProviders.size());
        testers = new IIgnoreProvider.IIgnoreTester[myProviders.size()];
        try {
            i = 0;
            for (IIgnoreProvider provider : myProviders.values()) {
                testers[i++] = provider.getTester(shareable);
            }
            walker /* !! */  = new RelativeLocation(new String[0]);
            segments = fullPath.getInnerPath().segments();
            allRules = new ArrayList<IIgnoreProvider.IIgnoreRule>();
            i = 0;
            while (i < segments.length) {
                walker /* !! */  = walker /* !! */ .append(segments[i]);
                var15_15 = testers;
                var14_14 = testers.length;
                var13_13 = 0;
                while (var13_13 < var14_14) {
                    tester = var15_15[var13_13];
                    rules = tester.findIgnoreReasons(shareable, walker /* !! */ , (IProgressMonitor)monitor.newChild(1));
                    Assert.isNotNull((Object)rules);
                    allRules.addAll(rules);
                    ++var13_13;
                }
                if (allRules.size() > 0) {
                    inheritsFrom = null;
                    if (i < segments.length - 1) {
                        inheritsFrom = sandbox.findShareable(walker /* !! */ , ResourceType.FOLDER);
                    }
                    var18_17 = new IgnoreReason(shareable, allRules, inheritsFrom);
                    return var18_17;
                }
                ++i;
            }
        }
        finally {
            var22_18 = testers;
            var21_21 = testers.length;
            var20_24 = 0;
            ** while (var20_24 < var21_21)
        }
lbl-1000:
        // 1 sources

        {
            tester = var22_18[var20_24];
            if (tester != null) {
                try {
                    tester.done();
                }
                catch (Exception e) {
                    LoggingHelper.error("com.ibm.team.filesystem.client", Messages.IgnoreManager_2, e);
                }
            }
            ++var20_24;
            continue;
        }
lbl55:
        // 1 sources

        monitor.done();
        return var18_17;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean shouldBeIgnored(IShareable shareable, IProgressMonitor progress) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 24[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void addGenericListener(Object category, IListener listener) {
        this.eventSource.addGenericListener(category, listener);
    }

    @Override
    public void addGenericListener(Object[] categories, IListener listener) {
        Object[] objectArray = categories;
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            Object category = objectArray[n2];
            this.addGenericListener(category, listener);
            ++n2;
        }
    }

    public void purgeGenericListener(IListener listener) {
        this.eventSource.purgeGenericListener(listener);
    }

    @Override
    public void removeGenericListener(Object[] categories, IListener listener) {
        Object[] objectArray = categories;
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            Object category = objectArray[n2];
            this.eventSource.removeGenericListener(category, listener);
            ++n2;
        }
    }

    public void removeGenericListener(Object category, IListener listener) {
        this.eventSource.removeGenericListener(category, listener);
    }

    public void waitForEventsToDrain() {
        while (this.eventSource.internalIsBusy()) {
            try {
                Thread.sleep(4L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IIgnoreProvider getIgnoreProvider(String name, IProgressMonitor progress) {
        Object object = this.providersLock;
        synchronized (object) {
            this.loadProvidersFromExtensionPoint(progress);
            if (!this.providers.containsKey(name)) {
                throw new IllegalStateException(NLS.bind((String)Messages.IgnoreManager_5, (Object)name));
            }
            return this.providers.get(name);
        }
    }

    @Override
    public boolean hasUndeliveredEvents() {
        return this.eventSource.internalIsBusy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IIgnoreManager createCopy(Collection<? extends IIgnoreManager.ICopyParameter> list, IProgressMonitor progress) {
        Set<Map.Entry<String, IIgnoreProvider>> providers;
        final IgnoreManager copy = new IgnoreManager();
        copy.eventSource = new EventSource();
        copy.cache = new SynchronizedLRUCache<PathPair, Boolean>(new LRUCache());
        copy.providers = new HashMap();
        ArrayList<IIgnoreManager.ICopyParameter> paramWithIgnoreManager = new ArrayList<IIgnoreManager.ICopyParameter>();
        paramWithIgnoreManager.addAll(list);
        paramWithIgnoreManager.add(new IIgnoreManager.IIgnoreManagerCopyParameter(){

            @Override
            public IIgnoreManager getNewIgnoreManager() {
                return copy;
            }

            @Override
            public EventSource getEventQueue() {
                return copy.eventSource;
            }
        });
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)5);
        Object object = this.providersLock;
        synchronized (object) {
            providers = this.getProviders(monitor.newChild(1)).entrySet();
            copy.providersLoadedFromExtensionPoint = this.providersLoadedFromExtensionPoint;
        }
        monitor.setWorkRemaining(providers.size());
        for (Map.Entry<String, IIgnoreProvider> entry : providers) {
            IIgnoreProvider provider = entry.getValue().createCopy(paramWithIgnoreManager, (IProgressMonitor)monitor.newChild(1));
            copy.providers.put(entry.getKey(), provider);
        }
        return copy;
    }

    @Override
    public IIgnoreManager createCopy(IProgressMonitor progress) {
        return this.createCopy(Collections.EMPTY_LIST, progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deallocate() {
        Object object = this.providersLock;
        synchronized (object) {
            for (IIgnoreProvider provider : this.providers.values()) {
                provider.deallocate(this);
            }
            this.providers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushInAbsenceOfEvents(Collection<IShareable> roots, IProgressMonitor progress) throws FileSystemException {
        Object object = this.providersLock;
        synchronized (object) {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)this.providers.size());
            for (IIgnoreProvider provider : this.providers.values()) {
                provider.flushInAbsenceOfEvents(roots, (IProgressMonitor)monitor.newChild(1));
            }
        }
        this.cache.flush();
    }
}

