/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.util;

import com.ibm.team.repository.common.UUID;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.util.AbstractEnumerator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ObjectSizer {
    private static Log logger = LogFactory.getLog(ObjectSizer.class);
    private static List unsizeableObjectList = new ArrayList(10);

    public static long getSize(Object object) {
        if (object == null) {
            return 0L;
        }
        ObjectSizer sizer = new ObjectSizer();
        long size = sizer.getSize(object, 0L);
        return size;
    }

    private ObjectSizer() {
    }

    private void addSize(Collection<?> objects, SizeResult result) {
        if (objects == null) {
            return;
        }
        result.size += 8;
        result.size += objects.size() * 4;
        for (Object child : objects) {
            result.push(child);
        }
    }

    private void addSize(Map<?, ?> objects, SizeResult result) {
        if (objects == null) {
            return;
        }
        result.size += 32;
        for (Map.Entry<?, ?> entry : objects.entrySet()) {
            result.size += 12;
            result.push(entry.getKey());
            result.push(entry.getValue());
        }
    }

    private void addSize(Object[] objects, SizeResult result) {
        if (objects == null) {
            return;
        }
        result.size += 8;
        result.size += 4 * objects.length;
        int i = 0;
        while (i < objects.length) {
            result.push(objects[i]);
            ++i;
        }
    }

    public long getSize(Object object, long extra) {
        SizeResult result = new SizeResult(object);
        this.addSize(object, extra, result);
        Object child = null;
        while ((child = result.pop()) != null) {
            this.addSize(child, 0L, result);
        }
        return result.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSize(Object object, long extra, SizeResult result) {
        if (object == null) {
            result.size += 0;
        } else if (object instanceof Integer) {
            result.size += 4;
        } else if (object instanceof Float) {
            result.size += 4;
        } else if (object instanceof Double) {
            result.size += 8;
        } else if (object instanceof Long) {
            result.size += 8;
        } else if (object instanceof Short) {
            result.size += 2;
        } else if (object instanceof Byte) {
            ++result.size;
        } else if (object instanceof Boolean) {
            ++result.size;
        } else if (object instanceof Character) {
            result.size += 2;
        } else if (object instanceof AtomicInteger) {
            result.size += 16;
        } else if (object instanceof String) {
            result.size = (int)((long)result.size + (extra + 8L + 24L + (long)(((String)object).length() * 2)));
        } else if (object instanceof UUID) {
            result.size = (int)((long)result.size + (extra + 8L + 16L));
        } else if (object instanceof Collection) {
            result.size = (int)((long)result.size + (extra + 8L));
            this.addSize((Collection)object, result);
        } else if (object instanceof Map) {
            result.size = (int)((long)result.size + (extra + 8L));
            this.addSize((Map)object, result);
        } else if (object instanceof int[]) {
            result.size = (int)((long)result.size + (extra + 8L + (long)(((int[])object).length * 4)));
        } else if (object instanceof Object[]) {
            result.size = (int)((long)result.size + (extra + 8L));
            this.addSize((Object[])object, result);
        } else if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            long size = extra + 8L + 20L;
            for (EStructuralFeature feature : eObject.eClass().getEAllStructuralFeatures()) {
                size += 4L;
                if (!eObject.eIsSet(feature)) continue;
                Object value = eObject.eGet(feature);
                result.push(value);
            }
            result.size = (int)((long)result.size + size);
        } else if (object instanceof Timestamp) {
            result.size = (int)((long)result.size + (28L + extra));
        } else if (object instanceof AbstractEnumerator) {
            AbstractEnumerator enumerator = (AbstractEnumerator)object;
            long nameSize = ObjectSizer.getSize(enumerator.getName());
            long literalSize = ObjectSizer.getSize(enumerator.getLiteral());
            result.size = (int)((long)result.size + (nameSize + literalSize + 4L + 8L + extra));
        } else if (object instanceof Date) {
            result.size = (int)((long)result.size + (28L + extra));
        } else if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            long stringSize = ObjectSizer.getSize(bigDecimal.toString());
            result.size = (int)((long)result.size + (stringSize + 8L + extra));
        } else if (object instanceof Sizeable) {
            Sizeable sizeable = (Sizeable)object;
            long size = sizeable.getObjectSize(this);
            result.size = (int)((long)result.size + (size + extra));
        } else {
            String className = object.getClass().getName();
            if ("com.ibm.team.repository.client.internal.TeamRepository".equals(className)) {
                result.size += 0;
                return;
            }
            List list = unsizeableObjectList;
            synchronized (list) {
                if (unsizeableObjectList.contains(className)) {
                    result.size += 0;
                    return;
                }
                String message = "Unhandled ObjectSizer Class Case : '%s'";
                logger.warn((Object)String.format(message, className));
                unsizeableObjectList.add(className);
                result.size += 0;
            }
        }
    }

    private class SizeResult {
        int size = 0;
        private LinkedList<Object> objectStack = new LinkedList();
        private IdentityHashMap<Object, Object> objectMap = new IdentityHashMap();

        public SizeResult(Object root) {
            this.objectMap.put(root, root);
        }

        public Object pop() {
            if (this.objectStack.isEmpty()) {
                return null;
            }
            Object o = this.objectStack.removeLast();
            this.objectMap.remove(o);
            return o;
        }

        public void push(Object o) {
            if (o == null || this.objectMap.containsKey(o)) {
                return;
            }
            this.objectStack.addLast(o);
            this.objectMap.put(o, o);
        }
    }

    public static interface Sizeable {
        public long getObjectSize(ObjectSizer var1);
    }
}

