/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.transport;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public abstract class AbstractElementDescriptor {
    private static final String ATTRIBUTE_IS_MISSING_ERROR = "The %s bundle's plugin.xml file contains a <%s> element that has a missing '%s' attribute value.";
    private static final String ATTRIBUTE_IS_ILLEGAL_ERROR = "The %s bundle's plugin.xml file contains a <%s> element that has an illegal '%s' attribute value '%s'.";
    private static final String ATTRIBUTE_IS_DEPRECATED_ERROR = "The %s bundle's plugin.xml file contains a <%s> element that is using the deprecated '%s' attribute value. Use the '%s' attribute instead.";
    private static final String ELEMENT_DOES_HAVE_NESTED_ELEMENTS = "The %s bundle's plugin.xml file contains a <%s> element that does not contain at least one nested element.";
    private static final Log LOGGER = LogFactory.getLog(AbstractElementDescriptor.class);
    private static final String REPOSITORY_SERVICE_BUNDLE = "com.ibm.team.repository.service";
    private IConfigurationElement element;
    private String bundleSymbolicName;

    protected AbstractElementDescriptor(IConfigurationElement element, String name) {
        this.basicInitialize(element, name);
        this.initialize();
        this.processChildren();
        this.checkElement();
    }

    private void basicInitialize(IConfigurationElement element, String name) {
        this.setElement(element);
        this.checkElementName(name);
        String bundleSymbolicName = element.getNamespaceIdentifier();
        this.setBundleSymbolicName(bundleSymbolicName);
    }

    private Class<?> basicLoadClass(String name) throws ClassNotFoundException {
        Bundle bundle = this.getBundle();
        if (bundle == null) {
            throw new ClassNotFoundException("bundle is null");
        }
        Class clazz = bundle.loadClass(name);
        return clazz;
    }

    protected final void basicPrintOn(StringBuffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer must not be null");
        }
        String value = super.toString();
        int index = value.lastIndexOf(46);
        value = value.substring(index + 1);
        buffer.append(value);
    }

    protected final boolean checkAttributeIsLegal(String attributeValue, String attributeName, boolean throwException, String ... legalValues) throws IllegalArgumentException {
        this.checkAttributeIsSet(attributeValue, attributeName, throwException);
        if (legalValues == null || legalValues.length == 0) {
            throw new IllegalArgumentException("legalValues must not be null or empty");
        }
        String[] stringArray = legalValues;
        int n = legalValues.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            boolean match = value.equals(attributeValue);
            if (match) {
                return true;
            }
            ++n2;
        }
        String bundleSymbolicName = this.getBundleSymbolicName();
        String elementName = this.getElementName();
        String message = String.format(ATTRIBUTE_IS_ILLEGAL_ERROR, bundleSymbolicName, elementName, attributeName, attributeValue);
        if (throwException) {
            throw new IllegalArgumentException(message);
        }
        LOGGER.warn((Object)message);
        return false;
    }

    protected final void checkAttributeIsLegal(String attributeValue, String attributeName, String ... legalValues) throws IllegalArgumentException {
        this.checkAttributeIsLegal(attributeValue, attributeName, true, legalValues);
    }

    protected final void checkAttributeIsSet(String attributeValue, String attributeName) throws IllegalArgumentException {
        this.checkAttributeIsSet(attributeValue, attributeName, true);
    }

    protected final boolean checkAttributeIsSet(String attributeValue, String attributeName, boolean throwException) throws IllegalArgumentException {
        boolean valid;
        boolean bl = valid = attributeValue != null && attributeValue.length() != 0;
        if (valid) {
            return true;
        }
        if (attributeName == null) {
            throw new IllegalArgumentException("attributeName must not be null");
        }
        String bundleSymbolicName = this.getBundleSymbolicName();
        String elementName = this.getElementName();
        String message = String.format(ATTRIBUTE_IS_MISSING_ERROR, bundleSymbolicName, elementName, attributeName);
        if (throwException) {
            throw new IllegalArgumentException(message);
        }
        LOGGER.warn((Object)message);
        return false;
    }

    protected void checkElement() {
    }

    private void checkElementName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        String value = this.getElementName();
        boolean valid = value.equalsIgnoreCase(name);
        if (valid) {
            return;
        }
        String message = String.format("Illegal element name: %s", value);
        throw new IllegalArgumentException(message);
    }

    protected final void checkHasChildren() {
        boolean children = this.hasChildren();
        if (children) {
            return;
        }
        String bundleSymbolicName = this.getBundleSymbolicName();
        String elementName = this.getElementName();
        String message = String.format(ELEMENT_DOES_HAVE_NESTED_ELEMENTS, bundleSymbolicName, elementName);
        throw new IllegalArgumentException(message);
    }

    protected final Object createInstance(String attribute) throws CoreException {
        if (attribute == null) {
            throw new IllegalArgumentException("attribute must not be null");
        }
        IConfigurationElement element = this.getElement();
        Object object = null;
        try {
            object = element.createExecutableExtension(attribute);
        }
        catch (CoreException exception) {
            String message = exception.getMessage();
            this.logError(message, exception);
            throw exception;
        }
        catch (RuntimeException exception) {
            String message = exception.getMessage();
            this.logError(message, exception);
        }
        return object;
    }

    protected final int estimateHashedCollectionSize(int capacity) {
        if (capacity <= 0) {
            return 0;
        }
        int size = capacity * 4 / 3 + 1;
        return size;
    }

    private IConfigurationElement getAncestor(IConfigurationElement element, String name) {
        IConfigurationElement ancestor = null;
        Object parent = element.getParent();
        if (parent instanceof IConfigurationElement) {
            IConfigurationElement parentElement = (IConfigurationElement)parent;
            String parentElementName = this.safeGetName(parentElement);
            boolean match = parentElementName.equals(name);
            ancestor = match ? parentElement : this.getAncestor(parentElement, name);
        }
        return ancestor;
    }

    private String safeGetName(IConfigurationElement parentElement) {
        int tries = 0;
        while (true) {
            try {
                return parentElement.getName();
            }
            catch (InvalidRegistryObjectException e) {
                LOGGER.error((Object)(this + ":  Failed to get IConfigurationElement's name"));
                if (tries >= 15) {
                    throw e;
                }
                ++tries;
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
            }
            break;
        }
    }

    protected final IConfigurationElement getAncestor(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        IConfigurationElement element = this.getElement();
        IConfigurationElement ancestor = this.getAncestor(element, name);
        return ancestor;
    }

    protected final String getAttribute(String name) {
        String value = this.getAttribute(name, null);
        return value;
    }

    protected final String getAttribute(String name, String defaultValue) {
        IConfigurationElement element = this.getElement();
        String value = element.getAttribute(name);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    protected final Bundle getBundle() {
        String bundleSymbolicName = this.getBundleSymbolicName();
        Bundle bundle = this.getBundle(bundleSymbolicName);
        return bundle;
    }

    protected final Bundle getBundle(String bundleSymbolicName) {
        if (bundleSymbolicName == null) {
            throw new IllegalArgumentException("bundleSymbolicName must not be null");
        }
        Bundle bundle = Platform.getBundle((String)bundleSymbolicName);
        return bundle;
    }

    public final BundleContext getBundleContext() {
        boolean resolved;
        Bundle bundle = this.getBundle();
        BundleContext bundleContext = bundle.getBundleContext();
        if (bundleContext != null) {
            return bundleContext;
        }
        int state = bundle.getState();
        boolean bl = resolved = (state & 4) != 0;
        if (resolved) {
            try {
                bundle.start();
                bundleContext = bundle.getBundleContext();
                if (bundleContext != null) {
                    return bundleContext;
                }
            }
            catch (BundleException exception) {
                String message = exception.getMessage();
                LOGGER.error((Object)message, (Throwable)exception);
            }
        }
        bundle = Platform.getBundle((String)REPOSITORY_SERVICE_BUNDLE);
        bundleContext = bundle.getBundleContext();
        return bundleContext;
    }

    public final String getBundleSymbolicName() {
        return this.bundleSymbolicName;
    }

    private IConfigurationElement[] getChildren() {
        IConfigurationElement element = this.getElement();
        IConfigurationElement[] children = element.getChildren();
        return children;
    }

    protected final IConfigurationElement getElement() {
        return this.element;
    }

    protected final String getElementName() {
        IConfigurationElement element = this.getElement();
        String name = this.safeGetName(element);
        return name;
    }

    protected final int getNumberOfChildren() {
        IConfigurationElement[] children = this.getChildren();
        int size = children.length;
        return size;
    }

    protected final String getValue() {
        IConfigurationElement element = this.getElement();
        String value = element.getValue();
        return value;
    }

    protected final boolean hasChildren() {
        int size = this.getNumberOfChildren();
        boolean result = size > 0;
        return result;
    }

    protected void initialize() {
    }

    protected final Class<?> loadClass(String name) throws ClassNotFoundException {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        Class<?> clazz = this.basicLoadClass(name);
        boolean isInterface = clazz.isInterface();
        if (isInterface) {
            String message = String.format("The value \"%s\" is not the name of a class", name);
            throw new IllegalArgumentException(message);
        }
        return clazz;
    }

    protected final Class<?> loadInterface(String name) throws ClassNotFoundException {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        Class<?> clazz = this.basicLoadClass(name);
        boolean isInterface = clazz.isInterface();
        if (!isInterface) {
            String message = String.format("The value \"%s\" is not the name of an interface", name);
            throw new IllegalArgumentException(message);
        }
        return clazz;
    }

    protected final void logAttributeIsDeprecated(String oldAttribute, String newAttribute) {
        if (oldAttribute == null) {
            throw new IllegalArgumentException("oldAttribute must not be null");
        }
        if (newAttribute == null) {
            throw new IllegalArgumentException("newAttribute must not be null");
        }
        String bundleSymbolicName = this.getBundleSymbolicName();
        String elementName = this.getElementName();
        String message = String.format(ATTRIBUTE_IS_DEPRECATED_ERROR, bundleSymbolicName, elementName, oldAttribute, newAttribute);
        LOGGER.warn((Object)message);
    }

    protected final void logError(String message, Throwable throwable) {
        LOGGER.error((Object)message, throwable);
    }

    protected final void logFailedToProcessChildError(IConfigurationElement child) {
        if (child == null) {
            throw new IllegalArgumentException("child must not be null");
        }
        String elementName = this.getElementName();
        String childName = this.safeGetName(child);
        String message = String.format("Failed to process '%s' child named '%s'", elementName, childName);
        LOGGER.error((Object)message);
    }

    protected final void logWarning(String message) {
        LOGGER.warn((Object)message);
    }

    protected final void printBundleSymbolicNameOn(StringBuffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer must not be null");
        }
        String bundleSymbolicName = this.getBundleSymbolicName();
        this.printOn(buffer, "bundle", bundleSymbolicName);
    }

    private void printNullOn(StringBuffer buffer, String key) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer must not be null");
        }
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        String pattern = ", %s=null";
        String message = String.format(pattern, key);
        buffer.append(message);
    }

    private void printObjectOn(StringBuffer buffer, String key, Object value) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer must not be null");
        }
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        String pattern = ", %s=<%s>";
        String message = String.format(pattern, key, value);
        buffer.append(message);
    }

    protected void printOn(StringBuffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer must not be null");
        }
        this.basicPrintOn(buffer);
        this.printBundleSymbolicNameOn(buffer);
    }

    protected final void printOn(StringBuffer buffer, String key, Object value) {
        if (value == null) {
            this.printNullOn(buffer, key);
        } else {
            this.printObjectOn(buffer, key, value);
        }
    }

    protected final void printOn(StringBuffer buffer, String key, String value) {
        if (value == null) {
            this.printNullOn(buffer, key);
        } else {
            this.printStringOnBuffer(buffer, key, value);
        }
    }

    private void printStringOnBuffer(StringBuffer buffer, String key, String value) {
        String pattern = ", %s=\"%s\"";
        String message = String.format(pattern, key, value);
        buffer.append(message);
    }

    protected void processChild(IConfigurationElement child) {
        this.logFailedToProcessChildError(child);
    }

    private void processChildren() {
        IConfigurationElement[] children;
        IConfigurationElement[] iConfigurationElementArray = children = this.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            try {
                this.processChild(child);
            }
            catch (Throwable exception) {
                exception.printStackTrace();
                String message = exception.getMessage();
                LOGGER.error((Object)message, exception);
            }
            ++n2;
        }
    }

    private void setBundleSymbolicName(String bundleSymbolicName) {
        this.bundleSymbolicName = bundleSymbolicName;
    }

    private void setElement(IConfigurationElement element) {
        if (element == null) {
            throw new IllegalArgumentException("element must not be null");
        }
        this.element = element;
    }

    public final String toString() {
        String value;
        StringBuffer buffer = new StringBuffer(256);
        try {
            this.printOn(buffer);
            value = buffer.toString();
        }
        catch (Throwable exception) {
            String message = exception.getMessage();
            LOGGER.error((Object)message);
            value = super.toString();
        }
        return value;
    }
}

