/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.transport.auth;

import com.ibm.team.repository.transport.auth.Messages;
import com.ibm.team.repository.transport.auth.Tracer;
import com.ibm.team.repository.transport.auth.TransportAuthException;
import com.ibm.team.repository.transport.auth.TransportAuthUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;

public class TransportAuthUtil2 {
    public static final String X_NO_RETRY_HEADER = "X-com-ibm-team-repository.common.remoteaccess.noRetry";
    public static final String FORM_AUTH_HEADER = "X-com-ibm-team-repository-web-auth-msg";
    public static final String FORM_AUTH_REQUIRED_MSG = "authrequired";
    public static final String FORM_AUTH_FAILED_MSG = "authfailed";
    public static final String FORM_AUTH_URI = "j_security_check";
    public static final String FORM_AUTH_USER_FIELD = "j_username";
    public static final String FORM_AUTH_PASSWORD_FIELD = "j_password";
    public static final String FORM_LOGOUT_URI = "/auth/logout";
    public static final String FORM_AUTH_FAILED_URI = "/auth/authfailed";
    public static final String FORM_AUTH_REQUESTED_URI = "/auth/authrequired";
    public static final String FORM_AUTH = "FORM";
    public static final String BASIC_AUTH = "BASIC";
    public static final String LOCATION = "Location";
    public static final String CONTENT_TYPE_HEADER = "Content-Type";
    public static final String CONTENT_TYPE_FORM_URLENCODED = "application/x-www-form-urlencoded; charset=utf-8";
    public static final String SLASH = "/";
    private static final String NLS_UNEXPECTED_LOGIN_ERROR = "TransportAuthUtil.UnexpectedLoginError";
    private static final String NLS_UNEXPECTED_STATUS = "TransportAuthUtil.UnexpectedStatus";
    private static final String NLS_INVALID_CREDENTIALS = "TransportAuthUtil.InvalidCredentials";
    private static final String NLS_SERVLET_ERROR = "TransportAuthUtil.ServletError";
    private static final String NLS_SERVER_CONFIG_ERROR = "TransportAuthUtil.ServerConfigError";
    private static final String NLS_LOGIN_ERROR = "TransportAuthUtil.LoginError";
    private static final Tracer _tracer = new Tracer(TransportAuthUtil.class);

    public static HttpRequest formBasedAuthenticate(String repoPath, HttpClient httpClient, UsernamePasswordCredentials storedCredentials) throws TransportAuthException, UnsupportedEncodingException {
        _tracer.enter("formBasedAuthenticate", new Object[0]);
        try {
            if (!repoPath.endsWith(SLASH)) {
                repoPath = String.valueOf(repoPath) + SLASH;
            }
            String formAuthURI = String.valueOf(repoPath) + FORM_AUTH_URI;
            _tracer.debug("formAuthURI: %s", formAuthURI);
            HttpPost postMethod = new HttpPost(formAuthURI);
            ArrayList<BasicNameValuePair> parms = new ArrayList<BasicNameValuePair>();
            parms.add(new BasicNameValuePair(FORM_AUTH_USER_FIELD, storedCredentials.getUserName()));
            parms.add(new BasicNameValuePair(FORM_AUTH_PASSWORD_FIELD, storedCredentials.getPassword()));
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(parms);
            postMethod.setEntity((HttpEntity)entity);
            postMethod.addHeader(CONTENT_TYPE_HEADER, CONTENT_TYPE_FORM_URLENCODED);
            HttpResponse response = null;
            try {
                response = httpClient.execute((HttpUriRequest)postMethod);
                int rc = response.getStatusLine().getStatusCode();
                _tracer.debug("statusCode: %d", rc);
                if (rc == 400) {
                    TransportAuthUtil2.visitAuthenticatedURL(repoPath, httpClient);
                    HttpRequest method = TransportAuthUtil2.formBasedAuthenticate(repoPath, httpClient, storedCredentials);
                    TransportAuthUtil2.visitAuthenticatedURL(repoPath, httpClient);
                    HttpRequest httpRequest = method;
                    return httpRequest;
                }
                try {
                    Header authHeader = response.getFirstHeader(FORM_AUTH_HEADER);
                    if (authHeader != null) {
                        if (authHeader.getValue().equals(FORM_AUTH_REQUIRED_MSG)) {
                            _tracer.trace("formBasedAuthenticate - throwing TransportAuthException - authHeader: %s", authHeader.getValue());
                            throw new TransportAuthException(MessageFormat.format(Messages.getString(NLS_SERVER_CONFIG_ERROR), FORM_AUTH_URI));
                        }
                        if (authHeader.getValue().equals(FORM_AUTH_FAILED_MSG)) {
                            _tracer.trace("formBasedAuthenticate - throwing TransportAuthException - authHeader: %s", authHeader.getValue());
                            throw new TransportAuthException(Messages.getString(NLS_INVALID_CREDENTIALS));
                        }
                        _tracer.trace("formBasedAuthenticate - throwing TransportAuthException - authHeader: %s", authHeader.getValue());
                        throw new TransportAuthException(MessageFormat.format(Messages.getString(NLS_SERVLET_ERROR), FORM_AUTH_REQUIRED_MSG, FORM_AUTH_FAILED_MSG, authHeader.getValue()));
                    }
                    if (rc == 302) {
                        String redirectURI = response.getFirstHeader(LOCATION).getValue();
                        if (redirectURI.matches("^.*/auth/authfailed.*$")) {
                            _tracer.trace("formBasedAuthenticate - throwing TransportAuthException - redirectUri: %s", redirectURI);
                            throw new TransportAuthException(Messages.getString(NLS_INVALID_CREDENTIALS));
                        }
                    } else if (rc != 200) {
                        String msg = MessageFormat.format(Messages.getString(NLS_UNEXPECTED_STATUS), formAuthURI, 302, rc);
                        _tracer.trace("formBasedAuthenticate - throwing TransportAuthException - %s", msg);
                        throw new TransportAuthException(msg);
                    }
                }
                catch (Exception e) {
                    if (e.getClass().equals(TransportAuthException.class)) {
                        _tracer.trace("formBasedAuthenticate - re-throwing TransportAuthException", new Object[0]);
                        throw (TransportAuthException)e;
                    }
                    String msg = MessageFormat.format(Messages.getString(NLS_UNEXPECTED_LOGIN_ERROR), e.getMessage());
                    _tracer.trace("formBasedAuthenticate - throwing TransportAuthException - %s", msg);
                    throw new TransportAuthException(msg, e);
                }
            }
            finally {
                TransportAuthUtil2.finalize(response);
            }
            HttpPost httpPost = postMethod;
            return httpPost;
        }
        finally {
            _tracer.leave("formBasedAuthenticate", new Object[0]);
        }
    }

    public static int visitAuthenticatedURL(String repoPath, HttpClient httpClient) throws TransportAuthException {
        _tracer.enter("visitAuthenticatedURL", new Object[0]);
        try {
            if (!repoPath.endsWith(SLASH)) {
                repoPath = String.valueOf(repoPath) + SLASH;
            }
            HttpGet authenticatedURL = new HttpGet(String.valueOf(repoPath) + "authenticated/identity");
            _tracer.debug("Path: %s", authenticatedURL.getURI().getPath());
            HttpParams params = httpClient.getParams();
            params.setBooleanParameter("http.protocol.handle-redirects", true);
            HttpResponse response = null;
            int statusCode = 0;
            try {
                try {
                    response = httpClient.execute((HttpUriRequest)authenticatedURL);
                    statusCode = response.getStatusLine().getStatusCode();
                }
                catch (Exception e) {
                    String msg = MessageFormat.format(Messages.getString(NLS_UNEXPECTED_LOGIN_ERROR), e.getMessage());
                    _tracer.trace("visitAuthenticatedURL - throwning TransportAuthException: %s", msg);
                    throw new TransportAuthException(msg, e);
                }
            }
            catch (Throwable throwable) {
                TransportAuthUtil2.finalize(response);
                throw throwable;
            }
            TransportAuthUtil2.finalize(response);
            _tracer.debug("HTTP status code after touching \"%s\": %d", authenticatedURL.getURI().getPath(), statusCode);
            int n = statusCode;
            return n;
        }
        finally {
            _tracer.leave("visitAuthenticatedURL", new Object[0]);
        }
    }

    public static String determineAuthMethod(HttpClient httpClient, String repoPath) throws TransportAuthException {
        if (httpClient == null) {
            throw new IllegalArgumentException("httpClient must not be null");
        }
        if (repoPath == null) {
            throw new IllegalArgumentException("repoPath must not be null");
        }
        _tracer.enter("determineAuthMethod", new Object[0]);
        try {
            if (!repoPath.endsWith(SLASH)) {
                repoPath = String.valueOf(repoPath) + SLASH;
            }
            repoPath = String.valueOf(repoPath) + FORM_AUTH_URI;
            _tracer.debug("path: %s", repoPath);
            HttpGet formAuth = new HttpGet(repoPath);
            String serverAuthMethod = null;
            HttpParams params = httpClient.getParams();
            params.setBooleanParameter("http.protocol.handle-redirects", false);
            HttpResponse response = null;
            try {
                try {
                    response = httpClient.execute((HttpUriRequest)formAuth);
                    int rc = response.getStatusLine().getStatusCode();
                    _tracer.debug("status: %d", rc);
                    serverAuthMethod = rc == 200 ? FORM_AUTH : (rc == 302 && response.getFirstHeader(LOCATION).getValue().matches("^.*/auth/authfailed.*$") ? FORM_AUTH : BASIC_AUTH);
                }
                catch (Exception e) {
                    String msg = MessageFormat.format(Messages.getString(NLS_LOGIN_ERROR), e.getMessage());
                    _tracer.trace("determineAuthMethod - throwing TransportAuthException: %s", msg);
                    throw new TransportAuthException(msg, e);
                }
            }
            catch (Throwable throwable) {
                TransportAuthUtil2.finalize(response);
                throw throwable;
            }
            TransportAuthUtil2.finalize(response);
            _tracer.trace("determineAuthMethod - authMethod: %s", serverAuthMethod);
            String string = serverAuthMethod;
            return string;
        }
        finally {
            _tracer.leave("determineAuthMethod", new Object[0]);
        }
    }

    public static boolean credDefined(UsernamePasswordCredentials storedCredentials) {
        _tracer.enter("credDefined", new Object[0]);
        try {
            String storedUsername = null;
            String storedPassword = null;
            if (storedCredentials != null) {
                storedUsername = storedCredentials.getUserName();
                storedPassword = storedCredentials.getPassword();
            }
            boolean retval = storedUsername != null && storedUsername.length() != 0 && storedPassword != null && storedPassword.length() != 0;
            _tracer.trace("credDefined: %s", retval);
            boolean bl = retval;
            return bl;
        }
        finally {
            _tracer.leave("credDefined", new Object[0]);
        }
    }

    public static void finalize(HttpResponse response) {
        if (response == null) {
            return;
        }
        try {
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
        catch (IOException iOException) {}
    }
}

