/**
 * <copyright>
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2006, 2009. All Rights Reserved. 
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 * </copyright>
 *
 * $Id$
 */
package com.ibm.team.foundation.rcp.core.internal.favorites.util;

import com.ibm.team.foundation.rcp.core.IModelAccessor;
import com.ibm.team.foundation.rcp.core.internal.favorites.*;
import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

import com.ibm.team.foundation.rcp.core.internal.favorites.Favorite;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesFolder;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesNode;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesPackage;
import com.ibm.team.foundation.rcp.core.internal.favorites.ModelAccessor;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 *
 * @since 0.5
 * <!-- end-user-doc -->
 * @see com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesPackage
 * @generated
 */
public class FavoritesSwitch {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static FavoritesPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FavoritesSwitch() {
		if (modelPackage == null) {
			modelPackage = FavoritesPackage.eINSTANCE;
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	public Object doSwitch(EObject theEObject) {
		return doSwitch(theEObject.eClass(), theEObject);
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected Object doSwitch(EClass theEClass, EObject theEObject) {
		if (theEClass.eContainer() == modelPackage) {
			return doSwitch(theEClass.getClassifierID(), theEObject);
		} else {
			List eSuperTypes = theEClass.getESuperTypes();
			return eSuperTypes.isEmpty() ? defaultCase(theEObject) : doSwitch(
					(EClass) eSuperTypes.get(0), theEObject);
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected Object doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
		case FavoritesPackage.FAVORITES_NODE: {
			FavoritesNode favoritesNode = (FavoritesNode) theEObject;
			Object result = caseFavoritesNode(favoritesNode);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case FavoritesPackage.URI_FAVORITE: {
			URIFavorite uriFavorite = (URIFavorite) theEObject;
			Object result = caseURIFavorite(uriFavorite);
			if (result == null)
				result = caseFavoritesNode(uriFavorite);
			if (result == null)
				result = caseModelAccessor(uriFavorite);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case FavoritesPackage.FAVORITES_FOLDER: {
			FavoritesFolder favoritesFolder = (FavoritesFolder) theEObject;
			Object result = caseFavoritesFolder(favoritesFolder);
			if (result == null)
				result = caseFavoritesNode(favoritesFolder);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case FavoritesPackage.FAVORITE: {
			Favorite favorite = (Favorite) theEObject;
			Object result = caseFavorite(favorite);
			if (result == null)
				result = caseFavoritesNode(favorite);
			if (result == null)
				result = caseModelAccessor(favorite);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case FavoritesPackage.MODEL_ACCESSOR: {
			ModelAccessor modelAccessor = (ModelAccessor) theEObject;
			Object result = caseModelAccessor(modelAccessor);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		default:
			return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Node</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Node</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseFavoritesNode(FavoritesNode object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>URI Favorite</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>URI Favorite</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseURIFavorite(URIFavorite object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Folder</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Folder</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseFavoritesFolder(FavoritesFolder object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Favorite</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Favorite</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseFavorite(Favorite object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Model Accessor</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Model Accessor</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseModelAccessor(ModelAccessor object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Model Accessor Facade</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Model Accessor Facade</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseModelAccessorFacade(IModelAccessor object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	public Object defaultCase(EObject object) {
		return null;
	}

} //FavoritesSwitch
