/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.daemon.trace;

import com.ibm.team.filesystem.client.internal.daemon.Messages;
import com.ibm.team.filesystem.client.restproxy.Discovery2;
import java.io.File;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.osgi.util.NLS;

public abstract class DaemonTraceConfigurator {
    private static final Log log = LogFactory.getLog((String)DaemonTraceConfigurator.class.getName());
    public static final String PREF_TRACE_DISABLE = "trace.disable";
    public static final boolean DEFAULT_TRACE_DISABLE = false;
    public static final String PREF_TRACE_DIR = "trace.dir";
    public static final String PREF_MAX_TRACE_FILE_SIZE = "trace.file.max_size";
    public static final long DEFAULT_MAX_TRACE_FILE_SIZE = 80000L;
    public static final String PREF_MAX_TRACE_DIR_SIZE = "trace.dir.max_size";
    public static final long DEFAULT_MAX_TRACE_DIR_SIZE = 2000000L;
    public static final String PREF_TRACE_COMPRESS = "trace.file.compress";
    public static final boolean DEFAULT_TRACE_COMPRESS = true;

    public static Discovery2.AutoTracingParams configure(Discovery2.DiscoveryParams params, File configRoot, Map<String, String> env, Map<String, String> config) {
        try {
            return DaemonTraceConfigurator.doConfigure(params, configRoot, env, config);
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }

    private static Discovery2.AutoTracingParams doConfigure(Discovery2.DiscoveryParams params, File configRoot, Map<String, String> env, Map<String, String> config) {
        if (DaemonTraceConfigurator.getBoolean(env, "SCM_TRACE_DISABLE", config, PREF_TRACE_DISABLE, false)) {
            return null;
        }
        String rootString = DaemonTraceConfigurator.getString(env, "SCM_TRACE_DIR", config, PREF_TRACE_DIR, null);
        File traceRoot = rootString == null ? new File(configRoot, "trace") : new File(rootString);
        Discovery2.AutoTracingParams autoTrace = new Discovery2.AutoTracingParams(traceRoot, DaemonTraceConfigurator.getSize(env, "SCM_TRACE_MAX_FILE_SIZE", config, PREF_MAX_TRACE_FILE_SIZE, 80000L), DaemonTraceConfigurator.getSize(env, "SCM_TRACE_MAX_DIR_SIZE", config, PREF_MAX_TRACE_DIR_SIZE, 2000000L), DaemonTraceConfigurator.getBoolean(env, "SCM_TRACE_COMPRESS", config, PREF_TRACE_COMPRESS, true));
        params.setAutoTraceParams(autoTrace);
        return autoTrace;
    }

    private static boolean getBoolean(Map<String, String> env, String envKey, Map<String, String> config, String configKey, boolean defaultValue) {
        String envValue;
        if (env != null && (envValue = env.get(envKey)) != null) {
            try {
                return DaemonTraceConfigurator.parseBoolean(envValue);
            }
            catch (NumberFormatException e) {
                log.error((Object)NLS.bind((String)Messages.getString("DaemonTraceConfigurator_BAD_ENVIRONMENT_VARIABLE"), (Object)envValue, (Object)envKey), (Throwable)e);
            }
        }
        if (config == null) {
            return defaultValue;
        }
        String val = config.get(configKey);
        if (val == null) {
            return defaultValue;
        }
        try {
            return DaemonTraceConfigurator.parseBoolean(val);
        }
        catch (NumberFormatException e) {
            log.error((Object)NLS.bind((String)Messages.getString("DaemonTraceConfigurator_BAD_CONFIG_FILE"), (Object)val, (Object)configKey), (Throwable)e);
            return defaultValue;
        }
    }

    private static boolean parseBoolean(String envValue) throws NumberFormatException {
        if ("1".equalsIgnoreCase(envValue = envValue.trim()) || "t".equalsIgnoreCase(envValue) || "true".equalsIgnoreCase(envValue)) {
            return true;
        }
        if ("0".equalsIgnoreCase(envValue) || "f".equalsIgnoreCase(envValue) || "false".equalsIgnoreCase(envValue)) {
            return false;
        }
        throw new NumberFormatException();
    }

    private static long getSize(Map<String, String> env, String envKey, Map<String, String> config, String configKey, long defaultValue) {
        String envValue;
        if (env != null && (envValue = env.get(envKey)) != null) {
            try {
                return Integer.parseInt(envValue);
            }
            catch (NumberFormatException e) {
                log.error((Object)NLS.bind((String)Messages.getString("DaemonTraceConfigurator_BAD_ENVIRONMENT_VARIABLE"), (Object)envValue, (Object)envKey), (Throwable)e);
            }
        }
        if (config == null) {
            return defaultValue;
        }
        String val = config.get(configKey);
        if (val == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            log.error((Object)NLS.bind((String)Messages.getString("DaemonTraceConfigurator_BAD_CONFIG_FILE"), (Object)val, (Object)configKey), (Throwable)e);
            return defaultValue;
        }
    }

    private static String getString(Map<String, String> env, String envKey, Map<String, String> config, String configKey, String defaultValue) {
        String envValue;
        if (env != null && (envValue = env.get(envKey)) != null) {
            return envValue;
        }
        if (config == null) {
            return defaultValue;
        }
        String val = config.get(configKey);
        if (val == null) {
            return defaultValue;
        }
        return val;
    }
}

