/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.restproxy;

import com.ibm.team.filesystem.client.restproxy.RestInvocationParticipant;
import com.ibm.team.repository.client.IStatistics;
import com.ibm.team.repository.client.internal.Statistics;
import com.ibm.team.repository.client.util.StatisticsUtil;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.commons.httpclient.HttpMethod;

public class StatisticsRestParticipant
extends RestInvocationParticipant {
    public static final String SERVICE_METHOD_PROGRESS_POLLS = "serviceMethodProgressPolls";
    final Statistics stats;
    HashMap<RestInvocationParticipant.CallKey, Timings> timings = new HashMap();
    private Method[] dumpOnMethods = new Method[0];
    static final int NULL_TIME = -1;

    public StatisticsRestParticipant() {
        this.stats = new Statistics(null);
        this.stats.enable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preInvoke(RestInvocationParticipant.CallKey key, Object proxy, Method method, Object[] args) {
        HashMap<RestInvocationParticipant.CallKey, Timings> hashMap = this.timings;
        synchronized (hashMap) {
            assert (!this.timings.containsKey(key));
            this.timings.put(key, new Timings(method, System.currentTimeMillis()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preRequest(RestInvocationParticipant.CallKey key, HttpMethod request) {
        HashMap<RestInvocationParticipant.CallKey, Timings> hashMap = this.timings;
        synchronized (hashMap) {
            Timings timing = this.timings.get(key);
            assert (timing != null);
            assert (timing.preRequestTime == -1L);
            timing.preRequestTime = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postRequest(RestInvocationParticipant.CallKey key, HttpMethod request, Throwable t) {
        HashMap<RestInvocationParticipant.CallKey, Timings> hashMap = this.timings;
        synchronized (hashMap) {
            Timings timing = this.timings.get(key);
            assert (timing != null);
            assert (timing.postRequestTime == -1L);
            timing.postRequestTime = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postInvoke(RestInvocationParticipant.CallKey key, Object proxy, Method method, Object[] args, Object returnValue, Throwable exception) {
        Timings timing;
        if (exception != null) {
            return;
        }
        HashMap<RestInvocationParticipant.CallKey, Timings> hashMap = this.timings;
        synchronized (hashMap) {
            timing = this.timings.remove(key);
        }
        assert (timing != null);
        long now = System.currentTimeMillis();
        long elapsedTime = now - timing.startTime;
        this.stats.incStatisticValue("com.ibm.team.repository.statistics.serviceMethod", (Object)method, "serviceMethodElapsedTime", elapsedTime);
        this.stats.incStatisticValue("com.ibm.team.repository.statistics.service", (Object)method.getDeclaringClass().getName(), "serviceElapsedTime", elapsedTime);
        this.stats.incStatisticValue("com.ibm.team.repository.totalContext", (Object)this, "totalServiceElapsedTime", elapsedTime);
        this.stats.incStatisticValue("com.ibm.team.repository.statistics.serviceMethod", (Object)method, "serviceMethodCallCount", 1L);
        this.stats.incStatisticValue("com.ibm.team.repository.statistics.service", (Object)method.getDeclaringClass().getName(), "serviceCallCount", 1L);
        this.stats.incStatisticValue("com.ibm.team.repository.totalContext", (Object)this, "totalServiceCallCount", 1L);
        this.stats.incStatisticValue("com.ibm.team.repository.statistics.serviceMethod", (Object)method, "serviceMethodPreTransportTime", timing.preRequestTime - timing.startTime);
        this.stats.incStatisticValue("com.ibm.team.repository.statistics.serviceMethod", (Object)method, "serviceMethodTransportTime", timing.postRequestTime - timing.preRequestTime);
        this.stats.incStatisticValue("com.ibm.team.repository.statistics.serviceMethod", (Object)method, "serviceMethodPostTransportTime", now - timing.postRequestTime);
        Method[] methodArray = this.dumpOnMethods;
        int n = this.dumpOnMethods.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.equals(method)) {
                StatisticsRestParticipant.printStatistics((IStatistics)this.stats, System.err);
            }
            ++n2;
        }
    }

    public IStatistics getStatistics() {
        return this.stats;
    }

    public static void printStatistics(IStatistics stats2, PrintStream stream) {
        StatisticsUtil.printStatistics((IStatistics)stats2, (PrintStream)stream, (StatisticsUtil.StatisticsColumn[])new StatisticsUtil.StatisticsColumn[]{new StatisticsUtil.StatisticsColumn(){

            public String getName(IStatistics stats) {
                return "Prog. Updates";
            }

            public String getValue(IStatistics stats, Method method) {
                return Long.toString(stats.getStatisticValue("com.ibm.team.repository.statistics.serviceMethod", (Object)method, StatisticsRestParticipant.SERVICE_METHOD_PROGRESS_POLLS));
            }
        }});
    }

    public void setDumpStatsOnMethods(Method[] terminationMethods) {
        this.dumpOnMethods = terminationMethods;
    }

    private static class Timings {
        final long startTime;
        long preRequestTime = -1L;
        long postRequestTime = -1L;
        final Method method;

        Timings(Method m, long start) {
            this.method = m;
            this.startTime = start;
        }
    }
}

