/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.restproxy.notification;

import com.ibm.team.filesystem.client.daemon.OrderlyShutdownNotification;
import com.ibm.team.filesystem.client.daemon.events.ILightweightEventListener;
import com.ibm.team.filesystem.client.daemon.events.LightweightEventSource;
import com.ibm.team.filesystem.client.internal.daemon.FSDaemon;
import com.ibm.team.filesystem.client.internal.http.HttpRequest;
import com.ibm.team.filesystem.client.internal.http.HttpResponse;
import com.ibm.team.filesystem.client.internal.http.IExternalManager;
import com.ibm.team.filesystem.client.internal.http.constants.ResponseCode;
import com.ibm.team.filesystem.client.restproxy.exceptions.RestMarshallingException;
import com.ibm.team.filesystem.client.restproxy.notification.IServerNotificationChannel;
import com.ibm.team.filesystem.client.restproxy.notification.Notification;
import com.ibm.team.filesystem.client.restproxy.notification.NotificationDroppedEvent;
import com.ibm.team.filesystem.client.restproxy.notification.NotificationEvent;
import com.ibm.team.filesystem.client.restproxy.notification.NotificationMarshaller;
import com.ibm.team.filesystem.client.restproxy.notification.NotificationQueuedEvent;
import com.ibm.team.filesystem.client.restproxy.notification.NotificationSentEvent;
import com.ibm.team.repository.common.LogFactory;
import com.ibm.team.repository.common.transport.IParameterWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class ServerNotificationChannel
implements IServerNotificationChannel,
IExternalManager {
    private static final Log log = LogFactory.getLog((String)ServerNotificationChannel.class.getName());
    private final Queue<Channel> uninitializedChannels = new ConcurrentLinkedQueue<Channel>();
    private final Map<Channel, Object> channels = new ConcurrentHashMap<Channel, Object>();
    private boolean hasActiveChannels = false;
    private final Object isActiveLock = new Object();
    private final LinkedList<QueuedNotification> pendingNotifications = new LinkedList();
    private final Job notificationJob = new Job("FSD Notifier"){

        protected IStatus run(IProgressMonitor monitor) {
            return ServerNotificationChannel.this.runNotify(monitor);
        }
    };
    NotificationMarshaller marshaller = new NotificationMarshaller();
    private final FSDaemon fsd;
    private volatile LightweightEventSource<NotificationEvent> eventManager;

    public ServerNotificationChannel(FSDaemon fsd) {
        this.fsd = fsd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void manage(HttpRequest rq, HttpResponse rp) throws IOException {
        rp.setExternallyManaged(this);
        rq.setFinishedReading();
        Channel ch = new Channel(rp);
        Object object = this.isActiveLock;
        synchronized (object) {
            this.uninitializedChannels.add(ch);
            this.hasActiveChannels = true;
        }
        this.notificationJob.schedule();
    }

    @Override
    public void shutdown() {
        this.notificationJob.schedule();
    }

    @Override
    public void remoteClosed() {
        this.notificationJob.schedule();
    }

    @Override
    public void queueNotification(String key, String type, IParameterWrapper notification) {
        Notification<IParameterWrapper> n = new Notification<IParameterWrapper>(key, type, notification);
        this.queueNotification(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueNotification(Notification<?> n) {
        LinkedList<QueuedNotification> linkedList = this.isActiveLock;
        synchronized (linkedList) {
            if (!this.hasActiveChannels) {
                return;
            }
        }
        linkedList = this.pendingNotifications;
        synchronized (linkedList) {
            this.pendingNotifications.add(new QueuedNotification(n, System.currentTimeMillis()));
        }
        this.eventManager.fireEvent(new NotificationQueuedEvent((IServerNotificationChannel)this, (Notification)n));
        this.notificationJob.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus runNotify(IProgressMonitor monitor) {
        QueuedNotification notification;
        this.writeHeadersOnNewChannels();
        while ((notification = this.nextNotification()) != null) {
            this.sendNotification(notification);
        }
        this.closeConnectionsPendingShutDown();
        Object object = this.isActiveLock;
        synchronized (object) {
            this.hasActiveChannels = !this.uninitializedChannels.isEmpty() || !this.channels.isEmpty();
        }
        return Status.OK_STATUS;
    }

    /*
     * Unable to fully structure code
     */
    private void writeHeadersOnNewChannels() {
        if (!this.uninitializedChannels.isEmpty()) ** GOTO lbl14
        return;
lbl-1000:
        // 1 sources

        {
            try {
                channel.rp.setCode(ResponseCode.OK);
                channel.rp.writeHeader("Content-Type", "application/vnd.ibm.jazz-json-notification-1.0");
                stream = channel.rp.getResponseStream();
                stream.flush();
                this.channels.put(channel, channel);
                continue;
            }
            catch (IOException v0) {
                channel.rp.setIgnoreWriteErrors(true);
                channel.rp.close();
            }
lbl14:
            // 3 sources

            ** while ((channel = this.uninitializedChannels.poll()) != null)
        }
lbl15:
        // 1 sources

    }

    private void closeConnectionsPendingShutDown() {
        Iterator<Channel> i = this.channels.keySet().iterator();
        while (i.hasNext()) {
            Channel channel = i.next();
            if (!channel.isDone()) continue;
            if (channel.rp.shouldShutdown() && channel.rp.isClientConnected()) {
                try {
                    this.writeNotification(this.marshallNotification(new Notification<OrderlyShutdownNotification>("orderlyShutdown", OrderlyShutdownNotification.TYPE, new OrderlyShutdownNotification())), channel);
                }
                catch (IOException iOException) {
                    channel.rp.setIgnoreWriteErrors(true);
                }
            }
            i.remove();
            channel.rp.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected QueuedNotification nextNotification() {
        LinkedList<QueuedNotification> linkedList = this.pendingNotifications;
        synchronized (linkedList) {
            block4: {
                if (!this.pendingNotifications.isEmpty()) break block4;
                return null;
            }
            return this.pendingNotifications.remove();
        }
    }

    private void sendNotification(QueuedNotification notification) {
        byte[] bytes = this.marshallNotification(notification.notification);
        if (bytes == null) {
            return;
        }
        boolean sent = false;
        Iterator<Channel> i = this.channels.keySet().iterator();
        while (i.hasNext()) {
            sent = true;
            Channel channel = i.next();
            if (channel.isDone()) continue;
            try {
                this.writeNotification(bytes, channel);
                this.fireSentEvent(channel, notification);
            }
            catch (IOException e) {
                i.remove();
                channel.rp.setIgnoreWriteErrors(true);
                channel.rp.close();
                this.fireDroppedEvent(channel, notification, e.getMessage());
            }
        }
        if (!sent) {
            this.fireDroppedEvent(null, notification, "No available notification channels");
        }
    }

    private void fireSentEvent(Channel channel, QueuedNotification notification) {
        LightweightEventSource<NotificationEvent> eventManager = this.eventManager;
        if (eventManager != null) {
            eventManager.fireEvent(new NotificationSentEvent(this, channel.rp, notification.notification, System.currentTimeMillis() - notification.queuedAt));
        }
    }

    private void fireDroppedEvent(Channel channel, QueuedNotification notification, String reason) {
        LightweightEventSource<NotificationEvent> eventManager = this.eventManager;
        if (eventManager != null) {
            eventManager.fireEvent(new NotificationDroppedEvent(this, channel.rp, notification.notification, System.currentTimeMillis() - notification.queuedAt, reason));
        }
    }

    private byte[] marshallNotification(Notification<?> notification) {
        byte[] bytes;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            this.marshaller.write(buffer, notification.getKey(), notification.getType(), (IParameterWrapper)notification.getNotification());
            bytes = buffer.toByteArray();
        }
        catch (RestMarshallingException e) {
            log.error((Object)"Could not marshal notification", (Throwable)e);
            try {
                buffer.close();
            }
            catch (IOException iOException) {}
            return null;
        }
        catch (IOException e) {
            try {
                log.error((Object)"We should never get an IOException here", (Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    buffer.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                buffer.close();
            }
            catch (IOException iOException) {}
            return null;
        }
        try {
            buffer.close();
        }
        catch (IOException iOException) {}
        return bytes;
    }

    private void writeNotification(byte[] bytes, Channel channel) throws IOException {
        OutputStream out = channel.rp.getResponseStream();
        out.write(bytes);
        out.flush();
    }

    @Override
    public void addListener(ILightweightEventListener<? super NotificationEvent> listener) {
        LightweightEventSource<NotificationEvent> eventManager = this.eventManager;
        if (eventManager != null) {
            eventManager.addListener(listener);
        }
    }

    @Override
    public void removeListener(ILightweightEventListener<? super NotificationEvent> listener) {
        LightweightEventSource<NotificationEvent> eventManager = this.eventManager;
        if (eventManager != null) {
            eventManager.removeListener(listener);
        }
    }

    @Override
    public FSDaemon getFSDaemon() {
        return this.fsd;
    }

    public void setEventManager(LightweightEventSource<NotificationEvent> eventManager) {
        this.eventManager = eventManager;
    }

    private static class Channel {
        final HttpResponse rp;

        public Channel(HttpResponse rp) {
            this.rp = rp;
        }

        boolean isDone() {
            return this.rp.shouldShutdown() || !this.rp.isClientConnected();
        }
    }

    private static class QueuedNotification {
        final Notification<?> notification;
        final long queuedAt;

        public QueuedNotification(Notification<?> notification, long queuedAt) {
            this.notification = notification;
            this.queuedAt = queuedAt;
        }
    }
}

