/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.process;

import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.process.IModifyStreamOperationData;
import com.ibm.team.scm.common.process.IStreamChange;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ModifyStreamOperationData
implements IModifyStreamOperationData {
    private final IWorkspaceHandle targetWorkspace;
    private Map<String, IStreamChange> changes;
    private final int operationType;

    public ModifyStreamOperationData(IWorkspaceHandle targetWorkspace, int operationType) {
        this.targetWorkspace = targetWorkspace;
        this.operationType = operationType;
        this.changes = new HashMap<String, IStreamChange>();
    }

    @Override
    public IWorkspaceHandle getTargetWorkspace() {
        return this.targetWorkspace;
    }

    @Override
    public boolean isOperationType(int type) {
        return (this.operationType & type) != 0;
    }

    public void addChange(IStreamChange change) {
        this.changes.put(change.getIdentifier(), change);
    }

    @Override
    public IStreamChange getChange(String identifier) {
        return this.changes.get(identifier);
    }

    @Override
    public Set<String> getChangeIds() {
        return this.changes.keySet();
    }
}

