/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.common.internal.patch;

import com.ibm.team.filesystem.common.changemodel.FileChange;
import com.ibm.team.filesystem.common.changemodel.ResolvedConfigurationChangePaths;
import com.ibm.team.filesystem.common.internal.patch.DiffParticipant;
import com.ibm.team.filesystem.common.internal.patch.HunkRange;
import com.ibm.team.filesystem.common.internal.patch.RangeDifference;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.VersionedContentDeleted;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

public class CreateDiffUtil {
    public static final int BOTH_STATES_PRESENT = 0;
    public static final int BEFORE_STATE_DELETED = 1;
    public static final int AFTER_STATE_DELETED = 2;
    public static final String DIFF_DATE_FORMAT_STR = "yyyy-MM-dd HH:mm:ss.SSSSSSSSS Z";
    public static final String NO_TRAILING_NL_STRING = "\n\\ No newline at end of file\n";
    static final String UTF8 = "UTF-8";
    public static final byte[] NO_TRAILING_NL;
    public static final String NONEXISTENT_PATH = "/dev/null";
    static final int CONTEXT_LINES = 3;

    static {
        try {
            NO_TRAILING_NL = NO_TRAILING_NL_STRING.getBytes(UTF8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> void writeDiff(DiffParticipant<T> participant, FileChange change, ResolvedConfigurationChangePaths paths, IProgressMonitor monitor) throws IOException, TeamRepositoryException {
        String beforePath = null;
        String afterPath = null;
        if (paths != null) {
            if (!change.getInitial().isDeleted()) {
                beforePath = paths.computePath(change.getSiloedItemId(), true, null).toPath().toString();
            }
            if (!change.getFinal().isDeleted()) {
                afterPath = paths.computePath(change.getSiloedItemId(), false, null).toPath().toString();
            }
        }
        CreateDiffUtil.writeDiff(participant, change, beforePath, afterPath, true, monitor);
    }

    public static <T> int writeDiff(DiffParticipant<T> participant, FileChange change, String beforePath, String afterPath, boolean throwOnContentDeleted, IProgressMonitor monitor) throws IOException {
        int code;
        InputStream beforeStream;
        T afterRange;
        T beforeRange;
        InputStream afterStream;
        SubMonitor progress;
        block19: {
            progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            afterStream = null;
            beforeRange = null;
            afterRange = null;
            beforeStream = null;
            code = 0;
            try {
                try {
                    beforeStream = change.getInitial().getContents().getInputStream((IProgressMonitor)progress.newChild(25));
                    beforeRange = participant.getRange(beforeStream, change.getInitial().getCharacterEncoding());
                    beforeStream.close();
                    beforeStream = null;
                }
                catch (IOException e) {
                    if (!throwOnContentDeleted && e.getCause() instanceof VersionedContentDeleted) {
                        code = 1;
                    }
                    throw e;
                }
                try {
                    afterStream = change.getFinal().getContents().getInputStream((IProgressMonitor)progress.newChild(25));
                    afterRange = participant.getRange(afterStream, change.getFinal().getCharacterEncoding());
                }
                catch (IOException e) {
                    if (!throwOnContentDeleted && e.getCause() instanceof VersionedContentDeleted) {
                        code |= 2;
                        break block19;
                    }
                    throw e;
                }
            }
            finally {
                try {
                    if (beforeStream != null) {
                        beforeStream.close();
                    }
                }
                finally {
                    if (afterStream != null) {
                        afterStream.close();
                    }
                }
            }
        }
        if (code != 0) {
            return code;
        }
        beforeStream = null;
        afterStream = null;
        progress.setWorkRemaining(50);
        RangeDifference[] diff = participant.getDifferences(beforeRange, afterRange);
        progress.worked(50);
        if (diff.length != 0) {
            int[] counts;
            participant.writeHeader(beforePath, afterPath, change.getInitial().getTimestamp(), change.getFinal().getTimestamp());
            boolean beforeHasTrailingNL = participant.hasTrailingNL(beforeRange);
            int beforeLines = participant.numLines(beforeRange);
            boolean afterHasTrailingNL = participant.hasTrailingNL(afterRange);
            int afterLines = participant.numLines(afterRange);
            int lastHunk = 0;
            do {
                counts = CreateDiffUtil.writeHunk(diff, lastHunk, beforeLines, beforeHasTrailingNL, beforeRange, afterLines, afterHasTrailingNL, afterRange, null, false);
                HunkRange range = new HunkRange(counts[0], counts[1], counts[2], counts[3]);
                participant.writeHunkRange(range);
                CreateDiffUtil.writeHunk(diff, lastHunk, beforeLines, beforeHasTrailingNL, beforeRange, afterLines, afterHasTrailingNL, afterRange, participant, true);
            } while ((lastHunk = counts[4]) < diff.length);
        }
        return 0;
    }

    public static <T> int[] writeHunk(RangeDifference[] diff, int startIndex, int beforeLines, boolean beforeHasTrailingNL, T beforeRange, int afterLines, boolean afterHasTrailingNL, T afterRange, DiffParticipant<T> participant, boolean doWrite) throws IOException {
        boolean goAgain;
        int i = startIndex;
        int beforeBegin = diff[i].leftStart();
        int commonBeforeBegin = Math.max(beforeBegin - 3, 0);
        int commonAfterBegin = diff[i].rightStart() - beforeBegin + commonBeforeBegin;
        int numBeforeLines = 0;
        int numAfterLines = 0;
        int j = commonBeforeBegin;
        while (j < beforeBegin) {
            if (doWrite) {
                participant.writeCommonLine(beforeRange, j);
            }
            ++numBeforeLines;
            ++numAfterLines;
            ++j;
        }
        do {
            int commonLinesEnd;
            int beforeEnd = diff[i].leftEnd();
            int j2 = beforeBegin;
            while (j2 < beforeEnd) {
                if (doWrite) {
                    participant.writeRemovedLine(beforeRange, j2);
                    if (!beforeHasTrailingNL && j2 == beforeLines - 1) {
                        participant.writeNoTrailingNL(beforeRange);
                    }
                }
                ++numBeforeLines;
                ++j2;
            }
            int afterEnd = diff[i].rightEnd();
            int j3 = diff[i].rightStart();
            while (j3 < afterEnd) {
                if (doWrite) {
                    participant.writeAddedLine(afterRange, j3);
                    if (!afterHasTrailingNL && j3 == afterLines - 1) {
                        participant.writeNoTrailingNL(afterRange);
                    }
                }
                ++numAfterLines;
                ++j3;
            }
            if (i < diff.length - 1) {
                int nextStart = diff[i + 1].leftStart();
                if (nextStart <= beforeEnd + 6) {
                    goAgain = true;
                    commonLinesEnd = nextStart;
                    beforeBegin = nextStart;
                    ++i;
                } else {
                    goAgain = false;
                    commonLinesEnd = beforeEnd + 3;
                }
            } else {
                goAgain = false;
                commonLinesEnd = Math.min(beforeEnd + 3, beforeLines);
            }
            int j4 = beforeEnd;
            while (j4 < commonLinesEnd) {
                if (doWrite) {
                    participant.writeCommonLine(beforeRange, j4);
                    if (!beforeHasTrailingNL && j4 == beforeLines - 1) {
                        participant.writeNoTrailingNL(beforeRange);
                    }
                }
                ++numBeforeLines;
                ++numAfterLines;
                ++j4;
            }
        } while (goAgain);
        return new int[]{commonBeforeBegin, numBeforeLines, commonAfterBegin, numAfterLines, i + 1};
    }

    public static String getFilePatchHeader(String beforePath, String afterPath, Date beforeDate, Date afterDate) {
        StringBuffer result = new StringBuffer();
        boolean isCreation = false;
        boolean isDeletion = true;
        if (beforePath == null || beforePath.length() == 0 || beforeDate == null) {
            isCreation = true;
            beforePath = new Path(NONEXISTENT_PATH).toString();
            beforeDate = new Date(0L);
        }
        if (afterPath == null || afterPath.length() == 0 || afterDate == null) {
            isDeletion = true;
            afterPath = new Path(NONEXISTENT_PATH).toString();
            afterDate = new Date(0L);
        }
        if (isCreation || isDeletion) {
            result.append("diff -u -N ");
        } else {
            result.append("diff -u ");
        }
        SimpleDateFormat diff_date_format = new SimpleDateFormat(DIFF_DATE_FORMAT_STR, Locale.ENGLISH);
        result.append(beforePath);
        result.append(" ");
        result.append(afterPath);
        result.append("\n--- ");
        result.append(beforePath);
        result.append('\t');
        result.append(diff_date_format.format(beforeDate));
        result.append("\n+++ ");
        result.append(afterPath);
        result.append('\t');
        result.append(diff_date_format.format(afterDate));
        result.append('\n');
        return result.toString();
    }
}

