/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.client.internal;

import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.IURIReference;
import com.ibm.team.links.common.factory.IReferenceFactory;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.internal.Messages;
import com.ibm.team.workitem.client.internal.ModelPlugin;
import com.ibm.team.workitem.client.internal.util.InternalContentTypeUtils;
import com.ibm.team.workitem.common.internal.model.Attachment;
import com.ibm.team.workitem.common.internal.util.PermissionContext;
import com.ibm.team.workitem.common.model.IAttachment;
import com.ibm.team.workitem.common.model.IAttachmentHandle;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.WorkItemEndPoints;
import com.ibm.team.workitem.common.model.WorkItemLinkTypes;
import java.net.URI;
import java.sql.Timestamp;
import java.util.Date;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.content.IContentDescription;

public class ArtifactLink {
    private final WorkItemWorkingCopy fWorkingCopy;
    private IReference fReference;
    private IFileStore fFileStore;
    private IContent fContent;
    private String fFutureName;
    private IReference fTemporaryReference;
    private boolean fReplaced;
    private boolean fMoved;
    private IReference fReplacedReference;
    private Timestamp fCreationDate;
    private IContributorHandle fCreator;
    IItem fSharedItem;

    public ArtifactLink(WorkItemWorkingCopy workingCopy, IReference reference) {
        this.fWorkingCopy = workingCopy;
        this.fReference = reference;
        try {
            if (reference.isURIReference()) {
                this.fFileStore = EFS.getStore((URI)((IURIReference)reference).getURI());
            }
        }
        catch (CoreException x) {
            ModelPlugin.log(Messages.ArtifactLink_EXCEPTION_CREATING_FILE, (Exception)((Object)x));
        }
        this.grabSharedItem();
    }

    public IReference getReference() {
        return this.fReference;
    }

    public IReference getReplacedReference() {
        return this.fReplacedReference;
    }

    public String getId() {
        int begin;
        String text = null;
        text = this.fReplacedReference != null ? this.fReplacedReference.getComment() : this.getReference().getComment();
        if (text != null && (begin = text.indexOf(58)) > -1) {
            return text.substring(0, begin).trim();
        }
        return null;
    }

    public String getName() {
        if (this.fFutureName != null && !"".equals(this.fFutureName)) {
            return this.fFutureName;
        }
        if (this.fFileStore != null) {
            return this.fFileStore.getName();
        }
        String text = this.getReference().getComment();
        if (text == null || text.length() == 0) {
            return Messages.ArtifactLink_UNNAMED_ATTACHMENT_ENTRY;
        }
        int begin = text.indexOf(58);
        return begin > -1 ? text.substring(begin + 1).trim() : text;
    }

    public void setName(String name) {
        this.fFutureName = name;
        String id = this.getId();
        String text = name;
        if (id != null && id.length() > 0) {
            text = String.valueOf(id) + ": " + name;
        }
        if (text.length() > WorkItemLinkTypes.getMaxReferenceCommentLength()) {
            text = String.valueOf(text.substring(0, WorkItemLinkTypes.getMaxReferenceCommentLength() - 3)) + "...";
        }
        Object reference = this.fReference.isItemReference() ? IReferenceFactory.INSTANCE.createReferenceToItem(((IItemReference)this.fReference).getReferencedItem(), text) : IReferenceFactory.INSTANCE.createReferenceFromURI(((IURIReference)this.fReference).getURI(), text);
        this.setReference((IReference)reference);
    }

    public boolean needsUpload() {
        return this.fFileStore != null && this.fContent == null;
    }

    public long getContentLength() {
        if (this.fFileStore != null) {
            return this.fFileStore.fetchInfo().getLength();
        }
        if (this.fContent != null) {
            return this.fContent.getRawLength();
        }
        return -1L;
    }

    public String getContentType() {
        if (this.fContent != null) {
            return this.fContent.getContentType();
        }
        if (this.fFileStore != null) {
            try {
                IContentDescription contentDescription = InternalContentTypeUtils.getContentDescription(this.fFileStore);
                return InternalContentTypeUtils.getMIMEType(this.fFileStore.getName(), contentDescription);
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    public void replace(IURIReference reference) {
        try {
            this.fFileStore = EFS.getStore((URI)reference.getURI());
            this.fContent = null;
            this.fReplaced = true;
            this.fFutureName = this.fFileStore.getName();
            if (this.fReplacedReference == null) {
                this.fReplacedReference = this.fReference;
            }
            this.fCreator = this.fWorkingCopy.getTeamRepository().loggedInContributor();
            this.fCreationDate = new Timestamp(new Date().getTime());
            this.setReference((IReference)reference);
        }
        catch (CoreException e) {
            ModelPlugin.log(Messages.ArtifactLink_EXCEPTION_CREATING_FILE, (Exception)((Object)e));
        }
    }

    public void restore(IAttachment oldState) {
        this.fContent = ((IAttachment)oldState.getWorkingCopy()).getContent();
        this.fFutureName = oldState.getName();
        if (this.fReplaced) {
            this.fFileStore = null;
        }
        this.fReplaced = true;
        if (this.fReplacedReference == null) {
            this.fReplacedReference = this.fReference;
        }
        this.fCreator = oldState.getCreator();
        this.fCreationDate = oldState.getCreationDate();
        this.setReference((IReference)IReferenceFactory.INSTANCE.createReferenceToItem((IItemHandle)oldState, String.valueOf(oldState.getId()) + ": " + this.fFutureName));
    }

    public void upload(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fFileStore == null || this.fContent != null) {
            return;
        }
        try {
            IContentDescription contentDescription = InternalContentTypeUtils.getContentDescription(this.fFileStore);
            String mime = InternalContentTypeUtils.getMIMEType(this.fFileStore.getName(), contentDescription);
            String charset = InternalContentTypeUtils.getCharSet(contentDescription, mime);
            this.fContent = this.fWorkingCopy.getTeamRepository().contentManager().storeContent(mime, charset, this.fFileStore.openInputStream(0, monitor), null, monitor);
        }
        catch (CoreException x) {
            throw new TeamRepositoryException((Throwable)x);
        }
    }

    public void setMoved() {
        this.fMoved = true;
    }

    public boolean needsUpdate() {
        return this.fFutureName != null && !this.fFutureName.equals("") || this.getReference().isURIReference() || this.fReplaced || this.fMoved;
    }

    public IAttachment createUpdatedAttachment(IProgressMonitor monitor) throws TeamRepositoryException {
        IAttachment attachment = null;
        if (this.fContent != null && this.fReplaced && (attachment = this.getAttachmentOfReference((IItemReference)this.fReplacedReference, monitor)) != null) {
            attachment = (IAttachment)attachment.getWorkingCopy();
            attachment.setContent(this.fContent);
            if (this.fCreator != null) {
                ((Attachment)attachment).setCreator(this.fCreator);
            }
            if (this.fCreationDate != null) {
                ((Attachment)attachment).setCreationDate(this.fCreationDate);
            }
        }
        if (attachment == null) {
            attachment = this.getAttachmentOfReference((IItemReference)this.getReference(), monitor);
        }
        if (attachment != null) {
            attachment = (IAttachment)attachment.getWorkingCopy();
            if (this.fFutureName != null) {
                if (attachment.getDescription() != null && attachment.getDescription().equals(attachment.getName()) || this.fReplaced) {
                    attachment.setDescription(this.fFutureName);
                }
                attachment.setName(this.fFutureName);
            }
            if (this.fMoved) {
                ((Attachment)attachment).setProjectArea(this.fWorkingCopy.getWorkItem().getProjectArea());
                PermissionContext.setDefault((IItem)attachment);
            }
            attachment.patchProjectArea(this.fWorkingCopy.getWorkItem().getProjectArea());
        } else {
            IWorkItemClient workItemClient = (IWorkItemClient)this.fWorkingCopy.getTeamRepository().getClientLibrary(IWorkItemClient.class);
            String fileName = this.fFutureName != null && !"".equals(this.fFutureName) ? this.fFutureName : this.fFileStore.getName();
            attachment = workItemClient.createAttachment(this.fWorkingCopy.getWorkItem().getProjectArea(), monitor);
            attachment.setName(fileName);
            attachment.setDescription(fileName);
            Assert.isNotNull((Object)this.fContent);
            attachment.setContent(this.fContent);
        }
        this.fTemporaryReference = this.fReference;
        this.setReference((IReference)WorkItemLinkTypes.createAttachmentReference((IAttachment)attachment));
        return attachment;
    }

    public void updateSuccessful() {
        this.fFileStore = null;
        this.fContent = null;
        this.fFutureName = null;
        this.fTemporaryReference = null;
        this.fReplacedReference = null;
        this.fReplaced = false;
        this.fMoved = false;
        this.fCreator = null;
        this.fCreationDate = null;
        this.grabSharedItem();
    }

    public void updateFinished() {
        if (this.fTemporaryReference != null) {
            Object reference = this.fTemporaryReference.isItemReference() ? IReferenceFactory.INSTANCE.createReferenceToItem(((IItemReference)this.fTemporaryReference).getReferencedItem(), this.fTemporaryReference.getComment()) : IReferenceFactory.INSTANCE.createReferenceFromURI(((IURIReference)this.fTemporaryReference).getURI(), this.fTemporaryReference.getComment());
            this.setReference((IReference)reference);
            this.fTemporaryReference = null;
        }
    }

    private void setReference(IReference newReference) {
        IWorkItemClient workItemClient = (IWorkItemClient)this.fWorkingCopy.getTeamRepository().getClientLibrary(IWorkItemClient.class);
        IWorkItemWorkingCopyManager workingCopyManager = workItemClient.getWorkItemWorkingCopyManager();
        try {
            workingCopyManager.beginCompoundWorkItemChange((IWorkItemHandle)this.fWorkingCopy.getWorkItem());
            this.fWorkingCopy.getReferences().remove(this.fReference);
            this.fWorkingCopy.getReferences().add(WorkItemEndPoints.ATTACHMENT, newReference);
            this.fReference = newReference;
        }
        finally {
            workingCopyManager.endCompoundWorkItemChange((IWorkItemHandle)this.fWorkingCopy.getWorkItem());
        }
    }

    private IAttachment getAttachmentOfReference(IItemReference reference, IProgressMonitor monitor) throws TeamRepositoryException {
        if (!(reference.getReferencedItem() instanceof IAttachmentHandle)) {
            return null;
        }
        IAuditableClient auditableClient = (IAuditableClient)this.fWorkingCopy.getTeamRepository().getClientLibrary(IAuditableClient.class);
        return (IAttachment)auditableClient.resolveAuditable((IAuditableHandle)((IAttachmentHandle)reference.getReferencedItem()), IAttachment.DEFAULT_PROFILE, monitor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ArtifactLink)) {
            return false;
        }
        return this.getReference().equals(((ArtifactLink)obj).getReference());
    }

    public int hashCode() {
        return this.getReference().hashCode();
    }

    private void grabSharedItem() {
        IReference reference = this.fReference;
        if (reference != null && ((IItemReference)reference).getReferencedItem() != null) {
            ITeamRepository teamRepository = this.fWorkingCopy.getTeamRepository();
            this.fSharedItem = teamRepository.itemManager().getSharedItemIfKnown(((IItemReference)reference).getReferencedItem());
        }
    }

    public boolean isReplaced() {
        return this.fReplaced;
    }

    public Timestamp getCreationDate() {
        if (this.fReplaced) {
            return this.fCreationDate;
        }
        return null;
    }

    public IContributorHandle getCreator() {
        if (this.fReplaced) {
            return this.fCreator;
        }
        return null;
    }
}

