/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.client.internal;

import com.ibm.icu.util.ULocale;
import com.ibm.team.process.client.IAccessGroupClientService;
import com.ibm.team.process.client.IClientProcess;
import com.ibm.team.process.client.IProcessClientService;
import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.common.IAccessGroup;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProcessDefinition;
import com.ibm.team.process.common.IProcessItem;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.common.advice.ProcessRunnable;
import com.ibm.team.process.internal.client.IProcessInternalClientService;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.StaleDataException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IEnumerationClient;
import com.ibm.team.workitem.client.internal.AuditableClientProcess;
import com.ibm.team.workitem.client.internal.ClientLinkDetectorHelper;
import com.ibm.team.workitem.client.internal.ClientServiceContext;
import com.ibm.team.workitem.client.internal.Messages;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IAuditableCommonProcess;
import com.ibm.team.workitem.common.QueryIterator;
import com.ibm.team.workitem.common.internal.AuditableCache;
import com.ibm.team.workitem.common.internal.AuditableCommon;
import com.ibm.team.workitem.common.internal.ICommonServiceContext;
import com.ibm.team.workitem.common.internal.IWorkItemRepositoryService;
import com.ibm.team.workitem.common.internal.enumeration.Enumeration;
import com.ibm.team.workitem.common.internal.linkdetection.WorkItemTextLinkDetector;
import com.ibm.team.workitem.common.internal.util.AuditablesHelper;
import com.ibm.team.workitem.common.internal.util.Utils;
import com.ibm.team.workitem.common.internal.util.WorkItemQueries;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class AuditableClient
extends AuditableCommon
implements IAuditableClient {
    private static final int CONTRIBUTOR_TYPE_CACHE_SIZES = 1000;
    private static final int MAX_FETCHED_ITEMS_PER_REQUEST = 2048;
    private IClientLibraryContext fContext;
    private ITeamRepository fTeamRepository;
    private InternalListener fInternalListener = new InternalListener();
    private Set<UUID> fNotFound = new HashSet<UUID>();

    public AuditableClient(IClientLibraryContext context) {
        super((ICommonServiceContext)new ClientServiceContext(context));
        this.fContext = context;
        this.fTeamRepository = context.teamRepository();
        this.fInternalListener.install(this.fTeamRepository);
        this.addItemTypeCache(IContributor.ITEM_TYPE, (AuditableCache.IItemTypeCache)new AuditableCache.PrimitiveCache(1000));
        this.addItemTypeCache(IProjectArea.ITEM_TYPE, (AuditableCache.IItemTypeCache)new AuditableCache.PrimitiveCache());
        this.addItemTypeCache(ITeamArea.ITEM_TYPE, (AuditableCache.IItemTypeCache)new AuditableCache.PrimitiveCache());
        WorkItemTextLinkDetector.setClientHelper((WorkItemTextLinkDetector.ILinkDetectorHelper)ClientLinkDetectorHelper.getInstance());
    }

    public <T extends IAuditable> T resolveAuditable(IAuditableHandle handle, ItemProfile<T> profile, IProgressMonitor monitor) throws TeamRepositoryException {
        IAuditable current = (IAuditable)this.fTeamRepository.itemManager().fetchPartialItem((IItemHandle)handle, 0, AuditablesHelper.getProperties(profile, (IItemType)handle.getItemType()), monitor);
        this.getCache().cache(current);
        return (T)current;
    }

    public <T extends IAuditable> List<T> resolveAuditables(List<? extends IAuditableHandle> handles, ItemProfile<T> profile, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.doResolveAuditables(handles, profile, 0, monitor);
    }

    public <T extends IAuditable> List<T> resolveAuditables2(List<? extends IAuditableHandle> handles, ItemProfile<T> profile, int flags, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.isSet(flags, 1)) {
            return this.doResolveAuditablesPermissionAware(handles, profile, flags, monitor);
        }
        return this.doResolveAuditables(handles, profile, flags, monitor);
    }

    public <T extends IAuditable> List<T> resolveAuditablesPermissionAware(List<? extends IAuditableHandle> handles, ItemProfile<T> profile, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.doResolveAuditablesPermissionAware(handles, profile, 0, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private <T extends IAuditable> List<T> doResolveAuditables(List<? extends IAuditableHandle> handles, ItemProfile<T> profile, int flags, IProgressMonitor monitor) throws TeamRepositoryException {
        if (handles.isEmpty()) {
            return Collections.emptyList();
        }
        doResolve = new ArrayList<IAuditableHandle>();
        var6_6 = this.fNotFound;
        synchronized (var6_6) {
            for (IAuditableHandle handle : handles) {
                if (this.fNotFound.contains(handle.getItemId())) continue;
                doResolve.add(handle);
            }
        }
        resolved = null;
        if (doResolve.size() <= 2048) {
            resolved = this.updateFromItemManager(this.fTeamRepository.itemManager().fetchPartialItems(doResolve, this.isSet(flags, 2) != false ? 1 : 0, AuditablesHelper.getProperties(profile, (IItemType)handles.get(0).getItemType()), monitor), monitor);
        } else {
            itemHandleCount = doResolve.size();
            resolved = new ArrayList<E>(itemHandleCount);
            i = 0;
            while (i < itemHandleCount) {
                itemHandlesChunk = doResolve.subList(i, Math.min(i + 2048, itemHandleCount));
                resolvedItemChunk = this.updateFromItemManager(this.fTeamRepository.itemManager().fetchPartialItems(itemHandlesChunk, this.isSet(flags, 2) != false ? 1 : 0, AuditablesHelper.getProperties(profile, (IItemType)handles.get(0).getItemType()), monitor), monitor);
                resolved.addAll(resolvedItemChunk);
                i += itemHandlesChunk.size();
            }
        }
        result = new ArrayList<IAuditable>();
        var8_7 = this.fNotFound;
        synchronized (var8_7) {
            i = 0;
            while (i < doResolve.size()) {
                handle = (IAuditableHandle)doResolve.get(i);
                while (!handles.get(result.size()).sameItemId((IItemHandle)handle)) {
                    result.add(null);
                }
                auditable = (IAuditable)resolved.get(i);
                result.add(auditable);
                if (auditable == null) {
                    this.fNotFound.add(handle.getItemId());
                }
                ++i;
            }
            // MONITOREXIT @DISABLED, blocks:[1, 3] lbl52 : MonitorExitStatement: MONITOREXIT : var8_7
            if (true) ** GOTO lbl55
        }
        do {
            result.add(null);
lbl55:
            // 2 sources

        } while (result.size() < handles.size());
        Assert.isTrue((boolean)(result.size() == handles.size()));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends IAuditable> List<T> doResolveAuditablesPermissionAware(List<? extends IAuditableHandle> handles, ItemProfile<T> profile, int flags, IProgressMonitor monitor) throws TeamRepositoryException {
        if (handles.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IAuditableHandle> doResolve = new ArrayList<IAuditableHandle>(handles.size());
        Set<UUID> set = this.fNotFound;
        synchronized (set) {
            for (IAuditableHandle iAuditableHandle : handles) {
                if (this.fNotFound.contains(iAuditableHandle.getItemId())) continue;
                doResolve.add(iAuditableHandle);
            }
        }
        List resolved = null;
        ArrayList arrayList = new ArrayList();
        if (doResolve.size() <= 2048) {
            IFetchResult fetchResult = this.fTeamRepository.itemManager().fetchPartialItemsPermissionAware(doResolve, this.isSet(flags, 2) ? 1 : 0, AuditablesHelper.getProperties(profile, (IItemType)handles.get(0).getItemType()), monitor);
            if (fetchResult.hasPermissionDeniedItems()) {
                throw new PermissionDeniedException(Messages.AuditableClient_MISSING_PERMISSION);
            }
            resolved = this.updateFromItemManager(new ArrayList(fetchResult.getRetrievedItems()), monitor);
            arrayList.addAll(fetchResult.getNotFoundItems());
        } else {
            int itemHandleCount = doResolve.size();
            resolved = new ArrayList(itemHandleCount);
            int i = 0;
            while (i < itemHandleCount) {
                List itemHandlesChunk = doResolve.subList(i, Math.min(i + 2048, itemHandleCount));
                IFetchResult fetchResult = this.fTeamRepository.itemManager().fetchPartialItemsPermissionAware(itemHandlesChunk, this.isSet(flags, 2) ? 1 : 0, AuditablesHelper.getProperties(profile, (IItemType)handles.get(0).getItemType()), monitor);
                if (fetchResult.hasPermissionDeniedItems()) {
                    throw new PermissionDeniedException(Messages.AuditableClient_MISSING_PERMISSION);
                }
                resolved.addAll(this.updateFromItemManager(new ArrayList(fetchResult.getRetrievedItems()), monitor));
                arrayList.addAll(fetchResult.getNotFoundItems());
                i += itemHandlesChunk.size();
            }
        }
        if (!arrayList.isEmpty()) {
            Set<UUID> itemHandleCount = this.fNotFound;
            synchronized (itemHandleCount) {
                for (IAuditableHandle handle : arrayList) {
                    this.fNotFound.add(handle.getItemId());
                }
            }
        }
        if (resolved.size() == handles.size()) {
            return resolved;
        }
        ArrayList<IAuditable> result = new ArrayList<IAuditable>(handles.size());
        int i = 0;
        while (i < resolved.size()) {
            IAuditable handle = (IAuditable)resolved.get(i);
            while (!handles.get(result.size()).sameItemId((IItemHandle)handle)) {
                result.add(null);
            }
            result.add(handle);
            ++i;
        }
        while (result.size() < handles.size()) {
            result.add(null);
        }
        Assert.isTrue((result.size() == handles.size() ? 1 : 0) != 0);
        return result;
    }

    @Override
    public <T extends IAuditable> T fetchCurrentAuditable(IAuditableHandle handle, ItemProfile<T> profile, IProgressMonitor monitor) throws TeamRepositoryException {
        T cached = this.findCachedAuditable(handle, profile);
        T newer = this.internalFetchNewerAuditable(handle, profile, monitor);
        if (newer != null) {
            return (T)((IAuditable)this.update(Collections.singletonList(newer), monitor).get(0));
        }
        Assert.isNotNull(cached);
        return cached;
    }

    public <T extends IAuditable> List<T> internalFetchNewerAuditable(List<? extends IAuditableHandle> handles, ItemProfile<T> profile, IProgressMonitor monitor) throws TeamRepositoryException {
        IAuditable[] auditables;
        ArrayList<IAuditable> result = new ArrayList<IAuditable>(handles.size());
        final HashSet properties = new HashSet(AuditablesHelper.getProperties(profile, (IItemType)profile.getItemType()));
        final IAuditableHandle[] params = new IAuditableHandle[handles.size()];
        ListIterator<? extends IAuditableHandle> iter = handles.listIterator();
        while (iter.hasNext()) {
            T tmp;
            int index = iter.nextIndex();
            IAuditableHandle handle = iter.next();
            T cached = this.findCachedAuditable(handle, profile);
            T t = tmp = cached != null ? cached : this.findCachedAuditable(handle, ItemProfile.createProfile((IItemType)profile.getItemType(), (String[])new String[0]));
            if (tmp != null) {
                properties.addAll(ItemProfile.computeProfile(tmp).getProperties());
            }
            IAuditableHandle resolveHandle = cached != null ? (IAuditableHandle)cached.getStateHandle() : this.createAuditableHandle(handle.getItemType(), handle.getItemId(), null);
            params[index] = resolveHandle;
        }
        IAuditable[] iAuditableArray = auditables = (IAuditable[])this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<IAuditable[]>(){

            public IAuditable[] run(IProgressMonitor monitor) throws TeamRepositoryException {
                IWorkItemRepositoryService service = (IWorkItemRepositoryService)AuditableClient.this.fContext.getServiceInterface(IWorkItemRepositoryService.class);
                return service.fetchAnyNewer(params, properties.toArray(new String[properties.size()]));
            }
        }, monitor);
        int n = auditables.length;
        int n2 = 0;
        while (n2 < n) {
            IAuditable auditable = iAuditableArray[n2];
            result.add(auditable);
            ++n2;
        }
        return result;
    }

    public <T extends IAuditable> T internalFetchNewerAuditable(IAuditableHandle handle, ItemProfile<T> profile, IProgressMonitor monitor) throws TeamRepositoryException {
        T tmp;
        T cached = this.findCachedAuditable(handle, profile);
        final HashSet properties = new HashSet(AuditablesHelper.getProperties(profile, (IItemType)handle.getItemType()));
        T t = tmp = cached != null ? cached : this.findCachedAuditable(handle, ItemProfile.createProfile((IItemType)profile.getItemType(), (String[])new String[0]));
        if (tmp != null) {
            properties.addAll(ItemProfile.computeProfile(tmp).getProperties());
        }
        final IAuditableHandle resolveHandle = cached != null ? (IAuditableHandle)cached.getStateHandle() : this.createAuditableHandle(handle.getItemType(), handle.getItemId(), null);
        IAuditable auditable = (IAuditable)this.fContext.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                IWorkItemRepositoryService service = (IWorkItemRepositoryService)AuditableClient.this.fContext.getServiceInterface(IWorkItemRepositoryService.class);
                String[] array = null;
                if (!properties.containsAll(AuditablesHelper.allProperties((IItemType)resolveHandle.getItemType()))) {
                    array = properties.toArray(new String[properties.size()]);
                }
                return service.fetchNewer(resolveHandle, array);
            }
        }, monitor);
        return (T)auditable;
    }

    public List fetchCurrentAuditables(List handles, ItemProfile profile, IProgressMonitor monitor) throws TeamRepositoryException {
        if (handles.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        IAuditableHandle handle = (IAuditableHandle)handles.get(0);
        Collection properties = AuditablesHelper.getProperties((ItemProfile)profile, (IItemType)handle.getItemType());
        List retrieved = this.fTeamRepository.itemManager().fetchPartialItems(handles, 1, properties, monitor);
        return this.updateFromItemManager(retrieved, monitor);
    }

    public IItem fetchItem(UUID itemId, IProgressMonitor monitor) throws TeamRepositoryException {
        IItemHandle handle = IWorkItem.ITEM_TYPE.createItemHandle(itemId, null);
        return this.fTeamRepository.itemManager().fetchCompleteItem(handle, 0, monitor);
    }

    @Override
    public <T extends IAuditable> T findCachedAuditable(IAuditableHandle handle, ItemProfile<T> profile) {
        IAuditable cache = (IAuditable)this.fTeamRepository.itemManager().getSharedItemIfKnown((IItemHandle)handle);
        if (cache != null && profile.isMatched(cache)) {
            this.getCache().cache(cache);
            return (T)cache;
        }
        return null;
    }

    public List findCachedAuditables(List handles, ItemProfile profile) {
        ArrayList auditables = new ArrayList(handles.size());
        for (IAuditableHandle handle : handles) {
            Object auditable = this.findCachedAuditable(handle, profile);
            if (auditable == null) continue;
            auditables.add(auditable);
        }
        return auditables;
    }

    public <T extends IAuditable> List<T> findAllCachedAuditables(ItemProfile<T> profile) {
        ArrayList cached = new ArrayList(this.fTeamRepository.itemManager().getKnownSharedItems(profile.getItemType()));
        Iterator iter = cached.iterator();
        while (iter.hasNext()) {
            IAuditable auditable = (IAuditable)iter.next();
            if (profile.isMatched(auditable)) continue;
            iter.remove();
        }
        return cached;
    }

    public <T extends IAuditable> T resolveAuditableByLocation(Location location, ItemProfile<T> profile, IProgressMonitor monitor) throws TeamRepositoryException {
        return (T)((IAuditable)this.fTeamRepository.itemManager().fetchPartialItem(location, 0, AuditablesHelper.getProperties(profile, (IItemType)location.getItemType()), monitor));
    }

    public <T extends IAuditable> List<T> findAuditables(ItemProfile<T> profile, IProgressMonitor monitor) throws TeamRepositoryException {
        List<T> cache = this.findAuditablesFromCache(profile);
        if (cache != null) {
            return cache;
        }
        QueryIterator iter = WorkItemQueries.all((IAuditableCommon)this, (IItemType)profile.getItemType());
        List<T> retrieved = this.resolveAuditables(iter.toList(monitor), profile, monitor);
        cache = this.updateFromItemManager(retrieved, monitor);
        this.getCache().cacheAll(cache, profile);
        return cache;
    }

    public <T extends IAuditable> List<T> findAuditablesFromCache(ItemProfile<T> profile) {
        return this.getCache().getAll(profile);
    }

    public IContributorHandle getUser() {
        return this.fTeamRepository.loggedInContributor();
    }

    public List<IProcessArea> getProcessAreas(IContributor user, IProjectAreaHandle projectAreaHandle, ItemProfile<IProcessArea> profile, IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessItemService processClient = (IProcessItemService)this.getTeamRepository().getClientLibrary(IProcessItemService.class);
        return processClient.findProcessAreas(user, projectAreaHandle, profile != null ? profile.getProperties() : null, monitor);
    }

    @Override
    public ITeamRepository getTeamRepository() {
        return this.fTeamRepository;
    }

    public IProcessArea findProcessAreaByURI(URI areaURI, ItemProfile profile, IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessClientService processClient = (IProcessClientService)this.getTeamRepository().getClientLibrary(IProcessClientService.class);
        return processClient.findProcessArea(areaURI, profile != null ? profile.getProperties() : null, monitor);
    }

    public IProcessDefinition findProcessDefinition(String processId, ItemProfile profile, IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessItemService processClient = (IProcessItemService)this.getTeamRepository().getClientLibrary(IProcessItemService.class);
        return processClient.findProcessDefinition(processId, AuditablesHelper.getProperties((ItemProfile)profile, (IItemType)IProcessDefinition.ITEM_TYPE), monitor);
    }

    public void initializeProjectArea(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessItemService processClient = (IProcessItemService)this.getTeamRepository().getClientLibrary(IProcessItemService.class);
        IProjectArea item = (IProjectArea)this.resolveAuditable((IAuditableHandle)projectArea, ItemProfile.createFullProfile((IItemType)IProjectArea.ITEM_TYPE), monitor);
        if (!item.isInitialized()) {
            processClient.initialize(item, monitor);
        }
    }

    public IAuditableCommonProcess getProcess(IProcessAreaHandle processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessInternalClientService processClient = (IProcessInternalClientService)this.getTeamRepository().getClientLibrary(IProcessInternalClientService.class);
        IProcessArea area = (IProcessArea)this.resolveAuditable((IAuditableHandle)processArea, ItemProfile.createFullProfile((IItemType)processArea.getItemType()), monitor);
        IClientProcess clientProcess = processClient.getClientProcess(area, monitor);
        return new AuditableClientProcess(this, clientProcess, processClient);
    }

    public IOperationReport execute(ProcessRunnable runnable, String name, IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessClientService processClient = (IProcessClientService)this.getTeamRepository().getClientLibrary(IProcessClientService.class);
        return processClient.execute(runnable, name, monitor);
    }

    public Object getOrigin() {
        return this.fTeamRepository;
    }

    public <T> T getPeer(Class<T> peerInterface) {
        return (T)Utils.getCommonLibrary((Object)this.fTeamRepository, peerInterface);
    }

    public String getRepositoryURI() {
        return this.fTeamRepository.getRepositoryURI();
    }

    public String getPublicRepositoryURI() {
        String publicUriRoot = this.fTeamRepository.publicUriRoot();
        if (publicUriRoot == null) {
            publicUriRoot = this.getRepositoryURI();
        }
        return publicUriRoot.charAt(publicUriRoot.length() - 1) == '/' ? publicUriRoot : String.valueOf(publicUriRoot) + '/';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends IAuditable> List<T> update(List<T> auditables, IProgressMonitor monitor) throws TeamRepositoryException {
        Set<UUID> set = this.fNotFound;
        synchronized (set) {
            for (IAuditable auditable : auditables) {
                if (auditable == null) continue;
                this.fNotFound.remove(auditable.getItemId());
            }
        }
        List<T> shared = this.updateItemManager(auditables, monitor);
        return super.update(shared, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends IAuditable> List<T> updateFromItemManager(List<T> auditables, IProgressMonitor monitor) throws TeamRepositoryException {
        Set<UUID> set = this.fNotFound;
        synchronized (set) {
            for (IAuditable auditable : auditables) {
                if (auditable == null) continue;
                this.fNotFound.remove(auditable.getItemId());
            }
        }
        return super.update(auditables, monitor);
    }

    private <T extends IAuditable> List<T> updateItemManager(List<T> auditables, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<Object> sharedItems = new ArrayList<Object>();
        for (IAuditable auditable : auditables) {
            if (auditable != null) {
                sharedItems.add((IAuditable)this.fTeamRepository.itemManager().applyItemUpdates(Collections.singletonList(auditable)).get(0));
                continue;
            }
            sharedItems.add(null);
        }
        int i = 0;
        while (i < sharedItems.size()) {
            IAuditable sharedItem = (IAuditable)sharedItems.get(i);
            if (sharedItem == null && auditables.get(i) != null) {
                IAuditable auditable = (IAuditable)auditables.get(i);
                IAuditable cached = (IAuditable)this.fTeamRepository.itemManager().getSharedItemIfKnown((IItemHandle)auditable);
                if (cached != null && auditable.sameStateId((IItemHandle)cached)) {
                    sharedItems.set(i, this.resolveAuditable((IAuditableHandle)auditable, ItemProfile.computeProfile((IAuditable)auditable), monitor));
                } else {
                    sharedItems.set(i, this.internalFetchCurrentAuditable((IAuditableHandle)auditable, ItemProfile.computeProfile((IAuditable)auditable), monitor));
                }
            }
            ++i;
        }
        return sharedItems;
    }

    public <T extends IAuditable> T internalFetchCurrentAuditable(IAuditableHandle handle, ItemProfile<T> profile, IProgressMonitor monitor) throws TeamRepositoryException {
        Collection properties = AuditablesHelper.getProperties(profile, (IItemType)handle.getItemType());
        IAuditable current = (IAuditable)this.fTeamRepository.itemManager().fetchPartialItem((IItemHandle)handle, 1, properties, monitor);
        this.getCache().cache(current);
        return (T)current;
    }

    public void retrieveContent(IContent content, OutputStream outStream, IProgressMonitor monitor) throws TeamRepositoryException {
        this.fTeamRepository.contentManager().retrieveContent(content, outStream, monitor);
    }

    public IContent storeContent(String contentType, String characterEncoding, InputStream inStream, long length, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fTeamRepository.contentManager().storeContent(contentType, characterEncoding, inStream, length, monitor);
    }

    public IDevelopmentLine getDevelopmentLine(ITeamAreaHandle teamArea, IProgressMonitor monitor) throws TeamRepositoryException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        ITeamArea area = (ITeamArea)this.resolveAuditable((IAuditableHandle)teamArea, ItemProfile.createFullProfile((IItemType)ITeamArea.ITEM_TYPE), monitor);
        IProcessItemService processItemService = (IProcessItemService)this.getTeamRepository().getClientLibrary(IProcessItemService.class);
        return processItemService.getDevelopmentLine((IProcessArea)area, monitor);
    }

    public List<IIteration> findCurrentIterations(IDevelopmentLineHandle developmentLine, IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessItemService processService = (IProcessItemService)this.fTeamRepository.getClientLibrary(IProcessItemService.class);
        return Arrays.asList(processService.getCurrentIterations(developmentLine, monitor));
    }

    public IProcessItem saveProcessItem(IProcessItem processItem, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            IProcessItemService processService = (IProcessItemService)this.fTeamRepository.getClientLibrary(IProcessItemService.class);
            return processService.save(processItem, monitor);
        }
        catch (StaleDataException x) {
            this.fetchCurrentAuditable((IAuditableHandle)processItem, ItemProfile.computeProfile((IAuditable)processItem), monitor);
            throw x;
        }
    }

    public List<IProcessItem> saveProcessItems(List<IProcessItem> processItems, IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessItemService processService = (IProcessItemService)this.fTeamRepository.getClientLibrary(IProcessItemService.class);
        return Arrays.asList(processService.save(processItems.toArray(new IProcessItem[processItems.size()]), monitor));
    }

    public List<ULocale> getUserLocales() {
        return Collections.singletonList(ULocale.getDefault());
    }

    public List<Enumeration> resolvePersistedEnumerations(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        IEnumerationClient enumerationClient = (IEnumerationClient)this.fTeamRepository.getClientLibrary(IEnumerationClient.class);
        Enumeration[] enumerations = enumerationClient.resolveEnumerations(projectArea, monitor);
        return Arrays.asList(enumerations);
    }

    public IAccessGroup[] getAccessGroups(String nameFilter, int maxResults, IProgressMonitor monitor) throws TeamRepositoryException {
        IAccessGroupClientService accessGroupService = (IAccessGroupClientService)this.fTeamRepository.getClientLibrary(IAccessGroupClientService.class);
        return accessGroupService.getAccessGroups(nameFilter, monitor);
    }

    public IAccessGroup getAccessGroupForGroupContextId(UUID groupContextId, IProgressMonitor monitor) throws TeamRepositoryException {
        IAccessGroupClientService accessGroupService = (IAccessGroupClientService)this.fTeamRepository.getClientLibrary(IAccessGroupClientService.class);
        return accessGroupService.getAccessGroupForGroupContextId(groupContextId, monitor);
    }

    private class InternalListener
    implements ISharedItemChangeListener {
        private InternalListener() {
        }

        public void install(ITeamRepository repository) {
            IItemType[] itemTypes = IItemType.IRegistry.INSTANCE.getAllItemTypes();
            int i = 0;
            while (i < itemTypes.length) {
                if (itemTypes[i].isAuditable()) {
                    repository.itemManager().addItemChangeListener(itemTypes[i], (ISharedItemChangeListener)this);
                }
                ++i;
            }
        }

        public void uninstall(ITeamRepository repository) {
            repository.itemManager().purgeItemChangeListener((ISharedItemChangeListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void itemsChanged(List events) {
            for (ISharedItemChangeEvent event : events) {
                if (!(event.getSharedItem() instanceof IAuditable)) continue;
                AuditableClient.this.getCache().cache((IAuditable)event.getSharedItem());
            }
            Set set = AuditableClient.this.fNotFound;
            synchronized (set) {
                for (ISharedItemChangeEvent event : events) {
                    AuditableClient.this.fNotFound.remove(event.getSharedItem().getItemId());
                }
            }
        }
    }
}

