/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemStatusException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;

public class FileSystemStatusUtil {
    public static IStatus getStatusFor(Throwable exception) {
        if (exception instanceof FileSystemStatusException) {
            return ((FileSystemStatusException)((Object)exception)).getStatus();
        }
        if (exception instanceof CoreException) {
            return ((CoreException)exception).getStatus();
        }
        return FileSystemStatusUtil.getStatusFor(4, "com.ibm.team.filesystem.client", 0, exception.getLocalizedMessage(), exception);
    }

    public static IStatus getStatusFor(int severity, String message, Throwable exception) {
        return FileSystemStatusUtil.getStatusFor(severity, "com.ibm.team.filesystem.client", 0, message, exception);
    }

    public static IStatus getStatusFor(int severity, String plugin, String message, Throwable exception) {
        return FileSystemStatusUtil.getStatusFor(severity, plugin, 0, message, exception);
    }

    private static IStatus getStatusFor(int severity, String plugin, int code, String message, Throwable exception) {
        if (exception instanceof CoreException) {
            CoreException ce = (CoreException)exception;
            MultiStatus multi = new MultiStatus(plugin, code, message, exception, severity){
                {
                    this.setSeverity(n);
                }
            };
            multi.add(ce.getStatus());
            return multi;
        }
        if (exception instanceof FileSystemStatusException) {
            FileSystemStatusException se = (FileSystemStatusException)((Object)exception);
            MultiStatus multi = new MultiStatus(plugin, code, message, exception, severity){
                {
                    this.setSeverity(n);
                }
            };
            multi.add(se.getStatus());
            return multi;
        }
        if (exception instanceof OperationCanceledException) {
            return new Status(8, plugin, code, message, exception);
        }
        return new Status(severity, plugin, code, message, exception);
    }

    public static IStatus getStatusFor(int severity, String message) {
        return new Status(severity, "com.ibm.team.filesystem.client", message);
    }
}

